/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base;

import java.io.Closeable;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.Processor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.base.kapt3.KaptFlag;
import org.jetbrains.kotlin.base.kapt3.KaptOptions;
import org.jetbrains.kotlin.kapt3.base.LoadedProcessors;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoaderKt;
import org.jetbrains.kotlin.kapt3.base.incremental.DeclaredProcType;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessor;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessorDiscoveryKt;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/ProcessorLoader;", "Ljava/io/Closeable;", "options", "Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "(Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;)V", "annotationProcessingClassLoader", "Ljava/net/URLClassLoader;", "close", "", "doLoadProcessors", "", "Ljavax/annotation/processing/Processor;", "classLoader", "loadProcessors", "Lorg/jetbrains/kotlin/kapt3/base/LoadedProcessors;", "parentClassLoader", "Ljava/lang/ClassLoader;", "tryLoadProcessor", "fqName", "", "wrapInIncrementalProcessor", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "processors", "classpath", "", "Ljava/io/File;", "kotlin-annotation-processing-maven"})
public class ProcessorLoader
implements Closeable {
    private URLClassLoader annotationProcessingClassLoader;
    private final KaptOptions options;
    private final KaptLogger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LoadedProcessors loadProcessors(@NotNull ClassLoader parentClassLoader) {
        List processors;
        List list;
        URLClassLoader classLoader;
        Collection<URL> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)parentClassLoader, (String)"parentClassLoader");
        ProcessorLoaderKt.access$clearJarURLCache();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$apply = linkedHashSet;
        boolean bl3 = false;
        $this$apply.addAll(this.options.getProcessingClasspath());
        if (this.options.get(KaptFlag.INCLUDE_COMPILE_CLASSPATH)) {
            $this$apply.addAll(this.options.getCompileClasspath());
        }
        LinkedHashSet classpath = linkedHashSet;
        Iterable $this$map$iv = classpath;
        boolean $i$f$map = false;
        $this$apply = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            URL uRL = it.toURI().toURL();
            collection.add(uRL);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv22 = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv22.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = uRLArray;
        ClassLoader classLoader2 = parentClassLoader;
        URL[] uRLArray2 = (URL[])collection;
        this.annotationProcessingClassLoader = classLoader = new URLClassLoader(uRLArray2, classLoader2);
        Collection $i$f$toTypedArray22 = this.options.getProcessors();
        boolean thisCollection$iv22 = false;
        if (!$i$f$toTypedArray22.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            this.logger.info("Annotation processor class names are set, skip AP discovery");
            Iterable $this$mapNotNull$iv = this.options.getProcessors();
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Processor processor;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                String it = (String)element$iv$iv;
                boolean bl6 = false;
                if (this.tryLoadProcessor(it, classLoader) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                Processor it$iv$iv = processor;
                boolean bl9 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            this.logger.info("Need to discovery annotation processors in the AP classpath");
            list = processors = this.doLoadProcessors(classLoader);
        }
        if (processors.isEmpty()) {
            this.logger.info("No annotation processors available, aborting");
        } else {
            KaptLogger $this$info$iv = this.logger;
            boolean $i$f$info = false;
            if ($this$info$iv.isVerbose()) {
                KaptLogger kaptLogger = $this$info$iv;
                boolean bl10 = false;
                String string = "Annotation processors: " + CollectionsKt.joinToString$default((Iterable)processors, null, null, null, (int)0, null, (Function1)loadProcessors.1.1.INSTANCE, (int)31, null);
                kaptLogger.info(string);
            }
        }
        return new LoadedProcessors(this.wrapInIncrementalProcessor(processors, classpath), classLoader);
    }

    public static /* synthetic */ LoadedProcessors loadProcessors$default(ProcessorLoader processorLoader, ClassLoader classLoader, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadProcessors");
        }
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
            classLoader = classLoader2;
        }
        return processorLoader.loadProcessors(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IncrementalProcessor> wrapInIncrementalProcessor(List<? extends Processor> processors, Iterable<? extends File> classpath) {
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (this.options.getIncrementalCache() == null) {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = processors;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it2;
                Processor processor = (Processor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                IncrementalProcessor incrementalProcessor = new IncrementalProcessor((Processor)it2, DeclaredProcType.NON_INCREMENTAL, this.logger);
                collection2.add(incrementalProcessor);
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$map$iv = processors;
        boolean $i$f$map = false;
        Iterable destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            Processor bl = (Processor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = it3.getClass().getName();
            collection.add(object);
        }
        Set processorNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Map<String, DeclaredProcType> processorsInfo = IncrementalProcessorDiscoveryKt.getIncrementalProcessorsFromClasspath(processorNames, classpath);
        Iterable $this$filter$iv = processorNames;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!processorsInfo.containsKey(it))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List nonIncremental = (List)destination$iv$iv3;
        Iterable $this$map$iv2 = processors;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DeclaredProcType declaredProcType;
            block9: {
                block8: {
                    it = (Processor)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    declaredProcType = processorsInfo.get(it.getClass().getName());
                    if (declaredProcType == null) break block8;
                    DeclaredProcType declaredProcType2 = declaredProcType;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    DeclaredProcType it4 = declaredProcType2;
                    boolean bl5 = false;
                    DeclaredProcType declaredProcType3 = nonIncremental.isEmpty() ? it4 : DeclaredProcType.INCREMENTAL_BUT_OTHER_APS_ARE_NOT;
                    declaredProcType = declaredProcType3;
                    if (declaredProcType3 != null) break block9;
                }
                declaredProcType = DeclaredProcType.NON_INCREMENTAL;
            }
            DeclaredProcType procType = declaredProcType;
            object = new IncrementalProcessor((Processor)it, procType, this.logger);
            collection.add(object);
        }
        return (List)destination$iv$iv3;
    }

    @NotNull
    public List<Processor> doLoadProcessors(@NotNull URLClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        ServiceLoader<Processor> serviceLoader = ServiceLoader.load(Processor.class, classLoader);
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader.load(Proce\u2026:class.java, classLoader)");
        return CollectionsKt.toList((Iterable)serviceLoader);
    }

    private final Processor tryLoadProcessor(String fqName, ClassLoader classLoader) {
        Class<?> clazz;
        try {
            clazz = Class.forName(fqName, true, classLoader);
        }
        catch (Throwable e) {
            this.logger.warn("Can't find annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
        Class<?> annotationProcessorClass = clazz;
        try {
            Object annotationProcessorInstance = annotationProcessorClass.newInstance();
            if (!(annotationProcessorInstance instanceof Processor)) {
                this.logger.warn(fqName + " is not an instance of 'Processor'");
                return null;
            }
            return (Processor)annotationProcessorInstance;
        }
        catch (Throwable e) {
            this.logger.warn("Can't load annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        URLClassLoader uRLClassLoader = this.annotationProcessingClassLoader;
        if (uRLClassLoader != null) {
            uRLClassLoader.close();
        }
        ProcessorLoaderKt.access$clearJarURLCache();
    }

    public ProcessorLoader(@NotNull KaptOptions options, @NotNull KaptLogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.options = options;
        this.logger = logger;
    }
}

