/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.incremental.Changes;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalAptCache;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessor;
import org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache;
import org.jetbrains.kotlin.kapt3.base.incremental.SourcesToReprocess;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\u0014\u0010\u001b\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCacheManager;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "aptCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalAptCache;", "aptCacheFile", "closed", "", "getFile", "()Ljava/io/File;", "javaCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "getJavaCache$kotlin_annotation_processing_maven", "()Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "javaCacheFile", "close", "", "invalidateAndGetDirtyFiles", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourcesToReprocess;", "changedSources", "", "dirtyClasspathJvmNames", "", "maybeGetAptCacheFromFile", "maybeGetJavaCacheFromFile", "updateCache", "processors", "", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "kotlin-annotation-processing-maven"})
public final class JavaClassCacheManager
implements Closeable {
    private final File javaCacheFile;
    @NotNull
    private final JavaClassCache javaCache;
    private final File aptCacheFile;
    private final IncrementalAptCache aptCache;
    private boolean closed;
    @NotNull
    private final File file;

    @NotNull
    public final JavaClassCache getJavaCache$kotlin_annotation_processing_maven() {
        return this.javaCache;
    }

    public final void updateCache(@NotNull List<IncrementalProcessor> processors) {
        Intrinsics.checkParameterIsNotNull(processors, (String)"processors");
        if (!this.aptCache.updateCache(processors)) {
            this.javaCache.invalidateAll$kotlin_annotation_processing_maven();
        }
    }

    @NotNull
    public final SourcesToReprocess invalidateAndGetDirtyFiles(@NotNull Collection<? extends File> changedSources, @NotNull Collection<String> dirtyClasspathJvmNames) {
        SourcesToReprocess sourcesToReprocess;
        Intrinsics.checkParameterIsNotNull(changedSources, (String)"changedSources");
        Intrinsics.checkParameterIsNotNull(dirtyClasspathJvmNames, (String)"dirtyClasspathJvmNames");
        if (!this.aptCache.isIncremental()) {
            return SourcesToReprocess.FullRebuild.INSTANCE;
        }
        HashSet<String> dirtyClasspathFqNames = new HashSet<String>(dirtyClasspathJvmNames.size());
        Iterable $this$forEach$iv = dirtyClasspathJvmNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            dirtyClasspathFqNames.add(StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"/", (String)".", (boolean)false, (int)4, null));
        }
        Changes changes = new Changes(changedSources, CollectionsKt.toSet((Iterable)dirtyClasspathFqNames));
        SourcesToReprocess filesToReprocess = this.javaCache.invalidateEntriesForChangedFiles(changes);
        SourcesToReprocess sourcesToReprocess2 = filesToReprocess;
        if (sourcesToReprocess2 instanceof SourcesToReprocess.FullRebuild) {
            sourcesToReprocess = SourcesToReprocess.FullRebuild.INSTANCE;
        } else if (sourcesToReprocess2 instanceof SourcesToReprocess.Incremental) {
            Set toReprocess = CollectionsKt.toMutableSet((Iterable)((SourcesToReprocess.Incremental)filesToReprocess).getToReprocess());
            List<File> isolatingGenerated = this.aptCache.invalidateIsolatingGenerated(toReprocess);
            Set generatedDirtyTypes = CollectionsKt.toMutableSet((Iterable)this.javaCache.invalidateGeneratedTypes(isolatingGenerated));
            if (!toReprocess.isEmpty()) {
                List<File> aggregatingGenerated = this.aptCache.invalidateAggregating();
                generatedDirtyTypes.addAll((Collection)this.javaCache.invalidateGeneratedTypes(aggregatingGenerated));
                toReprocess.addAll((Collection)this.javaCache.invalidateEntriesAnnotatedWith(this.aptCache.getAggregatingClaimedAnnotations()));
            }
            sourcesToReprocess = new SourcesToReprocess.Incremental(CollectionsKt.toList((Iterable)toReprocess), generatedDirtyTypes);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sourcesToReprocess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IncrementalAptCache maybeGetAptCacheFromFile() {
        Serializable serializable;
        if (this.aptCacheFile.exists()) {
            Object object;
            try {
                IncrementalAptCache incrementalAptCache;
                object = this.aptCacheFile;
                boolean bl = false;
                FileInputStream fileInputStream = new FileInputStream((File)object);
                InputStream inputStream = fileInputStream;
                InputStream inputStream2 = new BufferedInputStream(inputStream);
                object = new ObjectInputStream(inputStream2);
                bl = false;
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl2 = false;
                    Object object2 = it.readObject();
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.kapt3.base.incremental.IncrementalAptCache");
                    }
                    incrementalAptCache = (IncrementalAptCache)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = incrementalAptCache;
            }
            catch (Throwable e) {
                object = new IncrementalAptCache();
            }
            serializable = object;
        } else {
            serializable = new IncrementalAptCache();
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JavaClassCache maybeGetJavaCacheFromFile() {
        Serializable serializable;
        if (this.javaCacheFile.exists()) {
            Object object;
            try {
                JavaClassCache javaClassCache;
                object = this.javaCacheFile;
                boolean bl = false;
                FileInputStream fileInputStream = new FileInputStream((File)object);
                InputStream inputStream = fileInputStream;
                InputStream inputStream2 = new BufferedInputStream(inputStream);
                object = new ObjectInputStream(inputStream2);
                bl = false;
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl2 = false;
                    Object object2 = it.readObject();
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache");
                    }
                    javaClassCache = (JavaClassCache)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = javaClassCache;
            }
            catch (Throwable e) {
                object = new JavaClassCache();
            }
            serializable = object;
        } else {
            serializable = new JavaClassCache();
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ObjectOutputStream it2;
        if (this.closed) {
            return;
        }
        File file = this.javaCacheFile;
        boolean bl = false;
        boolean bl2 = false;
        File $this$with = file;
        boolean bl3 = false;
        $this$with.delete();
        $this$with.getParentFile().mkdirs();
        Object object = $this$with;
        boolean bl4 = false;
        FileOutputStream fileOutputStream = new FileOutputStream((File)object);
        OutputStream outputStream = fileOutputStream;
        OutputStream outputStream2 = new BufferedOutputStream(outputStream);
        object = new ObjectOutputStream(outputStream2);
        bl4 = false;
        Throwable throwable = null;
        try {
            it2 = (ObjectOutputStream)object;
            boolean bl5 = false;
            it2.writeObject(this.javaCache);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        file = this.aptCacheFile;
        bl = false;
        bl2 = false;
        $this$with = file;
        boolean bl6 = false;
        $this$with.delete();
        $this$with.getParentFile().mkdirs();
        object = $this$with;
        bl4 = false;
        fileOutputStream = new FileOutputStream((File)object);
        OutputStream outputStream3 = fileOutputStream;
        OutputStream outputStream4 = new BufferedOutputStream(outputStream3);
        object = new ObjectOutputStream(outputStream4);
        bl4 = false;
        throwable = null;
        try {
            it2 = (ObjectOutputStream)object;
            boolean bl7 = false;
            it2.writeObject(this.aptCache);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        this.closed = true;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public JavaClassCacheManager(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        this.javaCacheFile = FilesKt.resolve((File)this.file, (String)"java-cache.bin");
        this.javaCache = this.maybeGetJavaCacheFromFile();
        this.aptCacheFile = FilesKt.resolve((File)this.file, (String)"apt-cache.bin");
        this.aptCache = this.maybeGetAptCacheFromFile();
    }
}

