/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.util;

import java.io.PrintWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/util/WriterBackedKaptLogger;", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "isVerbose", "", "infoWriter", "Ljava/io/PrintWriter;", "warnWriter", "errorWriter", "(ZLjava/io/PrintWriter;Ljava/io/PrintWriter;Ljava/io/PrintWriter;)V", "getErrorWriter", "()Ljava/io/PrintWriter;", "getInfoWriter", "()Z", "getWarnWriter", "error", "", "message", "", "exception", "e", "", "info", "report", "prefix", "writer", "warn", "kotlin-annotation-processing-maven"})
public final class WriterBackedKaptLogger
implements KaptLogger {
    private final boolean isVerbose;
    @NotNull
    private final PrintWriter infoWriter;
    @NotNull
    private final PrintWriter warnWriter;
    @NotNull
    private final PrintWriter errorWriter;

    @Override
    public void info(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.isVerbose()) {
            this.report("INFO", message, this.getInfoWriter());
        }
    }

    @Override
    public void warn(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.report("WARN", message, this.getWarnWriter());
    }

    @Override
    public void error(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.report("ERROR", message, this.getErrorWriter());
    }

    @Override
    public void exception(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.getErrorWriter().println("An error occurred:");
        e.printStackTrace(this.getErrorWriter());
        this.getErrorWriter().flush();
    }

    private final void report(String prefix, String message, PrintWriter writer) {
        writer.println('[' + prefix + "] " + message);
        writer.flush();
    }

    @Override
    public boolean isVerbose() {
        return this.isVerbose;
    }

    @Override
    @NotNull
    public PrintWriter getInfoWriter() {
        return this.infoWriter;
    }

    @Override
    @NotNull
    public PrintWriter getWarnWriter() {
        return this.warnWriter;
    }

    @Override
    @NotNull
    public PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public WriterBackedKaptLogger(boolean isVerbose, @NotNull PrintWriter infoWriter, @NotNull PrintWriter warnWriter, @NotNull PrintWriter errorWriter) {
        Intrinsics.checkParameterIsNotNull((Object)infoWriter, (String)"infoWriter");
        Intrinsics.checkParameterIsNotNull((Object)warnWriter, (String)"warnWriter");
        Intrinsics.checkParameterIsNotNull((Object)errorWriter, (String)"errorWriter");
        this.isVerbose = isVerbose;
        this.infoWriter = infoWriter;
        this.warnWriter = warnWriter;
        this.errorWriter = errorWriter;
    }

    public /* synthetic */ WriterBackedKaptLogger(boolean bl, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            printWriter = new PrintWriter(System.out);
        }
        if ((n & 4) != 0) {
            printWriter2 = new PrintWriter(System.out);
        }
        if ((n & 8) != 0) {
            printWriter3 = new PrintWriter(System.err);
        }
        this(bl, printWriter, printWriter2, printWriter3);
    }
}

