/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.stubs;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.tools.javac.tree.JCTree;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.KaptContextForStubGeneration;
import org.jetbrains.kotlin.kapt3.base.stubs.FileInfoKt;
import org.jetbrains.kotlin.kapt3.base.stubs.KotlinPosition;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020$R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u0006j\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/kapt3/stubs/KaptLineMappingCollector;", "", "kaptContext", "Lorg/jetbrains/kotlin/kapt3/KaptContextForStubGeneration;", "(Lorg/jetbrains/kotlin/kapt3/KaptContextForStubGeneration;)V", "filePaths", "", "Lcom/intellij/psi/PsiFile;", "Lkotlin/Pair;", "", "", "lineInfo", "Lorg/jetbrains/kotlin/kapt3/base/stubs/KotlinPosition;", "Lorg/jetbrains/kotlin/kapt3/base/stubs/LineInfoMap;", "signatureInfo", "getFilePathRelativePreferred", "file", "register", "", "asmNode", "fqName", "psiElement", "Lcom/intellij/psi/PsiElement;", "registerClass", "clazz", "Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;", "registerField", "field", "Lorg/jetbrains/org/objectweb/asm/tree/FieldNode;", "registerMethod", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "registerSignature", "decl", "Lcom/sun/tools/javac/tree/JCTree$JCMethodDecl;", "serialize", "", "kotlin-annotation-processing-maven"})
public final class KaptLineMappingCollector {
    private final Map<String, KotlinPosition> lineInfo;
    private final Map<String, String> signatureInfo;
    private final Map<PsiFile, Pair<String, Boolean>> filePaths;
    private final KaptContextForStubGeneration kaptContext;

    public final void registerClass(@NotNull ClassNode clazz) {
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        String string = clazz.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clazz.name");
        this.register(clazz, string);
    }

    public final void registerMethod(@NotNull ClassNode clazz, @NotNull MethodNode method) {
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        this.register(method, clazz.name + "#" + method.name + method.desc);
    }

    public final void registerField(@NotNull ClassNode clazz, @NotNull FieldNode field) {
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this.register(field, clazz.name + "#" + field.name);
    }

    public final void registerSignature(@NotNull JCTree.JCMethodDecl decl, @NotNull MethodNode method) {
        Intrinsics.checkParameterIsNotNull((Object)decl, (String)"decl");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Map<String, String> map = this.signatureInfo;
        String string = FileInfoKt.getJavacSignature(decl);
        String string2 = method.name + method.desc;
        map.put(string, string2);
    }

    private final void register(Object asmNode, String fqName) {
        JvmDeclarationOrigin jvmDeclarationOrigin = this.kaptContext.getOrigins().get(asmNode);
        if (jvmDeclarationOrigin == null || (jvmDeclarationOrigin = jvmDeclarationOrigin.getElement()) == null) {
            return;
        }
        JvmDeclarationOrigin psiElement = jvmDeclarationOrigin;
        this.register(fqName, (PsiElement)psiElement);
    }

    /*
     * WARNING - void declaration
     */
    private final void register(String fqName, PsiElement psiElement) {
        void path;
        TextRange textRange = psiElement.getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange textRange2 = textRange;
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"psiElement.containingFile");
        Object object = this.getFilePathRelativePreferred(psiFile);
        String string = (String)object.component1();
        boolean isRelative = (Boolean)object.component2();
        object = this.lineInfo;
        KotlinPosition kotlinPosition = new KotlinPosition((String)path, isRelative, textRange2.getStartOffset());
        object.put((String)fqName, (KotlinPosition)kotlinPosition);
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<String, Boolean> getFilePathRelativePreferred(PsiFile file) {
        block6: {
            block5: {
                $receiver$iv = this.filePaths;
                value$iv = $receiver$iv.get(file);
                if (value$iv != null) break block5;
                v0 = file.getVirtualFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"file.virtualFile");
                v1 = v0.getCanonicalPath();
                if (v1 == null) {
                    v2 = file.getVirtualFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"file.virtualFile");
                    v1 = v2.getPath();
                }
                absolutePath = v1;
                absoluteFile = new File(absolutePath);
                v3 = file.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"file.project");
                v4 = v3.getBasePath();
                if (v4 != null) {
                    it = var6_6 = v4;
                    v5 = new File(it);
                } else {
                    v5 = baseFile = null;
                }
                if (!absoluteFile.exists() || baseFile == null || !baseFile.exists()) ** GOTO lbl-1000
                v6 = FilesKt.relativeToOrNull((File)absoluteFile, (File)baseFile);
                v7 = relativePath = v6 != null ? v6.getPath() : null;
                if (relativePath != null) {
                    v8 = new Pair((Object)relativePath, (Object)true);
                } else lbl-1000:
                // 2 sources

                {
                    v8 = new Pair((Object)absolutePath, (Object)false);
                }
                answer$iv = v8;
                $receiver$iv.put(file, (Pair<String, Boolean>)answer$iv);
                v9 = answer$iv;
                break block6;
            }
            v9 = var3_3;
        }
        return v9;
    }

    @NotNull
    public final byte[] serialize() {
        Object fqName;
        Map.Entry<String, KotlinPosition> entry;
        Map.Entry<String, Object> entry2;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeInt(1);
        oos.writeInt(this.lineInfo.size());
        Map<String, KotlinPosition> map = this.lineInfo;
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = entry2 = iterator.next();
            fqName = entry.getKey();
            entry = entry2;
            KotlinPosition kotlinPosition = entry.getValue();
            oos.writeUTF((String)fqName);
            oos.writeUTF(kotlinPosition.getPath());
            oos.writeBoolean(kotlinPosition.isRelativePath());
            oos.writeInt(kotlinPosition.getPos());
        }
        oos.writeInt(this.signatureInfo.size());
        fqName = this.signatureInfo;
        iterator = fqName.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = entry2 = iterator.next();
            String javacSignature = entry.getKey();
            entry = entry2;
            String methodDesc = (String)((Object)entry.getValue());
            oos.writeUTF(javacSignature);
            oos.writeUTF(methodDesc);
        }
        oos.flush();
        byte[] byArray = os.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"os.toByteArray()");
        return byArray;
    }

    public KaptLineMappingCollector(@NotNull KaptContextForStubGeneration kaptContext) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)kaptContext, (String)"kaptContext");
        this.kaptContext = kaptContext;
        KaptLineMappingCollector kaptLineMappingCollector = this;
        kaptLineMappingCollector.lineInfo = map = (Map)new LinkedHashMap();
        kaptLineMappingCollector = this;
        kaptLineMappingCollector.signatureInfo = map = (Map)new LinkedHashMap();
        kaptLineMappingCollector = this;
        kaptLineMappingCollector.filePaths = map = (Map)new LinkedHashMap();
    }
}

