/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinFakeClsStubsCache;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinStandaloneDeclarationIndex;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinStandaloneDeclarationProvider;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.SmartPointerIncompatiblePsiFile;
import org.jetbrains.kotlin.analysis.decompiler.konan.K2KotlinNativeMetadataDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltinsVirtualFileProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinClsStubBuilder;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.JavaClassFileType;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClsStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContentImpl;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinObjectStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002UVBQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0006H\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020\b2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:H\u0002J\u0014\u0010;\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030<H\u0002J\u0010\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020\u001aH\u0002J$\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a0@2\u0006\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020CH\u0002J\u001a\u0010D\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020\t2\u0006\u0010B\u001a\u00020CH\u0002J\u001c\u0010E\u001a\u00020\u001f2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a0@H\u0002J\u001a\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\f\u0010N\u001a\b\u0012\u0004\u0012\u00020)0\bJ\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020)0P2\u0006\u0010Q\u001a\u00020RJ\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020.0P2\u0006\u0010T\u001a\u00020RR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDeclarationProviderFactory;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "sourceKtFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "binaryRoots", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "sharedBinaryRoots", "skipBuiltins", "", "shouldBuildStubsForBinaryLibraries", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/util/List;Ljava/util/List;ZZ)V", "index", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationIndex;", "psiManager", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "builtInDecompiler", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinBuiltInDecompiler;", "createdFakeKtFiles", "", "loadBuiltIns", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "createKtFileStub", "fileContent", "Lorg/jetbrains/kotlin/com/intellij/util/indexing/FileContent;", "registerStub", "", "stub", "virtualFile", "addToFacadeFileMap", "file", "addToScriptMap", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "indexClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "addToClassMap", "indexSupertypeNames", "indexTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "addToTypeAliasMap", "indexTypeAliasDefinition", "findInheritableSimpleNames", "", "typeElement", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "addToFunctionMap", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "addToPropertyMap", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "indexStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "processStub", "ktFileStub", "collectStubsFromBinaryRoot", "", "binaryRoot", "binaryClassCache", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache;", "buildStubByVirtualFile", "processCollectedStubs", "stubs", "createDeclarationProvider", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDeclarationProvider;", "scope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "contextualModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getAdditionalCreatedKtFiles", "getAllKtClasses", "getDirectInheritorCandidates", "", "baseClassName", "Lorg/jetbrains/kotlin/name/Name;", "getInheritableTypeAliases", "aliasedName", "KtClassFileViewProvider", "KtDeclarationRecorder", "analysis-api-standalone-base"})
@SourceDebugExtension(value={"SMAP\nKotlinStandaloneDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStandaloneDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,502:1\n1863#2,2:503\n1557#2:506\n1628#2,3:507\n1863#2,2:510\n1863#2,2:512\n1611#2,9:514\n1863#2:523\n1864#2:525\n1620#2:526\n1863#2,2:527\n1863#2,2:529\n1863#2,2:531\n1863#2,2:533\n808#2,11:535\n1863#2,2:546\n1863#2,2:548\n1#3:505\n1#3:524\n216#4,2:550\n*S KotlinDebug\n*F\n+ 1 KotlinStandaloneDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory\n*L\n343#1:503,2\n363#1:506\n363#1:507,3\n364#1:510,2\n367#1:512,2\n174#1:514,9\n174#1:523\n174#1:525\n174#1:526\n264#1:527,2\n287#1:529,2\n377#1:531,2\n382#1:533,2\n389#1:535,11\n389#1:546,2\n409#1:548,2\n174#1:524\n446#1:550,2\n*E\n"})
public final class KotlinStandaloneDeclarationProviderFactory
implements KotlinDeclarationProviderFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final KotlinStandaloneDeclarationIndex index;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final KotlinBuiltInDecompiler builtInDecompiler;
    @NotNull
    private final List<KtFile> createdFakeKtFiles;

    /*
     * WARNING - void declaration
     */
    public KotlinStandaloneDeclarationProviderFactory(@NotNull Project project, @NotNull Collection<? extends KtFile> sourceKtFiles, @NotNull List<? extends VirtualFile> binaryRoots, @NotNull List<? extends VirtualFile> sharedBinaryRoots, boolean skipBuiltins, boolean shouldBuildStubsForBinaryLibraries) {
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sourceKtFiles, (String)"sourceKtFiles");
        Intrinsics.checkNotNullParameter(binaryRoots, (String)"binaryRoots");
        Intrinsics.checkNotNullParameter(sharedBinaryRoots, (String)"sharedBinaryRoots");
        this.project = project;
        this.index = new KotlinStandaloneDeclarationIndex();
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
        this.builtInDecompiler = new KotlinBuiltInDecompiler();
        this.createdFakeKtFiles = new ArrayList();
        KtDeclarationRecorder recorder = new KtDeclarationRecorder();
        if (!skipBuiltins) {
            $this$forEach$iv = this.loadBuiltIns();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinFileStubImpl it = (KotlinFileStubImpl)element$iv;
                boolean bl = false;
                this.processStub(it);
            }
        }
        if (shouldBuildStubsForBinaryLibraries) {
            void $this$forEach$iv2;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object element$iv;
            ClsKotlinBinaryClassCache binaryClassCache = ClsKotlinBinaryClassCache.Companion.getInstance();
            for (VirtualFile virtualFile : sharedBinaryRoots) {
                element$iv = KotlinFakeClsStubsCache.Companion.processAdditionalRoot(virtualFile, (Function1<? super VirtualFile, ? extends Map<VirtualFile, KotlinFileStubImpl>>)((Function1)arg_0 -> KotlinStandaloneDeclarationProviderFactory._init_$lambda$23(this, binaryClassCache, arg_0)));
                if (element$iv == null) continue;
                Object p0 = element$iv;
                boolean bl2 = false;
                this.processCollectedStubs((Map<VirtualFile, KotlinFileStubImpl>)p0);
            }
            Iterable $i$f$forEach2 = binaryRoots;
            boolean bl = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator bl2 = $this$mapTo$iv$iv.iterator();
            while (bl2.hasNext()) {
                void it;
                Object item$iv$iv = bl2.next();
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl22 = false;
                collection.add(this.collectStubsFromBinaryRoot((VirtualFile)it, binaryClassCache));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean bl3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map it = (Map)element$iv2;
                boolean bl32 = false;
                this.processCollectedStubs(it);
            }
        }
        $this$forEach$iv = sourceKtFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile file = (KtFile)element$iv;
            boolean bl = false;
            file.accept((PsiElementVisitor)recorder);
        }
    }

    public /* synthetic */ KotlinStandaloneDeclarationProviderFactory(Project project, Collection collection, List list, List list2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(project, collection, list, list2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KotlinFileStubImpl> loadBuiltIns() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = BuiltinsVirtualFileProvider.Companion.getInstance().getBuiltinVirtualFiles();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KotlinFileStubImpl it$iv$iv;
            FileContent fileContent;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)FileContentImpl.createByFile((VirtualFile)virtualFile, (Project)this.project), (String)"createByFile(...)");
            if (this.createKtFileStub(fileContent) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KotlinFileStubImpl createKtFileStub(FileContent fileContent) {
        PsiFileStub psiFileStub = this.builtInDecompiler.getStubBuilder().buildFileStub(fileContent);
        KotlinFileStubImpl kotlinFileStubImpl = psiFileStub instanceof KotlinFileStubImpl ? (KotlinFileStubImpl)psiFileStub : null;
        if (kotlinFileStubImpl == null) {
            return null;
        }
        KotlinFileStubImpl stub = kotlinFileStubImpl;
        VirtualFile virtualFile = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.registerStub(stub, virtualFile);
        return stub;
    }

    private final void registerStub(KotlinFileStubImpl stub, VirtualFile virtualFile) {
        KtClassFileViewProvider fileViewProvider = new KtClassFileViewProvider(this.psiManager, virtualFile);
        SmartPointerIncompatiblePsiFile fakeFile2 = new SmartPointerIncompatiblePsiFile(fileViewProvider, stub){
            final /* synthetic */ KotlinFileStubImpl $stub;
            {
                this.$stub = $stub;
                super((FileViewProvider)$fileViewProvider, true);
            }

            public KotlinFileStub getStub() {
                return (KotlinFileStub)this.$stub;
            }

            public boolean isPhysical() {
                return false;
            }
        };
        stub.setPsi((PsiFile)fakeFile2);
        this.createdFakeKtFiles.add((KtFile)fakeFile2);
    }

    private final void addToFacadeFileMap(KtFile file) {
        if (!file.hasTopLevelCallables()) {
            return;
        }
        this.index.getFacadeFileMap$analysis_api_standalone_base().computeIfAbsent(file.getPackageFqName(), arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToFacadeFileMap$lambda$2(KotlinStandaloneDeclarationProviderFactory::addToFacadeFileMap$lambda$1, arg_0)).add(file);
    }

    private final void addToScriptMap(KtScript script) {
        this.index.getScriptMap$analysis_api_standalone_base().computeIfAbsent(script.getFqName(), arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToScriptMap$lambda$4(KotlinStandaloneDeclarationProviderFactory::addToScriptMap$lambda$3, arg_0)).add(script);
    }

    private final void indexClassOrObject(KtClassOrObject classOrObject) {
        this.addToClassMap(classOrObject);
        this.indexSupertypeNames(classOrObject);
    }

    private final void addToClassMap(KtClassOrObject classOrObject) {
        block0: {
            ClassId classId = classOrObject.getClassId();
            if (classId == null) break block0;
            ClassId classId2 = classId;
            boolean bl = false;
            this.index.getClassMap$analysis_api_standalone_base().computeIfAbsent(classId2.getPackageFqName(), arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToClassMap$lambda$7$lambda$6(KotlinStandaloneDeclarationProviderFactory::addToClassMap$lambda$7$lambda$5, arg_0)).add(classOrObject);
        }
    }

    private final void indexSupertypeNames(KtClassOrObject classOrObject) {
        Iterable $this$forEach$iv = KtPsiUtilKt.getSuperNames((StubBasedPsiElementBase)((StubBasedPsiElementBase)classOrObject));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String superName = (String)element$iv;
            boolean bl = false;
            this.index.getClassesBySupertypeName$analysis_api_standalone_base().computeIfAbsent(Name.identifier((String)superName), arg_0 -> KotlinStandaloneDeclarationProviderFactory.indexSupertypeNames$lambda$10$lambda$9(KotlinStandaloneDeclarationProviderFactory::indexSupertypeNames$lambda$10$lambda$8, arg_0)).add(classOrObject);
        }
    }

    private final void indexTypeAlias(KtTypeAlias typeAlias) {
        this.addToTypeAliasMap(typeAlias);
        this.indexTypeAliasDefinition(typeAlias);
    }

    private final void addToTypeAliasMap(KtTypeAlias typeAlias) {
        block0: {
            ClassId classId = typeAlias.getClassId();
            if (classId == null) break block0;
            ClassId classId2 = classId;
            boolean bl = false;
            this.index.getTypeAliasMap$analysis_api_standalone_base().computeIfAbsent(classId2.getPackageFqName(), arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToTypeAliasMap$lambda$13$lambda$12(KotlinStandaloneDeclarationProviderFactory::addToTypeAliasMap$lambda$13$lambda$11, arg_0)).add(typeAlias);
        }
    }

    private final void indexTypeAliasDefinition(KtTypeAlias typeAlias) {
        KtTypeReference ktTypeReference = typeAlias.getTypeReference();
        if (ktTypeReference == null || (ktTypeReference = ktTypeReference.getTypeElement()) == null) {
            return;
        }
        KtTypeReference typeElement = ktTypeReference;
        Iterable $this$forEach$iv = this.findInheritableSimpleNames((KtTypeElement)typeElement);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String expandedName = (String)element$iv;
            boolean bl = false;
            this.index.getInheritableTypeAliasesByAliasedName$analysis_api_standalone_base().computeIfAbsent(Name.identifier((String)expandedName), arg_0 -> KotlinStandaloneDeclarationProviderFactory.indexTypeAliasDefinition$lambda$16$lambda$15(KotlinStandaloneDeclarationProviderFactory::indexTypeAliasDefinition$lambda$16$lambda$14, arg_0)).add(typeAlias);
        }
    }

    private final List<String> findInheritableSimpleNames(KtTypeElement typeElement) {
        List list;
        block5: {
            block6: {
                block7: {
                    KtTypeElement ktTypeElement;
                    block4: {
                        List list2;
                        ktTypeElement = typeElement;
                        if (!(ktTypeElement instanceof KtUserType)) break block4;
                        String string = ((KtUserType)typeElement).getReferencedName();
                        if (string == null) {
                            return kotlin.collections.CollectionsKt.emptyList();
                        }
                        String referenceName = string;
                        List $this$findInheritableSimpleNames_u24lambda_u2417 = list2 = kotlin.collections.CollectionsKt.createListBuilder();
                        boolean bl = false;
                        $this$findInheritableSimpleNames_u24lambda_u2417.add(referenceName);
                        KtFile ktFile = ((KtUserType)typeElement).getContainingKtFile();
                        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
                        KtFile ktFile2 = ktFile;
                        if (!ktFile2.isCompiled()) {
                            Collection collection = $this$findInheritableSimpleNames_u24lambda_u2417;
                            KtFile ktFile3 = ((KtUserType)typeElement).getContainingKtFile();
                            Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"getContainingKtFile(...)");
                            CollectionsKt.addIfNotNull((Collection)collection, (Object)KtPsiUtilKt.getImportedSimpleNameByImportAlias((KtFile)ktFile3, (String)referenceName));
                        }
                        list = kotlin.collections.CollectionsKt.build((List)list2);
                        break block5;
                    }
                    if (!(ktTypeElement instanceof KtNullableType)) break block6;
                    list = ((KtNullableType)typeElement).getInnerType();
                    if (list == null) break block7;
                    List p0 = list;
                    boolean bl = false;
                    List list3 = this.findInheritableSimpleNames((KtTypeElement)p0);
                    list = list3;
                    if (list3 != null) break block5;
                }
                list = kotlin.collections.CollectionsKt.emptyList();
                break block5;
            }
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    private final void addToFunctionMap(KtNamedFunction function) {
        if (!function.isTopLevel()) {
            return;
        }
        PsiElement psiElement = function.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
        this.index.getTopLevelFunctionMap$analysis_api_standalone_base().computeIfAbsent(packageFqName, arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToFunctionMap$lambda$19(KotlinStandaloneDeclarationProviderFactory::addToFunctionMap$lambda$18, arg_0)).add(function);
    }

    private final void addToPropertyMap(KtProperty property) {
        if (!property.isTopLevel()) {
            return;
        }
        PsiElement psiElement = property.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
        this.index.getTopLevelPropertyMap$analysis_api_standalone_base().computeIfAbsent(packageFqName, arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToPropertyMap$lambda$21(KotlinStandaloneDeclarationProviderFactory::addToPropertyMap$lambda$20, arg_0)).add(property);
    }

    /*
     * WARNING - void declaration
     */
    private final void indexStub(StubElement<?> stub) {
        block5: {
            void $this$filterIsInstanceTo$iv$iv;
            StubElement<?> stubElement;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                stubElement = stub;
                                if (!(stubElement instanceof KotlinClassStubImpl)) break block4;
                                PsiElement psiElement = ((KotlinClassStubImpl)stub).getPsi();
                                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                                this.indexClassOrObject((KtClassOrObject)psiElement);
                                List list = ((KotlinClassStubImpl)stub).getChildrenStubs();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
                                Iterable $this$forEach$iv = list;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    StubElement p0 = (StubElement)element$iv;
                                    boolean bl = false;
                                    this.indexStub(p0);
                                }
                                break block5;
                            }
                            if (!(stubElement instanceof KotlinObjectStubImpl)) break block6;
                            PsiElement psiElement = ((KotlinObjectStubImpl)stub).getPsi();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                            this.indexClassOrObject((KtClassOrObject)psiElement);
                            List list = ((KotlinObjectStubImpl)stub).getChildrenStubs();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
                            Iterable $this$forEach$iv = list;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                StubElement p0 = (StubElement)element$iv;
                                boolean bl = false;
                                this.indexStub(p0);
                            }
                            break block5;
                        }
                        if (!(stubElement instanceof KotlinTypeAliasStubImpl)) break block7;
                        PsiElement psiElement = ((KotlinTypeAliasStubImpl)stub).getPsi();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                        this.indexTypeAlias((KtTypeAlias)psiElement);
                        break block5;
                    }
                    if (!(stubElement instanceof KotlinFunctionStubImpl)) break block8;
                    PsiElement psiElement = ((KotlinFunctionStubImpl)stub).getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                    this.addToFunctionMap((KtNamedFunction)psiElement);
                    break block5;
                }
                if (!(stubElement instanceof KotlinPropertyStubImpl)) break block9;
                PsiElement psiElement = ((KotlinPropertyStubImpl)stub).getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                this.addToPropertyMap((KtProperty)psiElement);
                break block5;
            }
            if (!(stubElement instanceof KotlinPlaceHolderStubImpl) || !Intrinsics.areEqual((Object)((KotlinPlaceHolderStubImpl)stub).getStubType(), (Object)KtStubElementTypes.CLASS_BODY)) break block5;
            List list = ((KotlinPlaceHolderStubImpl)stub).getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KotlinClassOrObjectStub)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StubElement p0 = (StubElement)element$iv;
                boolean bl = false;
                this.indexStub(p0);
            }
        }
    }

    private final void processStub(KotlinFileStubImpl ktFileStub) {
        PsiFile psiFile = ktFileStub.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getPsi(...)");
        KtFile ktFile = (KtFile)psiFile;
        this.addToFacadeFileMap(ktFile);
        List partNames = ktFileStub.getFacadePartSimpleNames();
        if (partNames != null) {
            FqName packageFqName = ktFileStub.getPackageFqName();
            for (String partName : partNames) {
                Name name = Name.identifier((String)partName);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
                FqName multiFileClassPartFqName = packageFqName.child(name);
                this.index.getMultiFileClassPartMap$analysis_api_standalone_base().computeIfAbsent(multiFileClassPartFqName, arg_0 -> KotlinStandaloneDeclarationProviderFactory.processStub$lambda$32(KotlinStandaloneDeclarationProviderFactory::processStub$lambda$31, arg_0)).add(ktFile);
            }
        }
        List list = ktFileStub.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StubElement p0 = (StubElement)element$iv;
            boolean bl = false;
            this.indexStub(p0);
        }
    }

    private final Map<VirtualFile, KotlinFileStubImpl> collectStubsFromBinaryRoot(VirtualFile binaryRoot, ClsKotlinBinaryClassCache binaryClassCache) {
        Map map;
        Map $this$collectStubsFromBinaryRoot_u24lambda_u2434 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)binaryRoot, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>(this, binaryClassCache, (Map<VirtualFile, KotlinFileStubImpl>)$this$collectStubsFromBinaryRoot_u24lambda_u2434, optionArray){
            final /* synthetic */ KotlinStandaloneDeclarationProviderFactory this$0;
            final /* synthetic */ ClsKotlinBinaryClassCache $binaryClassCache;
            final /* synthetic */ Map<VirtualFile, KotlinFileStubImpl> $this_buildMap;
            {
                this.this$0 = $receiver;
                this.$binaryClassCache = $binaryClassCache;
                this.$this_buildMap = $receiver2;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.isDirectory()) {
                    KotlinFileStubImpl kotlinFileStubImpl = KotlinStandaloneDeclarationProviderFactory.access$buildStubByVirtualFile(this.this$0, file, this.$binaryClassCache);
                    if (kotlinFileStubImpl == null) {
                        return true;
                    }
                    KotlinFileStubImpl stub = kotlinFileStubImpl;
                    this.$this_buildMap.put(file, stub);
                }
                return true;
            }
        }));
        return MapsKt.build((Map)map);
    }

    private final KotlinFileStubImpl buildStubByVirtualFile(VirtualFile file, ClsKotlinBinaryClassCache binaryClassCache) {
        ClsStubBuilder clsStubBuilder;
        FileContent fileContent = FileContentImpl.createByFile((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)fileContent, (String)"createByFile(...)");
        FileContent fileContent2 = fileContent;
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        if (binaryClassCache.isKotlinJvmCompiledFile(file, fileContent2.getContent()) && Intrinsics.areEqual((Object)fileType2, (Object)JavaClassFileType.INSTANCE)) {
            clsStubBuilder = (ClsStubBuilder)new KotlinClsStubBuilder();
        } else if (Intrinsics.areEqual((Object)fileType2, (Object)KotlinBuiltInFileType.INSTANCE) && !Intrinsics.areEqual((Object)file.getExtension(), (Object)"kotlin_builtins")) {
            clsStubBuilder = (ClsStubBuilder)this.builtInDecompiler.getStubBuilder();
        } else if (Intrinsics.areEqual((Object)fileType2, (Object)KlibMetaFileType.INSTANCE)) {
            clsStubBuilder = (ClsStubBuilder)new K2KotlinNativeMetadataDecompiler().getStubBuilder();
        } else {
            return null;
        }
        ClsStubBuilder stubBuilder = clsStubBuilder;
        PsiFileStub psiFileStub = stubBuilder.buildFileStub(fileContent2);
        return psiFileStub instanceof KotlinFileStubImpl ? (KotlinFileStubImpl)psiFileStub : null;
    }

    private final void processCollectedStubs(Map<VirtualFile, KotlinFileStubImpl> stubs) {
        Map<VirtualFile, KotlinFileStubImpl> $this$forEach$iv = stubs;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VirtualFile, KotlinFileStubImpl>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VirtualFile, KotlinFileStubImpl> element$iv;
            Map.Entry<VirtualFile, KotlinFileStubImpl> entry = element$iv = iterator.next();
            boolean bl = false;
            KotlinFileStubImpl stub = entry.getValue();
            this.registerStub(stub, entry.getKey());
            this.processStub(stub);
        }
    }

    @Override
    @NotNull
    public KotlinDeclarationProvider createDeclarationProvider(@NotNull GlobalSearchScope scope, @Nullable KaModule contextualModule) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return new KotlinStandaloneDeclarationProvider(this.index, scope);
    }

    @NotNull
    public final List<KtFile> getAdditionalCreatedKtFiles() {
        return this.createdFakeKtFiles;
    }

    @NotNull
    public final List<KtClassOrObject> getAllKtClasses() {
        return (List)AddToStdlibKt.flattenTo((Iterable)this.index.getClassMap$analysis_api_standalone_base().values(), (Collection)new ArrayList());
    }

    @NotNull
    public final Set<KtClassOrObject> getDirectInheritorCandidates(@NotNull Name baseClassName) {
        Intrinsics.checkNotNullParameter((Object)baseClassName, (String)"baseClassName");
        Set set = this.index.getClassesBySupertypeName$analysis_api_standalone_base().get(baseClassName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<KtTypeAlias> getInheritableTypeAliases(@NotNull Name aliasedName) {
        Intrinsics.checkNotNullParameter((Object)aliasedName, (String)"aliasedName");
        Set set = this.index.getInheritableTypeAliasesByAliasedName$analysis_api_standalone_base().get(aliasedName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private static final Set addToFacadeFileMap$lambda$1(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToFacadeFileMap$lambda$2(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToScriptMap$lambda$3(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToScriptMap$lambda$4(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToClassMap$lambda$7$lambda$5(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToClassMap$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set indexSupertypeNames$lambda$10$lambda$8(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set indexSupertypeNames$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToTypeAliasMap$lambda$13$lambda$11(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToTypeAliasMap$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set indexTypeAliasDefinition$lambda$16$lambda$14(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set indexTypeAliasDefinition$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToFunctionMap$lambda$18(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToFunctionMap$lambda$19(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToPropertyMap$lambda$20(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToPropertyMap$lambda$21(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Map _init_$lambda$23(KotlinStandaloneDeclarationProviderFactory this$0, ClsKotlinBinaryClassCache $binaryClassCache, VirtualFile additionalRoot) {
        Intrinsics.checkNotNullParameter((Object)additionalRoot, (String)"additionalRoot");
        return this$0.collectStubsFromBinaryRoot(additionalRoot, $binaryClassCache);
    }

    private static final Set processStub$lambda$31(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set processStub$lambda$32(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KotlinFileStubImpl access$buildStubByVirtualFile(KotlinStandaloneDeclarationProviderFactory $this, VirtualFile file, ClsKotlinBinaryClassCache binaryClassCache) {
        return $this.buildStubByVirtualFile(file, binaryClassCache);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory$KtClassFileViewProvider;", "Lorg/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider;", "psiManager", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiManager;", "virtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;)V", "analysis-api-standalone-base"})
    private static final class KtClassFileViewProvider
    extends SingleRootFileViewProvider {
        public KtClassFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            super(psiManager, virtualFile, true, (Language)KotlinLanguage.INSTANCE);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory$KtDeclarationRecorder;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "analysis-api-standalone-base"})
    @SourceDebugExtension(value={"SMAP\nKotlinStandaloneDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStandaloneDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory$KtDeclarationRecorder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,502:1\n1#2:503\n*E\n"})
    private final class KtDeclarationRecorder
    extends KtVisitorVoid {
        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren((PsiElementVisitor)this);
        }

        public void visitKtFile(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KotlinStandaloneDeclarationProviderFactory.this.addToFacadeFileMap(file);
            KtScript ktScript = file.getScript();
            if (ktScript != null) {
                KtScript ktScript2 = ktScript;
                KotlinStandaloneDeclarationProviderFactory kotlinStandaloneDeclarationProviderFactory = KotlinStandaloneDeclarationProviderFactory.this;
                KtScript it = ktScript2;
                boolean bl = false;
                kotlinStandaloneDeclarationProviderFactory.addToScriptMap(it);
            }
            super.visitKtFile(file);
        }

        public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            KotlinStandaloneDeclarationProviderFactory.this.indexClassOrObject(classOrObject);
            super.visitClassOrObject(classOrObject);
        }

        public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            KotlinStandaloneDeclarationProviderFactory.this.indexTypeAlias(typeAlias);
            super.visitTypeAlias(typeAlias);
        }

        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            KotlinStandaloneDeclarationProviderFactory.this.addToFunctionMap(function);
            super.visitNamedFunction(function);
        }

        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            KotlinStandaloneDeclarationProviderFactory.this.addToPropertyMap(property);
            super.visitProperty(property);
        }
    }
}

