/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProvider;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0\u0017H\u0016J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0\u0017H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "searchScope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "doesPackageExist", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "doesPlatformSpecificPackageExist", "getSubPackageFqNames", "", "Lorg/jetbrains/kotlin/name/Name;", "nameFilter", "Lkotlin/Function1;", "getPlatformSpecificSubPackagesFqNames", "analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nKotlinPackageProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPackageProviderBase.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase\n+ 2 implUtils.kt\norg/jetbrains/kotlin/analysis/providers/impl/ImplUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n12#2,7:78\n12#2,5:85\n18#2:91\n1#3:90\n*S KotlinDebug\n*F\n+ 1 KotlinPackageProviderBase.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase\n*L\n29#1:78,7\n60#1:85,5\n60#1:91\n*E\n"})
public abstract class KotlinPackageProviderBase
extends KotlinPackageProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;

    public KotlinPackageProviderBase(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        this.project = project;
        this.searchScope = searchScope;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    @Override
    public boolean doesPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        return this.doesPlatformSpecificPackageExist(packageFqName, platform) || this.doesKotlinOnlyPackageExist(packageFqName);
    }

    @Override
    public boolean doesPlatformSpecificPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (JvmPlatformKt.isJvm((TargetPlatform)platform)) {
            String string = packageFqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String fqNameString = string;
            Project project$iv = this.project;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint((AreaInstance)project$iv).getExtensionList()) {
                if (Intrinsics.areEqual((Object)finder$iv.getClass().getName(), (Object)"org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNull((Object)finder$iv);
                PsiElementFinder finder = finder$iv;
                boolean bl = false;
                PsiPackage psiPackage = finder.findPackage(fqNameString);
                if (psiPackage == null) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<Name> getSubPackageFqNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        Set $this$getSubPackageFqNames_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getSubPackageFqNames_u24lambda_u241.addAll((Collection)this.getKotlinOnlySubPackagesFqNames(packageFqName, nameFilter));
        $this$getSubPackageFqNames_u24lambda_u241.addAll((Collection)this.getPlatformSpecificSubPackagesFqNames(packageFqName, platform, nameFilter));
        return SetsKt.build((Set)set);
    }

    @Override
    @NotNull
    public Set<Name> getPlatformSpecificSubPackagesFqNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        if (JvmPlatformKt.isJvm((TargetPlatform)platform)) {
            Set set2;
            String string = packageFqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String fqNameString = string;
            Set $this$getPlatformSpecificSubPackagesFqNames_u24lambda_u243 = set2 = SetsKt.createSetBuilder();
            boolean bl = false;
            Project project$iv = this.project;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint((AreaInstance)project$iv).getExtensionList()) {
                PsiPackage psiPackage;
                if (Intrinsics.areEqual((Object)finder$iv.getClass().getName(), (Object)"org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNull((Object)finder$iv);
                PsiElementFinder finder = finder$iv;
                boolean bl2 = false;
                if (finder.findPackage(fqNameString) == null) continue;
                for (PsiPackage subPackage : finder.getSubPackages(psiPackage, this.searchScope)) {
                    String name;
                    String string2 = subPackage.getName();
                    if (string2 == null) continue;
                    String p0 = string2;
                    boolean bl3 = false;
                    Name name2 = Name.identifierIfValid((String)p0);
                    string2 = name2;
                    if (name2 == null || !((Boolean)nameFilter.invoke((Object)(name = string2))).booleanValue()) continue;
                    $this$getPlatformSpecificSubPackagesFqNames_u24lambda_u243.add(name);
                }
            }
            set = SetsKt.build((Set)set2);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }
}

