/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KtSignatureSubstitutor;
import org.jetbrains.kotlin.analysis.api.signatures.KtCallableSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KtFunctionLikeSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KtVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtVariableLikeSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtSubstitutor;
import org.jetbrains.kotlin.analysis.utils.errors.UnexpectedElementErrorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ-\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\"\b\b\u0000\u0010\u0006*\u00020\r2\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0010\"\b\b\u0000\u0010\u0006*\u00020\u00112\u0006\u0010\b\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/components/AbstractKtSignatureSubstitutor;", "Lorg/jetbrains/kotlin/analysis/api/components/KtSignatureSubstitutor;", "<init>", "()V", "substitute", "Lorg/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature;", "S", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "symbol", "substitutor", "Lorg/jetbrains/kotlin/analysis/api/types/KtSubstitutor;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;Lorg/jetbrains/kotlin/analysis/api/types/KtSubstitutor;)Lorg/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature;", "Lorg/jetbrains/kotlin/analysis/api/signatures/KtVariableLikeSignature;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;Lorg/jetbrains/kotlin/analysis/api/types/KtSubstitutor;)Lorg/jetbrains/kotlin/analysis/api/signatures/KtVariableLikeSignature;", "asSignature", "Lorg/jetbrains/kotlin/analysis/api/signatures/KtCallableSignature;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;)Lorg/jetbrains/kotlin/analysis/api/signatures/KtCallableSignature;", "analysis-api-impl-base"})
public abstract class AbstractKtSignatureSubstitutor
extends KtSignatureSubstitutor {
    @Override
    @NotNull
    public <S extends KtFunctionLikeSymbol> KtFunctionLikeSignature<S> substitute(@NotNull S symbol, @NotNull KtSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        if (substitutor instanceof KtSubstitutor.Empty) {
            return ((KtSignatureSubstitutor)this).asSignature(symbol);
        }
        return ((KtSignatureSubstitutor)this).asSignature(symbol).substitute(substitutor);
    }

    @Override
    @NotNull
    public <S extends KtVariableLikeSymbol> KtVariableLikeSignature<S> substitute(@NotNull S symbol, @NotNull KtSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        if (substitutor instanceof KtSubstitutor.Empty) {
            return ((KtSignatureSubstitutor)this).asSignature(symbol);
        }
        return ((KtSignatureSubstitutor)this).asSignature(symbol).substitute(substitutor);
    }

    @Override
    @NotNull
    public <S extends KtCallableSymbol> KtCallableSignature<S> asSignature(@NotNull S symbol) {
        KtCallableSignature ktCallableSignature;
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        S s = symbol;
        if (s instanceof KtFunctionLikeSymbol) {
            ktCallableSignature = ((KtSignatureSubstitutor)this).asSignature((KtFunctionLikeSymbol)symbol);
        } else if (s instanceof KtVariableLikeSymbol) {
            ktCallableSignature = ((KtSignatureSubstitutor)this).asSignature((KtVariableLikeSymbol)symbol);
        } else {
            UnexpectedElementErrorKt.unexpectedElementError("symbol", symbol);
            throw null;
        }
        return ktCallableSignature;
    }
}

