/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.CleanableSoftValueCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirAbstractSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirCommonSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirDanglingFileSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJvmSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirNativeSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtDanglingFileModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleKt;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptDependencyModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.platform.JsPlatform;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatform;

@LLFirInternals
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 82\u00020\u0001:\u00018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0016H\u0002JK\u0010\u0017\u001a\u00020\n\"\b\b\u0000\u0010\u0018*\u00020\t2\u0006\u0010\u0010\u001a\u0002H\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u00072\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\n0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\tJ-\u0010!\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\t2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u0007H\u0002\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0012J\u0006\u0010%\u001a\u00020\u001eJ\u000e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\tJ\u0019\u0010(\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\tH\u0082\u0010J\u0006\u0010)\u001a\u00020\u001eJ\u0006\u0010*\u001a\u00020\u001eJ%\u0010+\u001a\u00020\u001e2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u0007H\u0002\u00a2\u0006\u0002\u0010,J%\u0010-\u001a\u00020\u001e2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u0007H\u0002\u00a2\u0006\u0002\u0010,J:\u0010.\u001a\u00020\u001e2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u00072\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u001bH\u0082\b\u00a2\u0006\u0002\u00100J\u0010\u00104\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010\u0010\u001a\u00020\tH\u0002J\b\u00107\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR \u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR \u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR \u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u00101\u001a\u00020\u0012*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sourceCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/SessionStorage;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;", "binaryCache", "danglingFileSessionCache", "unstableDanglingFileSessionCache", "getSession", "module", "preferBinary", "", "getSessionNoCaching", "getSessionNoCaching$low_level_api_fir", "getDanglingFileCachedSession", "Lorg/jetbrains/kotlin/analysis/project/structure/KtDanglingFileModule;", "getCachedSession", "T", "storage", "factory", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "checkSessionValidity", "", "session", "removeSession", "removeSessionFrom", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;)Z", "removeAllSessions", "includeLibraryModules", "removeUnstableDanglingFileSessions", "removeContextualDanglingFileSessions", "contextModule", "hasContextModule", "removeAllDanglingFileSessions", "removeAllScriptSessions", "removeAllScriptSessionsFrom", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;)V", "removeAllSessionsFrom", "removeAllMatchingSessionsFrom", "shouldBeRemoved", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;Lkotlin/jvm/functions/Function1;)V", "supportsIsolatedSessionCreation", "getSupportsIsolatedSessionCreation", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Z", "createSession", "createPlatformAwareSessionFactory", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirAbstractSessionFactory;", "dispose", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n+ 2 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n199#1:276\n200#1,4:278\n204#1:283\n199#1:284\n200#1,4:286\n204#1:291\n199#1:292\n200#1,4:294\n204#1:299\n199#1:300\n200#1,4:302\n204#1:307\n37#2,2:271\n37#2,2:273\n1#3:275\n1863#4:277\n1864#4:282\n1863#4:285\n1864#4:290\n1863#4:293\n1864#4:298\n1863#4:301\n1864#4:306\n1863#4,2:308\n1734#4,3:310\n1734#4,3:313\n1734#4,3:316\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n*L\n146#1:276\n146#1:278,4\n146#1:283\n160#1:284\n160#1:286,4\n160#1:291\n163#1:292\n163#1:294,4\n163#1:299\n189#1:300\n189#1:302,4\n189#1:307\n76#1:271,2\n93#1:273,2\n146#1:277\n146#1:282\n160#1:285\n160#1:290\n163#1:293\n163#1:298\n189#1:301\n189#1:306\n199#1:308,2\n233#1:310,3\n234#1:313,3\n235#1:316,3\n*E\n"})
public final class LLFirSessionCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CleanableSoftValueCache<KtModule, LLFirSession> sourceCache;
    @NotNull
    private final CleanableSoftValueCache<KtModule, LLFirSession> binaryCache;
    @NotNull
    private final CleanableSoftValueCache<KtModule, LLFirSession> danglingFileSessionCache;
    @NotNull
    private final CleanableSoftValueCache<KtModule, LLFirSession> unstableDanglingFileSessionCache;

    public LLFirSessionCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sourceCache = new CleanableSoftValueCache(sourceCache.1.INSTANCE);
        this.binaryCache = new CleanableSoftValueCache(binaryCache.1.INSTANCE);
        this.danglingFileSessionCache = new CleanableSoftValueCache(danglingFileSessionCache.1.INSTANCE);
        this.unstableDanglingFileSessionCache = new CleanableSoftValueCache(unstableDanglingFileSessionCache.1.INSTANCE);
    }

    @NotNull
    public final LLFirSession getSession(@NotNull KtModule module, boolean preferBinary) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module instanceof KtBinaryModule && (preferBinary || module instanceof KtSdkModule)) {
            return this.getCachedSession(module, this.binaryCache, arg_0 -> LLFirSessionCache.getSession$lambda$0(this, module, arg_0));
        }
        if (module instanceof KtDanglingFileModule) {
            return this.getDanglingFileCachedSession((KtDanglingFileModule)module);
        }
        return this.getCachedSession(module, this.sourceCache, (Function1)new Function1<KtModule, LLFirSession>((Object)this){

            public final LLFirSession invoke(KtModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
            }

            public final String getSignature() {
                return "createSession(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;";
            }

            public final String getName() {
                return "createSession";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(LLFirSessionCache.class);
            }
        });
    }

    public static /* synthetic */ LLFirSession getSession$default(LLFirSessionCache lLFirSessionCache, KtModule ktModule, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lLFirSessionCache.getSession(ktModule, bl);
    }

    @NotNull
    public final LLFirSession getSessionNoCaching$low_level_api_fir(@NotNull KtModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.createSession(module);
    }

    private final LLFirSession getDanglingFileCachedSession(KtDanglingFileModule module) {
        if (KtModuleKt.isStable((KtDanglingFileModule)module)) {
            return this.getCachedSession((KtModule)module, this.danglingFileSessionCache, (Function1)new Function1<KtModule, LLFirSession>((Object)this){

                public final LLFirSession invoke(KtModule p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
                }

                public final String getSignature() {
                    return "createSession(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;";
                }

                public final String getName() {
                    return "createSession";
                }

                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(LLFirSessionCache.class);
                }
            });
        }
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        LLFirSession session = this.unstableDanglingFileSessionCache.compute((KtModule)module, (Function2<KtModule, LLFirSession, LLFirSession>)((Function2)(arg_0, arg_1) -> LLFirSessionCache.getDanglingFileCachedSession$lambda$1(module, this, arg_0, arg_1)));
        if (session == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.checkSessionValidity(session);
        return session;
    }

    private final <T extends KtModule> LLFirSession getCachedSession(T module, CleanableSoftValueCache<KtModule, LLFirSession> storage, Function1<? super T, ? extends LLFirSession> factory) {
        LLFirSession lLFirSession;
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        if (this.getSupportsIsolatedSessionCreation(module)) {
            lLFirSession = storage.computeIfAbsent(module, (Function1<KtModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$2(factory, module, arg_0)));
        } else {
            lLFirSession = storage.get(module);
            if (lLFirSession == null) {
                LLFirSessionCache $this$getCachedSession_u24lambda_u244 = this;
                boolean bl = false;
                LLFirSession danglingSession = (LLFirSession)((Object)factory.invoke(module));
                lLFirSession = storage.computeIfAbsent(module, (Function1<KtModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$4$lambda$3(danglingSession, arg_0)));
            }
        }
        LLFirSession session = lLFirSession;
        this.checkSessionValidity(session);
        return session;
    }

    private final void checkSessionValidity(LLFirSession session) {
        if (!session.isValid()) {
            boolean bl = false;
            String string = "A session acquired via `getSession` should always be valid. Module: " + session.getKtModule();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean removeSession(@NotNull KtModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean didSourceSessionExist = this.removeSessionFrom(module, this.sourceCache);
        boolean didBinarySessionExist = module instanceof KtBinaryModule && this.removeSessionFrom(module, this.binaryCache);
        boolean didDanglingFileSessionExist = module instanceof KtDanglingFileModule && this.removeSessionFrom(module, this.danglingFileSessionCache);
        boolean didUnstableDanglingFileSessionExist = module instanceof KtDanglingFileModule && this.removeSessionFrom(module, this.unstableDanglingFileSessionCache);
        return didSourceSessionExist || didBinarySessionExist || didDanglingFileSessionExist || didUnstableDanglingFileSessionExist;
    }

    private final boolean removeSessionFrom(KtModule module, CleanableSoftValueCache<KtModule, LLFirSession> storage) {
        return storage.remove(module) != null;
    }

    public final void removeAllSessions(boolean includeLibraryModules) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (includeLibraryModules) {
            this.removeAllSessionsFrom(this.sourceCache);
            this.removeAllSessionsFrom(this.binaryCache);
        } else {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableSoftValueCache<KtModule, LLFirSession> storage$iv = this.sourceCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KtModule module$iv = (KtModule)element$iv$iv;
                boolean bl = false;
                KtModule it = module$iv;
                boolean bl2 = false;
                if (!(!(it instanceof KtBinaryModule) && !(it instanceof KtLibrarySourceModule))) continue;
                storage$iv.remove(module$iv);
            }
        }
        this.removeAllDanglingFileSessions();
    }

    public final void removeUnstableDanglingFileSessions() {
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeContextualDanglingFileSessions(@NotNull KtModule contextModule) {
        Intrinsics.checkNotNullParameter((Object)contextModule, (String)"contextModule");
        this.removeUnstableDanglingFileSessions();
        if (contextModule instanceof KtDanglingFileModule) {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableSoftValueCache<KtModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KtModule module$iv = (KtModule)element$iv$iv;
                boolean bl = false;
                KtModule it = module$iv;
                boolean bl2 = false;
                if (!(it instanceof KtDanglingFileModule && this.hasContextModule((KtDanglingFileModule)it, contextModule))) continue;
                storage$iv.remove(module$iv);
            }
        } else {
            LLFirSessionCache this_$iv = this;
            CleanableSoftValueCache<KtModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KtModule module$iv = (KtModule)element$iv$iv;
                boolean bl = false;
                KtModule it = module$iv;
                boolean bl3 = false;
                if (!(it instanceof KtDanglingFileModule && ((KtDanglingFileModule)it).isCodeFragment())) continue;
                storage$iv.remove(module$iv);
            }
        }
    }

    private final boolean hasContextModule(KtDanglingFileModule module, KtModule contextModule) {
        boolean bl;
        block2: {
            LLFirSessionCache lLFirSessionCache = this;
            while (true) {
                KtModule candidate;
                if (Intrinsics.areEqual((Object)(candidate = module.getContextModule()), (Object)contextModule)) {
                    bl = true;
                    break block2;
                }
                if (!(candidate instanceof KtDanglingFileModule)) break;
                LLFirSessionCache lLFirSessionCache2 = lLFirSessionCache;
                KtDanglingFileModule ktDanglingFileModule = (KtDanglingFileModule)candidate;
                KtModule ktModule = contextModule;
                lLFirSessionCache = lLFirSessionCache2;
                module = ktDanglingFileModule;
                contextModule = ktModule;
            }
            bl = false;
        }
        return bl;
    }

    public final void removeAllDanglingFileSessions() {
        this.removeAllSessionsFrom(this.danglingFileSessionCache);
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeAllScriptSessions() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeAllScriptSessionsFrom(this.sourceCache);
        this.removeAllScriptSessionsFrom(this.binaryCache);
    }

    private final void removeAllScriptSessionsFrom(CleanableSoftValueCache<KtModule, LLFirSession> storage) {
        LLFirSessionCache this_$iv = this;
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv$iv = storage.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            KtModule module$iv = (KtModule)element$iv$iv;
            boolean bl = false;
            KtModule it = module$iv;
            boolean bl2 = false;
            if (!(it instanceof KtScriptModule || it instanceof KtScriptDependencyModule)) continue;
            storage.remove(module$iv);
        }
    }

    private final void removeAllSessionsFrom(CleanableSoftValueCache<KtModule, LLFirSession> storage) {
        storage.clear();
    }

    private final void removeAllMatchingSessionsFrom(CleanableSoftValueCache<KtModule, LLFirSession> storage, Function1<? super KtModule, Boolean> shouldBeRemoved) {
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv = storage.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtModule module = (KtModule)element$iv;
            boolean bl = false;
            if (!((Boolean)shouldBeRemoved.invoke((Object)module)).booleanValue()) continue;
            storage.remove(module);
        }
    }

    private final boolean getSupportsIsolatedSessionCreation(KtModule $this$supportsIsolatedSessionCreation) {
        return !($this$supportsIsolatedSessionCreation instanceof KtDanglingFileModule);
    }

    private final LLFirSession createSession(KtModule module) {
        LLFirSession lLFirSession;
        LLFirAbstractSessionFactory sessionFactory = this.createPlatformAwareSessionFactory(module);
        KtModule ktModule = module;
        if (ktModule instanceof KtSourceModule) {
            lLFirSession = sessionFactory.createSourcesSession((KtSourceModule)module);
        } else if (ktModule instanceof KtLibraryModule || ktModule instanceof KtLibrarySourceModule) {
            lLFirSession = sessionFactory.createLibrarySession(module);
        } else if (ktModule instanceof KtSdkModule) {
            lLFirSession = sessionFactory.createBinaryLibrarySession((KtBinaryModule)module);
        } else if (ktModule instanceof KtScriptModule) {
            lLFirSession = sessionFactory.createScriptSession((KtScriptModule)module);
        } else if (ktModule instanceof KtDanglingFileModule) {
            LLFirSession contextSession = this.getSession(((KtDanglingFileModule)module).getContextModule(), false);
            lLFirSession = sessionFactory.createDanglingFileSession((KtDanglingFileModule)module, contextSession);
        } else if (ktModule instanceof KtNotUnderContentRootModule) {
            lLFirSession = sessionFactory.createNotUnderContentRootResolvableSession((KtNotUnderContentRootModule)module);
        } else {
            throw new IllegalStateException(("Unexpected module kind: " + Reflection.getOrCreateKotlinClass(module.getClass()).getSimpleName()).toString());
        }
        return lLFirSession;
    }

    private final LLFirAbstractSessionFactory createPlatformAwareSessionFactory(KtModule module) {
        LLFirAbstractSessionFactory lLFirAbstractSessionFactory;
        SimplePlatform it;
        boolean bl;
        boolean $i$f$all;
        Iterable $this$all$iv;
        TargetPlatform targetPlatform;
        block13: {
            targetPlatform = module.getPlatform();
            $this$all$iv = (Iterable)targetPlatform;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (SimplePlatform)element$iv;
                    boolean bl2 = false;
                    if (it instanceof JvmPlatform) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            lLFirAbstractSessionFactory = new LLFirJvmSessionFactory(this.project);
        } else {
            boolean bl3;
            block14: {
                $this$all$iv = (Iterable)targetPlatform;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (SimplePlatform)element$iv;
                        boolean bl4 = false;
                        if (it instanceof JsPlatform) continue;
                        bl3 = false;
                        break block14;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                lLFirAbstractSessionFactory = new LLFirJsSessionFactory(this.project);
            } else {
                boolean bl5;
                block15: {
                    $this$all$iv = (Iterable)targetPlatform;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (SimplePlatform)element$iv;
                            boolean bl6 = false;
                            if (it instanceof NativePlatform) continue;
                            bl5 = false;
                            break block15;
                        }
                        bl5 = true;
                    }
                }
                lLFirAbstractSessionFactory = bl5 ? (LLFirAbstractSessionFactory)new LLFirNativeSessionFactory(this.project) : (LLFirAbstractSessionFactory)new LLFirCommonSessionFactory(this.project);
            }
        }
        return lLFirAbstractSessionFactory;
    }

    public void dispose() {
    }

    private static final LLFirSession getSession$lambda$0(LLFirSessionCache this$0, KtModule $module, KtBinaryModule it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createPlatformAwareSessionFactory($module).createBinaryLibrarySession((KtBinaryModule)$module);
    }

    private static final LLFirSession getDanglingFileCachedSession$lambda$1(KtDanglingFileModule $module, LLFirSessionCache this$0, KtModule ktModule, LLFirSession existingSession) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ktModule, (String)"<unused var>");
        return existingSession instanceof LLFirDanglingFileSession && ((LLFirDanglingFileSession)existingSession).getModificationStamp() == $module.getFile().getModificationStamp() ? existingSession : this$0.createSession((KtModule)$module);
    }

    private static final LLFirSession getCachedSession$lambda$2(Function1 $factory, KtModule $module, KtModule it) {
        Intrinsics.checkNotNullParameter((Object)$factory, (String)"$factory");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LLFirSession)((Object)$factory.invoke((Object)$module));
    }

    private static final LLFirSession getCachedSession$lambda$4$lambda$3(LLFirSession $danglingSession, KtModule it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$danglingSession), (String)"$danglingSession");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $danglingSession;
    }

    public static final /* synthetic */ LLFirSession access$createSession(LLFirSessionCache $this, KtModule module) {
        return $this.createSession(module);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LLFirSessionCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LLFirSessionCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

