/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import java.net.URI;
import java.util.List;
import javax.lang.model.util.Elements;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache;
import org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure;
import org.jetbrains.kotlin.kapt3.base.incremental.TypeTreeVisitor;
import org.jetbrains.kotlin.kapt3.base.incremental.Visibility;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/MentionedTypesTaskListener;", "Lcom/sun/source/util/TaskListener;", "cache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "elementUtils", "Ljavax/lang/model/util/Elements;", "trees", "Lcom/sun/source/util/Trees;", "<init>", "(Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;Ljavax/lang/model/util/Elements;Lcom/sun/source/util/Trees;)V", "time", "", "getTime", "()J", "setTime", "(J)V", "failureReason", "", "getFailureReason", "()Ljava/lang/String;", "setFailureReason", "(Ljava/lang/String;)V", "started", "", "e", "Lcom/sun/source/util/TaskEvent;", "finished", "kotlin-annotation-processing-base"})
@SourceDebugExtension(value={"SMAP\njavacVisitors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 javacVisitors.kt\norg/jetbrains/kotlin/kapt3/base/incremental/MentionedTypesTaskListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1863#2,2:249\n*S KotlinDebug\n*F\n+ 1 javacVisitors.kt\norg/jetbrains/kotlin/kapt3/base/incremental/MentionedTypesTaskListener\n*L\n42#1:249,2\n*E\n"})
public final class MentionedTypesTaskListener
implements TaskListener {
    @NotNull
    private final JavaClassCache cache;
    @NotNull
    private final Elements elementUtils;
    @NotNull
    private final Trees trees;
    private long time;
    @Nullable
    private String failureReason;

    public MentionedTypesTaskListener(@NotNull JavaClassCache cache, @NotNull Elements elementUtils, @NotNull Trees trees) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)elementUtils, (String)"elementUtils");
        Intrinsics.checkNotNullParameter((Object)trees, (String)"trees");
        this.cache = cache;
        this.elementUtils = elementUtils;
        this.trees = trees;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    @Nullable
    public final String getFailureReason() {
        return this.failureReason;
    }

    public final void setFailureReason(@Nullable String string) {
        this.failureReason = string;
    }

    @Override
    public void started(@NotNull TaskEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void finished(@NotNull TaskEvent e) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.failureReason != null) {
                    return;
                }
                if (e.getKind() != TaskEvent.Kind.ENTER) break block7;
                URI uRI = e.getSourceFile().toUri();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
                if (!this.cache.isAlreadyProcessed(uRI)) break block8;
            }
            return;
        }
        try {
            long l = System.currentTimeMillis();
            CompilationUnitTree compilationUnit = e.getCompilationUnit();
            URI uRI = e.getSourceFile().toUri();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
            SourceFileStructure structure = new SourceFileStructure(uRI);
            Intrinsics.checkNotNull((Object)compilationUnit);
            TypeTreeVisitor treeVisitor = new TypeTreeVisitor(this.elementUtils, this.trees, compilationUnit, structure);
            List<? extends Tree> list = compilationUnit.getTypeDecls();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeDecls(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tree it = (Tree)element$iv;
                boolean bl = false;
                it.accept(treeVisitor, Visibility.ABI);
            }
            this.cache.addSourceStructure(structure);
            this.time += System.currentTimeMillis() - l;
        }
        catch (Throwable t) {
            this.failureReason = "Running non-incrementally because analyzing " + e.getSourceFile().toUri() + " failed.";
        }
    }
}

