/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtVariableLikeSymbol;
import org.jetbrains.kotlin.analysis.providers.KotlinPsiDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinPsiDeclarationProviderKt;
import org.jetbrains.kotlin.analysis.providers.PsiDeclarationAndKtSymbolEqualityChecker;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/DecompiledPsiDeclarationProvider;", "", "<init>", "()V", "findPsi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "ktSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "providePsiForConstructor", "constructorSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtConstructorSymbol;", "providePsiForFunction", "functionLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "providePsiForProperty", "variableLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;", "providePsiForClass", "classLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "providePsiForEnumEntry", "enumEntrySymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtEnumEntrySymbol;", "scope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "symbol-light-classes"})
public final class DecompiledPsiDeclarationProvider {
    @NotNull
    public static final DecompiledPsiDeclarationProvider INSTANCE = new DecompiledPsiDeclarationProvider();

    private DecompiledPsiDeclarationProvider() {
    }

    @Nullable
    public final PsiElement findPsi(@NotNull KtAnalysisSession $this$findPsi, @NotNull KtSymbol ktSymbol, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$findPsi, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ktSymbol, (String)"ktSymbol");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtSymbol ktSymbol2 = ktSymbol;
        return ktSymbol2 instanceof KtConstructorSymbol ? this.providePsiForConstructor($this$findPsi, (KtConstructorSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtFunctionLikeSymbol ? this.providePsiForFunction($this$findPsi, (KtFunctionLikeSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtEnumEntrySymbol ? this.providePsiForEnumEntry((KtEnumEntrySymbol)ktSymbol, project) : (ktSymbol2 instanceof KtVariableLikeSymbol ? this.providePsiForProperty((KtVariableLikeSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtClassLikeSymbol ? this.providePsiForClass((KtClassLikeSymbol)ktSymbol, project) : null))));
    }

    private final PsiElement providePsiForConstructor(KtAnalysisSession $this$providePsiForConstructor, KtConstructorSymbol constructorSymbol, Project project) {
        Object object;
        block3: {
            PsiClass psiClass;
            Object[] objectArray;
            ClassId classId = constructorSymbol.getContainingClassIdIfNonLocal();
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(constructorSymbol, project));
            if (kotlinPsiDeclarationProvider == null || (objectArray = kotlinPsiDeclarationProvider.getClassesByClassId(classId2)) == null || (psiClass = (PsiClass)CollectionsKt.firstOrNull((Iterable)((Iterable)objectArray))) == null) {
                return null;
            }
            PsiClass psiClass2 = psiClass;
            PsiMethod[] psiMethodArray = psiClass2.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
            for (Object object2 : (Object[])psiMethodArray) {
                PsiMethod psiMethod = (PsiMethod)object2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)psiMethod);
                if (!PsiDeclarationAndKtSymbolEqualityChecker.INSTANCE.representsTheSameDeclaration($this$providePsiForConstructor, psiMethod, constructorSymbol)) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    private final PsiElement providePsiForFunction(KtAnalysisSession $this$providePsiForFunction, KtFunctionLikeSymbol functionLikeSymbol, Project project) {
        PsiMethod psiMethod;
        CallableId callableId = functionLikeSymbol.getCallableIdIfNonLocal();
        if (callableId != null) {
            Collection<PsiMethod> candidates;
            CallableId it = callableId;
            boolean bl = false;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(functionLikeSymbol, project));
            Collection<PsiMethod> collection = candidates = kotlinPsiDeclarationProvider != null ? kotlinPsiDeclarationProvider.getFunctions(it) : null;
            boolean bl2 = collection != null ? collection.size() == 1 : false;
            if (bl2) {
                psiMethod = (PsiMethod)CollectionsKt.single((Iterable)candidates);
            } else {
                Collection<PsiMethod> collection2 = candidates;
                if (collection2 != null) {
                    Object v5;
                    block7: {
                        Iterable iterable = collection2;
                        for (Object t : iterable) {
                            PsiMethod psiMethod2 = (PsiMethod)t;
                            boolean bl3 = false;
                            if (!PsiDeclarationAndKtSymbolEqualityChecker.INSTANCE.representsTheSameDeclaration($this$providePsiForFunction, psiMethod2, functionLikeSymbol)) continue;
                            v5 = t;
                            break block7;
                        }
                        v5 = null;
                    }
                    psiMethod = v5;
                } else {
                    psiMethod = null;
                }
            }
        } else {
            psiMethod = null;
        }
        return (PsiElement)psiMethod;
    }

    private final PsiElement providePsiForProperty(KtVariableLikeSymbol variableLikeSymbol, Project project) {
        PsiMember psiMember;
        CallableId callableId = variableLikeSymbol.getCallableIdIfNonLocal();
        if (callableId != null) {
            Collection<PsiMember> collection;
            CallableId it = callableId;
            boolean bl = false;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(variableLikeSymbol, project));
            psiMember = kotlinPsiDeclarationProvider != null && (collection = kotlinPsiDeclarationProvider.getProperties(it)) != null ? (PsiMember)CollectionsKt.firstOrNull((Iterable)collection) : null;
        } else {
            psiMember = null;
        }
        return (PsiElement)psiMember;
    }

    private final PsiElement providePsiForClass(KtClassLikeSymbol classLikeSymbol, Project project) {
        PsiClass psiClass;
        ClassId classId = classLikeSymbol.getClassIdIfNonLocal();
        if (classId != null) {
            Collection<PsiClass> collection;
            ClassId it = classId;
            boolean bl = false;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(classLikeSymbol, project));
            psiClass = kotlinPsiDeclarationProvider != null && (collection = kotlinPsiDeclarationProvider.getClassesByClassId(it)) != null ? (PsiClass)CollectionsKt.firstOrNull((Iterable)collection) : null;
        } else {
            psiClass = null;
        }
        return (PsiElement)psiClass;
    }

    private final PsiElement providePsiForEnumEntry(KtEnumEntrySymbol enumEntrySymbol, Project project) {
        Object object;
        block3: {
            PsiClass psiClass;
            Object[] objectArray;
            ClassId classId = enumEntrySymbol.getContainingEnumClassIdIfNonLocal();
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(enumEntrySymbol, project));
            if (kotlinPsiDeclarationProvider == null || (objectArray = kotlinPsiDeclarationProvider.getClassesByClassId(classId2)) == null || (psiClass = (PsiClass)CollectionsKt.firstOrNull((Iterable)((Iterable)objectArray))) == null) {
                return null;
            }
            PsiClass psiClass2 = psiClass;
            PsiField[] psiFieldArray = psiClass2.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
            for (Object object2 : (Object[])psiFieldArray) {
                PsiField it = (PsiField)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)enumEntrySymbol.getName().asString())) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    private final GlobalSearchScope scope(KtSymbol $this$scope, Project project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return globalSearchScope;
    }
}

