/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.incremental.Changes;
import org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0016J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aJ\r\u0010\u001b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001cJ\u0014\u0010\u001d\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0007J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "Ljava/io/Serializable;", "()V", "dependencyCache", "", "", "", "Ljava/net/URI;", "nonTransitiveCache", "sourceCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourceFileStructure;", "addSourceStructure", "", "sourceStructure", "getAllImpactedTypes", "changes", "Lorg/jetbrains/kotlin/kapt3/base/incremental/Changes;", "getSourceForType", "Ljava/io/File;", "type", "getStructure", "sourceFile", "getStructure$kotlin_annotation_processing_base", "getTypesForFiles", "", "files", "", "invalidateAll", "invalidateAll$kotlin_annotation_processing_base", "invalidateDataForTypes", "impactedTypes", "isAlreadyProcessed", "", "readObject", "input", "Ljava/io/ObjectInputStream;", "writeObject", "output", "Ljava/io/ObjectOutputStream;", "kotlin-annotation-processing-base"})
public final class JavaClassCache
implements Serializable {
    @NotNull
    private Map<URI, SourceFileStructure> sourceCache = new LinkedHashMap();
    @NotNull
    private transient Map<String, Set<URI>> dependencyCache = new LinkedHashMap();
    @NotNull
    private transient Map<String, Set<URI>> nonTransitiveCache = new LinkedHashMap();

    public final void addSourceStructure(@NotNull SourceFileStructure sourceStructure) {
        Intrinsics.checkNotNullParameter((Object)sourceStructure, (String)"sourceStructure");
        Map<URI, SourceFileStructure> map = this.sourceCache;
        URI uRI = sourceStructure.getSourceFile();
        map.put(uRI, sourceStructure);
    }

    @NotNull
    public final Set<String> getTypesForFiles(@NotNull Collection<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        HashSet typesFromFiles = new HashSet(files.size());
        for (File file : files) {
            Set<String> set;
            Set<String> set2;
            SourceFileStructure sourceFileStructure = this.sourceCache.get(file.toURI());
            if (sourceFileStructure == null) continue;
            Set<String> it = set2 = (set = sourceFileStructure.getDeclaredTypes());
            boolean bl = false;
            typesFromFiles.addAll(it);
        }
        return typesFromFiles;
    }

    private final void readObject(ObjectInputStream input) {
        Object dependants;
        Set<URI> set;
        Iterator<SourceFileStructure> iterator = input.readObject();
        if (iterator == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<java.net.URI, org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure>");
        }
        this.sourceCache = TypeIntrinsics.asMutableMap((Object)iterator);
        this.dependencyCache = new HashMap(this.sourceCache.size() * 4);
        for (SourceFileStructure sourceInfo : this.sourceCache.values()) {
            for (String mentionedType : sourceInfo.getMentionedTypes()) {
                set = this.dependencyCache.get(mentionedType);
                dependants = set == null ? (Set)new LinkedHashSet() : set;
                dependants.add(sourceInfo.getSourceFile());
                set = this.dependencyCache;
                set.put(mentionedType, dependants);
            }
            for (String mentionedConstants : sourceInfo.getMentionedConstants().keySet()) {
                set = this.dependencyCache.get(mentionedConstants);
                dependants = set == null ? (Set)new LinkedHashSet() : set;
                dependants.add(sourceInfo.getSourceFile());
                set = this.dependencyCache;
                set.put(mentionedConstants, dependants);
            }
        }
        this.nonTransitiveCache = new HashMap(this.sourceCache.size() * 2);
        for (SourceFileStructure sourceInfo : this.sourceCache.values()) {
            for (String privateType : sourceInfo.getPrivateTypes()) {
                set = this.nonTransitiveCache.get(privateType);
                dependants = set == null ? (Set)new LinkedHashSet() : set;
                dependants.add(sourceInfo.getSourceFile());
                set = this.nonTransitiveCache;
                set.put((String)privateType, (Set<URI>)dependants);
            }
        }
    }

    private final void writeObject(ObjectOutputStream output) {
        output.writeObject(this.sourceCache);
    }

    public final boolean isAlreadyProcessed(@NotNull URI sourceFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        if (!sourceFile.isAbsolute()) {
            return true;
        }
        if (sourceFile.isOpaque()) {
            return true;
        }
        try {
            bl = this.sourceCache.containsKey(sourceFile);
        }
        catch (IllegalArgumentException e) {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public final SourceFileStructure getStructure$kotlin_annotation_processing_base(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.sourceCache.get(sourceFile.toURI());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getAllImpactedTypes(@NotNull Changes changes) {
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Set allDirtyTypes = new LinkedHashSet();
        Collection currentDirtyTypes = null;
        currentDirtyTypes = CollectionsKt.toMutableSet((Iterable)this.getTypesForFiles(changes.getSourceChanges()));
        Iterable $this$forEach$iv = changes.getDirtyFqNamesFromClasspath();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String classpathChange = (String)element$iv;
            boolean bl = false;
            JavaClassCache.getAllImpactedTypes$findImpactedTypes(this, classpathChange, currentDirtyTypes, allDirtyTypes);
        }
        while (!((Collection)currentDirtyTypes).isEmpty()) {
            void $this$filterTo$iv;
            Set nextRound = new LinkedHashSet();
            for (String dirtyType : currentDirtyTypes) {
                allDirtyTypes.add(dirtyType);
                JavaClassCache.getAllImpactedTypes$findImpactedTypes(this, dirtyType, nextRound, allDirtyTypes);
            }
            Iterable $i$f$forEach2 = nextRound;
            Collection destination$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(!allDirtyTypes.contains(it))) continue;
                destination$iv.add(element$iv);
            }
            Collection collection = destination$iv;
            currentDirtyTypes = collection;
        }
        return allDirtyTypes;
    }

    public final void invalidateAll$kotlin_annotation_processing_base() {
        this.sourceCache.clear();
    }

    @NotNull
    public final File getSourceForType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Map<URI, SourceFileStructure> $this$forEach$iv = this.sourceCache;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<URI, SourceFileStructure>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<URI, SourceFileStructure> element$iv;
            Map.Entry<URI, SourceFileStructure> $dstr$fileUri$typeInfo = element$iv = iterator.next();
            boolean bl = false;
            URI fileUri = $dstr$fileUri$typeInfo.getKey();
            SourceFileStructure typeInfo = $dstr$fileUri$typeInfo.getValue();
            if (!typeInfo.getDeclaredTypes().contains(type)) continue;
            return new File(fileUri);
        }
        throw new IllegalStateException(Intrinsics.stringPlus((String)"Unable to find source file for type ", (Object)type));
    }

    public final void invalidateDataForTypes(@NotNull Set<String> impactedTypes) {
        Map.Entry<URI, SourceFileStructure> element$iv;
        Intrinsics.checkNotNullParameter(impactedTypes, (String)"impactedTypes");
        Set allSources2 = new LinkedHashSet();
        Object $this$forEach$iv = this.sourceCache;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<URI, SourceFileStructure>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            URI fileUri;
            block5: {
                Map.Entry<URI, SourceFileStructure> $dstr$fileUri$typeInfo = element$iv = iterator.next();
                boolean bl2 = false;
                fileUri = $dstr$fileUri$typeInfo.getKey();
                SourceFileStructure typeInfo = $dstr$fileUri$typeInfo.getValue();
                Iterable $this$any$iv = typeInfo.getDeclaredTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl3 = false;
                        if (!impactedTypes.contains(it)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            allSources2.add(fileUri);
        }
        $this$forEach$iv = allSources2;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            URI it = (URI)((Object)element$iv);
            boolean bl = false;
            this.sourceCache.remove(it);
        }
    }

    private static final void getAllImpactedTypes$findImpactedTypes(JavaClassCache this$0, String changedType, Set<String> transitiveDeps, Set<String> nonTransitiveDeps) {
        URI it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Set<URI> impactedSources;
        Set<URI> set;
        Set<URI> set2 = this$0.dependencyCache.get(changedType);
        if (set2 != null) {
            impactedSources = set = set2;
            boolean bl = false;
            $this$forEach$iv = impactedSources;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (URI)element$iv;
                boolean bl2 = false;
                transitiveDeps.addAll((Collection<String>)((SourceFileStructure)MapsKt.getValue(this$0.sourceCache, (Object)it)).getDeclaredTypes());
            }
        }
        set2 = this$0.nonTransitiveCache.get(changedType);
        if (set2 != null) {
            impactedSources = set = set2;
            boolean bl = false;
            $this$forEach$iv = impactedSources;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (URI)element$iv;
                boolean bl3 = false;
                nonTransitiveDeps.addAll((Collection<String>)((SourceFileStructure)MapsKt.getValue(this$0.sourceCache, (Object)it)).getDeclaredTypes());
            }
        }
    }
}

