/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.annotation.AnnotatedElement;
import org.jetbrains.kotlin.annotation.KotlinAnnotationProvider;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u00152\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0016J\u001a\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"*\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0002J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"*\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 H\u0002J\u0014\u0010&\u001a\u00020\u0013*\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010'\u001a\u00020\u0013*\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/annotation/RoundEnvironmentWrapper;", "Ljavax/annotation/processing/RoundEnvironment;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "parent", "roundNumber", "", "kotlinAnnotationsProvider", "Lorg/jetbrains/kotlin/annotation/KotlinAnnotationProvider;", "(Ljavax/annotation/processing/ProcessingEnvironment;Ljavax/annotation/processing/RoundEnvironment;ILorg/jetbrains/kotlin/annotation/KotlinAnnotationProvider;)V", "getKotlinAnnotationsProvider", "()Lorg/jetbrains/kotlin/annotation/KotlinAnnotationProvider;", "getParent", "()Ljavax/annotation/processing/RoundEnvironment;", "getProcessingEnv", "()Ljavax/annotation/processing/ProcessingEnvironment;", "getRoundNumber", "()I", "errorRaised", "", "getElementsAnnotatedWith", "", "Ljavax/lang/model/element/Element;", "a", "Ljava/lang/Class;", "", "Ljavax/lang/model/element/TypeElement;", "getRootElements", "processingOver", "resolveKotlinElements", "", "annotationFqName", "", "filterEnclosedElements", "", "kind", "Ljavax/lang/model/element/ElementKind;", "name", "hasAnnotation", "hasInheritedAnnotation", "kotlin-annotation-processing-gradle"})
public final class RoundEnvironmentWrapper
implements RoundEnvironment {
    @NotNull
    private final ProcessingEnvironment processingEnv;
    @NotNull
    private final RoundEnvironment parent;
    private final int roundNumber;
    @NotNull
    private final KotlinAnnotationProvider kotlinAnnotationsProvider;

    @Override
    @Nullable
    public Set<? extends Element> getRootElements() {
        return this.parent.getRootElements();
    }

    @Override
    @Nullable
    public Set<? extends Element> getElementsAnnotatedWith(@NotNull TypeElement a) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        HashSet elements = CollectionsKt.toHashSet((Iterable)this.parent.getElementsAnnotatedWith(a));
        elements.addAll((Collection)this.resolveKotlinElements(a.getQualifiedName().toString()));
        return elements;
    }

    @Override
    @Nullable
    public Set<? extends Element> getElementsAnnotatedWith(@NotNull Class<? extends Annotation> a) {
        Intrinsics.checkParameterIsNotNull(a, (String)"a");
        HashSet elements = CollectionsKt.toHashSet((Iterable)this.parent.getElementsAnnotatedWith(a));
        String string = a.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.name");
        elements.addAll((Collection)this.resolveKotlinElements(string));
        return elements;
    }

    @Override
    public boolean processingOver() {
        return this.parent.processingOver();
    }

    @Override
    public boolean errorRaised() {
        return this.parent.errorRaised();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Element> filterEnclosedElements(@NotNull TypeElement $receiver, ElementKind kind, String name) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getEnclosedElements();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Element it = (Element)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)((Object)it.getKind()), (Object)((Object)kind)) && Intrinsics.areEqual((Object)it.getSimpleName().toString(), (Object)name))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Element> filterEnclosedElements(@NotNull TypeElement $receiver, ElementKind kind) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getEnclosedElements();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Element it = (Element)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)it.getKind()), (Object)((Object)kind))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean hasAnnotation(@NotNull Element $receiver, String annotationFqName) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = $receiver.getAnnotationMirrors();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    AnnotationMirror it = (AnnotationMirror)element$iv;
                    if (!Intrinsics.areEqual((Object)annotationFqName, (Object)it.getAnnotationType().asElement().toString())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasInheritedAnnotation(@NotNull TypeElement $receiver, String annotationFqName) {
        if (this.hasAnnotation($receiver, annotationFqName)) {
            return true;
        }
        TypeMirror superclassMirror = $receiver.getSuperclass();
        if (superclassMirror instanceof NoType) {
            return false;
        }
        Element superClass = this.processingEnv.getTypeUtils().asElement(superclassMirror);
        if (!(superClass instanceof TypeElement)) {
            return false;
        }
        return this.hasInheritedAnnotation((TypeElement)superClass, annotationFqName);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Element> resolveKotlinElements(String annotationFqName) {
        void $receiver$iv;
        void initial$iv;
        if (this.roundNumber > 1) {
            return SetsKt.emptySet();
        }
        Set set = this.kotlinAnnotationsProvider.getAnnotatedKotlinElements().get(annotationFqName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Set descriptors = set;
        Iterable iterable = descriptors;
        HashSet hashSet = new HashSet();
        void accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void v1;
            void descriptor;
            AnnotatedElement annotatedElement = (AnnotatedElement)element$iv;
            void set2 = accumulator$iv;
            if (this.processingEnv.getElementUtils().getTypeElement(descriptor.getClassFqName()) == null) {
                v1 = set2;
            } else {
                List list;
                Element it;
                Iterable $receiver$iv$iv;
                Collection destination$iv$iv;
                Iterable $receiver$iv2;
                void var14_14;
                TypeElement clazz;
                void var12_12 = descriptor;
                if (var12_12 instanceof AnnotatedElement.Class) {
                    set2.add(clazz);
                } else if (var12_12 instanceof AnnotatedElement.Constructor) {
                    Iterable iterable2 = this.filterEnclosedElements(clazz, ElementKind.CONSTRUCTOR);
                    var14_14 = set2;
                    void var15_15 = $receiver$iv2;
                    destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it = (Element)element$iv$iv;
                        if (!this.hasAnnotation(it, annotationFqName)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    var14_14.addAll(list);
                } else if (var12_12 instanceof AnnotatedElement.Field) {
                    $receiver$iv2 = this.filterEnclosedElements(clazz, ElementKind.FIELD, ((AnnotatedElement.Field)descriptor).getFieldName());
                    var14_14 = set2;
                    $receiver$iv$iv = $receiver$iv2;
                    destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it = (Element)element$iv$iv;
                        if (!this.hasAnnotation(it, annotationFqName)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    var14_14.addAll(list);
                } else if (var12_12 instanceof AnnotatedElement.Method) {
                    $receiver$iv2 = this.filterEnclosedElements(clazz, ElementKind.METHOD, ((AnnotatedElement.Method)descriptor).getMethodName());
                    var14_14 = set2;
                    $receiver$iv$iv = $receiver$iv2;
                    destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it = (Element)element$iv$iv;
                        if (!this.hasAnnotation(it, annotationFqName)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    var14_14.addAll(list);
                }
                v1 = set2;
            }
            accumulator$iv = v1;
        }
        void descriptorsWithKotlin = accumulator$iv;
        if (this.kotlinAnnotationsProvider.getSupportInheritedAnnotations()) {
            boolean isInherited;
            boolean bl;
            TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(annotationFqName);
            if (typeElement != null) {
                Element element = typeElement;
                String string = Inherited.class.getCanonicalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Inherited::class.java.canonicalName");
                bl = this.hasAnnotation(element, string);
            } else {
                bl = isInherited = false;
            }
            if (isInherited) {
                Iterable $receiver$iv3 = this.kotlinAnnotationsProvider.getKotlinClasses();
                for (Object element$iv : $receiver$iv3) {
                    TypeElement clazz;
                    String classFqName = (String)element$iv;
                    if (this.processingEnv.getElementUtils().getTypeElement(classFqName) == null) {
                        continue;
                    }
                    if (!this.hasInheritedAnnotation(clazz, annotationFqName)) continue;
                    descriptorsWithKotlin.add(clazz);
                }
            }
        }
        return (Set)descriptorsWithKotlin;
    }

    @NotNull
    public final ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    @NotNull
    public final RoundEnvironment getParent() {
        return this.parent;
    }

    public final int getRoundNumber() {
        return this.roundNumber;
    }

    @NotNull
    public final KotlinAnnotationProvider getKotlinAnnotationsProvider() {
        return this.kotlinAnnotationsProvider;
    }

    public RoundEnvironmentWrapper(@NotNull ProcessingEnvironment processingEnv, @NotNull RoundEnvironment parent, int roundNumber, @NotNull KotlinAnnotationProvider kotlinAnnotationsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)kotlinAnnotationsProvider, (String)"kotlinAnnotationsProvider");
        this.processingEnv = processingEnv;
        this.parent = parent;
        this.roundNumber = roundNumber;
        this.kotlinAnnotationsProvider = kotlinAnnotationsProvider;
    }
}

