/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.builder;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtBinaryModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilderDsl;
import org.jetbrains.kotlin.analysis.project.structure.impl.KaLibraryModuleImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.platform.TargetPlatform;

@KtModuleBuilderDsl
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtLibraryModuleBuilder;", "Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtBinaryModuleBuilder;", "kotlinCoreProjectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;)V", "libraryName", "", "getLibraryName", "()Ljava/lang/String;", "setLibraryName", "(Ljava/lang/String;)V", "librarySources", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "getLibrarySources", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "setLibrarySources", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;)V", "build", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "isSdk", "", "analysis-api-standalone"})
public class KtLibraryModuleBuilder
extends KtBinaryModuleBuilder {
    @NotNull
    private final KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment;
    public String libraryName;
    @Nullable
    private KaLibrarySourceModule librarySources;

    public KtLibraryModuleBuilder(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment) {
        Intrinsics.checkNotNullParameter((Object)kotlinCoreProjectEnvironment, (String)"kotlinCoreProjectEnvironment");
        this.kotlinCoreProjectEnvironment = kotlinCoreProjectEnvironment;
    }

    @NotNull
    public final String getLibraryName() {
        String string = this.libraryName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"libraryName");
        return null;
    }

    public final void setLibraryName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.libraryName = string;
    }

    @Nullable
    public final KaLibrarySourceModule getLibrarySources() {
        return this.librarySources;
    }

    public final void setLibrarySources(@Nullable KaLibrarySourceModule kaLibrarySourceModule) {
        this.librarySources = kaLibrarySourceModule;
    }

    @Override
    @NotNull
    public KaLibraryModule build() {
        return this.build(false);
    }

    @NotNull
    protected final KaLibraryModule build(boolean isSdk) {
        List<Path> binaryRoots = this.getBinaryRoots();
        List<VirtualFile> binaryVirtualFiles = this.getBinaryVirtualFiles();
        GlobalSearchScope contentScope = StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots((Collection<? extends Path>)binaryRoots, (Collection<? extends VirtualFile>)binaryVirtualFiles, this.kotlinCoreProjectEnvironment);
        List<KaModule> list = this.getDirectRegularDependencies();
        List<KaModule> list2 = this.getDirectDependsOnDependencies();
        List<KaModule> list3 = this.getDirectFriendDependencies();
        TargetPlatform targetPlatform = this.getPlatform();
        MockProject mockProject = this.kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"getProject(...)");
        return new KaLibraryModuleImpl(list, list2, list3, contentScope, targetPlatform, (Project)mockProject, (Collection<? extends Path>)binaryRoots, (Collection<? extends VirtualFile>)binaryVirtualFiles, this.getLibraryName(), this.librarySources, isSdk);
    }
}

