/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KaConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0082\b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u000e*\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u000e*\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u001c\u001a\u00020\u000e*\u00020\u000eH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010#\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0002J\f\u0010&\u001a\u00020'*\u00020(H\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0002J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020\u000eH\u0002J\u000e\u0010/\u001a\u0004\u0018\u00010(*\u00020%H\u0002J\u000e\u0010/\u001a\u0004\u0018\u00010(*\u000200H\u0002J\u0017\u0010/\u001a\u00020(\"\u0004\b\u0000\u00101*\u0002H1H\u0002\u00a2\u0006\u0002\u00102J\u0018\u00103\u001a\u0004\u0018\u00010\u0001*\u00020(2\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010\u0017\u001a\u00020\u000e*\u00020(2\b\u00105\u001a\u0004\u0018\u0001062\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0002J\u000e\u00107\u001a\u0004\u0018\u000108*\u00020\"H\u0002R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0016R\u0018\u0010-\u001a\u00020\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0016R\u0018\u0010.\u001a\u00020\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0016\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator;", "", "<init>", "()V", "variablesInProcessOfEvaluation", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "withTrackingVariableEvaluation", "R", "variableSymbol", "f", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "evaluate", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "mode", "Lorg/jetbrains/kotlin/analysis/api/components/KaConstantEvaluationMode;", "isStringLength", "", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "toLiteralExpression", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "evaluateAsKtConstantValue", "Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "adaptToConstKind", "evaluateStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "evaluateFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "adjustType", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "toCompileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "evaluateStringLength", "other", "isStringEquals", "isStringPlus", "toConstantValueKind", "", "T", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/types/ConstantValueKind;", "convertToNumber", "value", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "getOriginalFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirCompileTimeConstantEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,394:1\n46#1,8:396\n46#1,8:406\n32#2:395\n24#2:404\n16#2:405\n43#3:414\n43#3:415\n*S KotlinDebug\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n*L\n99#1:396,8\n111#1:406,8\n97#1:395\n109#1:404\n109#1:405\n173#1:414\n193#1:415\n*E\n"})
public final class FirCompileTimeConstantEvaluator {
    @NotNull
    public static final FirCompileTimeConstantEvaluator INSTANCE = new FirCompileTimeConstantEvaluator();
    @NotNull
    private static final Set<FirVariableSymbol<?>> variablesInProcessOfEvaluation = new LinkedHashSet();

    private FirCompileTimeConstantEvaluator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R withTrackingVariableEvaluation(FirVariableSymbol<?> variableSymbol, Function0<? extends R> f) {
        Object object;
        boolean $i$f$withTrackingVariableEvaluation = false;
        if (!variablesInProcessOfEvaluation.add(variableSymbol)) {
            return null;
        }
        try {
            object = f.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            variablesInProcessOfEvaluation.remove(variableSymbol);
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    @Nullable
    public final FirLiteralExpression evaluate(@Nullable FirElement fir, @NotNull KaConstantEvaluationMode mode) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirElement firElement = fir;
        if (firElement instanceof FirPropertyAccessExpression) {
            FirVariableSymbol referredVariable = FirReferenceUtilsKt.toResolvedVariableSymbol$default((FirReference)((FirPropertyAccessExpression)fir).getCalleeReference(), (boolean)false, (int)1, null);
            if (referredVariable instanceof FirPropertySymbol) {
                if (this.isStringLength(((FirPropertySymbol)referredVariable).getCallableId())) {
                    FirLiteralExpression firLiteralExpression = this.evaluate((FirElement)((FirPropertyAccessExpression)fir).getExplicitReceiver(), mode);
                    object = firLiteralExpression != null ? this.evaluateStringLength(firLiteralExpression) : null;
                } else {
                    object = this.toLiteralExpression((FirPropertySymbol)referredVariable, mode);
                }
            } else {
                object = referredVariable instanceof FirFieldSymbol ? this.toLiteralExpression((FirFieldSymbol)referredVariable, mode) : null;
            }
        } else if (firElement instanceof FirLiteralExpression) {
            object = this.adaptToConstKind((FirLiteralExpression)fir);
        } else if (firElement instanceof FirFunctionCall) {
            object = this.evaluateFunctionCall((FirFunctionCall)fir, mode);
        } else if (firElement instanceof FirStringConcatenationCall) {
            object = this.evaluateStringConcatenationCall((FirStringConcatenationCall)fir, mode);
        } else if (firElement instanceof FirNamedReference) {
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)((FirReference)fir), (boolean)false, (int)1, null);
            object = firPropertySymbol != null ? this.toLiteralExpression(firPropertySymbol, mode) : null;
        } else {
            object = null;
        }
        return object;
    }

    private final boolean isStringLength(CallableId $this$isStringLength) {
        return Intrinsics.areEqual((Object)$this$isStringLength.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringLength.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"length");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirLiteralExpression toLiteralExpression(FirPropertySymbol $this$toLiteralExpression, KaConstantEvaluationMode mode) {
        FirLiteralExpression firLiteralExpression;
        if (mode == KaConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION) {
            FirCallableSymbol $this$isConst$iv = (FirCallableSymbol)$this$toLiteralExpression;
            boolean $i$f$isConst = false;
            if (!$this$isConst$iv.getRawStatus().isConst()) {
                return null;
            }
        }
        if (!$this$toLiteralExpression.isVal()) return null;
        FirCompileTimeConstantEvaluator this_$iv = this;
        boolean $i$f$withTrackingVariableEvaluation = false;
        if (!variablesInProcessOfEvaluation.add((FirVariableSymbol)$this$toLiteralExpression)) {
            return null;
        }
        try {
            boolean bl = false;
            firLiteralExpression = INSTANCE.evaluate((FirElement)$this$toLiteralExpression.getResolvedInitializer(), mode);
        }
        finally {
            variablesInProcessOfEvaluation.remove((FirVariableSymbol)$this$toLiteralExpression);
        }
        FirLiteralExpression firLiteralExpression2 = firLiteralExpression;
        return firLiteralExpression2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirLiteralExpression toLiteralExpression(FirFieldSymbol $this$toLiteralExpression, KaConstantEvaluationMode mode) {
        FirLiteralExpression firLiteralExpression;
        if (mode == KaConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION) {
            FirCallableSymbol $this$isStatic$iv = (FirCallableSymbol)$this$toLiteralExpression;
            boolean $i$f$isStatic = false;
            if (!$this$isStatic$iv.getRawStatus().isStatic()) return null;
            FirCallableSymbol $this$isFinal$iv = (FirCallableSymbol)$this$toLiteralExpression;
            boolean $i$f$isFinal = false;
            if ($this$isFinal$iv.getResolvedStatus().getModality() != Modality.FINAL) return null;
            boolean bl = true;
            if (!bl) {
                return null;
            }
        }
        if (!$this$toLiteralExpression.isVal()) return null;
        FirCompileTimeConstantEvaluator this_$iv = this;
        boolean $i$f$withTrackingVariableEvaluation = false;
        if (!variablesInProcessOfEvaluation.add((FirVariableSymbol)$this$toLiteralExpression)) {
            return null;
        }
        try {
            boolean bl = false;
            firLiteralExpression = INSTANCE.evaluate((FirElement)$this$toLiteralExpression.getResolvedInitializer(), mode);
        }
        finally {
            variablesInProcessOfEvaluation.remove((FirVariableSymbol)$this$toLiteralExpression);
        }
        FirLiteralExpression firLiteralExpression2 = firLiteralExpression;
        return firLiteralExpression2;
    }

    @Nullable
    public final KaConstantValue evaluateAsKtConstantValue(@NotNull FirElement fir, @NotNull KaConstantEvaluationMode mode) {
        KaConstantValue kaConstantValue;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirLiteralExpression firLiteralExpression = this.evaluate(fir, mode);
        if (firLiteralExpression == null) {
            return null;
        }
        FirLiteralExpression evaluated = firLiteralExpression;
        Object value = evaluated.getValue();
        PsiElement psiElement = UtilsKt.getPsi((FirElement)((FirElement)evaluated));
        KtElement psi = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        psiElement = evaluated.getKind();
        if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Byte");
            kaConstantValue = new KaConstantValue.KaByteConstantValue((Byte)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
            kaConstantValue = new KaConstantValue.KaIntConstantValue((Integer)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            kaConstantValue = new KaConstantValue.KaLongConstantValue((Long)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Short");
            kaConstantValue = new KaConstantValue.KaShortConstantValue((Short)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.UByte");
            kaConstantValue = new KaConstantValue.KaUnsignedByteConstantValue(((UByte)value).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.UInt");
            kaConstantValue = new KaConstantValue.KaUnsignedIntConstantValue(((UInt)value).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.ULong");
            kaConstantValue = new KaConstantValue.KaUnsignedLongConstantValue(((ULong)value).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.UShort");
            kaConstantValue = new KaConstantValue.KaUnsignedShortConstantValue(((UShort)value).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Double");
            kaConstantValue = new KaConstantValue.KaDoubleConstantValue((Double)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Float");
            kaConstantValue = new KaConstantValue.KaFloatConstantValue(((Float)value).floatValue(), psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            kaConstantValue = new KaConstantValue.KaBooleanConstantValue((Boolean)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Char");
            kaConstantValue = new KaConstantValue.KaCharConstantValue(((Character)value).charValue(), psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            kaConstantValue = new KaConstantValue.KaStringConstantValue((String)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Null.INSTANCE)) {
            kaConstantValue = new KaConstantValue.KaNullConstantValue(psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.IntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            long l = (Long)value;
            kaConstantValue = Integer.MIN_VALUE < l && l < Integer.MAX_VALUE ? (KaConstantValue)new KaConstantValue.KaIntConstantValue((int)l, psi) : (KaConstantValue)new KaConstantValue.KaLongConstantValue(l, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.ULong");
            long l = ((ULong)value).unbox-impl();
            kaConstantValue = Long.compareUnsigned(ULong.constructor-impl((long)(0L & 0xFFFFFFFFL)), l) < 0 && Long.compareUnsigned(l, ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) < 0 ? (KaConstantValue)new KaConstantValue.KaUnsignedIntConstantValue(UInt.constructor-impl((int)((int)l)), psi, null) : (KaConstantValue)new KaConstantValue.KaUnsignedLongConstantValue(l, psi, null);
        } else {
            if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Error.INSTANCE)) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Should not be possible to get from FIR tree", null, fir, null, null, null, 58, null);
                throw null;
            }
            throw new NoWhenBranchMatchedException();
        }
        return kaConstantValue;
    }

    private final FirLiteralExpression adaptToConstKind(FirLiteralExpression $this$adaptToConstKind) {
        ConstantValueKind constantValueKind = $this$adaptToConstKind.getKind();
        KtSourceElement ktSourceElement = $this$adaptToConstKind.getSource();
        Object object = this.convertToNumber($this$adaptToConstKind.getKind(), $this$adaptToConstKind.getValue());
        if (object == null) {
            object = $this$adaptToConstKind.getValue();
        }
        return this.toLiteralExpression(constantValueKind, ktSourceElement, object);
    }

    private final FirLiteralExpression evaluateStringConcatenationCall(FirStringConcatenationCall stringConcatenationCall, KaConstantEvaluationMode mode) {
        StringBuilder stringBuilder;
        StringBuilder $this$evaluateStringConcatenationCall_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        FirCall $this$arguments$iv = (FirCall)stringConcatenationCall;
        boolean $i$f$getArguments = false;
        for (FirExpression arg : $this$arguments$iv.getArgumentList().getArguments()) {
            FirLiteralExpression evaluated;
            if (INSTANCE.evaluate((FirElement)arg, mode) == null) {
                return null;
            }
            $this$evaluateStringConcatenationCall_u24lambda_u242.append(String.valueOf(evaluated.getValue()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String concatenated = string;
        return this.toLiteralExpression((ConstantValueKind)ConstantValueKind.String.INSTANCE, stringConcatenationCall.getSource(), concatenated);
    }

    private final FirLiteralExpression evaluateFunctionCall(FirFunctionCall functionCall, KaConstantEvaluationMode mode) {
        FirCallableDeclaration firCallableDeclaration = this.getOriginalFunction(functionCall);
        FirSimpleFunction firSimpleFunction = firCallableDeclaration instanceof FirSimpleFunction ? (FirSimpleFunction)firCallableDeclaration : null;
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction function = firSimpleFunction;
        FirLiteralExpression firLiteralExpression = this.evaluate((FirElement)functionCall.getExplicitReceiver(), mode);
        if (firLiteralExpression == null) {
            return null;
        }
        FirLiteralExpression opr1 = firLiteralExpression;
        firCallableDeclaration = this.evaluate(opr1, function);
        if (firCallableDeclaration != null) {
            FirCallableDeclaration it = firCallableDeclaration;
            boolean bl = false;
            return INSTANCE.adjustType((FirLiteralExpression)it, FirTypeUtilsKt.getResolvedType((FirExpression)((FirExpression)functionCall)));
        }
        FirCall $this$arguments$iv = (FirCall)functionCall;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = (FirExpression)CollectionsKt.firstOrNull((List)$this$arguments$iv.getArgumentList().getArguments());
        if (firExpression == null) {
            return null;
        }
        FirExpression argument = firExpression;
        FirLiteralExpression firLiteralExpression2 = this.evaluate((FirElement)argument, mode);
        if (firLiteralExpression2 == null) {
            return null;
        }
        FirLiteralExpression opr2 = firLiteralExpression2;
        FirLiteralExpression firLiteralExpression3 = this.evaluate(opr1, function, opr2);
        if (firLiteralExpression3 != null) {
            FirLiteralExpression it = firLiteralExpression3;
            boolean bl = false;
            return INSTANCE.adjustType(it, FirTypeUtilsKt.getResolvedType((FirExpression)((FirExpression)functionCall)));
        }
        return null;
    }

    private final FirLiteralExpression adjustType(FirLiteralExpression $this$adjustType, ConeKotlinType expectedType) {
        FirLiteralExpression expression;
        FirLiteralExpression firLiteralExpression;
        FirLiteralExpression firLiteralExpression2;
        ConstantValueKind expectedKind = this.toConstantValueKind(expectedType);
        if (expectedKind != null && !Intrinsics.areEqual((Object)expectedKind, (Object)$this$adjustType.getKind()) && $this$adjustType.getValue() instanceof Number) {
            Object object = $this$adjustType.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            Object object2 = this.convertToNumber(expectedKind, (Number)object);
            Intrinsics.checkNotNull((Object)object2);
            Object typeAdjustedValue = object2;
            firLiteralExpression2 = this.toLiteralExpression(expectedKind, $this$adjustType.getSource(), typeAdjustedValue);
        } else {
            firLiteralExpression2 = $this$adjustType;
        }
        FirLiteralExpression $this$adjustType_u24lambda_u245 = firLiteralExpression = (expression = firLiteralExpression2);
        boolean bl = false;
        $this$adjustType_u24lambda_u245.replaceConeTypeOrNull(expectedType);
        return firLiteralExpression;
    }

    private final CompileTimeType toCompileTimeType(ConstantValueKind $this$toCompileTimeType) {
        ConstantValueKind constantValueKind = $this$toCompileTimeType;
        return Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? CompileTimeType.BYTE : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? CompileTimeType.SHORT : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? CompileTimeType.INT : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? CompileTimeType.LONG : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? CompileTimeType.FLOAT : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Char.INSTANCE) ? CompileTimeType.CHAR : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.String.INSTANCE) ? CompileTimeType.STRING : CompileTimeType.ANY))))))));
    }

    private final FirLiteralExpression evaluate(FirLiteralExpression $this$evaluate, FirSimpleFunction function) {
        FirLiteralExpression firLiteralExpression;
        Object object;
        Object opr;
        if ($this$evaluate.getValue() == null) {
            return null;
        }
        Object object2 = $this$evaluate.getValue();
        String string = object2 instanceof String ? (String)object2 : null;
        if (string != null) {
            opr = string;
            boolean bl = false;
            String string2 = function.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp((String)string2, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr);
            if (object != null) {
                Object it = object;
                boolean bl2 = false;
                return INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
            }
        }
        Object object3 = this.convertToNumber($this$evaluate.getKind(), $this$evaluate.getValue());
        if (object3 != null) {
            opr = object3;
            boolean bl = false;
            String string3 = function.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp((String)string3, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr);
            if (object != null) {
                Object it = object;
                boolean bl3 = false;
                firLiteralExpression = INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
            } else {
                firLiteralExpression = null;
            }
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final FirLiteralExpression evaluateStringLength(FirLiteralExpression $this$evaluateStringLength) {
        FirLiteralExpression firLiteralExpression;
        Object object = $this$evaluateStringLength.getValue();
        String string = object instanceof String ? (String)object : null;
        if (string != null) {
            int it = string.length();
            boolean bl = false;
            firLiteralExpression = INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluateStringLength.getSource(), it);
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final FirLiteralExpression evaluate(FirLiteralExpression $this$evaluate, FirSimpleFunction function, FirLiteralExpression other) {
        FirLiteralExpression firLiteralExpression;
        Object object;
        Object opr2;
        Object opr1;
        if ($this$evaluate.getValue() == null || other.getValue() == null) {
            return null;
        }
        CompileTimeType rightType = this.isStringEquals(function.getSymbol().getCallableId()) ? CompileTimeType.ANY : (this.isStringPlus(function.getSymbol().getCallableId()) ? CompileTimeType.ANY : this.toCompileTimeType(other.getKind()));
        Object object2 = $this$evaluate.getValue();
        String string = object2 instanceof String ? (String)object2 : null;
        if (string != null) {
            opr1 = string;
            boolean bl = false;
            Object object3 = other.getValue();
            if (object3 != null) {
                opr2 = object3;
                boolean bl2 = false;
                String string2 = function.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                object = OperationsMapGeneratedKt.evalBinaryOp((String)string2, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr1, (CompileTimeType)rightType, (Object)opr2);
                if (object != null) {
                    Object it = object;
                    boolean bl3 = false;
                    return INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
                }
            }
        }
        Object object4 = this.convertToNumber($this$evaluate.getKind(), $this$evaluate.getValue());
        if (object4 != null) {
            opr1 = object4;
            boolean bl = false;
            Object object5 = INSTANCE.convertToNumber(other.getKind(), other.getValue());
            if (object5 != null) {
                opr2 = object5;
                boolean bl4 = false;
                String string3 = function.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                object = OperationsMapGeneratedKt.evalBinaryOp((String)string3, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr1, (CompileTimeType)INSTANCE.toCompileTimeType(other.getKind()), (Object)opr2);
                if (object != null) {
                    Object it = object;
                    boolean bl5 = false;
                    firLiteralExpression = INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
                } else {
                    firLiteralExpression = null;
                }
            } else {
                firLiteralExpression = null;
            }
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final boolean isStringEquals(CallableId $this$isStringEquals) {
        return Intrinsics.areEqual((Object)$this$isStringEquals.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringEquals.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"equals");
    }

    private final boolean isStringPlus(CallableId $this$isStringPlus) {
        return Intrinsics.areEqual((Object)$this$isStringPlus.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringPlus.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"plus");
    }

    private final ConstantValueKind toConstantValueKind(ConeKotlinType $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        ConeKotlinType coneKotlinType = $this$toConstantValueKind;
        if (coneKotlinType instanceof ConeErrorType) {
            constantValueKind = null;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            String string = ((ConeLookupTagBasedType)$this$toConstantValueKind).getLookupTag().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            constantValueKind = this.toConstantValueKind(string);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            constantValueKind = this.toConstantValueKind((ConeKotlinType)((ConeFlexibleType)$this$toConstantValueKind).getUpperBound());
        } else if (coneKotlinType instanceof ConeCapturedType) {
            constantValueKind = ((ConeCapturedType)$this$toConstantValueKind).getLowerType();
            if (constantValueKind == null || (constantValueKind = this.toConstantValueKind((ConeKotlinType)constantValueKind)) == null) {
                List list = ((ConeCapturedType)$this$toConstantValueKind).getConstructor().getSupertypes();
                Intrinsics.checkNotNull((Object)list);
                constantValueKind = this.toConstantValueKind((ConeKotlinType)CollectionsKt.first((List)list));
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            constantValueKind = this.toConstantValueKind((ConeKotlinType)((ConeDefinitelyNotNullType)$this$toConstantValueKind).getOriginal());
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            constantValueKind = this.toConstantValueKind((ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toConstantValueKind).getIntersectedTypes()));
        } else if (coneKotlinType instanceof ConeStubType || coneKotlinType instanceof ConeIntegerLiteralType || coneKotlinType instanceof ConeTypeVariableType) {
            constantValueKind = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return constantValueKind;
    }

    private final ConstantValueKind toConstantValueKind(String $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        switch ($this$toConstantValueKind) {
            case "Byte": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Byte.INSTANCE;
                break;
            }
            case "Double": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Double.INSTANCE;
                break;
            }
            case "Float": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Float.INSTANCE;
                break;
            }
            case "Int": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Int.INSTANCE;
                break;
            }
            case "Long": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Long.INSTANCE;
                break;
            }
            case "Short": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Short.INSTANCE;
                break;
            }
            case "Char": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Char.INSTANCE;
                break;
            }
            case "String": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.String.INSTANCE;
                break;
            }
            case "Boolean": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Boolean.INSTANCE;
                break;
            }
            default: {
                constantValueKind = null;
            }
        }
        return constantValueKind;
    }

    private final <T> ConstantValueKind toConstantValueKind(T $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        T t = $this$toConstantValueKind;
        if (t instanceof Byte) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Byte.INSTANCE;
        } else if (t instanceof Double) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Double.INSTANCE;
        } else if (t instanceof Float) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Float.INSTANCE;
        } else if (t instanceof Integer) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Int.INSTANCE;
        } else if (t instanceof Long) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Long.INSTANCE;
        } else if (t instanceof Short) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Short.INSTANCE;
        } else if (t instanceof Character) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Char.INSTANCE;
        } else if (t instanceof String) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.String.INSTANCE;
        } else if (t instanceof Boolean) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Boolean.INSTANCE;
        } else if (t == null) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Null.INSTANCE;
        } else {
            throw new IllegalStateException("Unknown constant value".toString());
        }
        return constantValueKind;
    }

    private final Object convertToNumber(ConstantValueKind $this$convertToNumber, Object value) {
        if (value == null) {
            return null;
        }
        ConstantValueKind constantValueKind = $this$convertToNumber;
        return Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE) ? (Comparable)((Boolean)value) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Char.INSTANCE) ? (Comparable)((Character)value) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.String.INSTANCE) ? (Comparable)((Object)((String)value)) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? (Comparable)Byte.valueOf(((Number)value).byteValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? (Comparable)Double.valueOf(((Number)value).doubleValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? (Comparable)Float.valueOf(((Number)value).floatValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? (Comparable)Integer.valueOf(((Number)value).intValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? (Comparable)Long.valueOf(((Number)value).longValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? (Comparable)Short.valueOf(((Number)value).shortValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE) ? UByte.box-impl((byte)UByte.constructor-impl((byte)((byte)((Number)value).longValue()))) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE) ? UShort.box-impl((short)UShort.constructor-impl((short)((short)((Number)value).longValue()))) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE) ? UInt.box-impl((int)UInt.constructor-impl((int)((int)((Number)value).longValue()))) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)((Number)value).longValue())) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)((Number)value).longValue())) : null)))))))))))));
    }

    private final FirLiteralExpression toLiteralExpression(ConstantValueKind $this$toLiteralExpression, KtSourceElement source, Object value) {
        return FirConstExpressionBuilderKt.buildLiteralExpression$default((KtSourceElement)source, (ConstantValueKind)$this$toLiteralExpression, (Object)value, null, (boolean)false, (int)8, null);
    }

    private final FirCallableDeclaration getOriginalFunction(FirFunctionCall $this$getOriginalFunction) {
        FirBasedSymbol symbol;
        FirNamedReference reference = $this$getOriginalFunction.getCalleeReference();
        FirBasedSymbol firBasedSymbol = symbol = reference instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference).getResolvedSymbol() : null;
        FirDeclaration firDeclaration = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return firDeclaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)firDeclaration : null;
    }
}

