/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.templates;

import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KAnnotation;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.templates.KDocTemplate;

@KotlinClass(abiVersion=18, data={"\"\n)1\u0002+Y2lC\u001e,G+Z7qY\u0006$XmU;qa>\u0014HOC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\r!wn\u0019\u0006\ni\u0016l\u0007\u000f\\1uKNTAb\u0013#pGR+W\u000e\u001d7bi\u0016Ta\u0001P5oSRt$b\u00019lO*A1\nU1dW\u0006<WMC\u0003n_\u0012,GN\u0003\u0006gk:\\U-_<pe\u0012Taa\u0015;sS:<'\u0002\u00026bm\u0006TA\u0001\\1oO*iq-\u001a;Gk:\\U-_<pe\u0012Tqa[3zo>\u0014HM\u0003\u0003oC6,'BB4fiB[wM\u0003\tqe&tG/\u00118o_R\fG/[8og*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\f\u0017\u0006sgn\u001c;bi&|gN\u0003\u0003V]&$(\u0002B;uS2T1\u0003\u001d:j]R4UO\\2uS>tG)\u001a;bS2T\u0001BZ;oGRLwN\u001c\u0006\n\u0017\u001a+hn\u0019;j_:T\u0011BZ;oGRLwN\\:\u000b)A\u0014\u0018N\u001c;Gk:\u001cG/[8o'VlW.\u0019:z\u0015=\u0001(/\u001b8u!\u0006\u0014\u0018-\\3uKJ\u001c(BB7fi\"|GM\u0003\u000bqe&tG\u000f\u0015:pa\u0016\u0014H/_*v[6\f'/\u001f\u0006\u000baJ|\u0007/\u001a:uS\u0016\u001c(\"C&Qe>\u0004XM\u001d;z\u0015!\u0001(o\u001c9feRL(\"\u00059sS:$(+Z2fSZ,'\u000fV=qK*1\u0001O]3gSbTq\u0001]8ti\u001aL\u0007P\u0003\u0003o_:,'b\u00059sS:$H+\u001f9f!\u0006\u0014\u0018-\\3uKJ\u001c(\"C:fa\u0006\u0014\u0018\r^8s\u00159\u0011X\r\\1uSZ,\u0007K]3gSbT!B^1m\u0017\u0016Lxo\u001c:e\u001559W\r\u001e,bY.+\u0017p^8sI*Qa/\u0019:LKf<xN\u001d3\u000b\u001b\u001d,GOV1s\u0017\u0016Lxo\u001c:e9\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0002\u0005\u0005!\u0019A\u0002A\u0003\u0003\t\u0007AQ!B\u0002\u0005\b!%A\u0002A\u0003\u0003\t\u000fAI!B\u0001\t\u0004\u0015\u0019A!\u0002\u0005\u0007\u0019\u0001)\u0011\u0001#\u0004\u0006\u0005\u00111\u0001bB\u0003\u0003\t\u001bAa!B\u0002\u0005\u000b!UA\u0002A\u0003\u0004\t\u000fA1\u0002\u0004\u0001\u0006\u0007\u0011)\u0001r\u0003\u0007\u0001\u000b\t!a\u0001\u0003\u0007\u0006\u0005\u0011I\u0001RC\u0003\u0004\t\u000fAY\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u00012D\u0003\u0004\t\u000fA\u0011\u0003\u0004\u0001\u0006\u0005\u0011\u001d\u0001\"\u0005\u0003\u0011\u0019\u000bI\"!B\u0001\t\u00075zA\u0001\u0019\u0003\u0019\f\u0005\u0012Q!\u0001E\u0006+\u000eAQa\u0001C\u0006\u0013\u0005Aq!D\u0002\u0005\u0010%\t\u0001bB\u0017\u0014\t\tA\u0002\"(\u0004\u0005\u0001!EQBA\u0003\u0002\u0011\u0017\u00016\u0001A\u0011\u0003\u000b\u0005AY!U\u0002\u0006\t!I\u0011\u0001C\u0004\u000e\u0003!9Qf\u0004\u0003i\ta!\u0011EA\u0003\u0002\u0011\u0011)6\u0001C\u0003\u0004\t\u0011I\u0011\u0001#\u0003\u000e\u0007\u0011I\u0011\"\u0001E\u0005[]!\u0001\u0001g\u0005\u001e\u0016\u0011\u0001\u0001BC\u0007\u0007\u000b\u0005Ay!C\u0002\n\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0001\u0005\u0012Q!\u0001E\t#\u000e)A1C\u0005\u0002\t\u0001i\u0011\u0001c\u0005.'\u0011\u0001\u0001\u0014DO\u0007\t\u0001AQ\"\u0004\u0002\u0006\u0003!Q\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\u0012C)\u0004\u000b\u0011e\u0011\"\u0001\u0003\u0001\u001b\u0005A)\"L\f\u0005\u0001aeQT\u0003\u0003\u0001\u00119ia!B\u0001\t\u0010%\u0019\u0011BA\u0003\u0002\u0011)\u00016\u0001A\u0011\u0003\u000b\u0005A\t\"U\u0002\u0006\t3I\u0011\u0001\u0002\u0001\u000e\u0003!MQf\u0005\u0003\u00011;ij\u0001\u0002\u0001\t\u001b5\u0011Q!\u0001\u0005\u000b!\u000e\u0001\u0011EA\u0003\u0002\u0011#\t6!\u0002C\u000f\u0013\u0005!\u0001!D\u0001\t\u00165:B\u0001\u0001M\u000f;+!\u0001\u0001\u0003\b\u000e\r\u0015\t\u0001rB\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0006Q\u0007\u0001\t#!B\u0001\t\u0012E\u001bQ\u0001\"\b\n\u0003\u0011\u0001Q\"\u0001E\n[M!\u0001\u0001G\b\u001e\u000e\u0011\u0001\u0001rD\u0007\u0003\u000b\u0005A!\u0002U\u0002\u0001C\t)\u0011\u0001#\u0005R\u0007\u0015!q\"C\u0001\u0005\u00015\t\u0001RC\u0017\u0018\t\u0001A\u0002#(\u0006\u0005\u0001!\u0005RBB\u0003\u0002\u0011\u001fI1!\u0003\u0002\u0006\u0003!Y\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\u0012C)\u0004\u000b\u0011\u0001\u0012\"\u0001\u0003\u0001\u001b\u0005A\u0019\"L\n\u0005\u0001a\u0001RT\u0002\u0003\u0001\u0011Gi!!B\u0001\t\u0017A\u001b\u0001!\t\u0002\u0006\u0003!E\u0011kA\u0003\u0005!%\tA\u0001A\u0007\u0002\u0011/i{\u0006\u0002\u0001\u0019%u5A\u0001\u0001\u0005\u000e\u001b\t)\u0011\u0001\u0003\u0006Q\u0007\u0001ij\u0001B\u0001\t&5\u0011Q!\u0001E\u0006!\u000e\u0005QT\u0002\u0003\u0002\u0011Mi!!B\u0001\t\fA\u001b\u0011!(\u0004\u0005\u0003!\u001dRBA\u0003\u0002\u0011\u0017\u000161A\u0011\u0003\u000b\u0005A\t\"U\u0002\f\tII\u0011\u0001\u0002\u0001\u000e\u0003!UQ\"\u0001\u0005\b\u001b\u0005Aq!D\u0001\t\u000f5fB\u0001\u0001\r\u0015;\u001b!\u0001\u0001c\b\u000e\u0005\u0015\t\u0001B\u0003)\u0004\u0001u5A!\u0001E\u0015\u001b\t)\u0011\u0001c\u0003Q\u0007\u0003\t#!B\u0001\t\u0012E\u001bq\u0001\u0002\u000b\n\u0003\u0011\u0001Q\"\u0001E\u000b\u001b\u0005Aq!l\u0005\u0005\u0015a)\u0012EA\u0003\u0002\u0011\u0017\t6a\u0001\u0003\u0016\u0013\u0005Aq!L\b\u0005A\u0012AZ#\t\u0002\u0006\u0003!-Qk\u0001\u0005\u0006\u0007\u0011-\u0012\"\u0001\u0005\b\u001b\r!a#C\u0001\t\u000f5zA\u0001\u0019\u0003\u0019.\u0005\u0012Q!\u0001E\u0006+\u000eAQa\u0001C\u0017\u0013\u0005Aq!D\u0002\u0005/%\t\u0001bB[\u0015\u000bO!1\u001d\u0001M\u0004;\u001b!\u0001\u0001\u0003\u0003\u000e\u0005\u0015\t\u0001\u0002\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\u0003#\u000e)AqA\u0005\u0002\t\u0001i\u0011\u0001#\u0003"})
public abstract class PackageTemplateSupport
extends KDocTemplate
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final String funKeyword;
    @NotNull
    private final String valKeyword;
    @NotNull
    private final String varKeyword;
    @NotNull
    private final KPackage pkg;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(PackageTemplateSupport.class);
    }

    @Override
    @NotNull
    protected String relativePrefix() {
        return this.getPkg().getNameAsRelativePath();
    }

    @NotNull
    public final String getFunKeyword() {
        return this.funKeyword;
    }

    @NotNull
    public final String getValKeyword() {
        return this.valKeyword;
    }

    @NotNull
    public final String getVarKeyword() {
        return this.varKeyword;
    }

    @NotNull
    protected final String keyword(@JetValueParameter(name="name") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return "<B>" + name + "</B>";
    }

    public final void printFunctionSummary(@JetValueParameter(name="functions") @NotNull Collection<? extends KFunction> functions) {
        Intrinsics.checkParameterIsNotNull(functions, (String)"functions");
        if (KotlinPackage.isNotEmpty(functions)) {
            this.println("<!-- ========== FUNCTION SUMMARY =========== -->\n\n<A NAME=\"method_summary\"><!-- --></A>\n<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\n<B>Function Summary</B></FONT></TH>\n</TR>");
            for (KFunction kFunction : functions) {
                this.printFunctionSummary(kFunction);
            }
            this.println("</TABLE>\n&nbsp;\n<P>\n");
        }
    }

    public final void printFunctionSummary(@JetValueParameter(name="function") @NotNull KFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        String deprecated = ((KAnnotated)function).getDeprecated() ? "<B>Deprecated.</B>" : "";
        this.print("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\n<CODE>");
        if (!function.getTypeParameters().isEmpty()) {
            this.println("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" SUMMARY=\"\">\n            <TR ALIGN=\"right\" VALIGN=\"\">\n            <TD NOWRAP><FONT SIZE=\"-1\">\n            <CODE>");
            this.print(this.funKeyword + " ");
            PackageTemplateSupport.printTypeParameters$default(this, function, null, 2);
            PackageTemplateSupport.printReceiverType$default(this, function, "<BR>", null, null, 12);
            this.println("</CODE></FONT></TD>\n</TR>\n</TABLE>");
        } else {
            this.print(this.funKeyword);
            PackageTemplateSupport.printReceiverType$default(this, function, null, null, null, 14);
        }
        this.println("</CODE></FONT></TD>");
        this.print("<TD><CODE><B><A HREF=" + "\"" + this.href(function) + "\"" + ">" + function.getName() + "</A></B>");
        this.printParameters(function);
        this.print(": ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, function.getReturnType(), false, 2));
        this.println("</CODE>");
        this.println("");
        this.println("<BR>");
        this.println(String.valueOf(function.description(this)));
        this.println("</TD>");
        this.println("</TR>");
    }

    public final void printReceiverType(@JetValueParameter(name="function") @NotNull KFunction function, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="none") @NotNull String none) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)postfix, (String)"postfix");
        Intrinsics.checkParameterIsNotNull((Object)none, (String)"none");
        KType receiverType = function.getReceiverType();
        if (receiverType != null) {
            this.print(prefix);
            this.print(KDocTemplate.link$default((KDocTemplate)this, receiverType, false, 2));
            this.print(postfix);
        } else {
            this.print(none);
        }
    }

    public static void printReceiverType$default(PackageTemplateSupport packageTemplateSupport, KFunction kFunction, String string, String string2, String string3, int n) {
        if ((n & 2) != 0) {
            string = " ";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        packageTemplateSupport.printReceiverType(kFunction, string, string2, string3);
    }

    public final void printFunctionDetail(@JetValueParameter(name="functions") @NotNull Collection<? extends KFunction> functions) {
        Intrinsics.checkParameterIsNotNull(functions, (String)"functions");
        if (KotlinPackage.isNotEmpty(functions)) {
            this.println("\n\n            <!-- ============ FUNCTION DETAIL ========== -->\n\n            <A NAME=\"method_detail\"><!-- --></A>\n            <TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n            <TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n            <TH ALIGN=\"left\" COLSPAN=\"1\"><FONT SIZE=\"+2\">\n            <B>Function Detail</B></FONT></TH>\n            </TR>\n            </TABLE>\n            ");
            for (KFunction kFunction : functions) {
                this.printFunctionDetail(kFunction);
            }
        }
    }

    public final void printFunctionDetail(@JetValueParameter(name="function") @NotNull KFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        this.println("<div class=\"doc-member function\">");
        this.println("<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + this.sourceHref(function) + "\"" + function.sourceTargetAttribute() + ">source</a></div>");
        this.println("<A NAME=" + "\"" + function.getName() + "{" + function.getParameterTypeText() + "}" + "\"" + "><!-- --></A><A NAME=" + "\"" + function.getLink() + "\"" + "><!-- --></A><H3>");
        this.println(function.getName() + "</H3>");
        this.println("<PRE>");
        this.println("<FONT SIZE=\"-1\">");
        this.printAnnotations((Collection<? extends KAnnotation>)function.getAnnotations());
        this.print("</FONT>" + KotlinPackage.makeString$default((Iterable)function.getModifiers(), (String)" ", null, null, (int)0, null, (int)30) + " " + this.funKeyword);
        this.printTypeParameters(function, " ");
        this.printReceiverType(function, " ", ".", " ");
        this.print("<B>" + function.getName() + "</B>");
        this.printParameters(function);
        this.print(": ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, function.getReturnType(), false, 2));
        List<KClass> exlist = function.getExceptions();
        int first = 1;
        if (!exlist.isEmpty()) {
            this.println("                                throws ");
            for (KClass ex : exlist) {
                if (first != 0) {
                    first = 0;
                } else {
                    this.print(", ");
                }
                this.print(KDocTemplate.link$default((KDocTemplate)this, ex, false, 2));
            }
        }
        this.println("</PRE>");
        this.println(function.detailedDescription(this));
        this.println("</div>");
    }

    public final void printPropertySummary(@JetValueParameter(name="properties") @NotNull Collection<? extends KProperty> properties) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        if (KotlinPackage.isNotEmpty(properties)) {
            this.println("<!-- ========== PROPERTY SUMMARY =========== -->\n\n<A NAME=\"method_summary\"><!-- --></A>\n<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\n<B>Property Summary</B></FONT></TH>\n</TR>");
            for (KProperty kProperty : properties) {
                this.printPropertySummary(kProperty);
            }
            this.println("</TABLE>\n&nbsp;\n<P>\n");
        }
    }

    public final void printPropertySummary(@JetValueParameter(name="property") @NotNull KProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        String deprecated = ((KAnnotated)property).getDeprecated() ? "<B>Deprecated.</B>" : "";
        this.print("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\n<CODE>");
        this.print(property.isVar() ? this.varKeyword : this.valKeyword);
        this.println("</CODE></FONT></TD>");
        this.print("<TD>" + "\n" + "<div class=" + "\"" + "doc-member property" + "\"" + ">" + "\n" + "<div class=" + "\"" + "source-detail" + "\"" + "><a HREF=" + "\"" + this.sourceHref(property) + "\"" + property.sourceTargetAttribute() + ">source</a></div>" + "\n" + "        <CODE><B>" + property.getName() + "</B>: ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, property.getReturnType(), false, 2));
        this.println("</CODE>");
        this.println("");
        this.println("<BR>");
        this.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + deprecated + "&nbsp;" + property.detailedDescription(this) + "\n" + "</div></TD>");
        this.println("</TR>");
    }

    public final void printTypeParameters(@JetValueParameter(name="method") @NotNull KFunction method, @JetValueParameter(name="separator") @NotNull String separator) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        List<KTypeParameter> typeParameters = method.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            this.print(separator);
            this.print("&lt");
            String separator2 = "";
            for (KTypeParameter t : typeParameters) {
                this.print(separator2);
                separator2 = ", ";
                this.print(t.getName());
                List<KClass> elist = t.getExtends();
                if (!(!elist.isEmpty())) continue;
                this.print(" extends ");
                String esep = "";
                for (KClass e : elist) {
                    this.print(esep);
                    esep = " & ";
                    this.print(KDocTemplate.link$default((KDocTemplate)this, e, false, 2));
                }
            }
            this.print("&gt");
        }
    }

    public static void printTypeParameters$default(PackageTemplateSupport packageTemplateSupport, KFunction kFunction, String string, int n) {
        if ((n & 2) != 0) {
            string = "";
        }
        packageTemplateSupport.printTypeParameters(kFunction, string);
    }

    public final void printParameters(@JetValueParameter(name="method") @NotNull KFunction method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        this.print("(");
        int first = 1;
        int defaultValue = 0;
        for (KParameter p : method.getParameters()) {
            KType kType;
            if ((!p.hasDefaultValue() ? defaultValue : 0) != 0) {
                this.print("]");
                defaultValue = 0;
            }
            if (first != 0) {
                first = 0;
            } else {
                this.print(", ");
            }
            boolean bl = p.hasDefaultValue() ? defaultValue == 0 : false;
            if (bl) {
                this.print(" [");
                defaultValue = 1;
            }
            if (p.isVarArg()) {
                this.print("vararg ");
                kType = p.varArgType();
                if (kType == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                kType = p.getaType();
            }
            KType pType = kType;
            this.print(p.getName() + ":&nbsp;");
            this.print(KDocTemplate.link$default((KDocTemplate)this, pType, false, 2));
        }
        if (defaultValue != 0) {
            this.print("]");
        }
        this.print(")");
    }

    public final void printAnnotations(@JetValueParameter(name="annotations") @NotNull Collection<? extends KAnnotation> annotations) {
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        for (KAnnotation kAnnotation : annotations) {
            this.println(this.link(kAnnotation));
        }
    }

    @NotNull
    public KPackage getPkg() {
        return this.pkg;
    }

    public PackageTemplateSupport(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        this.pkg = pkg;
        this.funKeyword = this.keyword("fun");
        this.valKeyword = this.keyword("val");
        this.varKeyword = this.keyword("var");
    }
}

