/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.CharIterator;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.kotlin.doc.DocPackage$collections$b8ec3894;
import org.jetbrains.kotlin.doc.KDocConfig;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighlighter;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel$1;
import org.jetbrains.kotlin.doc.model.KModel$sourceInfoByFile$1;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.model.ModelPackage$KotlinModel$508284e7;
import org.jetbrains.kotlin.doc.model.SourceInfo;
import org.pegdown.Extensions;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;

@KotlinClass(abiVersion=18, data={"\u0014\u001e)11*T8eK2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004I>\u001c'\"B7pI\u0016d'bA!os*1A(\u001b8jizRqaY8oi\u0016DHO\u0003\bCS:$\u0017N\\4D_:$X\r\u001f;\u000b\u0007),GO\u0003\u0003mC:<'b\u0002:fg>dg/\u001a\u0006\u0007G>tg-[4\u000b\u0015-#unY\"p]\u001aLwM\u0003\u0006t_V\u00148-\u001a#jeNTA\u0001T5ti*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'bB:pkJ\u001cWm\u001d\u0006\b\u0015\u0016$h)\u001b7f\u0015\r\u00018/\u001b\u0006\u0005kRLGNC\b`aJ|'.Z2u%>|G\u000fR5s\u0015\u0019\u0019FO]5oO*a\u0011\r\u001a3Gk:\u001cG/[8og*)qn\u001e8fe*y1j\u00117bgN|%\u000fU1dW\u0006<WMC\u0003tG>\u0004XM\u0003\u0005KKR\u001c6m\u001c9f\u0015\u0019\u00198m\u001c9fg*!QK\\5u\u0015E\tG\r\u001a+za\u0016\u0004\u0016M]1nKR,'o\u001d\u0006\u0007C:\u001cx/\u001a:\u000b\u00175+H/\u00192mK2K7\u000f\u001e\u0006\u000f\u0017RK\b/\u001a)be\u0006lW\r^3s\u0015-!Wm]2sSB$xN]:\u000b/QK\b/\u001a)be\u0006lW\r^3s\t\u0016\u001c8M]5qi>\u0014(bC1mYB\u000b7m[1hKNT!bQ8mY\u0016\u001cG/[8o\u0015!Y\u0005+Y2lC\u001e,'BD4fi\u0006cG\u000eU1dW\u0006<Wm\u001d\u0006\bG2\f7o]3t\u0015\u0019Y5\t\\1tg*Qq-\u001a;DY\u0006\u001c8/Z:\u000b\u0017\r|W.\\3oiN4uN\u001d\u0006\u000bI\u0016\u001c8M]5qi>\u0014(\"\u0006#fG2\f'/\u0019;j_:$Um]2sSB$xN\u001d\u0006\nO\u0016$8i\u001c8gS\u001eT\u0011cY8oM&<WO]3D_6lWM\u001c;t\u0015%\tgN\\8uCR,GM\u0003\u0006L\u0003:tw\u000e^1uK\u0012T!bZ3u\u0007>tG/\u001a=u\u00159\u0019'/Z1uK\u001a+hn\u0019;j_:T!cQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*I1JR;oGRLwN\u001c\u0006\u000eGJ,\u0017\r^3QC\u000e\\\u0017mZ3\u000b3A\u000b7m[1hK\u001a\u0013\u0018mZ7f]R$Um]2sSB$xN\u001d\u0006\u0005]\u0006lWMC\bde\u0016\fG/\u001a)be\u0006lW\r^3s\u0015a1\u0016\r\\;f!\u0006\u0014\u0018-\\3uKJ$Um]2sSB$xN\u001d\u0006\u000b\u0017B\u000b'/Y7fi\u0016\u0014(bE2sK\u0006$X\rV=qKB\u000b'/Y7fi\u0016\u0014(\u0002D3yiJ\f7\r\u001e\"m_\u000e\\'\u0002\u0002;fqRTqAZ5mK\u001a{'O\u0003\u0005gS2,\u0007+\u0019;i\u0015\u00111\u0017\u000e\\3\u000b#A\u001b\u0018NR5mKNK8\u000f^3n\u0013R,WNC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0014M&tGMR;oGRLwN\\%oG2,H-\u001a\u0006\u000baNLW\t\\3nK:$(B\u0003)tS\u0016cW-\\3oi*Y\u0011N\\2mk\u0012,g)\u001b7f\u001511WO\\2uS>tg*Y7f\u0015!9W\r^\"mCN\u001c(\u0002D2mCN\u001cX\t\\3nK:$(bD\"mCN\u001cH)Z:de&\u0004Ho\u001c:\u000b\u001bE,\u0018\r\\5gS\u0016$g*Y7f\u0015I9W\r^(s\u0007J,\u0017\r^3QC\u000e\\\u0017mZ3\u000b\u0015\u001d,G\u000fU1dW\u0006<WMC\u0007hKR\u00046/[#mK6,g\u000e\u001e\u0006\bO\u0016$H+\u001f9f\u0015\u0015\tG+\u001f9f\u0015\u001dQU\r\u001e+za\u0016TQ\u0001^=qKNTQa\u0013+za\u0016T1\u0002[5hQ2Lw\r\u001b;fe*\t2+\u001f8uCbD\u0015n\u001a5mS\u001eDG/\u001a:\u000b\u001d\u001d,G\u000fS5hQ2Lw\r\u001b;fe*q1/\u001a;IS\u001eDG.[4ii\u0016\u0014(b\u00057pC\u0012<\u0016n[5EKN\u001c'/\u001b9uS>t'b\u00019lO*YAn\\2bi&|gNR8s\u00155a\u0015N\\3B]\u0012\u001cu\u000e\\;n]*yA)[1h]>\u001cH/[2Vi&d7OC\u0006eS\u0006<gn\\:uS\u000e\u001c(\"\b#jC\u001etwn\u001d;jGV#\u0018\u000e\\:%\u0019&tW-\u00118e\u0007>dW/\u001c8\u000b#5\f'o\u001b3po:\u0004&o\\2fgN|'O\u0003\tQK\u001e$un\u001e8Qe>\u001cWm]:pe*9\u0001/Z4e_^t'\u0002F4fi6\u000b'o\u001b3po:\u0004&o\\2fgN|'O\u0003\u000btKRl\u0015M]6e_^t\u0007K]8dKN\u001cxN\u001d\u0006\u0005]\u0016DHOC\fqC\u000e\\\u0017mZ3EKN\u001c'/\u001b9uS>tg)\u001b7fg*Qr-\u001a;QC\u000e\\\u0017mZ3EKN\u001c'/\u001b9uS>tg)\u001b7fg*Q\u0001/Y2lC\u001e,W*\u00199\u000b\u0013M{'\u000f^3e\u001b\u0006\u0004(\"D4fiB\u000b7m[1hK6\u000b\u0007O\u0003\u0005qC\u000e\\\u0017mZ3t\u0015-9W\r\u001e)bG.\fw-Z:\u000b\u0011A\u0014XM^5pkNTQ\u0002\u001d:pG\u0016\u001c8/T1de>\u001c(B\u0005;fqR<\u0016\u000e\u001e5XQ&$Xm\u001d9bG\u0016Ta\u0002\u001d:pU\u0016\u001cGOU8pi\u0012K'OC\tsK\u0006$W*\u001a#jeN\u001c6-\u00198oK\u0012Tq\u0001S1tQN+GO\u0003\u0007sK2\fG/\u001b<f\r&dWMC\u0005eSJ,7\r^8ss*a\u0001k]5ESJ,7\r^8ss*a!/\u001a7bi&4XMT1nK*9\u0001k]5GS2,'\"D4fiN{WO]2f\t&\u00148O\u0003\tt_V\u00148-Z%oM>\u0014\u0015PR5mK*Q1k\\;sG\u0016LeNZ8\u000b\u00075\u000b\u0007OC\u0007t_V\u00148-\u001a'j].4uN\u001d\u0006\u000bg>,(oY3MS:,'bA%oi*aA.\u001b8f\u0019&t7\u000eV3yi*Qq-\u001a;T_V\u00148-Z:\u000b\u0017M|WO]2fg&sgm\u001c\u0006\u000fO\u0016$8k\\;sG\u0016\u001c\u0018J\u001c4p\u0015\u0015!\u0018\u000e\u001e7f\u0015!9W\r\u001e+ji2,'\"\u0004;ss2{\u0017\r\u001a*fC\u0012lUMC\u0004wKJ\u001c\u0018n\u001c8\u000b\u0015\u001d,GOV3sg&|gNC\u0006xS.L7i\u001c8wKJ$(\u0002\u00047j].\u0014VM\u001c3fe\u0016\u0014(\u0002\u0004'j].\u0014VM\u001c3fe\u0016\u0014(\u0002\u00034jY\u0016t\u0015-\\3\u001a\f)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0002\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0011A\u0011\u0001\u0005\u0006\u000b\t!A\u0001c\u0003\u0006\u0005\u0011%\u0001BB\u0003\u0004\t\u0015AI\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001b\u0002\u0007\u0001\u000b\r!1\u0001\u0003\u0005\r\u0001\u0015\t\u0001\"C\u0003\u0003\t\u001dA\u0019\"B\u0002\u0005\u0010!EA\u0002A\u0003\u0003\t\u0013A1\"B\u0002\u0005\u0012!UA\u0002A\u0003\u0003\t\u0015AI!\u0002\u0002\u0005\u0004!9QA\u0001\u0003\b\u0011/)!\u0001\"\u0006\t\u0011\u0015\u0019Aa\u0001E\r\u0019\u0001)!\u0001B\u0004\t\f\u0015\u0011A\u0001\u0004E\r\u000b\r!!\u0001\u0003\b\r\u0001\u0015\u0011A!\u0002E\u0010\u000b\r!Y\u0002C\b\r\u0001\u0015\u0019Aa\u0001\u0005\u0011\u0019\u0001)!\u0001\u0002\u0002\t\u001d\u0015\u0011A1\u0004\u0005\u0010\u000b\r!1\u0001c\t\r\u0001\u0015\u0019AA\u0001\u0005\u0013\u0019\u0001)!\u0001\"\u0003\t&\u0015\u0019A!\u0005\u0005\u0014\u0019\u0001)1\u0001B\u0002\t)1\u0001Qa\u0001\u0003\u0003\u0011Sa\u0001!\u0002\u0002\u0005\u0016!!Ra\u0001\u0003\u0003\u0011Ya\u0001!B\u0002\u0005#!AB\u0002A\u0003\u0003\tEA\u0001$B\u0002\u0005\u0005!QB\u0002A\u0003\u0003\t\tA!$B\u0002\u0005#!]B\u0002A\u0003\u0004\t\tAA\u0004\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0002H\u0003\u0003\tEA9$B\u0002\u0005#!iB\u0002A\u0003\u0003\t\tAI#B\u0002\u0005#!uB\u0002A\u0003\u0004\t\tAq\u0004\u0004\u0001\u0006\u0005\u0011\u0011\u0001bH\u0003\u0003\tEAi$\u0002\u0002\u0005\u0005!\u0011RA\u0001\u0003\u0012\u0011M)\u0011\u0001C\u0012\u0006\u0005\u0011a\u0002rI\u0003\u0003\tsA1\"B\u0002\u0005;!\u0015C\u0002A\u0003\u0003\tuA)%B\u0002\u0005;!)C\u0002A\u0003\u0003\tuAQ%B\u0002\u0005#!=C\u0002A\u0003\u0003\t\tAa#\u0002\u0002\u0005#!=SA\u0001\u0003\u0012\u0011u)!\u0001\"\u0003\tX\u0015\u0019A1\t\u0005,\u0019\u0001)1\u0001\u0002\u0002\tY1\u0001QA\u0001\u0003\u0003\u00111*!\u0001b\u0011\tW\u0015\u0011A1\u0001E-\u000b\r!A\u0005C\u0017\r\u0001\u0015\u0011A\u0001\n\u0005.\u000b\t!I\u0001C\u0019\u0006\u0007\u0011-\u0003\u0012\r\u0007\u0001\u000b\r!a\u0005\u0003\u0019\r\u0001\u0015\u0011A1\nE2\u000b\t!\u0001\u0001C\u001a\u0006\u0007\u0011=\u0003R\r\u0007\u0001\u000b\t!y\u0005#\u001a\u0006\u0007\u0011U\u0001R\u000e\u0007\u0001\u000b\t!)\u0002#\u001c\u0006\u0007\u0011U\u0001b\u000f\u0007\u0001\u000b\t!)\u0002C\u001e\u0006\u0007\u0011i\u0002\u0012\u0010\u0007\u0001\u000b\r!Q\u0004c\u001f\r\u0001\u0015\u0011A!\bE>\u000b\t!Q\u0004#\u001f\u0006\u0007\u0011\u0011\u0001b\u0010\u0007\u0001\u000b\t!!\u0001C \u0006\u0005\u0011E\u0001RC\u0003\u0004\t\rAy\b\u0004\u0001\u0006\u0005\u0011U\u0001rPC\u0004\t\rA\u0011\u0019\u0001\u0007\u0001\u000b\u000f!y\u0005Cd\u0001\u0019\u0001))\u0001b\u0014\t\u000f\u0004!\u0001\u0001$\u0002\u001a\u0005\u0015\t\u0001rA\u0017\r\t\u0005g\u0001\u0004D\u0011\u0004\u000b\u0005A9\u0002$\u0001V\u0007\u0011)1\u0001\u0002\u0007\n\u0003!eQ\u0016\b\u0003\u000115ij\u0001\u0002\u0001\t\u001c5\u0011Q!\u0001\u0005\u000e!\u000e\u0001QT\u0002\u0003\u0001\u0011;i!!B\u0001\t\u001dA\u001b\t!\t\u0002\u0006\u0003!u\u0011kA\u0004\u0005\u001b%\tA\u0001A\u0007\u0002\u0011=i\u0011\u0001c\b.L\u0011\u0001\u0001\u0014EO\u000b\t\u0001A\u0011#\u0004\u0004\u0006\u0003!\u0001\u0012bA\u0005\u0003\u000b\u0005A\t\u0003U\u0002\u0001;/!\u0001\u0001#\n\u000e\u000f\u0015\t\u0001RB\u0005\u0005\u0013\r)\u0011\u0001c\t\r\u0002A\u001b\t!\t\u0002\u0006\u0003!u\u0011kA\u0004\u0005\"%\tA\u0001A\u0007\u0002\u0011-i\u0011\u0001C\u0006.!\u0011\u0001G\u0001g\n\"\r\u0015\t\u0001BE\u0005\u0004\u0013\t)\u0011\u0001#\n%AU\u001bA!D\u0002\u0005+%\t\u0001bE\u0017\u0011\t\u0001$\u00014F\u0011\u0007\u000b\u0005A!#C\u0002\n\u0005\u0015\t\u0001r\u0005\u0013!+\u000e!Qb\u0001C\u0017\u0013\u0005A1#L\n\u0005\u0005a9RT\u0002\u0003\u0001\u0011_i!!B\u0001\t)A\u001b\u0001!\t\u0002\u0006\u0003!]\u0011kA\u0003\u0005/%\t\u0001\u0012D\u0007\u0002\u0011Sis\u0002\u00021\u00051\u001b\t#!B\u0001\t\rU\u001b\u0001\"B\u0002\u0005\u000e%\t\u0001BC\u0007\u0004\tcI\u0011\u0001\u0003\u0006.:\u0011\u0001\u0001$GO\u0007\t\u0001A\u0019$\u0004\u0002\u0006\u0003!)\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001rF\u0007\u0003\u000b\u0005AA\u0003UB\u0001C\t)\u0011\u0001#\bR\u0007\u001d!\u0011$C\u0001\u0005\u00015\t\u00012F\u0007\u0002\u0011Sis\u0002\u00021\u00051\u0011\t#!B\u0001\t\fU\u001b\u0001\"B\u0002\u0005\t%\t\u00012C\u0007\u0004\tkI\u0011\u0001c\u0005.<\u0011\u0011\u0001dGO\u0007\t\u0001AY\"\u0004\u0002\u0006\u0003!i\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001rF\u0007\u0003\u000b\u0005Aa\u0003UB\u0001C\r)\u0011\u0001#\f\r\u0002E\u001bq\u0001B\u000e\n\u0003!9R\"\u0001\u0005\u0010\u001b\u0005Ay#,\u0011\u0005\u0003aeRT\u0003\u0003\u0001\u0011Kia!B\u0001\t\u000e%\u0019\u0011BA\u0003\u0002\u0011a\u00016\u0001AO\u0007\t\u0001AY$\u0004\u0002\u0006\u0003!]\u0001k!\u0001\"\u0005\u0015\t\u0001RE)\u0004\u000f\u0011e\u0012\"\u0001E\u0019\u001b\u0005A1\"D\u0001\t\u001a5\"BA\u0001\r\u001f;\u001b!\u0001\u0001c\f\u000e\u0005\u0015\t\u0001\"\u0007)\u0004\u0001\u0005\u001aQ!\u0001E\u001a\u0019\u0003\t6!\u0002\u0003\u001f\u0013\u0005A!$D\u0001\t65\"BA\u0001M ;\u001b!\u0001\u0001c\f\u000e\u0005\u0015\t\u00012\u0005)\u0004\u0001\u0005\u001aQ!\u0001E\u0011\u0019\u0003\t6!\u0002C \u0013\u0005A1$D\u0001\t85\"BA\u0001\r!;\u001b!\u0001\u0001#\u0011\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\f\u0019\u0003\t6!\u0002\u0003!\u0013\u0005AI\"D\u0001\t\u001a5\"B\u0001\u0001\r\";\u001b!\u0001\u0001c\f\u000e\u0005\u0015\t\u0001\u0002\u0006)\u0004\u0001\u0005\u001aQ!\u0001E\f\u0019\u0003\t6!\u0002\u0003\"\u0013\u0005AI\"D\u0001\t*5\"B\u0001\u0001M\";\u001b!\u0001\u0001c\f\u000e\u0005\u0015\t\u0001\u0002\u0006)\u0004\u0001\u0005\u001aQ!\u0001E\f\u0019\u0003\t6!\u0002C\"\u0013\u0005AI\"D\u0001\t*5*BA\u0001M\";\u001f!\u0001\u0001\u0003\u0012\u000e\u0007\u0015\t\u00012\bG\u0001!\u000e\u0001\u0011eA\u0003\u0002\u0011/a\t!U\u0002\u0006\t\u0007J\u0011\u0001#\u0007\u000e\u0003!qRf\n\u0003\u00031\u0011jj\u0001\u0002\u0001\tJ5\u0011Q!\u0001E\u001f!\u000e\u0001QT\u0002\u0003\u0001\u0011\u0017j!!B\u0001\t\u0018A\u001b\t!(\u0004\u0005\u0001!1SBA\u0003\u0002\u0011/\u00016!A\u0011\u0004\u000b\u0005A9\u0002$\u0001R\u0007%!A%C\u0001\t\u001a5\t\u0001bH\u0007\u0002\u00113i\u0011\u0001#\u0007.)\u0011\u0001\u0001TJO\u0007\t\u0001Aq%\u0004\u0002\u0006\u0003!}\u0002k\u0001\u0001\"\u0007\u0015\t\u0001r\u0005G\u0001#\u000e)AQJ\u0005\u0002\u0011\u0001j\u0011\u0001#\u0011.)\u0011\u0001\u0001TJO\u0007\t\u0001A\u0001&\u0004\u0002\u0006\u0003!]\u0001k\u0001\u0001\"\u0007\u0015\t\u0001r\u0005G\u0001#\u000e)AQJ\u0005\u0002\u0011\u0001j\u0011\u0001#\u0007.'\u0011\u0001\u0001\u0014KO\u0007\t\u0001Ay#\u0004\u0002\u0006\u0003!A\u0002k\u0001\u0001\"\u0005\u0015\t\u0001RE)\u0004\u000b\u0011E\u0013\"\u0001E\u0019\u001b\u0005A\u0011%\f\u000b\u0005\u0001aIST\u0002\u0003\u0001\u0011wi!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!\u0015B\u0012A)\u0004\u000b\u0011I\u0013\"\u0001E\u0019\u001b\u0005AI\"\f\u000b\u0005\u0001aMST\u0002\u0003\u0001\u0011_i!!B\u0001\t)A\u001b\u0001!I\u0002\u0006\u0003!uB\u0012A)\u0004\u000b\u0011M\u0013\"\u0001\u0005 \u001b\u0005AI#L\u000b\u0005\u0001aQSt\u0002\u0003\u0001\u0011+j1!B\u0001\tE1\u0005\u0001k\u0001\u0001\"\u0007\u0015\t\u0001R\tG\u0001#\u000e)AAK\u0005\u0002\u0011\rj\u0011\u0001c\u0012.+\u0011\u0001M\u0002'\u0017\"\u0005\u0015\t\u0001\u0012J+\u0004\u001d\u0015\u0019A\u0011L\u0005\u0002\u0011\u0015j1\u0001b\u0017\n\u0003!)\u0013#\u0002\u0003/\u0013\u0005!\u0001!D\u0001\tK5nBA\u0001M/;\u001b!\u0001\u0001C\u0018\u000e\u0005\u0015\t\u0001R\u0005)\u0004\u0001u=A\u0001\u0001\u0005#\u001b\r)\u0011\u0001c\u0006\r\u0002A\u001b\t!\t\u0002\u0006\u0003!u\u0011kA\u0004\u0005^%\tA\u0001A\u0007\u0002\u0011ci\u0011\u0001#\u0007.)\u0011\u0001\u0001tLO\u0007\t\u0001Ay#\u0004\u0002\u0006\u0003!!\u0002k\u0001\u0001\"\u0007\u0015\t\u0001R\nG\u0001#\u000e)AqL\u0005\u0002\u0011\u001dj\u0011\u0001#\u000b.+\u0011\u0001M\u0002\u0007\u001a\"\u0005\u0015\t\u0001\u0002K+\u0004\u001d\u0015\u0019AAM\u0005\u0002\u0011#j1\u0001b\u001a\n\u0003!E\u0013#\u0002\u00035\u0013\u0005!\u0001!D\u0001\tR5\"B\u0001\u0001M5;\u001b!\u0001\u0001C\u0018\u000e\u0005\u0015\t\u0001R\u0005)\u0004\u0001\u0005\u001aQ!\u0001E\u0013\u0019\u0003\t6!\u0002C5\u0013\u0005A\t$D\u0001\t25\u001aB\u0001\u0019\u0003\u0019k\u00052Q!\u0001E\u0007\u0013\rI!!B\u0001\t\u0018U\u001b\u0001\"B\u0002\u0005k%\t\u0001bC\u0007\u0004\tWJ\u0011\u0001C\u0006./\u0011\u0001G\u0001\u0007\u001c\"\u0015\u0015\t\u0001\"K\u0005\u0004\u0013\t)\u0011\u0001c\u0006\n\u0007%\u0011Q!\u0001E\u0013+\u000eAQa\u0001\u00037\u0013\u0005A\u0019&D\u0002\u0005o%\t\u00012K\u0017\u0011\t\u0001$\u0001tN\u0011\u0007\u000b\u0005A!#C\u0002\n\u0005\u0015\t\u0001R\u0005\u0013!+\u000e!Qb\u0001\u00039\u0013\u0005A1#\f\u000b\u0005\u0001aETT\u0002\u0003\u0001\u0011=j!!B\u0001\t&A\u001b\u0001!I\u0002\u0006\u0003!\u0015B\u0012A)\u0004\u000b\u0011E\u0014\"\u0001E\u0019\u001b\u0005A\t$,\u000f\u0005\u0005aITT\u0002\u0003\u0001\u0011gj!!B\u0001\t\u0018A\u001b\u0001!(\u0004\u0005\u0001!%SBA\u0003\u0002\u0011{\u00016\u0011A\u0011\u0003\u000b\u0005A9\"U\u0002\b\teJ\u0011\u0001#\u0007\u000e\u0003!eQ\"\u0001\u0005 ['!\u0001\u0001\u0007\u001e\"\u0005\u0015\t\u0001rC)\u0004\u0007\u0011Q\u0014\"\u0001E\r[=!\u0011\r\u0002M;C\u0019)\u0011\u0001\u0003\u0016\n\u0007%\u0011Q!\u0001E\f+\u000e!Qa\u0001C;\u0013\u0005A)&l\u000f\u0005\u0005a]TT\u0002\u0003\u0001\u0011qj!!B\u0001\tWA\u001b\u0001!(\u0004\u0005\u0001!iTBA\u0003\u0002\u0011/\u00016\u0011A\u0011\u0004\u000b\u0005A9\u0006$\u0001R\u0007\u001d!9(C\u0001\tY5\t\u0001\u0012L\u0007\u0002\u00113i3\u0003\u00021\u00051\u001f\tc!B\u0001\t\u000e%\u0019\u0011BA\u0003\u0002\u0011!)6\u0001C\u0003\u0004\t\u001fI\u0011\u0001C\u0006\u000e\u0007\u0011q\u0014\"\u0001\u0005\f[M!\u0001\u0001' \u001e\u000e\u0011\u0001\u0001BI\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0001C\t)\u0011\u0001C\u0017R\u0007\u0015!i(C\u0001\t\\5\t\u0001BL\u0017\u0014\t\u0005$\u0001TP\u0011\u000b\u000b\u0005Ai&C\u0002\n\u0005\u0015\t\u0001\"C\u0005\u0004\u0013\t)\u0011\u0001C\u0017V\u0007\u0011)1\u0001\" \n\u0003!yS&\u000b\u0003\u00011\u0001\u0007QT\u0002\u0003\u0001\u0011\u0007j!!B\u0001\t\u0018A\u001b\u0001!H\u0004\u0005\u0001!\u0005\r!\u0004\u0002\u0006\u0003!}\u0003k!\u0001\u001e\u000f\u0011\t\u000121\u0001\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0003\u0005\u001aQ!\u0001E\f\u0019\u0003\t61\u0003\u0003A\u0002%\t\u0001\u0012D\u0007\u0002\u00113i\u0011\u0001\"\u0002\u000e\u0003!eQv\u0005\u0003a\taQ\u0011EB\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!IQk!\u0005\u0006\u0007\u0011Q\u0011\"\u0001\u0005\f\u001b\u000f!!\u0019A\u0005\u0002\u0011-iK\u0003\u00021\u00051\u000b\u0007\u0011EB\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!iSkA\u0005\u0006\b\u0011\u0015\r!C\u0001\t\u00175\u001dAa1\u0001\n\u0003!YQ&\u0004\u0003a\ta\u001d\r!\t\u0002\u0006\u0003!]A\u0005I+\u0004\n5\u001dA\u00012\u0001\n\u0003!eQ6\b\u0003\u00011\u0013\u0007QT\u0002\u0003\u0001\u0011=j!!B\u0001\t&A\u001b\u0001!(\u0004\u0005\u0001!=RBA\u0003\u0002\u0011Q\u00016\u0011A\u0011\u0003\u000b\u0005Ai\"UB\b\t\u0013\u0007\u0011\"\u0001\u0003\u0001\u001b\u0005A\t$D\u0001\t*5jA\u0001\u0019\u0003\u0019\u000b\u0004\t#!B\u0001\t\u0018\u0011\u0002Sk!\u0003\u000e\b\u0011-\r!C\u0001\t\u001a5JC\u0001\u0001\rG\u0002u5A\u0001\u0001E!\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001ir\u0001\u0002\u0001\t\u000e\u0004i!!B\u0001\taA\u001b\t!\b\u0005\u0005\u0001!=\r!D\u0002\u0006\u0003!]A\u0012\u0001)\u0004\u0003\u0005\u0012Q!\u0001E\f#\u000eMAA2\u0001\n\u0003!eQ\"\u0001E\r\u001b\u0005A\t'D\u0001\t\u001aUJT\u0001\u000f\u0003d\u0002a\u001dQT\u0002\u0003\u0001\u0011\u0011i!!B\u0001\t\fA\u001b\u0001!(\u0004\u0005\u0001!5QBA\u0003\u0002\u0011\u0019\u00016\u0011AO\u000b\t\u0001Ay!\u0004\u0004\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005A\u0001\u0002U\u0002\u0002;+!\u0001\u0001\u0003\u0006\u000e\r\u0015\t\u0001RB\u0005\u0004\u0013\t)\u0011\u0001C\u0005Q\u0007\u0007\t#!B\u0001\t\u0006E\u001b1\u0002b\u0002\n\u0003\u0011\u0001Q\"\u0001E\n\u001b\u0005A!\"D\u0001\t\u00175\t\u0001b\u0003"})
public final class KModel
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final SortedMap<String, KPackage> packageMap;
    @NotNull
    private PegDownProcessor markdownProcessor;
    @NotNull
    private SyntaxHighlighter highlighter;
    private String _projectRootDir;
    @NotNull
    private final List<? extends String> packageDescriptionFiles;
    private final HashSet<String> readMeDirsScanned;
    @NotNull
    private final List<? extends SourceInfo> sourcesInfo;
    private final Map<JetFile, ? extends SourceInfo> sourceInfoByFile;
    @NotNull
    private final BindingContext context;
    @NotNull
    private final KDocConfig config;
    @NotNull
    private final List<? extends File> sourceDirs;
    @NotNull
    private final List<? extends JetFile> sources;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(KModel.class);
    }

    @NotNull
    public final SortedMap<String, KPackage> getPackageMap() {
        return this.packageMap;
    }

    @NotNull
    public final Collection<KPackage> getAllPackages() {
        return this.packageMap.values();
    }

    @NotNull
    public final Collection<KPackage> getPackages() {
        Iterable iterable;
        Iterable iterable2 = iterable = (Iterable)this.getAllPackages();
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            KPackage it = (KPackage)t;
            if (!this.getConfig().includePackage(it)) continue;
            collection.add(t);
        }
        return (ArrayList)collection;
    }

    @NotNull
    public final Collection<KClass> getClasses() {
        Iterable iterable;
        Iterable iterable2 = iterable = (Iterable)this.getPackages();
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            KPackage it = (KPackage)t;
            Iterable iterable3 = it.getClasses();
            KotlinPackage.addAll((Collection)collection, (Iterable)iterable3);
        }
        return (ArrayList)collection;
    }

    @NotNull
    public final PegDownProcessor getMarkdownProcessor() {
        return this.markdownProcessor;
    }

    public final void setMarkdownProcessor(@JetValueParameter(name="<set-?>") @NotNull PegDownProcessor pegDownProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)pegDownProcessor, (String)"<set-?>");
        this.markdownProcessor = pegDownProcessor;
    }

    @NotNull
    public final SyntaxHighlighter getHighlighter() {
        return this.highlighter;
    }

    public final void setHighlighter(@JetValueParameter(name="<set-?>") @NotNull SyntaxHighlighter syntaxHighlighter) {
        Intrinsics.checkParameterIsNotNull((Object)syntaxHighlighter, (String)"<set-?>");
        this.highlighter = syntaxHighlighter;
    }

    @NotNull
    public final String getTitle() {
        return this.config.getTitle();
    }

    @NotNull
    public final String getVersion() {
        return this.config.getVersion();
    }

    @NotNull
    public final List<String> getPackageDescriptionFiles() {
        return this.packageDescriptionFiles;
    }

    @NotNull
    public final List<SourceInfo> getSourcesInfo() {
        return this.sourcesInfo;
    }

    @NotNull
    public final SourceInfo sourceInfoByFile(@JetValueParameter(name="file") @NotNull JetFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        SourceInfo sourceInfo = this.sourceInfoByFile.get(file);
        if (sourceInfo == null) {
            Intrinsics.throwNpe();
        }
        return sourceInfo;
    }

    @NotNull
    public final String projectRootDir() {
        String string;
        if (this._projectRootDir == null) {
            String string2;
            String rootDir = this.config.getProjectRootDir();
            if (rootDir == null) {
                ModelPackage$KotlinModel$508284e7.warning("KDocConfig does not have a projectRootDir defined so we cannot generate relative source Hrefs");
                string2 = "";
            } else {
                string2 = this._projectRootDir = new File(rootDir).getCanonicalPath();
            }
        }
        if ((string = this._projectRootDir) == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final KPackage getPackage(@JetValueParameter(name="name") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (KPackage)this.packageMap.get(name);
    }

    @NotNull
    public final KPackage getOrCreatePackage(@JetValueParameter(name="descriptor") @NotNull PackageFragmentDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        String name = ModelPackage$KotlinModel$508284e7.qualifiedName((DeclarationDescriptor)descriptor);
        KPackage pkg = (KPackage)this.packageMap.get(name);
        if (pkg != null) {
            return pkg;
        }
        return this.createPackage(KotlinPackage.listOf((Object[])new PackageFragmentDescriptor[]{descriptor}), name);
    }

    private final KPackage createPackage(@JetValueParameter(name="descriptors") List<? extends PackageFragmentDescriptor> descriptors, @JetValueParameter(name="name") String name) {
        boolean bl;
        KPackage pkg = new KPackage(this, descriptors, name, KotlinPackage.isNotEmpty((String)this.config.resolveLink(name, false)));
        boolean bl2 = bl = !this.packageMap.containsKey(name);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String string = "packageMap entry created earlier for package " + name + ": old=" + (KPackage)this.getPackageMap().get(name) + ", new=" + pkg;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinPackage.set((Map)this.packageMap, (Object)name, (Object)pkg);
        for (PackageFragmentDescriptor packageFragmentDescriptor : descriptors) {
            this.addFunctions(pkg, packageFragmentDescriptor.getMemberScope());
        }
        String string = this.config.getPackageDescriptionFiles().get(name);
        this.loadWikiDescription(pkg, string);
        return pkg;
    }

    protected final void loadWikiDescription(@JetValueParameter(name="pkg") @NotNull KPackage pkg, @JetValueParameter(name="file", type="?") @Nullable String file) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        if (file != null) {
            try {
                ((KAnnotated)pkg).setWikiDescription(IoPackage.readText$default((File)new File(file), null, (int)1));
            }
            catch (Throwable e) {
                ModelPackage$KotlinModel$508284e7.warning("Failed to load package " + pkg.getName() + " documentation file " + file + ". Reason " + e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void tryLoadReadMe(@JetValueParameter(name="pkg") @NotNull KPackage pkg, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        File srcFile;
        File dir;
        String srcPath;
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        if (KotlinPackage.isEmpty((String)((KAnnotated)pkg).getWikiDescription()) && (srcPath = ((KAnnotated)pkg).getModel().filePath(descriptor)) != null && ((dir = (srcFile = new File(srcPath)).isDirectory() ? srcFile : srcFile.getParentFile()) != null ? this.readMeDirsScanned.add(dir.getPath()) : false)) {
            Iterator<Object> iterator;
            block5: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)this.packageDescriptionFiles;
                Collection collection = new ArrayList();
                for (Object t : iterable2) {
                    void it;
                    String string = (String)t;
                    Collection collection2 = collection;
                    File file = new File(dir, (String)it);
                    collection2.add(file);
                }
                iterable2 = iterable = (Iterable)((ArrayList)collection);
                for (Iterator<Object> iterator2 : iterable2) {
                    File it = (File)((Object)iterator2);
                    if (!it.exists()) continue;
                    iterator = iterator2;
                    break block5;
                }
                iterator = null;
            }
            File f = (File)((Object)iterator);
            if (f != null) {
                String file = f.getCanonicalPath();
                this.loadWikiDescription(pkg, file);
            } else {
                ModelPackage$KotlinModel$508284e7.info("package " + pkg.getName() + " has no ReadMe.(html|md) in " + dir);
            }
        }
    }

    @NotNull
    public final String wikiConvert(@JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="linkRenderer") @NotNull LinkRenderer linkRenderer, @JetValueParameter(name="fileName", type="?") @Nullable String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)linkRenderer, (String)"linkRenderer");
        String string = this.markdownProcessor.markdownToHtml(text, linkRenderer);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Nullable
    public final String sourceLinkFor(@JetValueParameter(name="filePath") @NotNull String filePath, @JetValueParameter(name="sourceLine") int sourceLine, @JetValueParameter(name="lineLinkText") @NotNull String lineLinkText) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)lineLinkText, (String)"lineLinkText");
        String root = this.config.getSourceRootHref();
        if (root != null) {
            String rootDir = this.projectRootDir();
            String canonicalFile = new File(filePath).getCanonicalPath();
            String relativeFile = KotlinPackage.startsWith((String)canonicalFile, (String)rootDir) ? KotlinPackage.substring((String)canonicalFile, (int)KotlinPackage.length((String)rootDir)) : canonicalFile;
            String cleanRoot = KotlinPackage.trimTrailing((String)root, (String)"/");
            String cleanPath = KotlinPackage.trimLeading((String)relativeFile, (String)"/");
            return cleanRoot + "/" + cleanPath + lineLinkText + sourceLine;
        }
        return null;
    }

    public static String sourceLinkFor$default(KModel kModel, String string, int n, String string2, int n2) {
        if ((n2 & 4) != 0) {
            string2 = "#L";
        }
        return kModel.sourceLinkFor(string, n, string2);
    }

    public final void addFunctions(@JetValueParameter(name="owner") @NotNull KClassOrPackage owner, @JetValueParameter(name="scope") @NotNull JetScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        try {
            Collection descriptors = scope.getAllDescriptors();
            for (DeclarationDescriptor descriptor : descriptors) {
                KFunction function;
                if (descriptor instanceof PropertyDescriptor) {
                    String name = ((PropertyDescriptor)descriptor).getName().asString();
                    KType returnType = this.getType(((PropertyDescriptor)descriptor).getReturnType());
                    if (!(returnType != null)) continue;
                    ReceiverParameterDescriptor receiver = ((PropertyDescriptor)descriptor).getReceiverParameter();
                    KType extensionClass = receiver != null ? this.getType(receiver.getType()) : (KType)null;
                    KType kType = extensionClass;
                    KProperty property = new KProperty(owner, (PropertyDescriptor)descriptor, name, returnType, kType != null ? kType.getKlass() : null);
                    owner.getProperties().add(property);
                    continue;
                }
                if (!(descriptor instanceof CallableDescriptor) || !((function = this.createFunction(owner, (CallableDescriptor)descriptor)) != null)) continue;
                owner.getFunctions().add(function);
            }
        }
        catch (Throwable e) {
            ModelPackage$KotlinModel$508284e7.warning("Caught exception finding function declarations on " + owner + " " + e);
            e.printStackTrace();
        }
    }

    @Nullable
    protected final KFunction createFunction(@JetValueParameter(name="owner") @NotNull KClassOrPackage owner, @JetValueParameter(name="descriptor") @NotNull CallableDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        KType returnType = this.getType(descriptor.getReturnType());
        if (returnType != null) {
            String name = descriptor.getName().asString();
            ArrayList<KParameter> parameters = new ArrayList<KParameter>();
            List params = descriptor.getValueParameters();
            for (ValueParameterDescriptor param : params) {
                KParameter p = this.createParameter(param);
                if (!(p != null)) continue;
                parameters.add(p);
            }
            KFunction function = new KFunction(descriptor, owner, name, returnType, parameters, null, null, null, null, null, null, 2016);
            this.addTypeParameters(function.getTypeParameters(), descriptor.getTypeParameters());
            this.configureComments(function, (DeclarationDescriptor)descriptor);
            ReceiverParameterDescriptor receiver = descriptor.getReceiverParameter();
            if (receiver != null) {
                KType receiverType = this.getType(receiver.getType());
                function.setReceiverType(receiverType);
                KType kType = receiverType;
                function.setExtensionClass(kType != null ? kType.getKlass() : null);
            }
            return function;
        }
        return null;
    }

    public final void addTypeParameters(@JetValueParameter(name="answer") @NotNull List<KTypeParameter> answer, @JetValueParameter(name="descriptors") @NotNull List<? extends TypeParameterDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(answer, (String)"answer");
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        for (TypeParameterDescriptor typeParameterDescriptor : descriptors) {
            KTypeParameter p;
            if (!(typeParameterDescriptor != null) || !((p = this.createTypeParameter(typeParameterDescriptor)) != null)) continue;
            answer.add(p);
        }
    }

    @Nullable
    protected final KTypeParameter createTypeParameter(@JetValueParameter(name="descriptor") @NotNull TypeParameterDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        String name = descriptor.getName().asString();
        KTypeParameter answer = new KTypeParameter(name, descriptor, this, null, 8);
        this.configureComments(answer, (DeclarationDescriptor)descriptor);
        return answer;
    }

    @Nullable
    protected final KParameter createParameter(@JetValueParameter(name="descriptor") @NotNull ValueParameterDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        KType returnType = this.getType(descriptor.getReturnType());
        if (returnType != null) {
            String name = descriptor.getName().asString();
            KParameter answer = new KParameter(descriptor, name, returnType);
            this.configureComments(answer, (DeclarationDescriptor)descriptor);
            return answer;
        }
        return null;
    }

    @Nullable
    public final DiagnosticUtils.LineAndColumn locationFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.getPsiElement(descriptor);
        if (psiElement != null) {
            Document document;
            PsiFile psiFile = psiElement.getContainingFile();
            Document document2 = document = psiFile != null && (psiFile = psiFile.getViewProvider()) != null ? psiFile.getDocument() : null;
            if (document != null) {
                int offset = psiElement.getTextOffset();
                return DiagnosticUtils.offsetToLineAndColumn((Document)document, (int)offset);
            }
        }
        return null;
    }

    @Nullable
    public final String fileFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.getPsiElement(descriptor);
        PsiElement psiElement2 = psiElement;
        return psiElement2 != null && (psiElement2 = psiElement2.getContainingFile()) != null ? psiElement2.getName() : null;
    }

    @Nullable
    public final String filePath(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement2 = psiElement = this.getPsiElement(descriptor);
        PsiFile file = psiElement2 != null ? psiElement2.getContainingFile() : null;
        return this.filePath((PsiFileSystemItem)file);
    }

    @Nullable
    public final PsiElement getPsiElement(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        try {
            psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)descriptor);
        }
        catch (Throwable e) {
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String commentsFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.getPsiElement(descriptor);
        if (psiElement != null) {
            ASTNode aSTNode = psiElement.getNode();
            ASTNode node = aSTNode != null ? aSTNode.getTreePrev() : null;
            while (true) {
                boolean bl;
                if (node != null) {
                    ASTNode aSTNode2 = node;
                    if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)JetTokens.WHITE_SPACE)) {
                        ASTNode aSTNode3 = node;
                        bl = Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)JetTokens.BLOCK_COMMENT);
                    } else {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
                if (!bl) break;
                ASTNode aSTNode4 = node;
                node = aSTNode4 != null ? aSTNode4.getTreePrev() : null;
            }
            if (node == null) {
                return "";
            }
            ASTNode aSTNode5 = node;
            if (Intrinsics.areEqual((Object)(aSTNode5 != null ? aSTNode5.getElementType() : null), (Object)JetTokens.DOC_COMMENT) ^ true) {
                return "";
            }
            Object object = node;
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            Object nodeText = object;
            String[] lines = KotlinPackage.split((String)KotlinPackage.trim((String)nodeText), (String)"\\n");
            StringBuilder buffer = new StringBuilder();
            int last = lines.length - 1;
            int n = 0;
            int n2 = last;
            if (n <= n2) {
                while (true) {
                    void i;
                    String text = lines[i];
                    text = KotlinPackage.trim((String)text);
                    if (i == false) {
                        text = KotlinPackage.trimLeading((String)KotlinPackage.trimLeading((String)text, (String)"/**"), (String)"/*");
                    } else {
                        buffer.append("\n");
                    }
                    if (i >= last) {
                        text = KotlinPackage.trimTrailing((String)text, (String)"*/");
                    } else if (i > false && Intrinsics.areEqual((Object)(text = KotlinPackage.trimLeading((String)text, (String)"* ")), (Object)"*")) {
                        text = "";
                    }
                    text = this.processMacros(text, psiElement);
                    buffer.append(text);
                    if (i == n2) break;
                    ++i;
                }
            }
            return buffer.toString();
        }
        return "";
    }

    @NotNull
    protected final String processMacros(@JetValueParameter(name="textWithWhitespace") @NotNull String textWithWhitespace, @JetValueParameter(name="psiElement") @NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull((Object)textWithWhitespace, (String)"textWithWhitespace");
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        String text = KotlinPackage.trim((String)textWithWhitespace);
        if (KotlinPackage.startsWith((String)text, (String)"@")) {
            String macro;
            String remaining = KotlinPackage.substring((String)text, (int)1);
            if (KotlinPackage.startsWith((String)remaining, (String)(macro = "includeFunctionBody"))) {
                String next = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)KotlinPackage.length((String)macro)));
                String[] words = KotlinPackage.split((String)next, (String)"\\s");
                if (words.length > 1) {
                    String includeFile = words[0];
                    String fnName = words[1];
                    String content = this.findFunctionInclude(psiElement, includeFile, fnName);
                    if (content != null) {
                        return content;
                    }
                    ModelPackage$KotlinModel$508284e7.warning("could not find function " + fnName + " in file " + includeFile + " from source file " + psiElement.getContainingFile());
                }
            } else {
                ModelPackage$KotlinModel$508284e7.warning("Unknown kdoc macro @" + remaining);
            }
        }
        return textWithWhitespace;
    }

    @Nullable
    protected final String findFunctionInclude(@JetValueParameter(name="psiElement") @NotNull PsiElement psiElement, @JetValueParameter(name="includeFile") @NotNull String includeFile, @JetValueParameter(name="functionName") @NotNull String functionName) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        Intrinsics.checkParameterIsNotNull((Object)includeFile, (String)"includeFile");
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        PsiFile psiFile = psiElement.getContainingFile();
        PsiDirectory dir = psiFile != null ? psiFile.getParent() : null;
        if (dir != null) {
            int idx;
            String remaining;
            String content;
            Pattern regex;
            Matcher matcher;
            String text;
            PsiFile file;
            PsiDirectory psiDirectory = dir;
            if (psiDirectory == null) {
                Intrinsics.throwNpe();
            }
            if ((file = this.relativeFile(psiDirectory, includeFile)) != null && (text = file.getText()) != null && (matcher = (regex = KotlinPackage.toRegex$default((String)("fun" + "\\" + "s+" + functionName + "\\" + "(.*" + "\\" + ")"), (int)0, (int)1)).matcher(text)).find() && (content = this.extractBlock(remaining = KotlinPackage.substring((String)text, (int)(idx = matcher.end())))) != null) {
                String highlight = this.highlighter.highlight(content);
                String filePath = this.filePath((PsiFileSystemItem)file);
                String string = KotlinPackage.substring((String)text, (int)0, (int)idx);
                int n = 0;
                CharIterator charIterator = KotlinPackage.iterator((CharSequence)string);
                while (charIterator.hasNext()) {
                    char c = charIterator.nextChar();
                    char it = c;
                    if (!(it == '\n')) continue;
                    ++n;
                }
                int sourceLine = n + 1;
                String link = filePath != null ? KModel.sourceLinkFor$default(this, filePath, sourceLine, null, 4) : (String)null;
                return link != null ? "<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + link + "\"" + " target=" + "\"" + "_top" + "\"" + "  class=" + "\"" + "repoSourceCode" + "\"" + ">source</a></div>" + "\n" + highlight : highlight;
            }
        }
        return null;
    }

    @Nullable
    protected final String filePath(@JetValueParameter(name="file", type="?") @Nullable PsiFileSystemItem file) {
        PsiFileSystemItem dir;
        if (file != null && (dir = file.getParent()) != null) {
            String string = this.filePath(dir);
            if (string == null) {
                string = "";
            }
            String parentName = string;
            return parentName + "/" + file.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final String extractBlock(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int idx = KotlinPackage.indexOf((String)text, (char)'{');
        if (idx >= 0) {
            String line22;
            int nidx;
            String remaining = KotlinPackage.substring((String)text, (int)(idx + 1));
            while ((nidx = KotlinPackage.indexOf((String)remaining, (char)'\n')) >= 0 && KotlinPackage.isEmpty((String)(line22 = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)0, (int)nidx))))) {
                remaining = KotlinPackage.substring((String)remaining, (int)(nidx + 1));
            }
            int count = 1;
            int line22 = 0;
            int n = KotlinPackage.getSize((String)remaining) - 1;
            if (line22 <= n) {
                while (true) {
                    void i;
                    char ch;
                    if ((ch = remaining.charAt((int)i)) == '{') {
                        ++count;
                    } else if (ch == '}' && --count <= 0) {
                        return KotlinPackage.substring((String)remaining, (int)0, (int)i);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            ModelPackage$KotlinModel$508284e7.warning("missing } in code block for " + remaining);
            return remaining;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiFile relativeFile(@JetValueParameter(name="directory") @NotNull PsiDirectory directory, @JetValueParameter(name="relativeName") @NotNull String relativeName) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)relativeName, (String)"relativeName");
        PsiDirectory dir = directory;
        String[] paths = KotlinPackage.split((String)relativeName, (String)"/");
        int size = paths.length;
        int n = 0;
        int n2 = size - 2;
        if (n <= n2) {
            while (true) {
                void i;
                String path;
                if (!Intrinsics.areEqual((Object)(path = paths[i]), (Object)".")) {
                    if (Intrinsics.areEqual((Object)path, (Object)"..")) {
                        PsiDirectory psiDirectory = dir;
                        dir = psiDirectory != null ? psiDirectory.getParent() : null;
                    } else {
                        PsiDirectory psiDirectory = dir;
                        Object object = dir = psiDirectory != null ? psiDirectory.findSubdirectory(path) : null;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        String name = paths[size - 1];
        if (dir != null) {
            PsiDirectory psiDirectory = dir;
            Object file = psiDirectory != null ? psiDirectory.findFile(name) : null;
            if (file != null) {
                return file;
            }
            ModelPackage$KotlinModel$508284e7.warning("could not find file " + relativeName + " in " + dir + " with name " + name);
        }
        return null;
    }

    public final void configureComments(@JetValueParameter(name="annotated") @NotNull KAnnotated annotated, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)annotated, (String)"annotated");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        String detailedText = KotlinPackage.trim((String)this.commentsFor(descriptor));
        annotated.setWikiDescription(detailedText);
    }

    @Nullable
    public final KType getType(@JetValueParameter(name="aType", type="?") @Nullable JetType aType) {
        if (aType != null) {
            ClassifierDescriptor classifierDescriptor = aType.getConstructor().getDeclarationDescriptor();
            KClass klass = classifierDescriptor instanceof ClassDescriptor ? this.getClass((ClassDescriptor)classifierDescriptor) : (KClass)null;
            return new KType(aType, this, klass, null, 8);
        }
        return null;
    }

    @Nullable
    public final KClass getClass(@JetValueParameter(name="qualifiedName") @NotNull String qualifiedName) {
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        int idx = KotlinPackage.lastIndexOf((String)qualifiedName, (char)'.');
        String pkgName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)0, (int)idx) : "";
        KPackage pkg = this.getPackage(pkgName);
        if (pkg != null) {
            String simpleName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)(idx + 1)) : qualifiedName;
            return (KClass)pkg.getClassMap().get(simpleName);
        }
        return null;
    }

    @Nullable
    public final KClass getClass(@JetValueParameter(name="classElement") @NotNull ClassDescriptor classElement) {
        Intrinsics.checkParameterIsNotNull((Object)classElement, (String)"classElement");
        String name = classElement.getName().asString();
        DeclarationDescriptor dec = classElement.getContainingDeclaration();
        while (dec != null) {
            DeclarationDescriptor container = dec;
            if (container instanceof PackageFragmentDescriptor) {
                KPackage pkg = this.getOrCreatePackage((PackageFragmentDescriptor)container);
                return pkg.getClass(classElement);
            }
            DeclarationDescriptor declarationDescriptor = dec;
            dec = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        }
        ModelPackage$KotlinModel$508284e7.warning("no package found for class " + name);
        return null;
    }

    @Nullable
    public final KPackage previous(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        return null;
    }

    @Nullable
    public final KPackage next(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        return null;
    }

    @NotNull
    public final BindingContext getContext() {
        return this.context;
    }

    @NotNull
    public final KDocConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final List<File> getSourceDirs() {
        return this.sourceDirs;
    }

    @NotNull
    public final List<JetFile> getSources() {
        return this.sources;
    }

    /*
     * WARNING - void declaration
     */
    public KModel(@JetValueParameter(name="context") @NotNull BindingContext context, @JetValueParameter(name="config") @NotNull KDocConfig config, @JetValueParameter(name="sourceDirs") @NotNull List<? extends File> sourceDirs, @JetValueParameter(name="sources") @NotNull List<? extends JetFile> sources) {
        Iterable packageFragment;
        Object source;
        Object object;
        Object object2;
        Iterator iterator2;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(sourceDirs, (String)"sourceDirs");
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.context = context;
        this.config = config;
        this.sourceDirs = sourceDirs;
        this.sources = sources;
        this.packageMap = KotlinPackage.sortedMapOf((Pair[])new Pair[0]);
        this.markdownProcessor = new PegDownProcessor(Extensions.ALL);
        this.highlighter = new SyntaxHighlighter();
        this._projectRootDir = null;
        this.packageDescriptionFiles = KotlinPackage.listOf((Object[])new String[]{"readme.md", "ReadMe.md, readme.html, ReadMe.html"});
        this.readMeDirsScanned = new HashSet();
        Iterable object4 = this.sourceDirs;
        Object object5 = object4;
        Iterable iterable = new ArrayList();
        Object object6 = object5.iterator();
        while (object6.hasNext()) {
            void file;
            object3 = object6.next();
            iterator2 = (File)object3;
            object2 = iterable;
            object = file.getCanonicalPath();
            object2.add(object);
        }
        List normalizedSourceDirs = (ArrayList)iterable;
        KModel$1 kModel$1 = new KModel$1(normalizedSourceDirs);
        object5 = this.sources;
        object2 = this;
        iterable = object5;
        object6 = new ArrayList();
        for (Iterator iterator2 : iterable) {
            JetFile jetFile = (JetFile)iterator2;
            object = object6;
            String relativePath = kModel$1.invoke((PsiFile)source);
            String htmlPath = KotlinPackage.replaceFirst((String)relativePath, (String)"\\.kt$", (String)"") + ".html";
            SourceInfo sourceInfo = new SourceInfo((JetFile)source, relativePath, htmlPath);
            object.add(sourceInfo);
        }
        ((KModel)object2).sourcesInfo = object = (List)((ArrayList)object6);
        this.sourceInfoByFile = DocPackage$collections$b8ec3894.toHashMapMappingToKey(this.sourcesInfo, KModel$sourceInfoByFile$1.INSTANCE$);
        HashSet<Iterable> allPackageFragments = new HashSet<Iterable>();
        for (JetFile jetFile : this.sources) {
            packageFragment = (PackageFragmentDescriptor)this.context.get((ReadOnlySlice)BindingContext.FILE_TO_PACKAGE_FRAGMENT, (Object)jetFile);
            if (packageFragment != null) {
                allPackageFragments.add(packageFragment);
                continue;
            }
            ModelPackage$KotlinModel$508284e7.warning("No PackageFragmentDescriptor for source " + jetFile);
        }
        packageFragment = allPackageFragments;
        object6 = packageFragment;
        object3 = new LinkedHashMap();
        iterator2 = object6.iterator();
        while (iterator2.hasNext()) {
            Object object7;
            Object object8 = object3;
            source = iterator2.next();
            PackageFragmentDescriptor it = (PackageFragmentDescriptor)source;
            String string = ModelPackage$KotlinModel$508284e7.qualifiedName((DeclarationDescriptor)it);
            if (object8.containsKey(string)) {
                object7 = object8.get(string);
            } else {
                ArrayList arrayList = new ArrayList();
                object8.put(string, arrayList);
                object7 = arrayList;
            }
            List list = (List)object7;
            list.add(source);
        }
        object5 = KotlinPackage.iterator((Map)object3);
        while (object5.hasNext()) {
            Map.Entry entry = (Map.Entry)object5.next();
            String name = (String)KotlinPackage.component1((Map.Entry)entry);
            List packageFragments = (List)KotlinPackage.component2((Map.Entry)entry);
            this.createPackage(packageFragments, name);
            for (PackageFragmentDescriptor packageFragment2 : packageFragments) {
                for (DeclarationDescriptor descriptor : packageFragment2.getMemberScope().getAllDescriptors()) {
                    if (!(descriptor instanceof ClassDescriptor)) continue;
                    this.getClass((ClassDescriptor)descriptor);
                }
            }
        }
    }
}

