/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.highlighter;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import kotlin.template.HtmlFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetLexer;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighlighter$createStyleMap$1;

@KotlinClass(abiVersion=16, data={"\n\u0006)\t2+\u001f8uCbD\u0015n\u001a5mS\u001eDG/\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1\u0001Z8d\u0015-A\u0017n\u001a5mS\u001eDG/\u001a:\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\u000fGJ,\u0017\r^3TifdW-T1q\u0015\ri\u0015\r\u001d\u0006\r\u0013\u0016cW-\\3oiRK\b/\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u0007A\u001c\u0018N\u0003\u0003ue\u0016,'BB*ue&twM\u0003\u0003kCZ\f'\u0002B;uS2T\u0011BZ8s[\u0006$H/\u001a:\u000b\u001b!#X\u000e\u001c$pe6\fG\u000f^3s\u0015!!X-\u001c9mCR,'\u0002D4fi\u001a{'/\\1ui\u0016\u0014(\u0002D:fi\u001a{'/\\1ui\u0016\u0014(\"\u00035jO\"d\u0017n\u001a5u\u0015\u0011\u0019w\u000eZ3\u000b\t1\fgn\u001a\u0006\tgRLH.Z'ba*Yq-\u001a;TifdW-T1q\u001d\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)1\u0001B\u0002\t\n1\u0001Q!\u0001E\u0006\u000b\t!I\u0001\u0003\u0004\u0006\u0005\u0011)\u0001RB\u0003\u0003\t\u0017Aq!B\u0002\u0005\r!)A\u0002A\u0003\u0004\t\rAy\u0001\u0004\u0001\u0006\u0003!AQA\u0001C\b\u0011#)!\u0001\u0002\u0005\t\n\u0015\u0011Aa\u0001\u0005\u000b\u000b\r!\u0011\u0002c\u0005\r\u0001\u0015\u0011A!\u0003E\n\u000b\t!y\u0001#\u0007\u0006\u0005\u0011U\u0001r\u0002\u0003\u0001\u0019\u000bI\"!B\u0001\t\b5\u0016BA\u0001\r\u0005C-)\u0011\u0001\u0003\u0003\n\t%\u0019Q!\u0001E\u0007\u0019\u0003I1!\u0003\u0002\u0006\u0003!9\u0011kA\u0002\u0005\t%\t\u0001\u0012C\u0017\u0016\t\u0001g\u0001$C\u0011\u0003\u000b\u0005A\u0019\"V\u0002\u000f\u000b\r!\u0011\"C\u0001\t\u00155\u0019AQC\u0005\u0002\u0011)\tR\u0001B\u0006\n\u0003\u0011\u0001Q\"\u0001\u0005\u000b[M!\u0001\u0001g\u0006\u001e\u000e\u0011\u0001\u0001\u0002D\u0007\u0003\u000b\u0005Aq\u0001U\u0002\u0001C\t)\u0011\u0001C\u0004R\u0007\u0015!9\"C\u0001\t\u00175\t\u0001bC\u0017\u0019\t\u0001$\u0001$D\u0011\f\u000b\u0005AA!\u0003\u0003\n\u0007\u0015\t\u0001R\u0002G\u0001\u0013\rI!!B\u0001\t\u000fU\u001b\u0001\"B\u0002\u0005\u001b%\t\u0001\u0012C\u0007\u0004\t7I\u0011\u0001#\u00056\u0017\u0015QAa9\u0001\u0019\b\u0005\u0012Q!\u0001E\u0003#\u000e\u0019AqA\u0005\u0002\t\u0001\u0001"})
public final class SyntaxHighlighter
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private HtmlFormatter formatter = new HtmlFormatter(null, 1);
    @NotNull
    private final Map<IElementType, ? extends String> styleMap = this.createStyleMap();

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(SyntaxHighlighter.class);
    }

    @NotNull
    public final HtmlFormatter getFormatter() {
        return this.formatter;
    }

    public final void setFormatter(@JetValueParameter(name="<set-?>") @NotNull HtmlFormatter htmlFormatter) {
        this.formatter = htmlFormatter;
    }

    @NotNull
    public final Map<IElementType, String> getStyleMap() {
        return this.styleMap;
    }

    @NotNull
    public final String highlight(@JetValueParameter(name="code") @NotNull String code) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=\"code panel\" style=\"border-width: 1px\">" + "<div class=\"codeContent panelContent\">" + "<div class=\"container\">");
            int idx = 0;
            while (Character.isWhitespace(code.charAt(idx))) {
                ++idx;
            }
            if (idx > 0) {
                String space = KotlinPackage.substring((String)code, (int)0, (int)idx);
                builder.append("<code class=" + "\"" + "jet whitespace" + "\"" + ">" + space + "</code>");
            }
            JetLexer lexer = new JetLexer();
            lexer.start((CharSequence)code);
            while (true) {
                Unit unit;
                lexer.advance();
                IElementType token = lexer.getTokenType();
                boolean bl = true;
                if (token != null) {
                    bl = false;
                }
                if (bl) break;
                String tokenText = KotlinPackage.replaceAll((String)((Object)lexer.getTokenSequence()).toString(), (String)"\n", (String)"\r\n");
                String style = null;
                if (token instanceof JetKeywordToken) {
                    style = "keyword";
                } else if (Intrinsics.areEqual((Object)token, (Object)JetTokens.IDENTIFIER)) {
                    IElementType[] iElementTypeArray = JetTokens.SOFT_KEYWORDS.getTypes();
                    for (int i = 0; i < iElementTypeArray.length; ++i) {
                        IElementType softKeyword = iElementTypeArray[i];
                        if (!(softKeyword instanceof JetKeywordToken) || !Intrinsics.areEqual((Object)((JetKeywordToken)softKeyword).getValue(), (Object)tokenText)) continue;
                        style = "softkeyword";
                        break;
                    }
                    boolean bl2 = true;
                    if (style != null) {
                        bl2 = false;
                    }
                    style = bl2 ? "plain" : style;
                    unit = Unit.VALUE;
                } else if (this.styleMap.containsKey(token)) {
                    style = this.styleMap.get(token);
                    boolean bl3 = true;
                    if (style != null) {
                        bl3 = false;
                    }
                    if (bl3) {
                        IoPackage.println((Object)("Warning: No style for token " + token));
                    }
                    unit = Unit.VALUE;
                } else {
                    style = "plain";
                    unit = Unit.VALUE;
                }
                builder.append("<code class=" + "\"" + "jet " + style + "\"" + ">");
                this.formatter.format((Appendable)builder, tokenText);
                builder.append("</code>");
            }
            builder.append("</div>");
            builder.append("</div>");
            builder.append("</div>");
            return builder.toString();
        }
        catch (Exception e) {
            IoPackage.println((Object)("Warning: failed to parse code " + e));
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=" + "\"" + "jet herror" + "\"" + ">Jet highlighter error [" + "\"" + e.getClass().getSimpleName() + "\"" + "]: ");
            this.formatter.format((Appendable)builder, (Object)e.getMessage());
            builder.append("<br/>");
            builder.append("Original text:");
            builder.append("<pre>");
            this.formatter.format((Appendable)builder, code);
            builder.append("</pre>");
            builder.append("</div>");
            return builder.toString();
        }
    }

    @NotNull
    protected final Map<IElementType, String> createStyleMap() {
        HashMap<Object, String> styleMap = new HashMap<Object, String>();
        SyntaxHighlighter$createStyleMap$1 syntaxHighlighter$createStyleMap$1 = new SyntaxHighlighter$createStyleMap$1(styleMap);
        styleMap.put(JetTokens.BLOCK_COMMENT, "jet-comment");
        styleMap.put(JetTokens.DOC_COMMENT, "jet-comment");
        styleMap.put(JetTokens.EOL_COMMENT, "jet-comment");
        styleMap.put(JetTokens.WHITE_SPACE, "whitespace");
        styleMap.put(JetTokens.INTEGER_LITERAL, "number");
        styleMap.put(JetTokens.FLOAT_LITERAL, "number");
        styleMap.put(JetTokens.OPEN_QUOTE, "string");
        styleMap.put(JetTokens.REGULAR_STRING_PART, "string");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_END, "escape");
        styleMap.put(JetTokens.SHORT_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.CLOSING_QUOTE, "string");
        styleMap.put(JetTokens.CHARACTER_LITERAL, "string");
        styleMap.put(JetTokens.LABEL_IDENTIFIER, "label");
        styleMap.put(JetTokens.FIELD_IDENTIFIER, "field");
        styleMap.put(TokenType.BAD_CHARACTER, "bad");
        syntaxHighlighter$createStyleMap$1.invoke(JetTokens.STRINGS, "string");
        syntaxHighlighter$createStyleMap$1.invoke(JetTokens.MODIFIER_KEYWORDS, "softkeyword");
        syntaxHighlighter$createStyleMap$1.invoke(JetTokens.SOFT_KEYWORDS, "softkeyword");
        syntaxHighlighter$createStyleMap$1.invoke(JetTokens.COMMENTS, "jet-comment");
        syntaxHighlighter$createStyleMap$1.invoke(JetTokens.OPERATIONS, "operation");
        return styleMap;
    }
}

