/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.CharIterator;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.kotlin.doc.DocPackage-collections-b8ec3894;
import org.jetbrains.kotlin.doc.KDocConfig;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighlighter;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel$1;
import org.jetbrains.kotlin.doc.model.KModel$sourceInfoByFile$1;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.model.ModelPackage-KotlinModel-508284e7;
import org.jetbrains.kotlin.doc.model.SourceInfo;
import org.pegdown.Extensions;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;

@KotlinClass(abiVersion=15, data={"g\u001e)11*T8eK2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004I>\u001c'\"B7pI\u0016d'bA!os*1A(\u001b8jizRqaY8oi\u0016DHO\u0003\bCS:$\u0017N\\4D_:$X\r\u001f;\u000b\u0007),GO\u0003\u0003mC:<'b\u0002:fg>dg/\u001a\u0006\u0007G>tg-[4\u000b\u0015-#unY\"p]\u001aLwM\u0003\u0006t_V\u00148-\u001a#jeNTA\u0001T5ti*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'bB:pkJ\u001cWm\u001d\u0006\b\u0015\u0016$h)\u001b7f\u0015\r\u00018/\u001b\u0006\u0005kRLGNC\b`aJ|'.Z2u%>|G\u000fR5s\u0015\u0019\u0019FO]5oO*\u0011r-\u001a;`aJ|'.Z2u%>|G\u000fR5s\u0015I\u0019X\r^0qe>TWm\u0019;S_>$H)\u001b:\u000b\u0019\u0005$GMR;oGRLwN\\:\u000b\u000b=<h.\u001a:\u000b\u001f-\u001bE.Y:t\u001fJ\u0004\u0016mY6bO\u0016TQa]2pa\u0016T\u0001BS3u'\u000e|\u0007/\u001a\u0006\u0007g\u000e|\u0007/Z:\u000b\tUs\u0017\u000e\u001e\u0006\u0012C\u0012$G+\u001f9f!\u0006\u0014\u0018-\\3uKJ\u001c(BB1og^,'OC\u0006NkR\f'\r\\3MSN$(BD&UsB,\u0007+\u0019:b[\u0016$XM\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148OC\fUsB,\u0007+\u0019:b[\u0016$XM\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe*Y\u0011\r\u001c7QC\u000e\\\u0017mZ3t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\t\u0017B\u000b7m[1hK*qq-\u001a;BY2\u0004\u0016mY6bO\u0016\u001c(bB2mCN\u001cXm\u001d\u0006\u0007\u0017\u000ec\u0017m]:\u000b\u0015\u001d,Go\u00117bgN,7OC\u0006d_6lWM\u001c;t\r>\u0014(B\u00033fg\u000e\u0014\u0018\u000e\u001d;pe*)B)Z2mCJ\fG/[8o\t\u0016\u001c8M]5qi>\u0014(\"C4fi\u000e{gNZ5h\u0015E\u0019wN\u001c4jOV\u0014XmQ8n[\u0016tGo\u001d\u0006\nC:tw\u000e^1uK\u0012T!bS!o]>$\u0018\r^3e\u0015)9W\r^\"p]R,\u0007\u0010\u001e\u0006\u000fGJ,\u0017\r^3Gk:\u001cG/[8o\u0015I\u0019\u0015\r\u001c7bE2,G)Z:de&\u0004Ho\u001c:\u000b\u0013-3UO\\2uS>t'\"D2sK\u0006$X\rU1dW\u0006<WMC\rQC\u000e\\\u0017mZ3Ge\u0006<W.\u001a8u\t\u0016\u001c8M]5qi>\u0014(\u0002\u00028b[\u0016Tqb\u0019:fCR,\u0007+\u0019:b[\u0016$XM\u001d\u0006\u0019-\u0006dW/\u001a)be\u0006lW\r^3s\t\u0016\u001c8M]5qi>\u0014(BC&QCJ\fW.\u001a;fe*\u00192M]3bi\u0016$\u0016\u0010]3QCJ\fW.\u001a;fe*aQ\r\u001f;sC\u000e$(\t\\8dW*!A/\u001a=u\u0015\u001d1\u0017\u000e\\3G_JT\u0001BZ5mKB\u000bG\u000f\u001b\u0006\u0005M&dWMC\tQg&4\u0015\u000e\\3TsN$X-\\%uK6T1aY8n\u0015!Ig\u000e^3mY&T'b\u00054j]\u00124UO\\2uS>t\u0017J\\2mk\u0012,'B\u00039tS\u0016cW-\\3oi*Q\u0001k]5FY\u0016lWM\u001c;\u000b\u0017%t7\r\\;eK\u001aKG.\u001a\u0006\rMVt7\r^5p]:\u000bW.\u001a\u0006\tO\u0016$8\t\\1tg*a1\r\\1tg\u0016cW-\\3oi*y1\t\\1tg\u0012+7o\u0019:jaR|'OC\u0007rk\u0006d\u0017NZ5fI:\u000bW.\u001a\u0006\u0013O\u0016$xJ]\"sK\u0006$X\rU1dW\u0006<WM\u0003\u0006hKR\u0004\u0016mY6bO\u0016TQbZ3u!NLW\t\\3nK:$(bB4fiRK\b/\u001a\u0006\u0006CRK\b/\u001a\u0006\b\u0015\u0016$H+\u001f9f\u0015\u0015!\u0018\u0010]3t\u0015\u0015YE+\u001f9f\u0015-A\u0017n\u001a5mS\u001eDG/\u001a:\u000b#MKh\u000e^1y\u0011&<\u0007\u000e\\5hQR,'O\u0003\bhKRD\u0015n\u001a5mS\u001eDG/\u001a:\u000b\u001dM,G\u000fS5hQ2Lw\r\u001b;fe*\u0019Bn\\1e/&\\\u0017\u000eR3tGJL\u0007\u000f^5p]*\u0019\u0001o[4\u000b\u00171|7-\u0019;j_:4uN\u001d\u0006\u000e\u0019&tW-\u00118e\u0007>dW/\u001c8\u000b\u001f\u0011K\u0017m\u001a8pgRL7-\u0016;jYNT1\u0002Z5bO:|7\u000f^5dg*iB)[1h]>\u001cH/[2Vi&d7\u000f\n'j]\u0016\fe\u000eZ\"pYVlgNC\tnCJ\\Gm\\<o!J|7-Z:t_JT\u0001\u0003U3h\t><h\u000e\u0015:pG\u0016\u001c8o\u001c:\u000b\u000fA,w\rZ8x]*!r-\u001a;NCJ\\Gm\\<o!J|7-Z:t_JTAc]3u\u001b\u0006\u00148\u000eZ8x]B\u0013xnY3tg>\u0014(\u0002\u00028fqRTq\u0003]1dW\u0006<W\rR3tGJL\u0007\u000f^5p]\u001aKG.Z:\u000b5\u001d,G\u000fU1dW\u0006<W\rR3tGJL\u0007\u000f^5p]\u001aKG.Z:\u000b\u0015A\f7m[1hK6\u000b\u0007OC\u0005T_J$X\rZ'ba*iq-\u001a;QC\u000e\\\u0017mZ3NCBT\u0001\u0002]1dW\u0006<Wm\u001d\u0006\fO\u0016$\b+Y2lC\u001e,7O\u0003\u0005qe\u00164\u0018n\\;t\u00155\u0001(o\\2fgNl\u0015m\u0019:pg*\u0011B/\u001a=u/&$\bn\u00165ji\u0016\u001c\b/Y2f\u00159\u0001(o\u001c6fGR\u0014vn\u001c;ESJT\u0011C]3bI6+G)\u001b:t'\u000e\fgN\\3e\u0015\u001dA\u0015m\u001d5TKRTAcZ3u%\u0016\fG-T3ESJ\u001c8kY1o]\u0016$'\u0002\u0004:fY\u0006$\u0018N^3GS2,'\"\u00033je\u0016\u001cGo\u001c:z\u00151\u00016/\u001b#je\u0016\u001cGo\u001c:z\u00151\u0011X\r\\1uSZ,g*Y7f\u0015\u001d\u00016/\u001b$jY\u0016TQbZ3u'>,(oY3ESJ\u001c(\u0002E:pkJ\u001cW-\u00138g_\nKh)\u001b7f\u0015)\u0019v.\u001e:dK&sgm\u001c\u0006\u0004\u001b\u0006\u0004(bE4fiN{WO]2f\u0013:4wNQ=GS2,'\"D:pkJ\u001cW\rT5oW\u001a{'O\u0003\u0006t_V\u00148-\u001a'j]\u0016T1!\u00138u\u00151a\u0017N\\3MS:\\G+\u001a=u\u0015)9W\r^*pkJ\u001cWm\u001d\u0006\fg>,(oY3t\u0013:4wN\u0003\bhKR\u001cv.\u001e:dKNLeNZ8\u000b\u000bQLG\u000f\\3\u000b\u0011\u001d,G\u000fV5uY\u0016TQ\u0002\u001e:z\u0019>\fGMU3bI6+'b\u0002<feNLwN\u001c\u0006\u000bO\u0016$h+\u001a:tS>t'bC<jW&\u001cuN\u001c<feRTA\u0002\\5oWJ+g\u000eZ3sKJTA\u0002T5oWJ+g\u000eZ3sKJT\u0001BZ5mK:\u000bW.ZO\u0006\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\t!\t\u0001C\u0003\u0006\u0005\u0011!\u00012B\u0003\u0003\t\u0013Aa!B\u0002\u0005\u000b!%A\u0002A\u0003\u0004\t\u0007Aq\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0002\u0003\u0007\u0001\u000b\u0005A\u0011\"\u0002\u0002\u0005\u000f!MQa\u0001C\b\u0011#a\u0001!\u0002\u0002\u0005\n!YQa\u0001C\t\u0011+a\u0001!\u0002\u0002\u0005\u000b!%QA\u0001C\u0002\u0011\u001d)!\u0001B\u0004\t\u0018\u0015\u0011AQ\u0003\u0005\t\u000b\r!1\u0001#\u0007\r\u0001\u0015\u0011Aa\u0002E\u0006\u000b\t!A\u0002#\u0007\u0006\u0007\u0011\u0011\u0001b\u0004\u0007\u0001\u000b\t!Q\u0001#\t\u0006\u0007\u0011m\u0001\u0002\u0005\u0007\u0001\u000b\r!1\u0001C\t\r\u0001\u0015\u0011AA\u0001\u0005\u0010\u000b\t!Y\u0002\u0003\t\u0006\u0007\u0011\u0019\u0001R\u0005\u0007\u0001\u000b\r!!\u0001C\n\r\u0001\u0015\u0011A\u0011\u0002E\u0014\u000b\r!\u0011\u0003\u0003\u000b\r\u0001\u0015\u0019Aa\u0001\u0005\u0016\u0019\u0001)1\u0001\u0002\u0002\t,1\u0001QA\u0001C\u000b\u0011U)1\u0001\u0002\u0002\t/1\u0001Qa\u0001\u0003\u0012\u0011ea\u0001!\u0002\u0002\u0005#!IRa\u0001\u0003\u0003\u0011ma\u0001!\u0002\u0002\u0005\u0005!YRa\u0001\u0003\u0012\u0011sa\u0001!B\u0002\u0005\u0005!iB\u0002A\u0003\u0003\t\tAQ$\u0002\u0002\u0005#!eRa\u0001\u0003\u0012\u0011ya\u0001!\u0002\u0002\u0005\u0005!-Ra\u0001\u0003\u0012\u0011\u007fa\u0001!B\u0002\u0005\u0005!\u0001C\u0002A\u0003\u0003\t\tA\u0001%\u0002\u0002\u0005#!}RA\u0001\u0003\u0003\u0011M)!\u0001B\t\t)\u0015\t\u0001\u0002J\u0003\u0003\tqAI%\u0002\u0002\u0005:!YQa\u0001\u0003\u001e\u0011\u000fb\u0001!\u0002\u0002\u0005;!\u001dSa\u0001\u0003\u001e\u0011\u0019b\u0001!\u0002\u0002\u0005;!1Sa\u0001\u0003\u0012\u0011#b\u0001!\u0002\u0002\u0005\u0005!9RA\u0001\u0003\u0012\u0011#*!\u0001B\t\t=\u0015\u0011A\u0011\u0002E-\u000b\r!\u0019\u0005\u0003\u0017\r\u0001\u0015\u0019AA\u0001\u0005.\u0019\u0001)!\u0001\u0002\u0002\t[\u0015\u0011A1\t\u0005-\u000b\t!\u0019\u0001c\u0017\u0006\u0007\u0011!\u0003B\f\u0007\u0001\u000b\t!A\u0005\u0003\u0018\u0006\u0005\u0011%\u0001BM\u0003\u0004\t\u0017B\u0019\u0007\u0004\u0001\u0006\u0007\u00111\u0003\"\r\u0007\u0001\u000b\t!Y\u0005#\u001a\u0006\u0005\u0011\u0001\u0001\u0002N\u0003\u0004\t\u001fB9\u0007\u0004\u0001\u0006\u0005\u0011=\u0003rM\u0003\u0004\t+Ay\u0007\u0004\u0001\u0006\u0005\u0011U\u0001rN\u0003\u0004\t+AA\b\u0004\u0001\u0006\u0005\u0011U\u0001\u0002P\u0003\u0004\tuAa\b\u0004\u0001\u0006\u0007\u0011i\u0002b\u0010\u0007\u0001\u000b\t!Q\u0004C \u0006\u0005\u0011i\u0002BPC\u0004\t\tA\t\u0019\u0001\u0007\u0001\u000b\u000b!!\u0001#a\u0001\u000b\t!\t\u0002#\u0006\u0006\b\u0011\u0019\u0001\"1\u0001\r\u0001\u0015\u0015AQ\u0003\u0005B\u0002\u0015\u001dAa\u0001\u0005D\u00021\u0001Qq\u0001C(\u0011%\u0007A\u0002AC\u0003\t\u001fB\u0011\u001a\u0001\u0003\u0001\u0019\u000bI\"!B\u0001\t\b52B!1\u0007\u0019\u0019\u0005\u001aQ!\u0001E\f\u0019\u0003)6AD\u0003\u0004\t1I\u0011\u0001#\u0007\u000e\u0007\u0011i\u0011\"\u0001E\r#\u0015!Y\"C\u0001\u0005\u00015\t\u0001\u0012DW\u001d\t\u0001Ab\"(\u0004\u0005\u0001!uQBA\u0003\u0002\u00115\u00016\u0001AO\u0007\t\u0001Ay\"\u0004\u0002\u0006\u0003!q\u0001k!\u0001\"\u0005\u0015\t\u0001RD)\u0004\u000f\u0011q\u0011\"\u0001\u0003\u0001\u001b\u0005Aq\"D\u0001\t 5.C\u0001\u0001M\u0012;+!\u0001\u0001\u0003\n\u000e\r\u0015\t\u0001\u0002E\u0005\u0004\u0013\t)\u0011\u0001#\tQ\u0007\u0001i:\u0002\u0002\u0001\t(59Q!\u0001E\u0007\u0013\u0011I1!B\u0001\t$1\u0005\u0001k!\u0001\"\u0005\u0015\t\u0001RD)\u0004\u000f\u0011\r\u0012\"\u0001\u0003\u0001\u001b\u0005A1\"D\u0001\t\u00175\u0002B\u0001\u0019\u0003\u0019*\u00052Q!\u0001\u0005\u0013\u0013\rI!!B\u0001\t&\u0011\u0002Sk\u0001\u0003\u000e\u0007\u00111\u0012\"\u0001\u0005\u0014[A!\u0001\r\u0002M\u0017C\u0019)\u0011\u0001\u0003\n\n\u0007%\u0011Q!\u0001E\u0014I\u0001*6\u0001B\u0007\u0004\t_I\u0011\u0001C\n.'\u0011\u0011\u0001\u0004GO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!!\u0002k\u0001\u0001\"\u0005\u0015\t\u0001rC)\u0004\u000b\u0011A\u0012\"\u0001E\r\u001b\u0005AI#L\b\u0005A\u0012Aj!\t\u0002\u0006\u0003!1Qk\u0001\u0005\u0006\u0007\u00115\u0011\"\u0001\u0005\u000b\u001b\r!\u0019$C\u0001\t\u00155fB\u0001\u0001\r\u001b;\u001b!\u0001\u0001#\u000e\u000e\u0005\u0015\t\u0001\"\u0006)\u0004\u0001u5A\u0001\u0001E\u0019\u001b\t)\u0011\u0001\u0003\u000bQ\u0007\u0003\t#!B\u0001\t\u001eE\u001bq\u0001\u0002\u000e\n\u0003\u0011\u0001Q\"\u0001E\u0016\u001b\u0005AI#L\b\u0005A\u0012AB!\t\u0002\u0006\u0003!-Qk\u0001\u0005\u0006\u0007\u0011!\u0011\"\u0001E\n\u001b\r!9$C\u0001\t\u00145nBA\u0001\r\u001d;\u001b!\u0001\u0001#\b\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0001u5A\u0001\u0001E\u0019\u001b\t)\u0011\u0001\u0003\fQ\u0007\u0003\t3!B\u0001\t.1\u0005\u0011kA\u0004\u00059%\t\u0001bF\u0007\u0002\u0011=i\u0011\u0001c\f.B\u0011\t\u00014HO\u000b\t\u0001A9#\u0004\u0004\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005A\u0001\u0004U\u0002\u0001;\u001b!\u0001\u0001#\u0010\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0002\u0005\u0012Q!\u0001E\u0013#\u000e9A1H\u0005\u0002\u0011ci\u0011\u0001C\u0006\u000e\u0003!eQ\u0006\u0006\u0003\u00031}ij\u0001\u0002\u0001\t25\u0011Q!\u0001\u0005\u001a!\u000e\u0001\u0011eA\u0003\u0002\u0011ga\t!U\u0002\u0006\t}I\u0011\u0001\u0003\u000e\u000e\u0003!UR\u0006\u0006\u0003\u00031\u0003jj\u0001\u0002\u0001\t25\u0011Q!\u0001E\u0012!\u000e\u0001\u0011eA\u0003\u0002\u0011Ca\t!U\u0002\u0006\t\u0003J\u0011\u0001C\u000e\u000e\u0003!]R\u0006\u0006\u0003\u00031\u0005jj\u0001\u0002\u0001\tD5\u0011Q!\u0001E\f!\u000e\u0001\u0011eA\u0003\u0002\u0011/a\t!U\u0002\u0006\t\u0005J\u0011\u0001#\u0007\u000e\u0003!eQ\u0006\u0006\u0003\u00011\tjj\u0001\u0002\u0001\t25\u0011Q!\u0001\u0005\u0015!\u000e\u0001\u0011eA\u0003\u0002\u0011/a\t!U\u0002\u0006\t\tJ\u0011\u0001#\u0007\u000e\u0003!%R\u0006\u0006\u0003\u00011\u000bjj\u0001\u0002\u0001\t25\u0011Q!\u0001\u0005\u0015!\u000e\u0001\u0011eA\u0003\u0002\u0011/a\t!U\u0002\u0006\t\u000bJ\u0011\u0001#\u0007\u000e\u0003!%R&\u0006\u0003\u00031\u000bjz\u0001\u0002\u0001\tG5\u0019Q!\u0001E\u001e\u0019\u0003\u00016\u0001A\u0011\u0004\u000b\u0005A9\u0002$\u0001R\u0007\u0015!)%C\u0001\t\u001a5\t\u0001BH\u0017(\t\tAR%(\u0004\u0005\u0001!-SBA\u0003\u0002\u0011{\u00016\u0001AO\u0007\t\u0001Ai%\u0004\u0002\u0006\u0003!]\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001bJ\u0007\u0003\u000b\u0005A9\u0002U\u0002\u0002C\r)\u0011\u0001c\u0006\r\u0002E\u001b\u0011\u0002B\u0013\n\u0003!eQ\"\u0001\u0005 \u001b\u0005AI\"D\u0001\t\u001a5\"B\u0001\u0001M(;\u001b!\u0001\u0001\u0003\u0015\u000e\u0005\u0015\t\u0001r\b)\u0004\u0001\u0005\u001aQ!\u0001E\u0014\u0019\u0003\t6!\u0002C(\u0013\u0005A\u0001%D\u0001\tB5\"B\u0001\u0001M(;\u001b!\u0001\u0001C\u0015\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\u0014\u0019\u0003\t6!\u0002C(\u0013\u0005A\u0001%D\u0001\t\u001a5\u001aB\u0001\u0001M*;\u001b!\u0001\u0001#\r\u000e\u0005\u0015\t\u0001\u0002\u0007)\u0004\u0001\u0005\u0012Q!\u0001E\u0013#\u000e)A1K\u0005\u0002\u0011ci\u0011\u0001C\u0011.)\u0011\u0001\u0001DKO\u0007\t\u0001Ai$\u0004\u0002\u0006\u0003!]\u0001k\u0001\u0001\"\u0007\u0015\t\u0001R\u0005G\u0001#\u000e)AAK\u0005\u0002\u0011ci\u0011\u0001#\u0007.)\u0011\u0001\u0001TKO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!!\u0002k\u0001\u0001\"\u0007\u0015\t\u0001R\bG\u0001#\u000e)AQK\u0005\u0002\u0011}i\u0011\u0001#\u000b.+\u0011\u0001\u0001dKO\b\t\u0001A9&D\u0002\u0006\u0003!\u0011C\u0012\u0001)\u0004\u0001\u0005\u001aQ!\u0001E#\u0019\u0003\t6!\u0002\u0003,\u0013\u0005A1%D\u0001\tH5*B\u00011\u0007\u0019\\\u0005\u0012Q!\u0001E%+\u000eqQa\u0001C.\u0013\u0005AQ%D\u0002\u0005^%\t\u0001\"J\t\u0006\t=J\u0011\u0001\u0002\u0001\u000e\u0003!)S6\b\u0003\u00031?jj\u0001\u0002\u0001\ta5\u0011Q!\u0001E\u0013!\u000e\u0001Qt\u0002\u0003\u0001\u0011\rj1!B\u0001\t\u00181\u0005\u0001k!\u0001\"\u0005\u0015\t\u0001RD)\u0004\u000f\u0011}\u0013\"\u0001\u0003\u0001\u001b\u0005A\t$D\u0001\t\u001a5\"B\u0001\u0001M1;\u001b!\u0001\u0001#\r\u000e\u0005\u0015\t\u0001\u0002\u0006)\u0004\u0001\u0005\u001aQ!\u0001E'\u0019\u0003\t6!\u0002C1\u0013\u0005Aq%D\u0001\t*5*B\u00011\u0007\u0019g\u0005\u0012Q!\u0001\u0005)+\u000eqQa\u0001\u00034\u0013\u0005A\t&D\u0002\u0005j%\t\u0001\u0012K\t\u0006\tUJ\u0011\u0001\u0002\u0001\u000e\u0003!ES\u0006\u0006\u0003\u00011Wjj\u0001\u0002\u0001\ta5\u0011Q!\u0001E\u0013!\u000e\u0001\u0011eA\u0003\u0002\u0011Ka\t!U\u0002\u0006\tWJ\u0011\u0001#\r\u000e\u0003!ERf\u0005\u0003a\ta1\u0014EB\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!]Qk\u0001\u0005\u0006\u0007\u00111\u0014\"\u0001\u0005\f\u001b\r!i'C\u0001\t\u00175:B\u0001\u0019\u0003\u0019o\u0005RQ!\u0001\u0005*\u0013\rI!!B\u0001\t\u0018%\u0019\u0011BA\u0003\u0002\u0011K)6\u0001C\u0003\u0004\t]J\u0011\u0001c\u0015\u000e\u0007\u0011A\u0014\"\u0001E*[A!\u0001\r\u0002M9C\u0019)\u0011\u0001\u0003\n\n\u0007%\u0011Q!\u0001E\u0013I\u0001*6\u0001B\u0007\u0004\teJ\u0011\u0001C\n.)\u0011\u0001\u00014OO\u0007\t\u0001A\u0001'\u0004\u0002\u0006\u0003!\u0015\u0002k\u0001\u0001\"\u0007\u0015\t\u0001R\u0005G\u0001#\u000e)A1O\u0005\u0002\u0011ci\u0011\u0001#\r.:\u0011\u0011\u0001DOO\u0007\t\u0001A)(\u0004\u0002\u0006\u0003!]\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012J\u0007\u0003\u000b\u0005Ai\u0004UB\u0001C\t)\u0011\u0001c\u0006R\u0007\u001d!!(C\u0001\t\u001a5\t\u0001\u0012D\u0007\u0002\u0011}i\u001b\u0002\u0002\u0001\u0019w\u0005\u0012Q!\u0001E\f#\u000e\u0019AaO\u0005\u0002\u00113i3\u0003B1\u00051o\nc!B\u0001\tU%\u0019\u0011BA\u0003\u0002\u0011/)6\u0001C\u0003\u0004\toJ\u0011\u0001#\u0016\u000e\u0007\u0011e\u0014\"\u0001E+[w!!\u0001G\u001f\u001e\u000e\u0011\u0001\u00012P\u0007\u0003\u000b\u0005A1\u0006U\u0002\u0001;\u001b!\u0001\u0001# \u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0002\u0005\u001aQ!\u0001E,\u0019\u0003\t6a\u0002\u0003>\u0013\u0005AA&D\u0001\tZ5\t\u0001\u0012D\u0017\u0014\t\u0001$\u0001tB\u0011\u0007\u000b\u0005Ai!C\u0002\n\u0005\u0015\t\u0001\u0002C+\u0004\u0011\u0015\u0019AqB\u0005\u0002\u0011-i1\u0001b \n\u0003!YQ\u0006\u0006\u0003\u00011\u0001\u0007QT\u0002\u0003\u0001\u0011\rj!!B\u0001\t\u0013A\u001b\u0001!\t\u0002\u0006\u0003!i\u0013ka\u0003\u0005\u0001\u0004I\u0011\u0001c\u0017\u000e\u0003!qS\u0016\u0007\u0003b\ta\u0001\r!\t\u0006\u0006\u0003!u\u0013bA\u0005\u0003\u000b\u0005A\u0011\"C\u0002\n\u0005\u0015\t\u0001\"L+\u0004\u0013\u0015\u001dA\u00011\u0001\n\u0003!ySr\u0001CB\u0002%\t\u0001bL\u0017*\t\u0001A\"\u0019AO\u0007\t\u0001A)%\u0004\u0002\u0006\u0003!]\u0001k\u0001\u0001\u001e\u000f\u0011\u0001\u0001R1\u0001\u000e\u0005\u0015\t\u0001r\f)\u0004\u0002u9A!\u0001ED\u00025\u0011Q!\u0001E\f!\u000e\t\u0011eA\u0003\u0002\u0011/a\t!UB\n\t\t\u0007\u0011\"\u0001E\r\u001b\u0005AI\"D\u0001\u0005\u00065\t\u0001\u0012DW\u0014\t\u0001$\u0001DC\u0011\u0007\u000b\u0005Ai!C\u0002\n\u0005\u0015\t\u0001\"C+\u0004\u0012\u0015\u0019AAC\u0005\u0002\u0011-i9\u0001\u0002c\u0001\u0013\u0005A1\",\u000b\u0005A\u0012AJ\u0019A\u0011\u0007\u000b\u0005Ai!C\u0002\n\u0005\u0015\t\u0001\"L+\u0004\u0013\u0015\u001dA\u00112\u0001\n\u0003!YQr\u0001\u0003F\u0002%\t\u0001bC\u0017\u000e\t\u0001$\u000142\u0001\"\u0005\u0015\t\u0001r\u0003\u0013!+\u000e%Qr\u0001\u0003G\u0002%\t\u0001\u0012DW\u001e\t\u0001Aj\u0019AO\u0007\t\u0001A\u0001'\u0004\u0002\u0006\u0003!\u0015\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0012G\u0007\u0003\u000b\u0005AA\u0003UB\u0001C\t)\u0011\u0001#\bR\u0007\u001f!i\u0019A\u0005\u0002\t\u0001i\u0011\u0001#\r\u000e\u0003!%R&\u0004\u0003a\ta9\r!\t\u0002\u0006\u0003!]A\u0005I+\u0004\n5\u001dAq2\u0001\n\u0003!eQ&\u000b\u0003\u00011!\u0007QT\u0002\u0003\u0001\u0011\u0007j!!B\u0001\t\u0018A\u001b\u0001!H\u0004\u0005\u0001!E\r!\u0004\u0002\u0006\u0003!\u0001\u0004k!\u0001\u001e\u0011\u0011\u0001\u000123\u0001\u000e\u0007\u0015\t\u0001r\u0003G\u0001!\u000e\t\u0011EA\u0003\u0002\u0011/\t61\u0003\u0003I\u0002%\t\u0001\u0012D\u0007\u0002\u00113i\u0011\u0001#\u0019\u000e\u0003!eQ'O\u00039\t\r\b\u0001tAO\u0007\t\u0001AA!\u0004\u0002\u0006\u0003!-\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005Aa\u0001UB\u0001;+!\u0001\u0001c\u0004\u000e\r\u0015\t\u0001RB\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0005Q\u0007\u0005i*\u0002\u0002\u0001\t\u001551Q!\u0001E\u0007\u0013\rI!!B\u0001\t\u0013A\u001b\u0019!\t\u0002\u0006\u0003!\u0015\u0011kA\u0006\u0005\b%\tA\u0001A\u0007\u0002\u0011'i\u0011\u0001\u0003\u0006\u000e\u0003!YQ\"\u0001\u0005\f"})
public final class KModel
implements KObject {
    @NotNull
    private final SortedMap<String, KPackage> packageMap;
    @NotNull
    private PegDownProcessor markdownProcessor;
    @NotNull
    private SyntaxHighlighter highlighter;
    private String _projectRootDir;
    @NotNull
    private final List<? extends String> packageDescriptionFiles;
    private final HashSet<String> readMeDirsScanned;
    @NotNull
    private final List<? extends SourceInfo> sourcesInfo;
    private final Map<JetFile, ? extends SourceInfo> sourceInfoByFile;
    @NotNull
    private final BindingContext context;
    @NotNull
    private final KDocConfig config;
    @NotNull
    private final List<? extends File> sourceDirs;
    @NotNull
    private final List<? extends JetFile> sources;

    @NotNull
    public final SortedMap<String, KPackage> getPackageMap() {
        return this.packageMap;
    }

    @NotNull
    public final Collection<KPackage> getAllPackages() {
        return this.packageMap.values();
    }

    @NotNull
    public final Collection<KPackage> getPackages() {
        Iterable iterable;
        Iterable iterable2 = iterable = (Iterable)this.getAllPackages();
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            KPackage it = (KPackage)t;
            Object object = Boolean.valueOf(this.getConfig().includePackage(it)) != false ? Boolean.valueOf(collection.add(t)) : Unit.VALUE;
        }
        return (ArrayList)collection;
    }

    @NotNull
    public final Collection<KClass> getClasses() {
        Iterable iterable;
        Iterable iterable2 = iterable = (Iterable)this.getPackages();
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            KPackage it = (KPackage)t;
            Iterable iterable3 = it.getClasses();
            KotlinPackage.addAll((Collection)collection, (Iterable)iterable3);
        }
        return (ArrayList)collection;
    }

    @NotNull
    public final PegDownProcessor getMarkdownProcessor() {
        return this.markdownProcessor;
    }

    @NotNull
    public final void setMarkdownProcessor(@JetValueParameter(name="<set-?>") @NotNull PegDownProcessor pegDownProcessor) {
        this.markdownProcessor = pegDownProcessor;
    }

    @NotNull
    public final SyntaxHighlighter getHighlighter() {
        return this.highlighter;
    }

    @NotNull
    public final void setHighlighter(@JetValueParameter(name="<set-?>") @NotNull SyntaxHighlighter syntaxHighlighter) {
        this.highlighter = syntaxHighlighter;
    }

    @NotNull
    public final String getTitle() {
        return this.config.getTitle();
    }

    @NotNull
    public final String getVersion() {
        return this.config.getVersion();
    }

    private final String get_projectRootDir() {
        return this._projectRootDir;
    }

    private final void set_projectRootDir(@JetValueParameter(name="<set-?>", type="?") String string) {
        this._projectRootDir = string;
    }

    @NotNull
    public final List<String> getPackageDescriptionFiles() {
        return this.packageDescriptionFiles;
    }

    private final HashSet<String> getReadMeDirsScanned() {
        return this.readMeDirsScanned;
    }

    @NotNull
    public final List<SourceInfo> getSourcesInfo() {
        return this.sourcesInfo;
    }

    private final Map<JetFile, SourceInfo> getSourceInfoByFile() {
        return this.sourceInfoByFile;
    }

    @NotNull
    public final SourceInfo sourceInfoByFile(@JetValueParameter(name="file") @NotNull JetFile file) {
        SourceInfo sourceInfo = this.sourceInfoByFile.get(file);
        if (sourceInfo == null) {
            Intrinsics.throwNpe();
        }
        return sourceInfo;
    }

    @NotNull
    public final String projectRootDir() {
        String string;
        boolean bl = true;
        if (this._projectRootDir != null) {
            bl = false;
        }
        if (bl) {
            String string2;
            String rootDir = this.config.getProjectRootDir();
            boolean bl2 = true;
            if (rootDir != null) {
                bl2 = false;
            }
            if (bl2) {
                ModelPackage-KotlinModel-508284e7.warning("KDocConfig does not have a projectRootDir defined so we cannot generate relative source Hrefs");
                string2 = "";
            } else {
                string2 = this._projectRootDir = new File(rootDir).getCanonicalPath();
            }
        }
        if ((string = this._projectRootDir) == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final KPackage getPackage(@JetValueParameter(name="name") @NotNull String name) {
        return (KPackage)this.packageMap.get(name);
    }

    @NotNull
    public final KPackage getOrCreatePackage(@JetValueParameter(name="descriptor") @NotNull PackageFragmentDescriptor descriptor) {
        String name = ModelPackage-KotlinModel-508284e7.qualifiedName((DeclarationDescriptor)descriptor);
        KPackage pkg = (KPackage)this.packageMap.get(name);
        boolean bl = true;
        if (pkg == null) {
            bl = false;
        }
        if (bl) {
            return pkg;
        }
        return this.createPackage(KotlinPackage.listOf((Object[])new PackageFragmentDescriptor[]{descriptor}), name);
    }

    private final KPackage createPackage(@JetValueParameter(name="descriptors") List<? extends PackageFragmentDescriptor> descriptors, @JetValueParameter(name="name") String name) {
        boolean bl;
        KPackage pkg = new KPackage(this, descriptors, name, KotlinPackage.isNotEmpty((String)this.config.resolveLink(name, false)));
        boolean bl2 = bl = !this.packageMap.containsKey(name);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String string = "packageMap entry created earlier for package " + name + ": old=" + (KPackage)this.getPackageMap().get(name) + ", new=" + pkg;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinPackage.set((Map)this.packageMap, (Object)name, (Object)pkg);
        for (PackageFragmentDescriptor packageFragmentDescriptor : descriptors) {
            this.addFunctions(pkg, packageFragmentDescriptor.getMemberScope());
        }
        String string = this.config.getPackageDescriptionFiles().get(name);
        this.loadWikiDescription(pkg, string);
        return pkg;
    }

    @NotNull
    protected final void loadWikiDescription(@JetValueParameter(name="pkg") @NotNull KPackage pkg, @JetValueParameter(name="file", type="?") @Nullable String file) {
        boolean bl = true;
        if (file == null) {
            bl = false;
        }
        if (bl) {
            try {
                ((KAnnotated)pkg).setWikiDescription(IoPackage.readText$default((File)new File(file), null, (int)1));
            }
            catch (Throwable throwable) {
                ModelPackage-KotlinModel-508284e7.warning("Failed to load package " + pkg.getName() + " documentation file " + file + ". Reason " + throwable);
            }
        }
    }

    @NotNull
    public final void tryLoadReadMe(@JetValueParameter(name="pkg") @NotNull KPackage pkg, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        if (KotlinPackage.isEmpty((String)((KAnnotated)pkg).getWikiDescription())) {
            String srcPath = ((KAnnotated)pkg).getModel().filePath(descriptor);
            boolean bl = true;
            if (srcPath == null) {
                bl = false;
            }
            if (bl) {
                File srcFile = new File(srcPath);
                File dir = srcFile.isDirectory() ? srcFile : srcFile.getParentFile();
                boolean bl2 = true;
                if (dir == null) {
                    bl2 = false;
                }
                if (bl2 ? this.readMeDirsScanned.add(dir.getPath()) : false) {
                    Iterator<Object> iterator;
                    block10: {
                        Iterable iterable;
                        Iterable iterable2 = iterable = (Iterable)this.packageDescriptionFiles;
                        Collection collection = new ArrayList();
                        for (Object t : iterable2) {
                            String it = (String)t;
                            collection.add(new File(dir, it));
                        }
                        iterable2 = iterable = (Iterable)((ArrayList)collection);
                        for (Iterator<Object> iterator2 : iterable2) {
                            File it = (File)((Object)iterator2);
                            if (!Boolean.valueOf(it.exists()).booleanValue()) continue;
                            iterator = iterator2;
                            break block10;
                        }
                        iterator = null;
                    }
                    File f = (File)((Object)iterator);
                    boolean bl3 = true;
                    if (f == null) {
                        bl3 = false;
                    }
                    if (bl3) {
                        String file = f.getCanonicalPath();
                        this.loadWikiDescription(pkg, file);
                    } else {
                        ModelPackage-KotlinModel-508284e7.info("package " + pkg.getName() + " has no ReadMe.(html|md) in " + dir);
                    }
                }
            }
        }
    }

    @NotNull
    public final String wikiConvert(@JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="linkRenderer") @NotNull LinkRenderer linkRenderer, @JetValueParameter(name="fileName", type="?") @Nullable String fileName) {
        String string = this.markdownProcessor.markdownToHtml(text, linkRenderer);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Nullable
    public final String sourceLinkFor(@JetValueParameter(name="filePath") @NotNull String filePath, @JetValueParameter(name="sourceLine") int sourceLine, @JetValueParameter(name="lineLinkText") @NotNull String lineLinkText) {
        String root = this.config.getSourceRootHref();
        boolean bl = true;
        if (root == null) {
            bl = false;
        }
        if (bl) {
            String rootDir = this.projectRootDir();
            String canonicalFile = new File(filePath).getCanonicalPath();
            String relativeFile = KotlinPackage.startsWith((String)canonicalFile, (String)rootDir) ? KotlinPackage.substring((String)canonicalFile, (int)KotlinPackage.length((String)rootDir)) : canonicalFile;
            String cleanRoot = KotlinPackage.trimTrailing((String)root, (String)"/");
            String cleanPath = KotlinPackage.trimLeading((String)relativeFile, (String)"/");
            return cleanRoot + "/" + cleanPath + lineLinkText + sourceLine;
        }
        return null;
    }

    public static String sourceLinkFor$default(KModel kModel, String string, int n, String string2, int n2) {
        if ((n2 & 4) != 0) {
            string2 = "#L";
        }
        return kModel.sourceLinkFor(string, n, string2);
    }

    @NotNull
    public final void addFunctions(@JetValueParameter(name="owner") @NotNull KClassOrPackage owner, @JetValueParameter(name="scope") @NotNull JetScope scope) {
        try {
            Collection descriptors = scope.getAllDescriptors();
            for (DeclarationDescriptor descriptor : descriptors) {
                Unit unit;
                if (descriptor instanceof PropertyDescriptor) {
                    String name = ((PropertyDescriptor)descriptor).getName().asString();
                    KType returnType = this.getType(((PropertyDescriptor)descriptor).getReturnType());
                    boolean bl = true;
                    if (returnType == null) {
                        bl = false;
                    }
                    if (!bl) continue;
                    ReceiverParameterDescriptor receiver = ((PropertyDescriptor)descriptor).getReceiverParameter();
                    boolean bl2 = true;
                    if (receiver == null) {
                        bl2 = false;
                    }
                    KType extensionClass = bl2 ? this.getType(receiver.getType()) : (KType)null;
                    KType kType = extensionClass;
                    KProperty property = new KProperty(owner, (PropertyDescriptor)descriptor, name, returnType, kType != null ? kType.getKlass() : null);
                    owner.getProperties().add(property);
                    continue;
                }
                if (descriptor instanceof CallableDescriptor) {
                    KFunction function = this.createFunction(owner, (CallableDescriptor)descriptor);
                    boolean bl = true;
                    if (function == null) {
                        bl = false;
                    }
                    if (bl) {
                        owner.getFunctions().add(function);
                    }
                    unit = Unit.VALUE;
                    continue;
                }
                unit = Unit.VALUE;
            }
        }
        catch (Throwable throwable) {
            ModelPackage-KotlinModel-508284e7.warning("Caught exception finding function declarations on " + owner + " " + throwable);
            throwable.printStackTrace();
        }
    }

    @Nullable
    protected final KFunction createFunction(@JetValueParameter(name="owner") @NotNull KClassOrPackage owner, @JetValueParameter(name="descriptor") @NotNull CallableDescriptor descriptor) {
        KType returnType = this.getType(descriptor.getReturnType());
        boolean bl = true;
        if (returnType == null) {
            bl = false;
        }
        if (bl) {
            String name = descriptor.getName().asString();
            ArrayList<KParameter> parameters = new ArrayList<KParameter>();
            List params = descriptor.getValueParameters();
            for (ValueParameterDescriptor param : params) {
                KParameter p = this.createParameter(param);
                boolean bl2 = true;
                if (p == null) {
                    bl2 = false;
                }
                if (!bl2) continue;
                parameters.add(p);
            }
            KFunction function = new KFunction(descriptor, owner, name, returnType, parameters, null, null, null, null, null, null, 2016);
            this.addTypeParameters(function.getTypeParameters(), descriptor.getTypeParameters());
            this.configureComments(function, (DeclarationDescriptor)descriptor);
            ReceiverParameterDescriptor receiver = descriptor.getReceiverParameter();
            boolean bl3 = true;
            if (receiver == null) {
                bl3 = false;
            }
            if (bl3) {
                KType receiverType = this.getType(receiver.getType());
                function.setReceiverType(receiverType);
                KType kType = receiverType;
                function.setExtensionClass(kType != null ? kType.getKlass() : null);
            }
            return function;
        }
        return null;
    }

    @NotNull
    public final void addTypeParameters(@JetValueParameter(name="answer") @NotNull List<KTypeParameter> answer, @JetValueParameter(name="descriptors") @NotNull List<? extends TypeParameterDescriptor> descriptors) {
        for (TypeParameterDescriptor typeParameterDescriptor : descriptors) {
            boolean bl = true;
            if (typeParameterDescriptor == null) {
                bl = false;
            }
            if (!bl) continue;
            KTypeParameter p = this.createTypeParameter(typeParameterDescriptor);
            boolean bl2 = true;
            if (p == null) {
                bl2 = false;
            }
            if (!bl2) continue;
            answer.add(p);
        }
    }

    @Nullable
    protected final KTypeParameter createTypeParameter(@JetValueParameter(name="descriptor") @NotNull TypeParameterDescriptor descriptor) {
        String name = descriptor.getName().asString();
        KTypeParameter answer = new KTypeParameter(name, descriptor, this, null, 8);
        this.configureComments(answer, (DeclarationDescriptor)descriptor);
        return answer;
    }

    @Nullable
    protected final KParameter createParameter(@JetValueParameter(name="descriptor") @NotNull ValueParameterDescriptor descriptor) {
        KType returnType = this.getType(descriptor.getReturnType());
        boolean bl = true;
        if (returnType == null) {
            bl = false;
        }
        if (bl) {
            String name = descriptor.getName().asString();
            KParameter answer = new KParameter(descriptor, name, returnType);
            this.configureComments(answer, (DeclarationDescriptor)descriptor);
            return answer;
        }
        return null;
    }

    @Nullable
    public final DiagnosticUtils.LineAndColumn locationFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement = this.getPsiElement(descriptor);
        boolean bl = true;
        if (psiElement == null) {
            bl = false;
        }
        if (bl) {
            PsiFile psiFile = psiElement.getContainingFile();
            Object object = psiFile != null ? psiFile.getViewProvider() : null;
            Document document = object != null ? object.getDocument() : null;
            boolean bl2 = true;
            if (document == null) {
                bl2 = false;
            }
            if (bl2) {
                int offset = psiElement.getTextOffset();
                return DiagnosticUtils.offsetToLineAndColumn((Document)document, (int)offset);
            }
        }
        return null;
    }

    @Nullable
    public final String fileFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        PsiElement psiElement2 = psiElement = this.getPsiElement(descriptor);
        Object object = psiElement2 != null ? psiElement2.getContainingFile() : null;
        return object != null ? object.getName() : null;
    }

    @Nullable
    public final String filePath(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        PsiElement psiElement2 = psiElement = this.getPsiElement(descriptor);
        PsiFile file = psiElement2 != null ? psiElement2.getContainingFile() : null;
        return this.filePath((PsiFileSystemItem)file);
    }

    @Nullable
    public final PsiElement getPsiElement(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        try {
            psiElement = BindingContextUtils.descriptorToDeclaration((BindingContext)this.context, (DeclarationDescriptor)descriptor);
        }
        catch (Throwable throwable) {
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String commentsFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement = this.getPsiElement(descriptor);
        boolean bl = true;
        if (psiElement == null) {
            bl = false;
        }
        if (bl) {
            ASTNode aSTNode = psiElement.getNode();
            ASTNode node = aSTNode != null ? aSTNode.getTreePrev() : null;
            while (true) {
                boolean bl2;
                boolean bl3 = true;
                if (node == null) {
                    bl3 = false;
                }
                if (bl3) {
                    ASTNode aSTNode2 = node;
                    if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)JetTokens.WHITE_SPACE)) {
                        ASTNode aSTNode3 = node;
                        bl2 = Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)JetTokens.BLOCK_COMMENT);
                    } else {
                        bl2 = true;
                    }
                } else {
                    bl2 = false;
                }
                if (!bl2) break;
                ASTNode aSTNode4 = node;
                node = aSTNode4 != null ? aSTNode4.getTreePrev() : null;
            }
            boolean bl4 = true;
            if (node != null) {
                bl4 = false;
            }
            if (bl4) {
                return "";
            }
            ASTNode aSTNode5 = node;
            if (Intrinsics.areEqual((Object)(aSTNode5 != null ? aSTNode5.getElementType() : null), (Object)JetTokens.DOC_COMMENT) ^ true) {
                return "";
            }
            ASTNode aSTNode6 = node;
            String string = aSTNode6 != null ? aSTNode6.getText() : null;
            if (string == null) {
                string = "";
            }
            String nodeText = string;
            String[] lines = KotlinPackage.split((String)KotlinPackage.trim((String)nodeText), (String)"\\n");
            StringBuilder buffer = new StringBuilder();
            int last = lines.length - 1;
            int n = 0;
            int n2 = last;
            if (n <= n2) {
                while (true) {
                    Unit unit;
                    void i;
                    String text = lines[i];
                    text = KotlinPackage.trim((String)text);
                    boolean bl5 = true;
                    if (i != false) {
                        bl5 = false;
                    }
                    if (bl5) {
                        text = KotlinPackage.trimLeading((String)KotlinPackage.trimLeading((String)text, (String)"/**"), (String)"/*");
                    } else {
                        buffer.append("\n");
                    }
                    if (i >= last) {
                        text = KotlinPackage.trimTrailing((String)text, (String)"*/");
                    } else if (i > false) {
                        if (Intrinsics.areEqual((Object)(text = KotlinPackage.trimLeading((String)text, (String)"* ")), (Object)"*")) {
                            text = "";
                        }
                        unit = Unit.VALUE;
                    } else {
                        unit = Unit.VALUE;
                    }
                    text = this.processMacros(text, psiElement);
                    buffer.append(text);
                    if (i == n2) break;
                    ++i;
                }
            }
            return buffer.toString();
        }
        return "";
    }

    @NotNull
    protected final String processMacros(@JetValueParameter(name="textWithWhitespace") @NotNull String textWithWhitespace, @JetValueParameter(name="psiElement") @NotNull PsiElement psiElement) {
        String text = KotlinPackage.trim((String)textWithWhitespace);
        if (KotlinPackage.startsWith((String)text, (String)"@")) {
            String macro;
            String remaining = KotlinPackage.substring((String)text, (int)1);
            if (KotlinPackage.startsWith((String)remaining, (String)(macro = "includeFunctionBody"))) {
                String next = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)KotlinPackage.length((String)macro)));
                String[] words = KotlinPackage.split((String)next, (String)"\\s");
                if (words.length > 1) {
                    String includeFile = words[0];
                    String fnName = words[1];
                    String content = this.findFunctionInclude(psiElement, includeFile, fnName);
                    boolean bl = true;
                    if (content == null) {
                        bl = false;
                    }
                    if (bl) {
                        return content;
                    }
                    ModelPackage-KotlinModel-508284e7.warning("could not find function " + fnName + " in file " + includeFile + " from source file " + psiElement.getContainingFile());
                }
            } else {
                ModelPackage-KotlinModel-508284e7.warning("Unknown kdoc macro @" + remaining);
            }
        }
        return textWithWhitespace;
    }

    @Nullable
    protected final String findFunctionInclude(@JetValueParameter(name="psiElement") @NotNull PsiElement psiElement, @JetValueParameter(name="includeFile") @NotNull String includeFile, @JetValueParameter(name="functionName") @NotNull String functionName) {
        PsiFile psiFile = psiElement.getContainingFile();
        PsiDirectory dir = psiFile != null ? psiFile.getParent() : null;
        boolean bl = true;
        if (dir == null) {
            bl = false;
        }
        if (bl) {
            PsiDirectory psiDirectory = dir;
            if (psiDirectory == null) {
                Intrinsics.throwNpe();
            }
            PsiFile file = this.relativeFile(psiDirectory, includeFile);
            boolean bl2 = true;
            if (file == null) {
                bl2 = false;
            }
            if (bl2) {
                Pattern regex;
                Matcher matcher;
                String text = file.getText();
                boolean bl3 = true;
                if (text == null) {
                    bl3 = false;
                }
                if (bl3 && (matcher = (regex = KotlinPackage.toRegex$default((String)("fun" + "\\" + "s+" + functionName + "\\" + "(.*" + "\\" + ")"), (int)0, (int)1)).matcher(text)).find()) {
                    int idx = matcher.end();
                    String remaining = KotlinPackage.substring((String)text, (int)idx);
                    String content = this.extractBlock(remaining);
                    boolean bl4 = true;
                    if (content == null) {
                        bl4 = false;
                    }
                    if (bl4) {
                        String highlight = this.highlighter.highlight(content);
                        String filePath = this.filePath((PsiFileSystemItem)file);
                        String string = KotlinPackage.substring((String)text, (int)0, (int)idx);
                        int n = 0;
                        CharIterator charIterator = KotlinPackage.iterator((CharSequence)string);
                        while (charIterator.hasNext()) {
                            Object object;
                            char c = charIterator.nextChar();
                            char it = Character.valueOf(c).charValue();
                            if (Boolean.valueOf(it == '\n').booleanValue()) {
                                object = n;
                                ++n;
                                continue;
                            }
                            object = Unit.VALUE;
                        }
                        int sourceLine = n + 1;
                        boolean bl5 = true;
                        if (filePath == null) {
                            bl5 = false;
                        }
                        String link = bl5 ? KModel.sourceLinkFor$default(this, filePath, sourceLine, null, 4) : (String)null;
                        boolean bl6 = true;
                        if (link == null) {
                            bl6 = false;
                        }
                        return bl6 ? "<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + link + "\"" + " target=" + "\"" + "_top" + "\"" + "  class=" + "\"" + "repoSourceCode" + "\"" + ">source</a></div>" + "\n" + highlight : highlight;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    protected final String filePath(@JetValueParameter(name="file", type="?") @Nullable PsiFileSystemItem file) {
        boolean bl = true;
        if (file == null) {
            bl = false;
        }
        if (bl) {
            PsiFileSystemItem dir = file.getParent();
            boolean bl2 = true;
            if (dir == null) {
                bl2 = false;
            }
            if (bl2) {
                String string = this.filePath(dir);
                if (string == null) {
                    string = "";
                }
                String parentName = string;
                return parentName + "/" + file.getName();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final String extractBlock(@JetValueParameter(name="text") @NotNull String text) {
        int idx = KotlinPackage.indexOf((String)text, (char)'{');
        if (idx >= 0) {
            String line22;
            int nidx;
            String remaining = KotlinPackage.substring((String)text, (int)(idx + 1));
            while ((nidx = KotlinPackage.indexOf((String)remaining, (char)'\n')) >= 0 && KotlinPackage.isEmpty((String)(line22 = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)0, (int)nidx))))) {
                remaining = KotlinPackage.substring((String)remaining, (int)(nidx + 1));
            }
            int count = 1;
            int line22 = 0;
            int n = KotlinPackage.getSize((String)remaining) - 1;
            if (line22 <= n) {
                while (true) {
                    Integer n2;
                    void i;
                    char ch;
                    if ((ch = remaining.charAt((int)i)) == '{') {
                        n2 = count;
                        ++count;
                    } else if (ch == '}') {
                        if (--count <= 0) {
                            return KotlinPackage.substring((String)remaining, (int)0, (int)i);
                        }
                        n2 = Unit.VALUE;
                    } else {
                        n2 = Unit.VALUE;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            ModelPackage-KotlinModel-508284e7.warning("missing } in code block for " + remaining);
            return remaining;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiFile relativeFile(@JetValueParameter(name="directory") @NotNull PsiDirectory directory, @JetValueParameter(name="relativeName") @NotNull String relativeName) {
        PsiDirectory dir = directory;
        int n = 0;
        String[] paths = KotlinPackage.split((String)relativeName, (String)"/");
        int size = paths.length;
        int n2 = size - 2;
        if (n <= n2) {
            while (true) {
                void i;
                String path;
                if (!Intrinsics.areEqual((Object)(path = paths[i]), (Object)".")) {
                    Unit unit;
                    if (Intrinsics.areEqual((Object)path, (Object)"..")) {
                        PsiDirectory psiDirectory = dir;
                        dir = psiDirectory != null ? psiDirectory.getParent() : null;
                        unit = Unit.VALUE;
                    } else {
                        PsiDirectory psiDirectory = dir;
                        dir = psiDirectory != null ? psiDirectory.findSubdirectory(path) : null;
                        unit = Unit.VALUE;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        String name = paths[size - 1];
        boolean bl = true;
        if (dir == null) {
            bl = false;
        }
        if (bl) {
            PsiDirectory psiDirectory = dir;
            PsiFile file = psiDirectory != null ? psiDirectory.findFile(name) : null;
            boolean bl2 = true;
            if (file == null) {
                bl2 = false;
            }
            if (bl2) {
                return file;
            }
            ModelPackage-KotlinModel-508284e7.warning("could not find file " + relativeName + " in " + dir + " with name " + name);
        }
        return null;
    }

    @NotNull
    public final void configureComments(@JetValueParameter(name="annotated") @NotNull KAnnotated annotated, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        String detailedText = KotlinPackage.trim((String)this.commentsFor(descriptor));
        annotated.setWikiDescription(detailedText);
    }

    @Nullable
    public final KType getType(@JetValueParameter(name="aType", type="?") @Nullable JetType aType) {
        boolean bl = true;
        if (aType == null) {
            bl = false;
        }
        if (bl) {
            ClassifierDescriptor classifierDescriptor = aType.getConstructor().getDeclarationDescriptor();
            KClass klass = classifierDescriptor instanceof ClassDescriptor ? this.getClass((ClassDescriptor)classifierDescriptor) : (KClass)null;
            return new KType(aType, this, klass, null, 8);
        }
        return null;
    }

    @Nullable
    public final KClass getClass(@JetValueParameter(name="qualifiedName") @NotNull String qualifiedName) {
        int idx = KotlinPackage.lastIndexOf((String)qualifiedName, (char)'.');
        String pkgName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)0, (int)idx) : "";
        KPackage pkg = this.getPackage(pkgName);
        boolean bl = true;
        if (pkg == null) {
            bl = false;
        }
        if (bl) {
            String simpleName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)(idx + 1)) : qualifiedName;
            return (KClass)pkg.getClassMap().get(simpleName);
        }
        return null;
    }

    @Nullable
    public final KClass getClass(@JetValueParameter(name="classElement") @NotNull ClassDescriptor classElement) {
        String name = classElement.getName().asString();
        DeclarationDescriptor dec = classElement.getContainingDeclaration();
        while (true) {
            boolean bl = true;
            if (dec == null) {
                bl = false;
            }
            if (!bl) break;
            DeclarationDescriptor container = dec;
            if (container instanceof PackageFragmentDescriptor) {
                KPackage pkg = this.getOrCreatePackage((PackageFragmentDescriptor)container);
                return pkg.getClass(classElement);
            }
            DeclarationDescriptor declarationDescriptor = dec;
            dec = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        }
        ModelPackage-KotlinModel-508284e7.warning("no package found for class " + name);
        return null;
    }

    @Nullable
    public final KPackage previous(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        return null;
    }

    @Nullable
    public final KPackage next(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        return null;
    }

    @NotNull
    public final BindingContext getContext() {
        return this.context;
    }

    @NotNull
    public final KDocConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final List<File> getSourceDirs() {
        return this.sourceDirs;
    }

    @NotNull
    public final List<JetFile> getSources() {
        return this.sources;
    }

    @NotNull
    public KModel(@JetValueParameter(name="context") @NotNull BindingContext context, @JetValueParameter(name="config") @NotNull KDocConfig config, @JetValueParameter(name="sourceDirs") @NotNull List<? extends File> sourceDirs, @JetValueParameter(name="sources") @NotNull List<? extends JetFile> sources) {
        Iterable packageFragment;
        Object source;
        Object object6;
        Object object2;
        this.context = context;
        this.config = config;
        this.sourceDirs = sourceDirs;
        this.sources = sources;
        this.packageMap = KotlinPackage.sortedMapOf((Pair[])new Pair[0]);
        this.markdownProcessor = new PegDownProcessor(Extensions.ALL);
        this.highlighter = new SyntaxHighlighter();
        this._projectRootDir = null;
        this.packageDescriptionFiles = KotlinPackage.listOf((Object[])new String[]{"readme.md", "ReadMe.md, readme.html, ReadMe.html"});
        this.readMeDirsScanned = new HashSet();
        Iterable object3 = this.sourceDirs;
        Object object4 = object3;
        Iterable iterable = new ArrayList();
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            object2 = object5.next();
            File file = (File)object2;
            iterable.add(file.getCanonicalPath());
        }
        List normalizedSourceDirs = (ArrayList)iterable;
        KModel$1 kModel$1 = new KModel$1(normalizedSourceDirs);
        object4 = this.sources;
        iterable = object4;
        object5 = new ArrayList();
        for (Object object6 : iterable) {
            source = (JetFile)object6;
            String relativePath = kModel$1.invoke((PsiFile)source);
            String htmlPath = KotlinPackage.replaceFirst((String)relativePath, (String)"\\.kt$", (String)"") + ".html";
            object5.add(new SourceInfo((JetFile)source, relativePath, htmlPath));
        }
        this.sourcesInfo = (ArrayList)object5;
        this.sourceInfoByFile = DocPackage-collections-b8ec3894.toHashMapMappingToKey(this.sourcesInfo, (Function1)KModel$sourceInfoByFile$1.instance$);
        HashSet<Iterable> allPackageFragments = new HashSet<Iterable>();
        for (JetFile jetFile : this.sources) {
            Boolean bl;
            packageFragment = (PackageFragmentDescriptor)this.context.get((ReadOnlySlice)BindingContext.FILE_TO_PACKAGE_FRAGMENT, (Object)jetFile);
            boolean bl2 = true;
            if (packageFragment == null) {
                bl2 = false;
            }
            if (bl2) {
                bl = allPackageFragments.add(packageFragment);
                continue;
            }
            ModelPackage-KotlinModel-508284e7.warning("No PackageFragmentDescriptor for source " + jetFile);
            bl = Unit.VALUE;
        }
        packageFragment = allPackageFragments;
        object5 = packageFragment;
        object2 = new HashMap();
        object6 = object5.iterator();
        while (object6.hasNext()) {
            Object object7;
            Object object8 = object2;
            source = object6.next();
            PackageFragmentDescriptor it = (PackageFragmentDescriptor)source;
            String string = ModelPackage-KotlinModel-508284e7.qualifiedName((DeclarationDescriptor)it);
            if (object8.containsKey(string)) {
                object7 = object8.get(string);
            } else {
                ArrayList arrayList = new ArrayList();
                object8.put(string, arrayList);
                object7 = arrayList;
            }
            List list = (List)object7;
            list.add(source);
        }
        object4 = KotlinPackage.iterator((Map)object2);
        while (object4.hasNext()) {
            Map.Entry entry = (Map.Entry)object4.next();
            String name = (String)KotlinPackage.component1((Map.Entry)entry);
            List packageFragments = (List)KotlinPackage.component2((Map.Entry)entry);
            this.createPackage(packageFragments, name);
            for (PackageFragmentDescriptor packageFragment2 : packageFragments) {
                for (DeclarationDescriptor descriptor : packageFragment2.getMemberScope().getAllDescriptors()) {
                    if (!(descriptor instanceof ClassDescriptor)) continue;
                    this.getClass((ClassDescriptor)descriptor);
                }
            }
        }
    }
}

