/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.templates;

import java.util.Collection;
import java.util.List;
import jet.JetObject;
import jet.KotlinClass;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KAnnotation;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.templates.KDocTemplate;

@KotlinClass(abiVersion=9, data={"'\n)1\u0002+Y2lC\u001e,G+Z7qY\u0006$XmU;qa>\u0014HOC\u0005uK6\u0004H.\u0019;fg*\u0019Am\\2\u000b\r-|G\u000f\\5o\u0015%QW\r\u001e2sC&t7OC\u0002pe\u001eTAb\u0013#pGR+W\u000e\u001d7bi\u0016Ta\u0001P5oSRt$b\u00019lO*A1\nU1dW\u0006<WMC\u0003n_\u0012,GN\u0003\u0006gk:\\U-_<pe\u0012Taa\u0015;sS:<'b\u00016fi*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\u001b\u001d,GOR;o\u0017\u0016Lxo\u001c:e\u0015\u001dYW-_<pe\u0012TAA\\1nK*1q-\u001a;QW\u001eT\u0001\u0003\u001d:j]R\feN\\8uCRLwN\\:\u000b\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u000b\u0007>dG.Z2uS>t'bC&B]:|G/\u0019;j_:TA!\u00168ji*!Q\u000f^5m\u0015M\u0001(/\u001b8u\rVt7\r^5p]\u0012+G/Y5m\u0015!1WO\\2uS>t'\"C&Gk:\u001cG/[8o\u0015%1WO\\2uS>t7O\u0003\u000bqe&tGOR;oGRLwN\\*v[6\f'/\u001f\u0006\u0010aJLg\u000e\u001e)be\u0006lW\r^3sg*1Q.\u001a;i_\u0012TA\u0003\u001d:j]R\u0004&o\u001c9feRL8+^7nCJL(B\u00039s_B,'\u000f^5fg*I1\n\u0015:pa\u0016\u0014H/\u001f\u0006\taJ|\u0007/\u001a:us*\t\u0002O]5oiJ+7-Z5wKJ$\u0016\u0010]3\u000b\rA\u0014XMZ5y\u0015\u001d\u0001xn\u001d;gSbTAA\\8oK*\u0019\u0002O]5oiRK\b/\u001a)be\u0006lW\r^3sg*I1/\u001a9be\u0006$xN\u001d\u0006\u000fe\u0016d\u0017\r^5wKB\u0013XMZ5y\u0015)1\u0018\r\\&fs^|'\u000f\u001a\u0006\u000eO\u0016$h+\u00197LKf<xN\u001d3\u000b\u0015Y\f'oS3zo>\u0014HMC\u0007hKR4\u0016M]&fs^|'\u000f\u001aO\u0002\u0015\t\u0001RA\u0003\u0003\t\u0001A!!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\u0005)!\u0001b\u0001\t\u0002\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00071\u0001QA\u0001C\u0002\u0011\u0015)1\u0001b\u0002\t\n1\u0001QA\u0001C\u0004\u0011\u0013)\u0011\u0001#\u0004\u0006\u0007\u0011)\u0001B\u0002\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\r!=QA\u0001C\u0007\u0011\u0019)1\u0001B\u0003\t\u00171\u0001Qa\u0001C\u0004\u0011/a\u0001!B\u0002\u0005\u000b!aA\u0002A\u0003\u0003\t\u0019AI\"\u0002\u0002\u0005\u0013!YQa\u0001C\u0004\u00119a\u0001!\u0002\u0002\u0005\b!qQa\u0001C\u0004\u0011Ga\u0001!\u0002\u0002\u0005\b!\rB\u0001\u0005G\u00033\t)\u0011\u0001C\u0002*%\u0011\u0019\u000f\u0001g\u0002\u001e\u000b\u0011\u0001\u0001\u0002B\u0007\u0003\u000b\u0005AA!\t\u0002\u0006\u0003!\u0015\u0011kA\u0003\u0005\b%\tA\u0001A\u0007\u0002\u0011\u0013is\u0002\u00021\u00111\u0017\t#!B\u0001\t\fU\u001b\u0001\"B\u0002\u0005\f%\t\u0001bB\u0007\u0004\t!I\u0011\u0001C\u0004.$\u0011\u0011\u0001\u0014C\u000f\u0006\t\u0001A\u0011\"\u0004\u0002\u0006\u0003!-\u0011EA\u0003\u0002\u0011\u0017\t6!\u0002C\t\u0013\u0005Aq!D\u0001\t\u000f5zA\u0001\u001b\t\u0019\t\u0005\u0012Q!\u0001\u0005\u0005+\u000eAQa\u0001\u0003\u0005\u0013\u0005AI!D\u0002\u0005\u0014%\t\u0001\u0012BW\u0016\t\u0001A\"\"H\u0005\u0005\u0001!UQBB\u0003\u0002\u0011\u001fI1!\u0003\u0002\u0006\u0003!A\u0011EA\u0003\u0002\u0011#\t6!\u0002\u0003\u000b\u0013\u0005!\u0001!D\u0001\t\u00145\u000eB\u0001\u0001\r\u000e;\u0015!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001BC\u0011\u0003\u000b\u0005A\t\"U\u0002\u0006\t5I\u0011\u0001\u0002\u0001\u000e\u0003!UQ6\u0006\u0003\u000115i\u0012\u0002\u0002\u0001\t\u001e51Q!\u0001E\b\u0013\rI!!B\u0001\t\u0015\u0005\u0012Q!\u0001E\t#\u000e)A!D\u0005\u0002\t\u0001i\u0011\u0001c\u0005.$\u0011\u0001\u0001dD\u000f\u0006\t\u0001AY\"\u0004\u0002\u0006\u0003!Q\u0011EA\u0003\u0002\u0011#\t6!\u0002\u0003\u0010\u0013\u0005!\u0001!D\u0001\t\u00165.B\u0001\u0001\r\u0010;%!\u0001\u0001#\b\u000e\r\u0015\t\u0001rB\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0006\"\u0005\u0015\t\u0001\u0012C)\u0004\u000b\u0011y\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0019\"l\t\u0005\u0001a}Q$\u0002\u0003\u0001\u0011Ai!!B\u0001\t\u0015\u0005\u0012Q!\u0001E\t#\u000e)AqD\u0005\u0002\t\u0001i\u0011\u0001#\u0006.,\u0011\u0001\u0001\u0014E\u000f\n\t\u0001A\u0011#\u0004\u0004\u0006\u0003!=\u0011bA\u0005\u0003\u000b\u0005A1\"\t\u0002\u0006\u0003!E\u0011kA\u0003\u0005\"%\tA\u0001A\u0007\u0002\u0011'i\u001b\u0003\u0002\u0001\u0019\"u)A\u0001\u0001\u0005\u0013\u001b\t)\u0011\u0001C\u0006\"\u0005\u0015\t\u0001\u0012C)\u0004\u000b\u0011\u0005\u0012\"\u0001\u0003\u0001\u001b\u0005A9\"l\u0015\u0005\u0001a\u0015R$\u0002\u0003\u0001\u00117i!!B\u0001\t\u0015u)A!\u0001\u0005\u0014\u001b\t)\u0011\u0001c\u0003\u001e\u000b\u0011\t\u0001rE\u0007\u0003\u000b\u0005AY!H\u0003\u0005\u0003!!RBA\u0003\u0002\u0011\u0017\t#!B\u0001\t\u0012E\u001b1\u0002\"\n\n\u0003\u0011\u0001Q\"\u0001E\u000b\u001b\u0005Aq!D\u0001\t\u000f5\t\u0001bBW\u001a\t\u0001AJ#H\u0003\u0005\u0001!\u0001RBA\u0003\u0002\u0011)iR\u0001B\u0001\t+5\u0011Q!\u0001E\u0006C\t)\u0011\u0001#\u0005R\u0007\u001d!I#C\u0001\u0005\u00015\t\u0001RC\u0007\u0002\u0011\u001di\u001b\u0002\u0002\u0006\u0019,\u0005\u0012Q!\u0001E\u0006#\u000e\u0019A1F\u0005\u0002\u0011\u001dis\u0002\u00021\u00111Y\t#!B\u0001\t\fU\u001b\u0001\"B\u0002\u0005-%\t\u0001bB\u0007\u0004\t[I\u0011\u0001C\u0004.\u001f\u0011\u0001\u0007\u0003G\f\"\u0005\u0015\t\u00012B+\u0004\u0011\u0015\u0019AaF\u0005\u0002\u0011\u001di1\u0001b\f\n\u0003!9\u0001"})
public abstract class PackageTemplateSupport
extends KDocTemplate
implements JetObject {
    private final String funKeyword;
    private final String valKeyword;
    private final String varKeyword;
    private final KPackage pkg;

    @Override
    protected String relativePrefix() {
        return this.getPkg().getNameAsRelativePath();
    }

    public final String getFunKeyword() {
        return this.funKeyword;
    }

    public final String getValKeyword() {
        return this.valKeyword;
    }

    public final String getVarKeyword() {
        return this.varKeyword;
    }

    protected final String keyword(@JetValueParameter(name="name") String name) {
        return "<B>" + name + "</B>";
    }

    public final void printFunctionSummary(@JetValueParameter(name="functions") Collection<? extends KFunction> functions2) {
        if (KotlinPackage.isNotEmpty(functions2)) {
            this.println("<!-- ========== FUNCTION SUMMARY =========== -->\n\n<A NAME=\"method_summary\"><!-- --></A>\n<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\n<B>Function Summary</B></FONT></TH>\n</TR>");
            for (KFunction kFunction : functions2) {
                this.printFunctionSummary(kFunction);
            }
            this.println("</TABLE>\n&nbsp;\n<P>\n");
        }
    }

    public final void printFunctionSummary(@JetValueParameter(name="function") KFunction function) {
        String deprecated = ((KAnnotated)function).getDeprecated() ? "<B>Deprecated.</B>" : "";
        this.print("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\n<CODE>");
        if (!function.getTypeParameters().isEmpty()) {
            this.println("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" SUMMARY=\"\">\n            <TR ALIGN=\"right\" VALIGN=\"\">\n            <TD NOWRAP><FONT SIZE=\"-1\">\n            <CODE>");
            this.print(this.funKeyword + " ");
            PackageTemplateSupport.printTypeParameters$default(this, function, null, 2);
            PackageTemplateSupport.printReceiverType$default(this, function, "<BR>", null, null, 12);
            this.println("</CODE></FONT></TD>\n</TR>\n</TABLE>");
        } else {
            this.print(this.funKeyword);
            PackageTemplateSupport.printReceiverType$default(this, function, null, null, null, 14);
        }
        this.println("</CODE></FONT></TD>");
        this.print("<TD><CODE><B><A HREF=" + "\"" + this.href(function) + "\"" + ">" + function.getName() + "</A></B>");
        this.printParameters(function);
        this.print(": ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, function.getReturnType(), false, 2));
        this.println("</CODE>");
        this.println("");
        this.println("<BR>");
        this.println(String.valueOf(function.description(this)));
        this.println("</TD>");
        this.println("</TR>");
    }

    public final void printReceiverType(@JetValueParameter(name="function") KFunction function, @JetValueParameter(name="prefix") String prefix, @JetValueParameter(name="postfix") String postfix, @JetValueParameter(name="none") String none) {
        KType receiverType = function.getReceiverType();
        boolean bl = true;
        if (receiverType == null) {
            bl = false;
        }
        if (bl) {
            this.print(prefix);
            this.print(KDocTemplate.link$default((KDocTemplate)this, receiverType, false, 2));
            this.print(postfix);
        } else {
            this.print(none);
        }
    }

    public static /* synthetic */ void printReceiverType$default(PackageTemplateSupport packageTemplateSupport, KFunction kFunction, String string, String string2, String string3, int n) {
        if ((n & 2) != 0) {
            string = " ";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        packageTemplateSupport.printReceiverType(kFunction, string, string2, string3);
    }

    public final void printFunctionDetail(@JetValueParameter(name="functions") Collection<? extends KFunction> functions2) {
        if (KotlinPackage.isNotEmpty(functions2)) {
            this.println("\n\n            <!-- ============ FUNCTION DETAIL ========== -->\n\n            <A NAME=\"method_detail\"><!-- --></A>\n            <TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n            <TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n            <TH ALIGN=\"left\" COLSPAN=\"1\"><FONT SIZE=\"+2\">\n            <B>Function Detail</B></FONT></TH>\n            </TR>\n            </TABLE>\n            ");
            for (KFunction kFunction : functions2) {
                this.printFunctionDetail(kFunction);
            }
        }
    }

    public final void printFunctionDetail(@JetValueParameter(name="function") KFunction function) {
        this.println("<div class=\"doc-member function\">");
        this.println("<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + this.sourceHref(function) + "\"" + function.sourceTargetAttribute() + ">source</a></div>");
        this.println("<A NAME=" + "\"" + function.getName() + "{" + function.getParameterTypeText() + "}" + "\"" + "><!-- --></A><A NAME=" + "\"" + function.getLink() + "\"" + "><!-- --></A><H3>");
        this.println(function.getName() + "</H3>");
        this.println("<PRE>");
        this.println("<FONT SIZE=\"-1\">");
        this.printAnnotations((Collection<? extends KAnnotation>)function.getAnnotations());
        this.print("</FONT>" + KotlinPackage.makeString$default((Iterable)function.getModifiers(), (String)" ", null, null, (int)0, null, (int)30) + " " + this.funKeyword);
        this.printTypeParameters(function, " ");
        this.printReceiverType(function, " ", ".", " ");
        this.print("<B>" + function.getName() + "</B>");
        this.printParameters(function);
        this.print(": ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, function.getReturnType(), false, 2));
        List<KClass> exlist = function.getExceptions();
        int first = 1;
        if (!exlist.isEmpty()) {
            this.println("                                throws ");
            for (KClass ex : exlist) {
                if (first != 0) {
                    first = 0;
                } else {
                    this.print(", ");
                }
                this.print(KDocTemplate.link$default((KDocTemplate)this, ex, false, 2));
            }
        }
        this.println("</PRE>");
        this.println(function.detailedDescription(this));
        this.println("</div>");
    }

    public final void printPropertySummary(@JetValueParameter(name="properties") Collection<? extends KProperty> properties) {
        if (KotlinPackage.isNotEmpty(properties)) {
            this.println("<!-- ========== PROPERTY SUMMARY =========== -->\n\n<A NAME=\"method_summary\"><!-- --></A>\n<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\n<B>Property Summary</B></FONT></TH>\n</TR>");
            for (KProperty kProperty : properties) {
                this.printPropertySummary(kProperty);
            }
            this.println("</TABLE>\n&nbsp;\n<P>\n");
        }
    }

    public final void printPropertySummary(@JetValueParameter(name="property") KProperty property) {
        String deprecated = ((KAnnotated)property).getDeprecated() ? "<B>Deprecated.</B>" : "";
        this.print("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\n<CODE>");
        this.print(property.isVar() ? this.varKeyword : this.valKeyword);
        this.println("</CODE></FONT></TD>");
        this.print("<TD>" + "\n" + "<div class=" + "\"" + "doc-member property" + "\"" + ">" + "\n" + "<div class=" + "\"" + "source-detail" + "\"" + "><a HREF=" + "\"" + this.sourceHref(property) + "\"" + property.sourceTargetAttribute() + ">source</a></div>" + "\n" + "        <CODE><B>" + property.getName() + "</B>: ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, property.getReturnType(), false, 2));
        this.println("</CODE>");
        this.println("");
        this.println("<BR>");
        this.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + deprecated + "&nbsp;" + property.detailedDescription(this) + "\n" + "</div></TD>");
        this.println("</TR>");
    }

    public final void printTypeParameters(@JetValueParameter(name="method") KFunction method, @JetValueParameter(name="separator") String separator) {
        List<KTypeParameter> typeParameters = method.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            this.print(separator);
            this.print("&lt");
            String separator2 = "";
            for (KTypeParameter t : typeParameters) {
                this.print(separator2);
                separator2 = ", ";
                this.print(t.getName());
                List<KClass> elist = t.getExtends();
                if (elist.isEmpty()) continue;
                this.print(" extends ");
                String esep = "";
                for (KClass e : elist) {
                    this.print(esep);
                    esep = " & ";
                    this.print(KDocTemplate.link$default((KDocTemplate)this, e, false, 2));
                }
            }
            this.print("&gt");
        }
    }

    public static /* synthetic */ void printTypeParameters$default(PackageTemplateSupport packageTemplateSupport, KFunction kFunction, String string, int n) {
        if ((n & 2) != 0) {
            string = "";
        }
        packageTemplateSupport.printTypeParameters(kFunction, string);
    }

    public final void printParameters(@JetValueParameter(name="method") KFunction method) {
        this.print("(");
        int first = 1;
        int defaultValue = 0;
        for (KParameter p : method.getParameters()) {
            KType kType;
            if ((!p.hasDefaultValue() ? defaultValue : 0) != 0) {
                this.print("]");
                defaultValue = 0;
            }
            if (first != 0) {
                first = 0;
            } else {
                this.print(", ");
            }
            boolean bl = p.hasDefaultValue() ? defaultValue == 0 : false;
            if (bl) {
                this.print(" [");
                defaultValue = 1;
            }
            if (p.isVarArg()) {
                this.print("vararg ");
                kType = p.varArgType();
                if (kType == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                kType = p.getaType();
            }
            KType pType = kType;
            this.print(p.getName() + ":&nbsp;");
            this.print(KDocTemplate.link$default((KDocTemplate)this, pType, false, 2));
        }
        if (defaultValue != 0) {
            this.print("]");
        }
        this.print(")");
    }

    public final void printAnnotations(@JetValueParameter(name="annotations") Collection<? extends KAnnotation> annotations) {
        for (KAnnotation kAnnotation : annotations) {
            this.println(this.link(kAnnotation));
        }
    }

    public KPackage getPkg() {
        return this.pkg;
    }

    public PackageTemplateSupport(@JetValueParameter(name="pkg") KPackage pkg2) {
        this.pkg = pkg2;
        this.funKeyword = this.keyword("fun");
        this.valKeyword = this.keyword("val");
        this.varKeyword = this.keyword("var");
    }
}

