/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.highlighter2;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import jet.Function0;
import jet.Function1;
import jet.JetObject;
import jet.KotlinClass;
import jet.TypeCastException;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.kotlin.doc.Doclet;
import org.jetbrains.kotlin.doc.KDocArguments;
import org.jetbrains.kotlin.doc.highlighter2.Highlighter2Package-ioUtils-a010ebf8;
import org.jetbrains.kotlin.doc.highlighter2.Html2CompilerPlugin$generate$1;
import org.jetbrains.kotlin.doc.highlighter2.Html2CompilerPlugin$processFile$template$1$render$1;
import org.jetbrains.kotlin.doc.highlighter2.Html2CompilerPlugin$sourceDirPaths$1;
import org.jetbrains.kotlin.doc.highlighter2.Html2CompilerPlugin$sourceDirs$1;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.SourceInfo;
import org.jetbrains.kotlin.doc.names;

@KotlinClass(abiVersion=9, data={":\b)\u0019\u0002\n^7me\r{W\u000e]5mKJ\u0004F.^4j]*a\u0001.[4iY&<\u0007\u000e^3se)\u0019Am\\2\u000b\r-|G\u000f\\5o\u0015%QW\r\u001e2sC&t7OC\u0002pe\u001eTa\u0001R8dY\u0016$(B\u0002\u001fj]&$hHC\td_6\u0004\u0018\u000e\\3s\u0003J<W/\\3oiNTQb\u0013#pG\u0006\u0013x-^7f]R\u001c(\u0002F4fi\u000e{W\u000e]5mKJ\f%oZ;nK:$8OC\u0007e_\u000e|U\u000f\u001e9viJ{w\u000e\u001e\u0006\u0005\r&dWM\u0003\u0002j_*!!.\u0019<b\u0015A9W\r\u001e#pG>+H\u000f];u%>|GOC\u0006gS2,Gk\\,sSR,'b\u00029tS\u001aKG.\u001a\u0006\b!NLg)\u001b7f\u0015\r\u00018/\u001b\u0006\tS:$X\r\u001c7jU*\u00191m\\7\u000b\rM#(/\u001b8h\u0015\rQW\r\u001e\u0006\u0005Y\u0006twM\u0003\u0005hK:,'/\u0019;f\u0015\u0015iw\u000eZ3m\u0015\u0019YUj\u001c3fY*Iq.\u001e;qkR$\u0015N\u001d\u0006\u0005+:LGOC\u0006qe>\u001cWm]:GS2,'BC:pkJ\u001cW-\u00138g_*Q1k\\;sG\u0016LeNZ8\u000b\u001dM|WO]2f\t&\u0014\b+\u0019;ig*!A*[:u\u0015\u0011)H/\u001b7\u000b#\u001d,GoU8ve\u000e,G)\u001b:QCRD7O\u0003\u0006t_V\u00148-\u001a#jeNTQbZ3u'>,(oY3ESJ\u001c(\"D:sG>+H\u000f];u%>|GO\u0003\thKR\u001c&oY(viB,HOU8pi\u001a\u000f!B\u0001\t\u0006\u0015\u0011A\u0001\u0001\u0005\u0003\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001\"A\u0003\u0003\t\u0007A\t!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0004\t\u0007A1\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\u0012\u0002\u0007\u0001\u000b\t!\u0019\u0001#\u0003\u0006\u0003!9QA\u0001C\u0005\u0011\u001b)1\u0001B\u0003\t\r1\u0001QA\u0001\u0003\u0006\u0011\u0019)\u0011\u0001#\u0006\u0006\u0005\u00115\u0001BC\u0003\u0003\t\u001dA\u0019\"B\u0002\u0005\u0010!IA\u0002A\u0003\u0002\u0011/)1\u0001\"\u0005\t\u00171\u0001QA\u0001C\u0005\u00111)!\u0001b\u0005\t\u0017\u0015\u0011Aq\u0002\u0005\n\u000b\t!\u0019\u0001C\u0007\u0006\u0007\u0011Y\u00012\u0004\u0007\u0001\u000b\r!\t\u0002#\b\r\u0001\u0015\u0011Aa\u0003E\u000e\u000b\r!1\u0002\u0003\t\r\u0001\u0015\u0011Aa\u0003\u0005\u0011\u000b\r!\t\u0002C\t\r\u0001\u0015\u0011A\u0011\u0002E\u0012\u000b\t!i\u0002C\t\u0005\u00011\u0015\u0011DA\u0003\u0002\u0011\rI#\u0003Br\u00011\u000fiR\u0001\u0002\u0001\t\t5\u0011Q!\u0001E\u0004C\t)\u0011\u0001#\u0002R\u0007\u0015!9!C\u0001\u0005\u00015\t\u0001\u0002B\u0017\u0010\t\u0005\u0004\u0002\u0004B\u0011\u0003\u000b\u0005A9!V\u0002\t\u000b\r!A!C\u0001\t\t5\u0019A!B\u0005\u0002\u0011\u0011is\u0002B1\u00111\u0017\t#!B\u0001\t\fU\u001b\u0001\"B\u0002\u0005\f%\t\u0001BB\u0007\u0004\t\u001fI\u0011\u0001\u0003\u0004.$\u0011\t\u0001\u0004C\u000f\u0006\t\u0001A\t\"\u0004\u0002\u0006\u0003!A\u0011EA\u0003\u0002\u0011%\t6!\u0002\u0003\t\u0013\u0005A!\"D\u0001\t\u00165NB\u0001\u0003M\r;\u0015!\u0001\u0001C\u0007\u000e\u0005\u0015\t\u0001rC\u000f\u0006\t\u0001Aa\"\u0004\u0002\u0006\u0003!-\u0011EA\u0003\u0002\u00111\t6a\u0002C\r\u0013\u0005!\u0001!D\u0001\t\u001a5\t\u0001BBW\u0012\t\u0005Ar\"H\u0003\u0005\u0001!}QBA\u0003\u0002\u00115\t#!B\u0001\t\u0019E\u001bQ\u0001B\b\n\u0003\u0011\u0001Q\"\u0001E\u000e[M!\u0011\r\u0005M\u0011C\u0019)\u0011\u0001\u0003\b\n\u0007%\u0011Q!\u0001\u0005\n+\u000eAQa\u0001C\u0011\u0013\u0005Aq\"D\u0002\u0005%%\t\u0001bD\u0017\u0014\t\u0005\u0004\u0002TE\u0011\u0007\u000b\u0005Aa\"C\u0002\n\u0005\u0015\t\u00012B+\u0004\u0011\u0015\u0019AQE\u0005\u0002\u0011=i1\u0001B\n\n\u0003!yQf\u0004\u0003b!a\u001d\u0012EA\u0003\u0002\u0011\u0017)6\u0001C\u0003\u0004\tOI\u0011\u0001\u0003\u0004\u000e\u0007\u0011!\u0012\"\u0001\u0005\u0007"})
public final class Html2CompilerPlugin
implements JetObject,
Doclet {
    private final File docOutputRoot;
    private final File srcOutputRoot;
    private final List<? extends File> sourceDirs;
    private final List<? extends String> sourceDirPaths;
    private final KDocArguments compilerArguments;

    private final File getDocOutputRoot() {
        return this.docOutputRoot;
    }

    private final File getSrcOutputRoot() {
        return this.srcOutputRoot;
    }

    private final List<File> getSourceDirs() {
        return this.sourceDirs;
    }

    private final List<String> getSourceDirPaths() {
        return this.sourceDirPaths;
    }

    private final String fileToWrite(@JetValueParameter(name="psiFile") PsiFile psiFile) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            throw new TypeCastException("com.intellij.openapi.vfs.VirtualFile? cannot be cast to com.intellij.openapi.vfs.local.CoreLocalVirtualFile");
        }
        String string = ((CoreLocalVirtualFile)virtualFile).getPath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        File file = new File(string).getCanonicalFile();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        File file2 = file;
        String string2 = file2.getPath();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String filePath = string2;
        for (String string3 : this.sourceDirPaths) {
            boolean bl = KotlinPackage.startsWith((String)filePath, (String)string3) ? KotlinPackage.length((String)filePath) > KotlinPackage.length((String)string3) : false;
            if (!bl) continue;
            String relativePath = KotlinPackage.substring((String)filePath, (int)(string3.length() + 1));
            return relativePath;
        }
        throw (Throwable)new Exception(file2 + " is not a child of any source roots " + this.sourceDirPaths);
    }

    @Override
    public void generate(@JetValueParameter(name="model") KModel model, @JetValueParameter(name="outputDir") File outputDir) {
        this.srcOutputRoot.mkdirs();
        ClassLoader classLoader = Html2CompilerPlugin.class.getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        InputStream inputStream = classLoader.getResourceAsStream("org/jetbrains/kotlin/doc/highlighter2/hightlight.css");
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        InputStream css = inputStream;
        Highlighter2Package-ioUtils-a010ebf8.write(new File(this.srcOutputRoot, "highlight.css"), (Function1<? super FileOutputStream, ? extends Unit>)((Function1)new Html2CompilerPlugin$generate$1(css)));
        for (SourceInfo sourceInfo : model.getSourcesInfo()) {
            this.processFile(sourceInfo);
        }
    }

    private final void processFile(@JetValueParameter(name="sourceInfo") SourceInfo sourceInfo) {
        JetFile psiFile = sourceInfo.getPsi();
        String htmlPath = sourceInfo.getHtmlPath();
        File htmlFile = new File(this.srcOutputRoot, htmlPath);
        IoPackage.println((Object)("Generating " + htmlFile));
        File file = htmlFile.getParentFile();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        file.mkdirs();
        JetObject template2 = new JetObject(this, psiFile){
            final /* synthetic */ Html2CompilerPlugin this$0;
            final /* synthetic */ JetFile $psiFile;

            public void render() {
                this.html((Function0<? extends Unit>)((Function0)new Html2CompilerPlugin$processFile$template$1$render$1(this)));
            }
            {
                this.this$0 = $outer;
                this.$psiFile = $shared_var$1;
            }
        };
        template2.renderTo(htmlFile);
    }

    private final KDocArguments getCompilerArguments() {
        return this.compilerArguments;
    }

    public Html2CompilerPlugin(@JetValueParameter(name="compilerArguments") KDocArguments compilerArguments) {
        this.compilerArguments = compilerArguments;
        String docOutputDir = this.compilerArguments.getDocConfig().getDocOutputDir();
        if (KotlinPackage.isEmpty((String)docOutputDir)) {
            throw (Throwable)new IllegalArgumentException("empty doc output dir");
        }
        this.docOutputRoot = new File(docOutputDir);
        this.srcOutputRoot = new File(this.docOutputRoot, names.instance$.getHtmlSourceDirName());
        this.sourceDirs = KotlinPackage.map((Collection)KotlinPackage.requireNoNulls((List)KotlinPackage.orEmpty((List)this.compilerArguments.getSourceDirs())), (Function1)((Function1)Html2CompilerPlugin$sourceDirs$1.instance$));
        this.sourceDirPaths = KotlinPackage.map((Collection)this.sourceDirs, (Function1)((Function1)Html2CompilerPlugin$sourceDirPaths$1.instance$));
    }
}

