/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.templates;

import java.util.Collection;
import java.util.List;
import jet.JetObject;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KAnnotation;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.templates.KDocTemplate;

@JetClass(signature="Lorg/jetbrains/kotlin/doc/templates/KDocTemplate;", flags=16, abiVersion=6)
public abstract class PackageTemplateSupport
extends KDocTemplate
implements JetObject {
    private final String funKeyword;
    private final String valKeyword;
    private final String varKeyword;
    private final KPackage pkg;

    @Override
    @JetMethod(flags=32, returnType="Ljava/lang/String;")
    protected String relativePrefix() {
        return this.getPkg().getNameAsRelativePath();
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getFunKeyword() {
        return this.funKeyword;
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getValKeyword() {
        return this.valKeyword;
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getVarKeyword() {
        return this.varKeyword;
    }

    @JetMethod(flags=32, returnType="Ljava/lang/String;")
    protected final String keyword(@JetValueParameter(name="name", type="Ljava/lang/String;") String name) {
        return "<B>" + name + "</B>";
    }

    @JetMethod(flags=16, returnType="V")
    public final void printFunctionSummary(@JetValueParameter(name="functions", type="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KFunction;>;") Collection<? extends KFunction> functions2) {
        if (KotlinPackage.isNotEmpty(functions2)) {
            this.println("<!-- ========== FUNCTION SUMMARY =========== -->\n\n<A NAME=\"method_summary\"><!-- --></A>\n<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\n<B>Function Summary</B></FONT></TH>\n</TR>");
            for (KFunction kFunction : functions2) {
                this.printFunctionSummary(kFunction);
            }
            this.println("</TABLE>\n&nbsp;\n<P>\n");
        }
    }

    @JetMethod(flags=16, returnType="V")
    public final void printFunctionSummary(@JetValueParameter(name="function", type="Lorg/jetbrains/kotlin/doc/model/KFunction;") KFunction function) {
        String deprecated = ((KAnnotated)function).getDeprecated() ? "<B>Deprecated.</B>" : "";
        this.print("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\n<CODE>");
        if (!function.getTypeParameters().isEmpty()) {
            this.println("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" SUMMARY=\"\">\n            <TR ALIGN=\"right\" VALIGN=\"\">\n            <TD NOWRAP><FONT SIZE=\"-1\">\n            <CODE>");
            this.print(this.funKeyword + " ");
            PackageTemplateSupport.printTypeParameters$default(this, function, null, 2);
            PackageTemplateSupport.printReceiverType$default(this, function, "<BR>", null, null, 12);
            this.println("</CODE></FONT></TD>\n</TR>\n</TABLE>");
        } else {
            this.print(this.funKeyword);
            PackageTemplateSupport.printReceiverType$default(this, function, null, null, null, 14);
        }
        this.println("</CODE></FONT></TD>");
        this.print("<TD><CODE><B><A HREF=" + "\"" + this.href(function) + "\"" + ">" + function.getName() + "</A></B>");
        this.printParameters(function);
        this.print(": ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, function.getReturnType(), false, 2));
        this.println("</CODE>");
        this.println("");
        this.println("<BR>");
        this.println(String.valueOf(function.description(this)));
        this.println("</TD>");
        this.println("</TR>");
    }

    @JetMethod(flags=16, returnType="V")
    public final void printReceiverType(@JetValueParameter(name="function", type="Lorg/jetbrains/kotlin/doc/model/KFunction;") KFunction function, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix, @JetValueParameter(name="none", hasDefaultValue=true, type="Ljava/lang/String;") String none) {
        KType receiverType = function.getReceiverType();
        boolean bl = true;
        if (receiverType == null) {
            bl = false;
        }
        if (bl) {
            this.print(prefix);
            this.print(KDocTemplate.link$default((KDocTemplate)this, receiverType, false, 2));
            this.print(postfix);
        } else {
            this.print(none);
        }
    }

    public static /* synthetic */ void printReceiverType$default(PackageTemplateSupport packageTemplateSupport, KFunction kFunction, String string, String string2, String string3, int n) {
        if ((n & 2) != 0) {
            string = " ";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        packageTemplateSupport.printReceiverType(kFunction, string, string2, string3);
    }

    @JetMethod(flags=16, returnType="V")
    public final void printFunctionDetail(@JetValueParameter(name="functions", type="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KFunction;>;") Collection<? extends KFunction> functions2) {
        if (KotlinPackage.isNotEmpty(functions2)) {
            this.println("\n\n            <!-- ============ FUNCTION DETAIL ========== -->\n\n            <A NAME=\"method_detail\"><!-- --></A>\n            <TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n            <TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n            <TH ALIGN=\"left\" COLSPAN=\"1\"><FONT SIZE=\"+2\">\n            <B>Function Detail</B></FONT></TH>\n            </TR>\n            </TABLE>\n            ");
            for (KFunction kFunction : functions2) {
                this.printFunctionDetail(kFunction);
            }
        }
    }

    @JetMethod(flags=16, returnType="V")
    public final void printFunctionDetail(@JetValueParameter(name="function", type="Lorg/jetbrains/kotlin/doc/model/KFunction;") KFunction function) {
        this.println("<div class=\"doc-member function\">");
        this.println("<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + this.sourceHref(function) + "\"" + function.sourceTargetAttribute() + ">source</a></div>");
        this.println("<A NAME=" + "\"" + function.getName() + "{" + function.getParameterTypeText() + "}" + "\"" + "><!-- --></A><A NAME=" + "\"" + function.getLink() + "\"" + "><!-- --></A><H3>");
        this.println(function.getName() + "</H3>");
        this.println("<PRE>");
        this.println("<FONT SIZE=\"-1\">");
        this.printAnnotations((Collection<? extends KAnnotation>)function.getAnnotations());
        this.print("</FONT>" + KotlinPackage.makeString$default((Iterable)function.getModifiers(), (String)" ", null, null, (int)0, null, (int)30) + " " + this.funKeyword);
        this.printTypeParameters(function, " ");
        this.printReceiverType(function, " ", ".", " ");
        this.print("<B>" + function.getName() + "</B>");
        this.printParameters(function);
        this.print(": ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, function.getReturnType(), false, 2));
        List<KClass> exlist = function.getExceptions();
        int first = 1;
        if (!exlist.isEmpty()) {
            this.println("                                throws ");
            for (KClass ex : exlist) {
                if (first != 0) {
                    first = 0;
                } else {
                    this.print(", ");
                }
                this.print(KDocTemplate.link$default((KDocTemplate)this, ex, false, 2));
            }
        }
        this.println("</PRE>");
        this.println(function.detailedDescription(this));
        this.println("</div>");
    }

    @JetMethod(flags=16, returnType="V")
    public final void printPropertySummary(@JetValueParameter(name="properties", type="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KProperty;>;") Collection<? extends KProperty> properties) {
        if (KotlinPackage.isNotEmpty(properties)) {
            this.println("<!-- ========== PROPERTY SUMMARY =========== -->\n\n<A NAME=\"method_summary\"><!-- --></A>\n<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\n<B>Property Summary</B></FONT></TH>\n</TR>");
            for (KProperty kProperty : properties) {
                this.printPropertySummary(kProperty);
            }
            this.println("</TABLE>\n&nbsp;\n<P>\n");
        }
    }

    @JetMethod(flags=16, returnType="V")
    public final void printPropertySummary(@JetValueParameter(name="property", type="Lorg/jetbrains/kotlin/doc/model/KProperty;") KProperty property) {
        String deprecated = ((KAnnotated)property).getDeprecated() ? "<B>Deprecated.</B>" : "";
        this.print("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\n<CODE>");
        this.print(property.isVar() ? this.varKeyword : this.valKeyword);
        this.println("</CODE></FONT></TD>");
        this.print("<TD>" + "\n" + "<div class=" + "\"" + "doc-member property" + "\"" + ">" + "\n" + "<div class=" + "\"" + "source-detail" + "\"" + "><a HREF=" + "\"" + this.sourceHref(property) + "\"" + property.sourceTargetAttribute() + ">source</a></div>" + "\n" + "        <CODE><B>" + property.getName() + "</B>: ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, property.getReturnType(), false, 2));
        this.println("</CODE>");
        this.println("");
        this.println("<BR>");
        this.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + deprecated + "&nbsp;" + property.detailedDescription(this) + "\n" + "</div></TD>");
        this.println("</TR>");
    }

    @JetMethod(flags=16, returnType="V")
    public final void printTypeParameters(@JetValueParameter(name="method", type="Lorg/jetbrains/kotlin/doc/model/KFunction;") KFunction method, @JetValueParameter(name="separator", hasDefaultValue=true, type="Ljava/lang/String;") String separator) {
        List<KTypeParameter> typeParameters = method.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            this.print(separator);
            this.print("&lt");
            String separator2 = "";
            for (KTypeParameter t : typeParameters) {
                this.print(separator2);
                separator2 = ", ";
                this.print(t.getName());
                List<KClass> elist = t.getExtends();
                if (elist.isEmpty()) continue;
                this.print(" extends ");
                String esep = "";
                for (KClass e : elist) {
                    this.print(esep);
                    esep = " & ";
                    this.print(KDocTemplate.link$default((KDocTemplate)this, e, false, 2));
                }
            }
            this.print("&gt");
        }
    }

    public static /* synthetic */ void printTypeParameters$default(PackageTemplateSupport packageTemplateSupport, KFunction kFunction, String string, int n) {
        if ((n & 2) != 0) {
            string = "";
        }
        packageTemplateSupport.printTypeParameters(kFunction, string);
    }

    @JetMethod(flags=16, returnType="V")
    public final void printParameters(@JetValueParameter(name="method", type="Lorg/jetbrains/kotlin/doc/model/KFunction;") KFunction method) {
        this.print("(");
        int first = 1;
        int defaultValue = 0;
        for (KParameter p : method.getParameters()) {
            KType kType;
            if ((!p.hasDefaultValue() ? defaultValue : 0) != 0) {
                this.print("]");
                defaultValue = 0;
            }
            if (first != 0) {
                first = 0;
            } else {
                this.print(", ");
            }
            boolean bl = p.hasDefaultValue() ? defaultValue == 0 : false;
            if (bl) {
                this.print(" [");
                defaultValue = 1;
            }
            if (p.isVarArg()) {
                this.print("vararg ");
                kType = p.varArgType();
                if (kType == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                kType = p.getaType();
            }
            KType pType = kType;
            this.print(p.getName() + ":&nbsp;");
            this.print(KDocTemplate.link$default((KDocTemplate)this, pType, false, 2));
        }
        if (defaultValue != 0) {
            this.print("]");
        }
        this.print(")");
    }

    @JetMethod(flags=16, returnType="V")
    public final void printAnnotations(@JetValueParameter(name="annotations", type="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KAnnotation;>;") Collection<? extends KAnnotation> annotations) {
        for (KAnnotation kAnnotation : annotations) {
            this.println(this.link(kAnnotation));
        }
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/kotlin/doc/model/KPackage;")
    public KPackage getPkg() {
        return this.pkg;
    }

    @JetConstructor
    public PackageTemplateSupport(@JetValueParameter(name="pkg", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage pkg2) {
        this.pkg = pkg2;
        this.funKeyword = this.keyword("fun");
        this.valKeyword = this.keyword("val");
        this.varKeyword = this.keyword("var");
    }
}

