/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jet.Function0;
import jet.Function1;
import jet.runtime.Intrinsics;
import jet.runtime.SharedVar;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.KPackage$classes$1;
import org.jetbrains.kotlin.doc.model.KPackage$getClass$klass$1;
import org.jetbrains.kotlin.doc.model.KPackage$groupClassMap$1;
import org.jetbrains.kotlin.doc.model.KPackage$nameAsRelativePath$answer$1;
import org.jetbrains.kotlin.doc.model.KPackage$packageFunctions$1;
import org.jetbrains.kotlin.doc.model.KPackage$packageProperties$1;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.templates.KDocTemplate;

@JetClass(signature="Lorg/jetbrains/kotlin/doc/model/KClassOrPackage;Ljava/lang/Comparable<Lorg/jetbrains/kotlin/doc/model/KPackage;>;", flags=16, abiVersion=6)
public final class KPackage
extends KClassOrPackage
implements Comparable<? super KPackage> {
    private final SortedMap<String, KClass> classMap;
    private final Collection<? extends KClass> annotations;
    private final NamespaceDescriptor descriptor;
    private final String name;
    private boolean local;
    private boolean useExternalLink;

    @JetMethod(flags=1, propertyType="Ljava/util/SortedMap<Ljava/lang/String;Lorg/jetbrains/kotlin/doc/model/KClass;>;")
    public final SortedMap<String, KClass> getClassMap() {
        return this.classMap;
    }

    @JetMethod(flags=1, propertyType="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KClass;>;")
    public final Collection<KClass> getClasses() {
        Collection<KClass> collection = this.classMap.values();
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return KotlinPackage.filter(collection, (Function1)((Function1)KPackage$classes$1.instance$));
    }

    @JetMethod(flags=1, propertyType="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KClass;>;")
    public final Collection<KClass> getAnnotations() {
        return this.annotations;
    }

    @Override
    @JetMethod(returnType="I")
    public int compareTo(@JetValueParameter(name="other", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage other) {
        return this.name.compareTo(other.name);
    }

    @JetMethod(flags=16, returnType="Z")
    public final boolean equals(@JetValueParameter(name="other", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage other) {
        return Intrinsics.areEqual((Object)this.name, (Object)other.name);
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String toString() {
        return "KPackage(" + this.name + ")";
    }

    @JetMethod(flags=16, returnType="Lorg/jetbrains/kotlin/doc/model/KClass;")
    public final KClass getClass(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/ClassDescriptor;") ClassDescriptor descriptor) {
        String name = descriptor.getName().asString();
        SharedVar.Boolean created = new SharedVar.Boolean();
        created.ref = 0;
        KClass klass2 = (KClass)KotlinPackage.getOrPut((Map)this.classMap, (Object)name, (Function0)((Function0)new KPackage$getClass$klass$1(this, descriptor, created)));
        if (created.ref) {
            this.getModel().tryLoadReadMe(this, (DeclarationDescriptor)descriptor);
            this.getModel().configureComments(klass2, (DeclarationDescriptor)descriptor);
            TypeConstructor typeConstructor = descriptor.getTypeConstructor();
            Collection superTypes = typeConstructor.getSupertypes();
            for (JetType st : superTypes) {
                KType sc = this.getModel().getType(st);
                boolean bl = true;
                if (sc == null) {
                    bl = false;
                }
                if (!bl) continue;
                klass2.getBaseClasses().add(sc);
            }
            JetScope scope = descriptor.getDefaultType().getMemberScope();
            this.getModel().addFunctions(klass2, scope);
            this.getModel().addTypeParameters(klass2.getTypeParameters(), typeConstructor.getParameters());
        }
        return klass2;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getNameAsPath() {
        boolean bl = true;
        if (KotlinPackage.length((String)this.name) != 0) {
            bl = false;
        }
        return bl ? "." : KotlinPackage.replace((String)this.name, (char)'.', (char)'/');
    }

    @JetMethod(flags=1, propertyType="Ljet/List<Ljava/lang/String;>;")
    public final List<String> getNamePaths() {
        ArrayList<String> answer2 = new ArrayList<String>();
        String[] stringArray = KotlinPackage.split((String)this.name, (String)"\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            String n = stringArray[i];
            answer2.add(n);
        }
        return answer2;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getNameAsRelativePath() {
        String answer2 = KotlinPackage.makeString$default((Iterable)KotlinPackage.map((Collection)this.getNamePaths(), (Function1)((Function1)KPackage$nameAsRelativePath$answer$1.instance$)), (String)"/", null, null, (int)0, null, (int)30);
        boolean bl = true;
        if (answer2.length() != 0) {
            bl = false;
        }
        return bl ? "" : answer2 + "/";
    }

    @Override
    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public String description(@JetValueParameter(name="template", type="Lorg/jetbrains/kotlin/doc/templates/KDocTemplate;") KDocTemplate template2) {
        String text2 = this.getModel().getConfig().getPackageSummaryText().get(this.name);
        boolean bl = true;
        if (text2 == null) {
            bl = false;
        }
        return bl ? KotlinPackage.trimTrailing((String)KotlinPackage.trimLeading((String)this.wikiConvert(text2, template2), (String)"<p>"), (String)"</p>") : super.description(template2);
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String qualifiedName(@JetValueParameter(name="simpleName", type="Ljava/lang/String;") String simpleName) {
        return KotlinPackage.length((String)this.name) > 0 ? this.name + "." + simpleName : simpleName;
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/kotlin/doc/model/KClass;")
    public final KClass previous(@JetValueParameter(name="pkg", type="Lorg/jetbrains/kotlin/doc/model/KClass;") KClass pkg2) {
        return null;
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/kotlin/doc/model/KClass;")
    public final KClass next(@JetValueParameter(name="pkg", type="Lorg/jetbrains/kotlin/doc/model/KClass;") KClass pkg2) {
        return null;
    }

    @JetMethod(flags=16, returnType="Ljet/Map<Ljava/lang/String;Ljet/List<Lorg/jetbrains/kotlin/doc/model/KClass;>;>;")
    public final Map<String, List<? extends KClass>> groupClassMap() {
        return KotlinPackage.groupByTo((Iterable)this.getClasses(), (Map)new TreeMap(), (Function1)((Function1)KPackage$groupClassMap$1.instance$));
    }

    @JetMethod(flags=16, returnType="Ljet/List<Lorg/jetbrains/kotlin/doc/model/KFunction;>;")
    public final List<KFunction> packageFunctions() {
        return KotlinPackage.filter((Collection)this.getFunctions(), (Function1)((Function1)KPackage$packageFunctions$1.instance$));
    }

    @JetMethod(flags=16, returnType="Ljet/List<Lorg/jetbrains/kotlin/doc/model/KProperty;>;")
    public final List<KProperty> packageProperties() {
        return KotlinPackage.filter((Collection)this.getProperties(), (Function1)((Function1)KPackage$packageProperties$1.instance$));
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/jet/lang/descriptors/NamespaceDescriptor;")
    public final NamespaceDescriptor getDescriptor() {
        return this.descriptor;
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getName() {
        return this.name;
    }

    @JetMethod(flags=17, propertyType="Z")
    public final boolean getLocal() {
        return this.local;
    }

    @JetMethod(flags=17, propertyType="Z")
    public final void setLocal(@JetValueParameter(name="<set-?>", type="Z") boolean bl) {
        this.local = bl;
    }

    @JetMethod(flags=17, propertyType="Z")
    public final boolean getUseExternalLink() {
        return this.useExternalLink;
    }

    @JetMethod(flags=17, propertyType="Z")
    public final void setUseExternalLink(@JetValueParameter(name="<set-?>", type="Z") boolean bl) {
        this.useExternalLink = bl;
    }

    @JetConstructor
    public KPackage(@JetValueParameter(name="model", type="Lorg/jetbrains/kotlin/doc/model/KModel;") KModel model, @JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/NamespaceDescriptor;") NamespaceDescriptor descriptor, @JetValueParameter(name="name", type="Ljava/lang/String;") String name, @JetValueParameter(name="local", hasDefaultValue=true, type="Z") boolean local, @JetValueParameter(name="useExternalLink", hasDefaultValue=true, type="Z") boolean useExternalLink) {
        super(model, (DeclarationDescriptor)descriptor);
        this.descriptor = descriptor;
        this.name = name;
        this.local = local;
        this.useExternalLink = useExternalLink;
        this.classMap = new TreeMap();
        this.annotations = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ KPackage(KModel kModel, NamespaceDescriptor namespaceDescriptor, String string, boolean bl, boolean bl2, int n) {
        int n2;
        int n3;
        void var6_8;
        if ((var6_8 & 8) != 0) {
            n3 = 0;
        }
        if ((var6_8 & 0x10) != 0) {
            n2 = 0;
        }
        this(kModel, namespaceDescriptor, string, n3 != 0, n2 != 0);
    }
}

