/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KAnnotation;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.model.SourceInfo;

@JetClass(signature="Lorg/jetbrains/kotlin/doc/model/KClassOrPackage;Ljava/lang/Comparable<Lorg/jetbrains/kotlin/doc/model/KClass;>;", flags=16, abiVersion=6)
public final class KClass
extends KClassOrPackage
implements Comparable<? super KClass> {
    private final String simpleName;
    private String group;
    private List<? extends KAnnotation> annotations;
    private List<KTypeParameter> typeParameters;
    private String since;
    private List<? extends String> authors;
    private List<KType> baseClasses;
    private List<? extends KClass> nestedClasses;
    private String url;
    private final String name;
    private final String packageName;
    private final KPackage pkg;
    private final ClassDescriptor descriptor;
    private final SourceInfo sourceInfo;

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getSimpleName() {
        return this.simpleName;
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getGroup() {
        return this.group;
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final void setGroup(@JetValueParameter(name="<set-?>", type="Ljava/lang/String;") String string) {
        this.group = string;
    }

    @JetMethod(flags=17, propertyType="Ljet/List<Lorg/jetbrains/kotlin/doc/model/KAnnotation;>;")
    public final List<KAnnotation> getAnnotations() {
        return this.annotations;
    }

    @JetMethod(flags=17, propertyType="Ljet/List<Lorg/jetbrains/kotlin/doc/model/KAnnotation;>;")
    public final void setAnnotations(@JetValueParameter(name="<set-?>", type="Ljet/List<Lorg/jetbrains/kotlin/doc/model/KAnnotation;>;") List<? extends KAnnotation> list) {
        this.annotations = list;
    }

    @JetMethod(flags=17, propertyType="Ljet/MutableList<Lorg/jetbrains/kotlin/doc/model/KTypeParameter;>;")
    public final List<KTypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @JetMethod(flags=17, propertyType="Ljet/MutableList<Lorg/jetbrains/kotlin/doc/model/KTypeParameter;>;")
    public final void setTypeParameters(@JetValueParameter(name="<set-?>", type="Ljet/MutableList<Lorg/jetbrains/kotlin/doc/model/KTypeParameter;>;") List<KTypeParameter> list) {
        this.typeParameters = list;
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getSince() {
        return this.since;
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final void setSince(@JetValueParameter(name="<set-?>", type="Ljava/lang/String;") String string) {
        this.since = string;
    }

    @JetMethod(flags=17, propertyType="Ljet/List<Ljava/lang/String;>;")
    public final List<String> getAuthors() {
        return this.authors;
    }

    @JetMethod(flags=17, propertyType="Ljet/List<Ljava/lang/String;>;")
    public final void setAuthors(@JetValueParameter(name="<set-?>", type="Ljet/List<Ljava/lang/String;>;") List<? extends String> list) {
        this.authors = list;
    }

    @JetMethod(flags=17, propertyType="Ljet/MutableList<Lorg/jetbrains/kotlin/doc/model/KType;>;")
    public final List<KType> getBaseClasses() {
        return this.baseClasses;
    }

    @JetMethod(flags=17, propertyType="Ljet/MutableList<Lorg/jetbrains/kotlin/doc/model/KType;>;")
    public final void setBaseClasses(@JetValueParameter(name="<set-?>", type="Ljet/MutableList<Lorg/jetbrains/kotlin/doc/model/KType;>;") List<KType> list) {
        this.baseClasses = list;
    }

    @JetMethod(flags=17, propertyType="Ljet/List<Lorg/jetbrains/kotlin/doc/model/KClass;>;")
    public final List<KClass> getNestedClasses() {
        return this.nestedClasses;
    }

    @JetMethod(flags=17, propertyType="Ljet/List<Lorg/jetbrains/kotlin/doc/model/KClass;>;")
    public final void setNestedClasses(@JetValueParameter(name="<set-?>", type="Ljet/List<Lorg/jetbrains/kotlin/doc/model/KClass;>;") List<? extends KClass> list) {
        this.nestedClasses = list;
    }

    @Override
    @JetMethod(returnType="I")
    public int compareTo(@JetValueParameter(name="other", type="Lorg/jetbrains/kotlin/doc/model/KClass;") KClass other) {
        return this.name.compareTo(other.name);
    }

    @JetMethod(flags=16, returnType="Z")
    public final boolean equals(@JetValueParameter(name="other", type="Lorg/jetbrains/kotlin/doc/model/KClass;") KClass other) {
        return Intrinsics.areEqual((Object)this.name, (Object)other.name);
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String toString() {
        return this.getKind() + "(" + this.name + ")";
    }

    @JetMethod(flags=16, returnType="Z")
    public final boolean isApi() {
        Visibility visibility = this.descriptor.getVisibility();
        return visibility.isPublicAPI();
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getKind() {
        ClassKind k = this.descriptor.getKind();
        return Intrinsics.areEqual((Object)k, (Object)ClassKind.TRAIT) ? "trait" : (Intrinsics.areEqual((Object)k, (Object)ClassKind.OBJECT) ? "object" : ((!Intrinsics.areEqual((Object)k, (Object)ClassKind.ENUM_CLASS) ? Intrinsics.areEqual((Object)k, (Object)ClassKind.ENUM_ENTRY) : true) ? "enum" : (Intrinsics.areEqual((Object)k, (Object)ClassKind.ANNOTATION_CLASS) ? "annotation" : "class")));
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getKindCode() {
        ClassKind k = this.descriptor.getKind();
        return Intrinsics.areEqual((Object)k, (Object)ClassKind.TRAIT) ? "trait" : (Intrinsics.areEqual((Object)k, (Object)ClassKind.OBJECT) ? "object" : ((!Intrinsics.areEqual((Object)k, (Object)ClassKind.ENUM_CLASS) ? Intrinsics.areEqual((Object)k, (Object)ClassKind.ENUM_ENTRY) : true) ? "enum class" : (Intrinsics.areEqual((Object)k, (Object)ClassKind.ANNOTATION_CLASS) ? "class" : "class")));
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public final String getVisibility() {
        Visibility v = this.descriptor.getVisibility();
        return Intrinsics.areEqual((Object)v, (Object)Visibilities.PUBLIC) ? "public" : (Intrinsics.areEqual((Object)v, (Object)Visibilities.PROTECTED) ? "protected" : (Intrinsics.areEqual((Object)v, (Object)Visibilities.PRIVATE) ? "private" : ""));
    }

    @JetMethod(flags=1, propertyType="?Ljava/lang/String;")
    public final String getUrl() {
        boolean bl = true;
        if (this.url != null) {
            bl = false;
        }
        if (bl) {
            this.url = this.getNameAsPath() + ".html";
        }
        return this.url;
    }

    @JetMethod(flags=1, propertyType="?Ljava/lang/String;")
    public final void setUrl(@JetValueParameter(name="<set-?>", type="?Ljava/lang/String;") String string) {
        this.url = string;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getName() {
        return this.name;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getPackageName() {
        return this.packageName;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getNameAsPath() {
        return KotlinPackage.replace((String)this.name, (char)'.', (char)'/');
    }

    @JetMethod(flags=16, returnType="Z")
    public final boolean isAnnotation() {
        return Intrinsics.areEqual((Object)this.getKind(), (Object)"annotation");
    }

    @JetMethod(flags=16, returnType="Z")
    public final boolean isInterface() {
        return Intrinsics.areEqual((Object)this.getKind(), (Object)"interface");
    }

    @JetMethod(flags=16, returnType="Ljet/Set<Lorg/jetbrains/kotlin/doc/model/KClass;>;")
    public final Set<KClass> descendants(@JetValueParameter(name="answer", hasDefaultValue=true, type="Ljet/MutableSet<Lorg/jetbrains/kotlin/doc/model/KClass;>;") Set<KClass> answer2) {
        for (KType b : this.baseClasses) {
            KClass c = b.getKlass();
            boolean bl = true;
            if (c == null) {
                bl = false;
            }
            if (!bl) continue;
            answer2.add(c);
            c.descendants(answer2);
        }
        return answer2;
    }

    public static /* synthetic */ Set descendants$default(KClass kClass, Set set, int n) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        return kClass.descendants(set);
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/kotlin/doc/model/KPackage;")
    public final KPackage getPkg() {
        return this.pkg;
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/jet/lang/descriptors/ClassDescriptor;")
    public final ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    @JetMethod(flags=17, propertyType="?Lorg/jetbrains/kotlin/doc/model/SourceInfo;")
    public final SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @JetConstructor
    public KClass(@JetValueParameter(name="pkg", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage pkg2, @JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/ClassDescriptor;") ClassDescriptor descriptor, @JetValueParameter(name="sourceInfo", type="?Lorg/jetbrains/kotlin/doc/model/SourceInfo;") SourceInfo sourceInfo) {
        super(((KAnnotated)pkg2).getModel(), (DeclarationDescriptor)descriptor);
        this.pkg = pkg2;
        this.descriptor = descriptor;
        this.sourceInfo = sourceInfo;
        this.simpleName = this.descriptor.getName().asString();
        this.group = "Other";
        this.annotations = KotlinPackage.arrayList((Object[])new KAnnotation[0]);
        this.typeParameters = KotlinPackage.arrayList((Object[])new KTypeParameter[0]);
        this.since = "";
        this.authors = KotlinPackage.arrayList((Object[])new String[0]);
        this.baseClasses = KotlinPackage.arrayList((Object[])new KType[0]);
        this.nestedClasses = KotlinPackage.arrayList((Object[])new KClass[0]);
        this.name = this.pkg.qualifiedName(this.descriptor.getName().asString());
        this.packageName = this.pkg.getName();
    }
}

