/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.highlighter;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import jet.Function2;
import jet.JetObject;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import kotlin.template.HtmlFormatter;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetLexer;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighligher$createStyleMap$1;

@JetClass(signature="Ljava/lang/Object;", flags=16, abiVersion=6)
public final class SyntaxHighligher
implements JetObject {
    private HtmlFormatter formatter = new HtmlFormatter(null, 1);
    private final Map<IElementType, ? extends String> styleMap = this.createStyleMap();

    @JetMethod(flags=17, propertyType="Lkotlin/template/HtmlFormatter;")
    public final HtmlFormatter getFormatter() {
        return this.formatter;
    }

    @JetMethod(flags=17, propertyType="Lkotlin/template/HtmlFormatter;")
    public final void setFormatter(@JetValueParameter(name="<set-?>", type="Lkotlin/template/HtmlFormatter;") HtmlFormatter htmlFormatter) {
        this.formatter = htmlFormatter;
    }

    @JetMethod(flags=17, propertyType="Ljet/Map<?Lcom/intellij/psi/tree/IElementType;Ljava/lang/String;>;")
    public final Map<IElementType, String> getStyleMap() {
        return this.styleMap;
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String highlight(@JetValueParameter(name="code", type="Ljava/lang/String;") String code) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=\"code panel\" style=\"border-width: 1px\">" + "<div class=\"codeContent panelContent\">" + "<div class=\"container\">");
            int idx = 0;
            while (Character.isWhitespace(code.charAt(idx))) {
                ++idx;
            }
            if (idx > 0) {
                String space = KotlinPackage.substring((String)code, (int)0, (int)idx);
                builder.append("<code class=" + "\"" + "jet whitespace" + "\"" + ">" + space + "</code>");
            }
            JetLexer lexer = new JetLexer();
            lexer.start((CharSequence)code);
            int end = lexer.getTokenEnd();
            while (true) {
                Unit unit;
                lexer.advance();
                IElementType token = lexer.getTokenType();
                boolean bl = true;
                if (token != null) {
                    bl = false;
                }
                if (bl) break;
                String tokenText = KotlinPackage.replaceAll((String)String.valueOf(lexer.getTokenSequence()), (String)"\n", (String)"\r\n");
                String style = null;
                if (token instanceof JetKeywordToken) {
                    style = "keyword";
                } else if (Intrinsics.areEqual((Object)token, (Object)JetTokens.IDENTIFIER)) {
                    IElementType[] types = JetTokens.SOFT_KEYWORDS.getTypes();
                    boolean bl2 = true;
                    if (types == null) {
                        bl2 = false;
                    }
                    if (bl2) {
                        for (int i = 0; i < types.length; ++i) {
                            IElementType softKeyword = types[i];
                            if (!(softKeyword instanceof JetKeywordToken) || !Intrinsics.areEqual((Object)((JetKeywordToken)softKeyword).getValue(), (Object)tokenText)) continue;
                            style = "softkeyword";
                            break;
                        }
                    }
                    boolean bl3 = true;
                    if (style != null) {
                        bl3 = false;
                    }
                    style = bl3 ? "plain" : style;
                    unit = Unit.VALUE;
                } else if (this.styleMap.containsKey(token)) {
                    style = this.styleMap.get(token);
                    boolean bl4 = true;
                    if (style != null) {
                        bl4 = false;
                    }
                    if (bl4) {
                        IoPackage.println((Object)("Warning: No style for token " + token));
                    }
                    unit = Unit.VALUE;
                } else {
                    style = "plain";
                    unit = Unit.VALUE;
                }
                builder.append("<code class=" + "\"" + "jet " + style + "\"" + ">");
                this.formatter.format((Appendable)builder, tokenText);
                builder.append("</code>");
            }
            builder.append("</div>");
            builder.append("</div>");
            builder.append("</div>");
            String string = builder.toString();
            if (string == null) {
                string = "";
            }
            return string;
        }
        catch (Exception exception) {
            IoPackage.println((Object)("Warning: failed to parse code " + exception));
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=" + "\"" + "jet herror" + "\"" + ">Jet highlighter error [" + "\"" + exception.getClass().getSimpleName() + "\"" + "]: ");
            this.formatter.format((Appendable)builder, (Object)exception.getMessage());
            builder.append("<br/>");
            builder.append("Original text:");
            builder.append("<pre>");
            this.formatter.format((Appendable)builder, code);
            builder.append("</pre>");
            builder.append("</div>");
            String string = builder.toString();
            if (string == null) {
                string = "";
            }
            return string;
        }
    }

    @JetMethod(flags=32, returnType="Ljet/Map<?Lcom/intellij/psi/tree/IElementType;Ljava/lang/String;>;")
    protected final Map<IElementType, String> createStyleMap() {
        HashMap<Object, String> styleMap = new HashMap<Object, String>();
        SyntaxHighligher$createStyleMap$1 syntaxHighligher$createStyleMap$1 = new SyntaxHighligher$createStyleMap$1(styleMap);
        styleMap.put(JetTokens.BLOCK_COMMENT, "jet-comment");
        styleMap.put(JetTokens.DOC_COMMENT, "jet-comment");
        styleMap.put(JetTokens.EOL_COMMENT, "jet-comment");
        styleMap.put(JetTokens.WHITE_SPACE, "whitespace");
        styleMap.put(JetTokens.INTEGER_LITERAL, "number");
        styleMap.put(JetTokens.FLOAT_LITERAL, "number");
        styleMap.put(JetTokens.OPEN_QUOTE, "string");
        styleMap.put(JetTokens.REGULAR_STRING_PART, "string");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_END, "escape");
        styleMap.put(JetTokens.SHORT_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.CLOSING_QUOTE, "string");
        styleMap.put(JetTokens.CHARACTER_LITERAL, "string");
        styleMap.put(JetTokens.LABEL_IDENTIFIER, "label");
        styleMap.put(JetTokens.ATAT, "label");
        styleMap.put(JetTokens.FIELD_IDENTIFIER, "field");
        styleMap.put(TokenType.BAD_CHARACTER, "bad");
        ((Function2)syntaxHighligher$createStyleMap$1).invoke((Object)JetTokens.STRINGS, (Object)"string");
        ((Function2)syntaxHighligher$createStyleMap$1).invoke((Object)JetTokens.MODIFIER_KEYWORDS, (Object)"softkeyword");
        ((Function2)syntaxHighligher$createStyleMap$1).invoke((Object)JetTokens.SOFT_KEYWORDS, (Object)"softkeyword");
        ((Function2)syntaxHighligher$createStyleMap$1).invoke((Object)JetTokens.COMMENTS, (Object)"jet-comment");
        ((Function2)syntaxHighligher$createStyleMap$1).invoke((Object)JetTokens.OPERATIONS, (Object)"operation");
        return styleMap;
    }

    @JetConstructor
    public SyntaxHighligher() {
    }
}

