/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jet.Function1;
import jet.JetObject;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import org.jetbrains.kotlin.doc.KDocConfig$includePackage$1;
import org.jetbrains.kotlin.doc.LongestFirstStringComparator;
import org.jetbrains.kotlin.doc.model.KPackage;

@JetClass(signature="Ljava/lang/Object;", flags=16, abiVersion=6)
public final class KDocConfig
implements JetObject {
    private String docOutputDir = "target/site/apidocs";
    private String title = "Documentation";
    private String version = "SNAPSHOT";
    private final Map<String, String> packagePrefixToUrls = new TreeMap(new LongestFirstStringComparator());
    private final Set<String> ignorePackages = new HashSet();
    private boolean warnNoComments = 1;
    private String sourceRootHref;
    private String projectRootDir;
    private Map<String, String> packageDescriptionFiles = new HashMap();
    private Map<String, String> packageSummaryText = new HashMap();
    private boolean includeProtected = 1;
    private final Set<String> mutableMissingPackageUrls;
    private final Set<? extends String> missingPackageUrls;

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getDocOutputDir() {
        return this.docOutputDir;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final void setDocOutputDir(@JetValueParameter(name="<set-?>", type="Ljava/lang/String;") String string) {
        this.docOutputDir = string;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getTitle() {
        return this.title;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final void setTitle(@JetValueParameter(name="<set-?>", type="Ljava/lang/String;") String string) {
        this.title = string;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getVersion() {
        return this.version;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final void setVersion(@JetValueParameter(name="<set-?>", type="Ljava/lang/String;") String string) {
        this.version = string;
    }

    @JetMethod(flags=1, propertyType="Ljet/MutableMap<Ljava/lang/String;Ljava/lang/String;>;")
    public final Map<String, String> getPackagePrefixToUrls() {
        return this.packagePrefixToUrls;
    }

    @JetMethod(flags=1, propertyType="Ljet/MutableSet<Ljava/lang/String;>;")
    public final Set<String> getIgnorePackages() {
        return this.ignorePackages;
    }

    @JetMethod(flags=1, propertyType="Z")
    public final boolean getWarnNoComments() {
        return this.warnNoComments;
    }

    @JetMethod(flags=1, propertyType="Z")
    public final void setWarnNoComments(@JetValueParameter(name="<set-?>", type="Z") boolean bl) {
        this.warnNoComments = bl;
    }

    @JetMethod(flags=1, propertyType="?Ljava/lang/String;")
    public final String getSourceRootHref() {
        return this.sourceRootHref;
    }

    @JetMethod(flags=1, propertyType="?Ljava/lang/String;")
    public final void setSourceRootHref(@JetValueParameter(name="<set-?>", type="?Ljava/lang/String;") String string) {
        this.sourceRootHref = string;
    }

    @JetMethod(flags=1, propertyType="?Ljava/lang/String;")
    public final String getProjectRootDir() {
        return this.projectRootDir;
    }

    @JetMethod(flags=1, propertyType="?Ljava/lang/String;")
    public final void setProjectRootDir(@JetValueParameter(name="<set-?>", type="?Ljava/lang/String;") String string) {
        this.projectRootDir = string;
    }

    @JetMethod(flags=1, propertyType="Ljet/MutableMap<Ljava/lang/String;Ljava/lang/String;>;")
    public final Map<String, String> getPackageDescriptionFiles() {
        return this.packageDescriptionFiles;
    }

    @JetMethod(flags=1, propertyType="Ljet/MutableMap<Ljava/lang/String;Ljava/lang/String;>;")
    public final void setPackageDescriptionFiles(@JetValueParameter(name="<set-?>", type="Ljet/MutableMap<Ljava/lang/String;Ljava/lang/String;>;") Map<String, String> map) {
        this.packageDescriptionFiles = map;
    }

    @JetMethod(flags=1, propertyType="Ljet/MutableMap<Ljava/lang/String;Ljava/lang/String;>;")
    public final Map<String, String> getPackageSummaryText() {
        return this.packageSummaryText;
    }

    @JetMethod(flags=1, propertyType="Ljet/MutableMap<Ljava/lang/String;Ljava/lang/String;>;")
    public final void setPackageSummaryText(@JetValueParameter(name="<set-?>", type="Ljet/MutableMap<Ljava/lang/String;Ljava/lang/String;>;") Map<String, String> map) {
        this.packageSummaryText = map;
    }

    @JetMethod(flags=1, propertyType="Z")
    public final boolean getIncludeProtected() {
        return this.includeProtected;
    }

    @JetMethod(flags=1, propertyType="Z")
    public final void setIncludeProtected(@JetValueParameter(name="<set-?>", type="Z") boolean bl) {
        this.includeProtected = bl;
    }

    @JetMethod(flags=9, propertyType="Ljet/MutableSet<Ljava/lang/String;>;")
    private final Set<String> getMutableMissingPackageUrls() {
        return this.mutableMissingPackageUrls;
    }

    @JetMethod(flags=1, propertyType="Ljet/Set<Ljava/lang/String;>;")
    public final Set<String> getMissingPackageUrls() {
        return this.missingPackageUrls;
    }

    @JetMethod(flags=16, returnType="V")
    public final void addPackageLink(@JetValueParameter(name="url", type="Ljava/lang/String;") String url, String ... packagePrefixes) {
        for (int i = 0; i < packagePrefixes.length; ++i) {
            String p = packagePrefixes[i];
            this.packagePrefixToUrls.put(p, url);
        }
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String resolveLink(@JetValueParameter(name="packageName", type="Ljava/lang/String;") String packageName, @JetValueParameter(name="warn", hasDefaultValue=true, type="Z") boolean warn) {
        Iterator iterator = KotlinPackage.iterator(this.packagePrefixToUrls);
        while (iterator.hasNext()) {
            Map.Entry e = (Map.Entry)iterator.next();
            String p = (String)KotlinPackage.getKey((Map.Entry)e);
            String url = (String)KotlinPackage.getValue((Map.Entry)e);
            if (!KotlinPackage.startsWith((String)packageName, (String)p)) continue;
            return url;
        }
        if (warn ? this.mutableMissingPackageUrls.add(packageName) : false) {
            IoPackage.println((Object)("Warning: could not find external link to package: " + packageName));
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ String resolveLink$default(KDocConfig kDocConfig, String string, boolean bl, int n) {
        int n2;
        void var3_4;
        if ((var3_4 & 2) != 0) {
            n2 = 1;
        }
        return kDocConfig.resolveLink(string, n2 != 0);
    }

    @JetMethod(flags=16, returnType="Z")
    public final boolean includePackage(@JetValueParameter(name="pkg", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage pkg2) {
        return !KotlinPackage.any((Iterable)this.ignorePackages, (Function1)((Function1)new KDocConfig$includePackage$1(pkg2)));
    }

    @JetConstructor
    public KDocConfig() {
        this.addPackageLink("http://docs.oracle.com/javase/6/docs/api/", "java", "org.w3c.dom", "org.xml.sax", "org.omg", "org.ietf.jgss");
        this.addPackageLink("http://kentbeck.github.com/junit/javadoc/latest/", "org.junit", "junit");
        this.mutableMissingPackageUrls = new TreeSet();
        this.missingPackageUrls = this.mutableMissingPackageUrls;
    }
}

