/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.highlighter;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.template.HtmlFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetLexer;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighligher$createStyleMap$1;

@KotlinClass(abiVersion=14, data={"\t\u0006)\u00012+\u001f8uCbD\u0015n\u001a5mS\u001eDWM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*\u0019Am\\2\u000b\u0017!Lw\r\u001b7jO\"$XM\u001d\u0006\u0004\u0003:L(B\u0002\u001fj]&$hH\u0003\bde\u0016\fG/Z*us2,W*\u00199\u000b\u00075\u000b\u0007O\u0003\u0007J\u000b2,W.\u001a8u)f\u0004XMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0004aNL'\u0002\u0002;sK\u0016Taa\u0015;sS:<'\u0002\u00026bm\u0006TA!\u001e;jY*Iam\u001c:nCR$XM\u001d\u0006\u000e\u0011RlGNR8s[\u0006$H/\u001a:\u000b\u0011Q,W\u000e\u001d7bi\u0016TAbZ3u\r>\u0014X.\u0019;uKJTAb]3u\r>\u0014X.\u0019;uKJT\u0011\u0002[5hQ2Lw\r\u001b;\u000b\t\r|G-\u001a\u0006\u0005Y\u0006twM\u0003\u0005tifdW-T1q\u0015-9W\r^*us2,W*\u00199\u000f\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0002\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0019Aa\u0001E\u0005\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011%\u0001BB\u0003\u0003\t\u0015Ai!\u0002\u0002\u0005\f!9Qa\u0001\u0003\u0007\u0011\u0015a\u0001!B\u0002\u0005\u0007!=A\u0002A\u0003\u0002\u0011!)!\u0001b\u0004\t\u0012\u0015\u0011A\u0001\u0003E\u0005\u000b\t!1\u0001\u0003\u0006\u0006\u0007\u0011I\u00012\u0003\u0007\u0001\u000b\t!\u0011\u0002c\u0005\u0006\u0005\u0011=\u0001\u0012D\u0003\u0003\t+Ay\u0001\u0002\u0001\r\u0006e\u0011Q!\u0001E\u0004[K!!\u0001\u0007\u0003\"\u0017\u0015\t\u0001\u0002B\u0005\u0005\u0013\r)\u0011\u0001#\u0004\r\u0002%\u0019\u0011BA\u0003\u0002\u0011\u001d\t6a\u0001\u0003\u0005\u0013\u0005A\t\"L\u000b\u0005\u00014A\u0012\"\t\u0002\u0006\u0003!MQk\u0001\b\u0006\u0007\u0011I\u0011\"\u0001\u0005\u000b\u001b\r!)\"C\u0001\t\u0015E)AaC\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0006.'\u0011\u0001\u0001tCO\u0007\t\u0001AA\"\u0004\u0002\u0006\u0003!9\u0001k\u0001\u0001\"\u0005\u0015\t\u0001bB)\u0004\u000b\u0011]\u0011\"\u0001\u0005\f\u001b\u0005A1\"\f\r\u0005A\u0012AR\"I\u0006\u0006\u0003!!\u0011\u0002B\u0005\u0004\u000b\u0005Ai\u0001$\u0001\n\u0007%\u0011Q!\u0001\u0005\b+\u000eAQa\u0001\u0003\u000e\u0013\u0005A\t\"D\u0002\u0005\u001c%\t\u0001\u0012C\u001b\f\u000b)!1\u001d\u0001M\u0004C\t)\u0011\u0001#\u0002R\u0007\r!9!C\u0001\u0005\u0001\u0001"})
public final class SyntaxHighligher
implements KObject {
    @NotNull
    private HtmlFormatter formatter = new HtmlFormatter(null, 1);
    @NotNull
    private final Map<IElementType, ? extends String> styleMap = this.createStyleMap();

    @NotNull
    public final HtmlFormatter getFormatter() {
        return this.formatter;
    }

    @NotNull
    public final void setFormatter(@JetValueParameter(name="<set-?>") @NotNull HtmlFormatter htmlFormatter) {
        this.formatter = htmlFormatter;
    }

    @NotNull
    public final Map<IElementType, String> getStyleMap() {
        return this.styleMap;
    }

    @NotNull
    public final String highlight(@JetValueParameter(name="code") @NotNull String code) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=\"code panel\" style=\"border-width: 1px\">" + "<div class=\"codeContent panelContent\">" + "<div class=\"container\">");
            int idx = 0;
            while (Character.isWhitespace(code.charAt(idx))) {
                ++idx;
            }
            if (idx > 0) {
                String space = KotlinPackage.substring((String)code, (int)0, (int)idx);
                builder.append("<code class=" + "\"" + "jet whitespace" + "\"" + ">" + space + "</code>");
            }
            JetLexer lexer = new JetLexer();
            lexer.start((CharSequence)code);
            int end = lexer.getTokenEnd();
            while (true) {
                Unit unit;
                lexer.advance();
                IElementType token = lexer.getTokenType();
                boolean bl = true;
                if (token != null) {
                    bl = false;
                }
                if (bl) break;
                String tokenText = KotlinPackage.replaceAll((String)((Object)lexer.getTokenSequence()).toString(), (String)"\n", (String)"\r\n");
                String style = null;
                if (token instanceof JetKeywordToken) {
                    style = "keyword";
                } else if (Intrinsics.areEqual((Object)token, (Object)JetTokens.IDENTIFIER)) {
                    IElementType[] types = JetTokens.SOFT_KEYWORDS.getTypes();
                    boolean bl2 = true;
                    if (types == null) {
                        bl2 = false;
                    }
                    if (bl2) {
                        for (int i = 0; i < types.length; ++i) {
                            IElementType softKeyword = types[i];
                            if (!(softKeyword instanceof JetKeywordToken) || !Intrinsics.areEqual((Object)((JetKeywordToken)softKeyword).getValue(), (Object)tokenText)) continue;
                            style = "softkeyword";
                            break;
                        }
                    }
                    boolean bl3 = true;
                    if (style != null) {
                        bl3 = false;
                    }
                    style = bl3 ? "plain" : style;
                    unit = Unit.VALUE;
                } else if (this.styleMap.containsKey(token)) {
                    style = this.styleMap.get(token);
                    boolean bl4 = true;
                    if (style != null) {
                        bl4 = false;
                    }
                    if (bl4) {
                        IoPackage.println((Object)("Warning: No style for token " + token));
                    }
                    unit = Unit.VALUE;
                } else {
                    style = "plain";
                    unit = Unit.VALUE;
                }
                builder.append("<code class=" + "\"" + "jet " + style + "\"" + ">");
                this.formatter.format((Appendable)builder, tokenText);
                builder.append("</code>");
            }
            builder.append("</div>");
            builder.append("</div>");
            builder.append("</div>");
            String string = builder.toString();
            if (string == null) {
                string = "";
            }
            return string;
        }
        catch (Exception exception) {
            IoPackage.println((Object)("Warning: failed to parse code " + exception));
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=" + "\"" + "jet herror" + "\"" + ">Jet highlighter error [" + "\"" + exception.getClass().getSimpleName() + "\"" + "]: ");
            this.formatter.format((Appendable)builder, (Object)exception.getMessage());
            builder.append("<br/>");
            builder.append("Original text:");
            builder.append("<pre>");
            this.formatter.format((Appendable)builder, code);
            builder.append("</pre>");
            builder.append("</div>");
            String string = builder.toString();
            if (string == null) {
                string = "";
            }
            return string;
        }
    }

    @NotNull
    protected final Map<IElementType, String> createStyleMap() {
        HashMap<Object, String> styleMap = new HashMap<Object, String>();
        SyntaxHighligher$createStyleMap$1 syntaxHighligher$createStyleMap$1 = new SyntaxHighligher$createStyleMap$1(styleMap);
        styleMap.put(JetTokens.BLOCK_COMMENT, "jet-comment");
        styleMap.put(JetTokens.DOC_COMMENT, "jet-comment");
        styleMap.put(JetTokens.EOL_COMMENT, "jet-comment");
        styleMap.put(JetTokens.WHITE_SPACE, "whitespace");
        styleMap.put(JetTokens.INTEGER_LITERAL, "number");
        styleMap.put(JetTokens.FLOAT_LITERAL, "number");
        styleMap.put(JetTokens.OPEN_QUOTE, "string");
        styleMap.put(JetTokens.REGULAR_STRING_PART, "string");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_END, "escape");
        styleMap.put(JetTokens.SHORT_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.CLOSING_QUOTE, "string");
        styleMap.put(JetTokens.CHARACTER_LITERAL, "string");
        styleMap.put(JetTokens.LABEL_IDENTIFIER, "label");
        styleMap.put(JetTokens.ATAT, "label");
        styleMap.put(JetTokens.FIELD_IDENTIFIER, "field");
        styleMap.put(TokenType.BAD_CHARACTER, "bad");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.STRINGS, "string");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.MODIFIER_KEYWORDS, "softkeyword");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.SOFT_KEYWORDS, "softkeyword");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.COMMENTS, "jet-comment");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.OPERATIONS, "operation");
        return styleMap;
    }

    @NotNull
    public SyntaxHighligher() {
    }
}

