/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.templates;

import java.util.Collection;
import jet.JetObject;
import jet.KotlinClass;
import jet.runtime.typeinfo.JetValueParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.templates.ClassTemplate;

@KotlinClass(abiVersion=13, data={"-\u0006)92\t\\1tg\u0016CH/\u001a8tS>t7\u000fV3na2\fG/\u001a\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*\u0019Am\\2\u000b\u0013Q,W\u000e\u001d7bi\u0016\u001c(\"D\"mCN\u001cH+Z7qY\u0006$XM\u0003\u0004=S:LGO\u0010\u0006\u0002[*11*T8eK2TQ!\\8eK2T\u0011\u0001\u001d\u0006\t\u0017B\u000b7m[1hK*\t1N\u0003\u0004L\u00072\f7o\u001d\u0006\nMVt7\r^5p]NT!bQ8mY\u0016\u001cG/[8o\u0015\rQW\r\u001e\u0006\n\u0017\u001a+hn\u0019;j_:T!\u0002\u001d:pa\u0016\u0014H/[3t\u0015%Y\u0005K]8qKJ$\u0018P\u0003\u0003kCZ\f'\u0002B;uS2TAbZ3u\rVt7\r^5p]NTA\u0001\u001b:fM*\taM\u0003\u0004TiJLgn\u001a\u0006\u0005Y\u0006twMC\u0005qC\u001e,G+\u001b;mK*I\u0001O]5oi\n{G-\u001f\u0006\u0005+:LGOC\u0007hKR\u0004&o\u001c9feRLWm\u001d\u0006\u000fe\u0016d\u0017\r^5wKB\u0013XMZ5ya\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0002\u0005\u0005!\u0019A\u0002A\u0003\u0003\t\u0007AQ!B\u0002\u0005\b!%A\u0002A\u0003\u0004\t\u000fAa\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u0001b\u0002\u0007\u0001\u000b\u0005A\t\"B\u0002\u0005\f!AA\u0002A\u0003\u0004\t\u000fA\u0011\u0002\u0004\u0001\u0006\u0007\u0011\u001d\u0001B\u0003\u0007\u0001\u000b\t!9\u0001#\u0003\u0006\u0005\u0011\u001d\u0001BB\u0003\u0003\t\u000fAq!B\u0001\t\u0016\u0015\u0011A!\u0003\u0005\f\u000b\t!\u0019\u0002\u0003\u0005\u0006\u0007\u0011-\u0001\"\u0004\u0007\u0001\u000b\t!\u0011\u0002c\u0007\u0006\u0005\u0011Y\u0001\"D\u0003\u0003\t\u000fA\u0011\"\u0002\u0002\u0005\b!QQa\u0001C\u0006\u0011=a\u0001\u0001\u0002\u0001\r\u0006e\u0011Q!\u0001\u0005\u0004[M!\u0001\r\u0002M\bC\u0019)\u0011\u0001\u0003\u0004\n\u0007%\u0011Q!\u0001E\u0007+\u000eAQa\u0001C\b\u0013\u0005A!\"D\u0002\u0005\u0018%\t\u0001BC\u0017\u0014\t!AB\"(\u0004\u0005\u0001!eQBA\u0003\u0002\u0011\u001b\u00016\u0001A\u0011\u0003\u000b\u0005A)\"U\u0002\u0006\t1I\u0011\u0001c\u0006\u000e\u0003!aQf\u0005\u0003\t11ij\u0001\u0002\u0001\t\u001a5\u0011Q!\u0001\u0005\b!\u000e\u0001\u0011EA\u0003\u0002\u0011+\t6!\u0002\u0003\r\u0013\u0005A9\"D\u0001\t\u001a5NA\u0001\u0003\r\u000fC\t)\u0011\u0001#\u0006R\u0007\r!a\"C\u0001\t\u00185NA\u0001\u0003M\u000fC\t)\u0011\u0001C\u0007R\u0007\r!i\"C\u0001\u0005\u00015\u001aB\u0001\u0019\u0003\u0019\u0014\u00052Q!\u0001\u0005\u0007\u0013\rI!!B\u0001\t\u000fU\u001b\u0001\"B\u0002\u0005\u0014%\t\u0001BC\u0007\u0004\t?I\u0011\u0001\u0003\u0006.\u0014\u0011Q\u0001\u0004E\u0011\u0003\u000b\u0005A)\"U\u0002\u0004\tAI\u0011\u0001c\u00066\u0007\u0004)\u0019\u0019\u0001\u0003d\u0002a\u001dQT\u0002\u0003\u0001\u0011\u0011i!!B\u0001\t\tA\u001b\u0001!(\u0004\u0005\u0001!-QBA\u0003\u0002\u0011\u0013\u00016\u0011AO\u0007\t\u0001Ai!\u0004\u0002\u0006\u0003!)\u0001kA\u0001\u001e\u0016\u0011\u0001\u0001rB\u0007\u0007\u000b\u0005Aa!C\u0002\n\u0005\u0015\t\u0001R\u0002)\u0004\u0004uUA\u0001\u0001E\n\u001b\u0019)\u0011\u0001\u0003\u0004\n\u0007%\u0011Q!\u0001\u0005\b!\u000e\u0011\u0011EA\u0003\u0002\u0011\u000b\t6!\u0004C\u0004\u0013\u0005!\u0001!D\u0001\t\u00105\t\u0001\u0002C\u0007\u0002\u0011#i\u0011\u0001\u0003\u0006\u000e\u0003!Q\u0001"})
public final class ClassExtensionsTemplate
extends ClassTemplate
implements JetObject {
    @NotNull
    private final Collection<? extends KFunction> functions;
    @NotNull
    private final Collection<? extends KProperty> properties;

    @Override
    @NotNull
    protected String relativePrefix() {
        return this.getPkg().getNameAsRelativePath() + this.getKlass().getPkg().getNameAsRelativePath();
    }

    @Override
    @NotNull
    public String pageTitle() {
        return this.getKlass().getName() + " Extensions fom " + this.getPkg().getName() + " (" + this.getModel().getTitle() + ")";
    }

    @Override
    @NotNull
    public void printBody() {
        this.println("<HR>" + "\n" + "<!-- ======== START OF CLASS EXTENSIONS DATA ======== -->" + "\n" + "<H2>" + "\n" + "<FONT SIZE=" + "\"" + "-1" + "\"" + ">" + "\n" + this.getPkg().getName() + "</FONT>" + "\n" + "<BR>" + "\n" + "Extensions on " + this.getKlass().getName() + "</H2>" + "\n" + "<DL>" + "\n" + "<DT>" + "\n" + "extension functions on class <A HREF=" + "\"" + this.sourceHref(this.getKlass()) + "\"" + this.getKlass().sourceTargetAttribute() + "><B>" + this.getKlass().getName() + "</B></A><DT>" + "\n" + "from package " + this.link(this.getPkg()) + "\n" + "</DL>" + "\n" + "</PRE>" + "\n" + "\n" + "<P>");
        this.printPropertySummary(this.properties);
        this.printFunctionSummary(this.functions);
        this.printFunctionDetail(this.functions);
        this.println("<!-- ========= END OF CLASS EXTENSIONS DATA ========= -->\n<HR>\n");
    }

    @Override
    @NotNull
    public String href(@JetValueParameter(name="f") @NotNull KFunction f2) {
        boolean bl = true;
        if (f2.getExtensionClass() == null) {
            bl = false;
        }
        return bl ? "#" + f2.getLink() : super.href(f2);
    }

    @Override
    @NotNull
    public String href(@JetValueParameter(name="f") @NotNull KProperty f2) {
        boolean bl = true;
        if (f2.getExtensionClass() == null) {
            bl = false;
        }
        return bl ? "#" + f2.getLink() : super.href(f2);
    }

    @NotNull
    public final Collection<KFunction> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final Collection<KProperty> getProperties() {
        return this.properties;
    }

    @NotNull
    public ClassExtensionsTemplate(@JetValueParameter(name="m") @NotNull KModel m, @JetValueParameter(name="p") @NotNull KPackage p, @JetValueParameter(name="k") @NotNull KClass k, @JetValueParameter(name="functions") @NotNull Collection<? extends KFunction> functions2, @JetValueParameter(name="properties") @NotNull Collection<? extends KProperty> properties) {
        super(m, p, k);
        this.functions = functions2;
        this.properties = properties;
    }
}

