/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.highlighter;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import jet.JetObject;
import jet.KotlinClass;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import kotlin.template.HtmlFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetLexer;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighligher$createStyleMap$1;

@KotlinClass(abiVersion=11, data={"\u000e\u0006)\u00012+\u001f8uCbD\u0015n\u001a5mS\u001eDWM\u001d\u0006\fQ&<\u0007\u000e\\5hQR,'OC\u0002e_\u000eTaa[8uY&t'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\ry'o\u001a\u0006\u0004\u0003:L(b\u00016fi*1A(\u001b8jizRab\u0019:fCR,7\u000b^=mK6\u000b\u0007OC\u0002NCBTA\"S#mK6,g\u000e\u001e+za\u0016TA\u0001\u001e:fK*\u0019\u0001o]5\u000b\u0011%tG/\u001a7mS*T1aY8n\u0015\u0019\u0019FO]5oO*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\u0013\u0019|'/\\1ui\u0016\u0014(\"\u0004%u[24uN]7biR,'O\u0003\u0005uK6\u0004H.\u0019;f\u001519W\r\u001e$pe6\fG\u000f^3s\u00151\u0019X\r\u001e$pe6\fG\u000f^3s\u0015%A\u0017n\u001a5mS\u001eDGO\u0003\u0003d_\u0012,'\u0002\u00027b]\u001eT\u0001b\u001d;zY\u0016l\u0015\r\u001d\u0006\fO\u0016$8\u000b^=mK6\u000b\u0007Oe\u0001\u000b\u0005A)!\u0002\u0002\u0005\u0001!\u0011QA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0003\u0015\u0011A1\u0001E\u0001\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\t\u0001rA\u0003\u0004\t\rA1\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001\"\u0002\u0007\u0001\u000b\u0005Ay!\u0002\u0002\u0005\n!9QA\u0001\u0003\u0006\u0011\u001b)!\u0001b\u0003\t\r\u0015\u0019AA\u0002E\u0006\u0019\u0001)1\u0001B\u0002\t\u00111\u0001Q!\u0001E\t\u000b\t!y\u0001C\u0005\u0006\u0005\u0011A\u0001\"B\u0003\u0002\u0011\u0007)!\u0001B\u0005\t\u0016\u0015\u0019A1\u0003\u0005\u000b\u0019\u0001)!\u0001b\u0005\t\u0015\u0015\u0011Aq\u0002\u0005\u000e\u000b\t!1\u0002\u0003\u0005\u0005\u00011\u0015\u0011DA\u0003\u0002\u0011\u000fI#\u0002Br\u00011\u0011\t#!B\u0001\t\u0006E\u001b1\u0001\u0002\u0003\n\u0003\u0011\u0001QV\u0005\u0003\u00031\u0013\t3\"B\u0001\t\t%!\u0011bA\u0003\u0002\u0011\u001ba\t!C\u0002\n\u0005\u0015\t\u0001bB)\u0004\u0007\u0011%\u0011\"\u0001E\t[U!\u0001\u0019\rM\nC\t)\u0011\u0001\u0003\u0006V\u00079)1\u0001b\u0005\n\u0003!UQb\u0001\u0003\f\u0013\u0005A)\"E\u0003\u0005\u0018%\tA\u0001A\u0007\u0002\u0011+i3\u0003\u0002\u0001\u0019\u0019u5A\u0001\u0001E\r\u001b\t)\u0011\u0001C\u0004Q\u0007\u0001\t#!B\u0001\t\u000fE\u001bQ\u0001\u0002\u0007\n\u0003!]Q\"\u0001E\f[a!\u0001\r\u0005M\u000eC-)\u0011\u0001\u0003\u0003\n\t%\u0019Q!\u0001E\u0007\u0019\u0003I1!\u0003\u0002\u0006\u0003!9Qk\u0001\u0005\u0006\u0007\u0011m\u0011\"\u0001E\t\u001b\r!a\"C\u0001\t\u0012\u0001"})
public final class SyntaxHighligher
implements JetObject {
    @NotNull
    private HtmlFormatter formatter = new HtmlFormatter(null, 1);
    @NotNull
    private final Map<IElementType, ? extends String> styleMap = this.createStyleMap();

    @NotNull
    public final HtmlFormatter getFormatter() {
        return this.formatter;
    }

    @NotNull
    public final void setFormatter(@JetValueParameter(name="<set-?>") @NotNull HtmlFormatter htmlFormatter) {
        this.formatter = htmlFormatter;
    }

    @NotNull
    public final Map<IElementType, String> getStyleMap() {
        return this.styleMap;
    }

    @NotNull
    public final String highlight(@JetValueParameter(name="code") @NotNull String code) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=\"code panel\" style=\"border-width: 1px\">" + "<div class=\"codeContent panelContent\">" + "<div class=\"container\">");
            int idx = 0;
            while (Character.isWhitespace(code.charAt(idx))) {
                ++idx;
            }
            if (idx > 0) {
                String space = KotlinPackage.substring((String)code, (int)0, (int)idx);
                builder.append("<code class=" + "\"" + "jet whitespace" + "\"" + ">" + space + "</code>");
            }
            JetLexer lexer = new JetLexer();
            lexer.start((CharSequence)code);
            int end = lexer.getTokenEnd();
            while (true) {
                Unit unit;
                lexer.advance();
                IElementType token = lexer.getTokenType();
                boolean bl = true;
                if (token != null) {
                    bl = false;
                }
                if (bl) break;
                String tokenText = KotlinPackage.replaceAll((String)lexer.getTokenSequence().toString(), (String)"\n", (String)"\r\n");
                String style = null;
                if (token instanceof JetKeywordToken) {
                    style = "keyword";
                } else if (Intrinsics.areEqual((Object)token, (Object)JetTokens.IDENTIFIER)) {
                    IElementType[] types = JetTokens.SOFT_KEYWORDS.getTypes();
                    boolean bl2 = true;
                    if (types == null) {
                        bl2 = false;
                    }
                    if (bl2) {
                        for (int i = 0; i < types.length; ++i) {
                            IElementType softKeyword = types[i];
                            if (!(softKeyword instanceof JetKeywordToken) || !Intrinsics.areEqual((Object)((JetKeywordToken)softKeyword).getValue(), (Object)tokenText)) continue;
                            style = "softkeyword";
                            break;
                        }
                    }
                    boolean bl3 = true;
                    if (style != null) {
                        bl3 = false;
                    }
                    style = bl3 ? "plain" : style;
                    unit = Unit.VALUE;
                } else if (this.styleMap.containsKey(token)) {
                    style = this.styleMap.get(token);
                    boolean bl4 = true;
                    if (style != null) {
                        bl4 = false;
                    }
                    if (bl4) {
                        IoPackage.println((Object)("Warning: No style for token " + token));
                    }
                    unit = Unit.VALUE;
                } else {
                    style = "plain";
                    unit = Unit.VALUE;
                }
                builder.append("<code class=" + "\"" + "jet " + style + "\"" + ">");
                this.formatter.format((Appendable)builder, tokenText);
                builder.append("</code>");
            }
            builder.append("</div>");
            builder.append("</div>");
            builder.append("</div>");
            String string = builder.toString();
            if (string == null) {
                string = "";
            }
            return string;
        }
        catch (Exception exception) {
            IoPackage.println((Object)("Warning: failed to parse code " + exception));
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=" + "\"" + "jet herror" + "\"" + ">Jet highlighter error [" + "\"" + exception.getClass().getSimpleName() + "\"" + "]: ");
            this.formatter.format((Appendable)builder, (Object)exception.getMessage());
            builder.append("<br/>");
            builder.append("Original text:");
            builder.append("<pre>");
            this.formatter.format((Appendable)builder, code);
            builder.append("</pre>");
            builder.append("</div>");
            String string = builder.toString();
            if (string == null) {
                string = "";
            }
            return string;
        }
    }

    @NotNull
    protected final Map<IElementType, String> createStyleMap() {
        HashMap<Object, String> styleMap = new HashMap<Object, String>();
        SyntaxHighligher$createStyleMap$1 syntaxHighligher$createStyleMap$1 = new SyntaxHighligher$createStyleMap$1(styleMap);
        styleMap.put(JetTokens.BLOCK_COMMENT, "jet-comment");
        styleMap.put(JetTokens.DOC_COMMENT, "jet-comment");
        styleMap.put(JetTokens.EOL_COMMENT, "jet-comment");
        styleMap.put(JetTokens.WHITE_SPACE, "whitespace");
        styleMap.put(JetTokens.INTEGER_LITERAL, "number");
        styleMap.put(JetTokens.FLOAT_LITERAL, "number");
        styleMap.put(JetTokens.OPEN_QUOTE, "string");
        styleMap.put(JetTokens.REGULAR_STRING_PART, "string");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_END, "escape");
        styleMap.put(JetTokens.SHORT_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.CLOSING_QUOTE, "string");
        styleMap.put(JetTokens.CHARACTER_LITERAL, "string");
        styleMap.put(JetTokens.LABEL_IDENTIFIER, "label");
        styleMap.put(JetTokens.ATAT, "label");
        styleMap.put(JetTokens.FIELD_IDENTIFIER, "field");
        styleMap.put(TokenType.BAD_CHARACTER, "bad");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.STRINGS, "string");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.MODIFIER_KEYWORDS, "softkeyword");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.SOFT_KEYWORDS, "softkeyword");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.COMMENTS, "jet-comment");
        syntaxHighligher$createStyleMap$1.invoke(JetTokens.OPERATIONS, "operation");
        return styleMap;
    }

    @NotNull
    public SyntaxHighligher() {
    }
}

