/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.templates;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.Function1;
import jet.JetObject;
import jet.KotlinClass;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.ModelPackage-KotlinModel-508284e7;
import org.jetbrains.kotlin.doc.templates.PackageFrameTemplate$printClasses$classes$1;
import org.jetbrains.kotlin.doc.templates.PackageTemplateSupport;

@KotlinClass(abiVersion=11, data={"\u000e\u0006)!\u0002+Y2lC\u001e,gI]1nKR+W\u000e\u001d7bi\u0016T\u0011\u0002^3na2\fG/Z:\u000b\u0007\u0011|7M\u0003\u0004l_Rd\u0017N\u001c\u0006\nU\u0016$(M]1j]NT1a\u001c:h\u0015Y\u0001\u0016mY6bO\u0016$V-\u001c9mCR,7+\u001e9q_J$(B\u0002\u001fj]&$hHC\u0003n_\u0012,GN\u0003\u0004L\u001b>$W\r\u001c\u0006\u0002a*A1\nU1dW\u0006<WM\u0003\u0005hKRlu\u000eZ3m\u00151\u0001(/\u001b8u\u00072\f7o]3t\u0015\u0011Y\u0017N\u001c3\u000b\rM#(/\u001b8h\u0015\rQW\r\u001e\u0006\fI\u0016\u001c8M]5qi&|gN\u0003\u0003V]&$(\u0002\u00026bm\u0006TA\u0001\\1oO*9\u0002O]5oi\u0016CH/\u001a8tS>tg)\u001e8di&|gn\u001d\u0006\u000faJLg\u000e\u001e$v]\u000e$\u0018n\u001c8t\u0015Y\u0001(/\u001b8u!\u0006\u001c7.Y4f!J|\u0007/\u001a:uS\u0016\u001c(B\u0002:f]\u0012,'O\u001d\u0006\u0003!\u0015QA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0002\u000b\t!\u0019\u0001#\u0001\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\r!!\u0001C\u0002\r\u0001\u0015\u0011A1\u0001\u0005\u0005\u000b\r!9\u0001#\u0003\r\u0001\u0015\u0019Aq\u0001E\u0006\u0019\u0001)!\u0001b\u0002\t\n\u0015\u0011Aq\u0001E\u0006\u000b\u0005A\u0001\"B\u0002\u0005\r!=A\u0002A\u0003\u0004\t\u0019A\u0011\u0002\u0004\u0001\u0006\u0003!MQA\u0001C\b\u0011))!\u0001\u0002\u0005\t\u0010\u0011\u0001ARA\r\u0003\u000b\u0005A1!K\u000f\u0005G\u0004A:!(\u0004\u0005\u0001!!QBA\u0003\u0002\u0011\u0011\u00016\u0001AO\u0007\t\u0001AQ!\u0004\u0002\u0006\u0003!%\u0001k!\u0001\"\u0005\u0015\t\u0001RA)\u0004\u000f\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005AQ!D\u0001\t\f5zA\u0001\u0019\t\u0019\t\u0005\u0012Q!\u0001\u0005\u0005+\u000eAQa\u0001\u0003\u0005\u0013\u0005AQ!D\u0002\u0005\r%\t\u0001\"BW\u001d\t\tAj!(\u0004\u0005\u0001!9QBA\u0003\u0002\u0011\u001b\u00016\u0001AO\u0007\t\u0001A\t\"\u0004\u0002\u0006\u0003!5\u0001k!\u0001\"\u0005\u0015\t\u0001bB)\u0004\u000f\u00115\u0011\"\u0001\u0003\u0001\u001b\u0005A\t\"D\u0001\t\u00125NAA\u0001M\u000bC\t)\u0011\u0001C\u0004R\u0007\r!)\"C\u0001\u0005\u00015NAA\u0001\r\fC\t)\u0011\u0001C\u0004R\u0007\r!1\"C\u0001\u0005\u00015NAA\u0001M\fC\t)\u0011\u0001C\u0004R\u0007\r!9\"C\u0001\u0005\u00015NA\u0001\u0003\r\rC\t)\u0011\u0001C\u0004R\u0007\r!A\"C\u0001\u0005\u0001\u0001"})
public final class PackageFrameTemplate
extends PackageTemplateSupport
implements JetObject {
    private final KModel model;

    @Override
    public void render() {
        this.println("<!DOCTYPE HTML PUBLIC " + "\"" + "-//W3C//DTD HTML 4.01 Transitional//EN" + "\"" + " " + "\"" + "http://www.w3.org/TR/html4/loose.dtd" + "\"" + ">" + "\n" + "<!--NewPage-->" + "\n" + "<HTML>" + "\n" + "<HEAD>" + "\n" + this.getGeneratedComment() + "\n" + "<META http-equiv=" + "\"" + "Content-Type" + "\"" + " content=" + "\"" + "text/html; charset=UTF-8" + "\"" + ">" + "\n" + "<TITLE>" + "\n" + this.getPkg().getName() + " (" + this.model.getTitle() + ")" + "\n" + "</TITLE>" + "\n" + "\n" + "<META NAME=" + "\"" + "date" + "\"" + " CONTENT=" + "\"" + "2012-01-09" + "\"" + ">" + "\n" + this.stylesheets() + "\n" + "\n" + "</HEAD>" + "\n" + "\n" + "<BODY BGCOLOR=" + "\"" + "white" + "\"" + ">" + "\n" + "<FONT size=" + "\"" + "+1" + "\"" + " CLASS=" + "\"" + "FrameTitleFont" + "\"" + ">" + "\n" + "<A HREF=" + "\"" + this.getPkg().getNameAsRelativePath() + this.getPkg().getNameAsPath() + "/package-summary.html" + "\"" + " target=" + "\"" + "classFrame" + "\"" + ">" + this.getPkg().getName() + "</A></FONT>");
        this.printClasses("trait", "Traits");
        this.printClasses("class", "Classes");
        this.printClasses("enum", "Enums");
        this.printClasses("annotation", "Annotations");
        this.printClasses("exception", "Exceptions");
        this.printPackageProperties();
        this.printFunctions();
        this.printExtensionFunctions();
        this.println("</BODY>\n</HTML>");
    }

    protected final void printClasses(@JetValueParameter(name="kind") String kind, @JetValueParameter(name="description") String description) {
        List classes2 = KotlinPackage.filter((Iterable)this.getPkg().getClasses(), (Function1)((Function1)new PackageFrameTemplate$printClasses$classes$1(kind)));
        if (!classes2.isEmpty()) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">");
            this.print(description);
            this.println("</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            for (KClass c : classes2) {
                String formatted = Intrinsics.areEqual((Object)kind, (Object)"interface") ? "<I>" + c.getSimpleName() + "</I>" : c.getSimpleName();
                this.println("<A HREF=" + "\"" + c.getSimpleName() + ".html" + "\"" + " title=" + "\"" + kind + " in " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + ">" + formatted + "</A>" + "\n" + "<BR>");
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    protected final void printFunctions() {
        Collection<KFunction> functions2 = ModelPackage-KotlinModel-508284e7.filterDuplicateNames((Collection<? extends KFunction>)this.getPkg().packageFunctions());
        if (!functions2.isEmpty()) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Functions</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            String lastName = "";
            for (KFunction c : functions2) {
                if (Intrinsics.areEqual((Object)c.getName(), (Object)lastName) ^ true) {
                    this.println("<A HREF=" + "\"" + this.href(c) + "\"" + " title=" + "\"" + "function in " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + "><I>" + c.getName() + "</I></A>" + "\n" + "    <BR>");
                }
                lastName = c.getName();
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    protected final void printExtensionFunctions() {
        Map<KClass, List<? extends KFunction>> map = ModelPackage-KotlinModel-508284e7.extensionFunctions((Collection<? extends KFunction>)((KClassOrPackage)this.getPkg()).getFunctions());
        if (!map.isEmpty()) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Extensions</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            Iterator iterator = KotlinPackage.iterator(map);
            while (iterator.hasNext()) {
                Map.Entry e = (Map.Entry)iterator.next();
                KClass c = (KClass)KotlinPackage.getKey((Map.Entry)e);
                boolean bl = true;
                if (c == null) {
                    bl = false;
                }
                if (!bl) continue;
                this.println("<A HREF=" + "\"" + this.extensionsHref(this.getPkg(), c) + "\"" + " title=" + "\"" + "extensions functions on class " + c.getName() + " from " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + "><I>" + c.getName() + "</I></A>" + "\n" + "<BR>");
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    protected final void printPackageProperties() {
        List<KProperty> list = this.getPkg().packageProperties();
        if (KotlinPackage.isNotEmpty((Collection)list)) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Properties</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            for (KProperty c : list) {
                boolean bl = true;
                if (c == null) {
                    bl = false;
                }
                if (!bl) continue;
                this.println("<A HREF=" + "\"" + this.href(this.getPkg(), c) + "\"" + " title=" + "\"" + "property from " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + "><I>" + c.getName() + "</I></A>" + "\n" + "<BR>");
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    public final KModel getModel() {
        return this.model;
    }

    public PackageFrameTemplate(@JetValueParameter(name="model") KModel model, @JetValueParameter(name="p") KPackage p) {
        super(p);
        this.model = model;
    }
}

