/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.Function0;
import jet.Function1;
import jet.JetObject;
import jet.KotlinClass;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.SharedVar;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.kotlin.doc.DocPackage-collections-b8ec3894;
import org.jetbrains.kotlin.doc.KDocConfig;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighligher;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel$1;
import org.jetbrains.kotlin.doc.model.KModel$2;
import org.jetbrains.kotlin.doc.model.KModel$classes$1;
import org.jetbrains.kotlin.doc.model.KModel$findFunctionInclude$sourceLine$1;
import org.jetbrains.kotlin.doc.model.KModel$getPackage$pkg$1;
import org.jetbrains.kotlin.doc.model.KModel$normalizedSourceDirs$1;
import org.jetbrains.kotlin.doc.model.KModel$packages$1;
import org.jetbrains.kotlin.doc.model.KModel$sourceInfoByFile$1;
import org.jetbrains.kotlin.doc.model.KModel$tryLoadReadMe$f$1;
import org.jetbrains.kotlin.doc.model.KModel$tryLoadReadMe$f$2;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.model.ModelPackage-KotlinModel-508284e7;
import org.jetbrains.kotlin.doc.model.SourceInfo;
import org.pegdown.Extensions;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;

@KotlinClass(abiVersion=11, data={"Z\u001e)11*T8eK2TQ!\\8eK2T1\u0001Z8d\u0015\u0019Yw\u000e\u001e7j]*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0004_J<'bA!os*\u0019!.\u001a;\u000b\rqJg.\u001b;?\u0015\u001d\u0019wN\u001c;fqRTaBQ5oI&twmQ8oi\u0016DHOC\u0004sKN|GN^3\u000b\t1\fgn\u001a\u0006\u0007G>tg-[4\u000b\u0015-#unY\"p]\u001aLwM\u0003\u0006t_V\u00148-\u001a#jeNTA\u0001T5ti*!a)\u001b7f\u0015\tIwN\u0003\u0003kCZ\f'bB:pkJ\u001cWm\u001d\u0006\b\u0015\u0016$h)\u001b7f\u0015\r\u00018/\u001b\u0006\u0005kRLGNC\b`aJ|'.Z2u%>|G\u000fR5s\u0015\u0019\u0019FO]5oO*\u0011r-\u001a;`aJ|'.Z2u%>|G\u000fR5s\u0015I\u0019X\r^0qe>TWm\u0019;S_>$H)\u001b:\u000b\u0019\u0005$GMR;oGRLwN\\:\u000b\u000b=<h.\u001a:\u000b\u001f-\u001bE.Y:t\u001fJ\u0004\u0016mY6bO\u0016TQa]2pa\u0016T\u0001BS3u'\u000e|\u0007/\u001a\u0006\u0007g\u000e|\u0007/Z:\u000b\tUs\u0017\u000e\u001e\u0006\u0012C\u0012$G+\u001f9f!\u0006\u0014\u0018-\\3uKJ\u001c(BB1og^,'OC\u0006NkR\f'\r\\3MSN$(BD&UsB,\u0007+\u0019:b[\u0016$XM\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148OC\fUsB,\u0007+\u0019:b[\u0016$XM\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe*Y\u0011\r\u001c7QC\u000e\\\u0017mZ3t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\t\u0017B\u000b7m[1hK*qq-\u001a;BY2\u0004\u0016mY6bO\u0016\u001c(bB2mCN\u001cXm\u001d\u0006\u0007\u0017\u000ec\u0017m]:\u000b\u0015\u001d,Go\u00117bgN,7OC\u0006d_6lWM\u001c;t\r>\u0014(B\u00033fg\u000e\u0014\u0018\u000e\u001d;pe*)B)Z2mCJ\fG/[8o\t\u0016\u001c8M]5qi>\u0014(\"C4fi\u000e{gNZ5h\u0015E\u0019wN\u001c4jOV\u0014XmQ8n[\u0016tGo\u001d\u0006\nC:tw\u000e^1uK\u0012T!bS!o]>$\u0018\r^3e\u0015)9W\r^\"p]R,\u0007\u0010\u001e\u0006\u000fGJ,\u0017\r^3Gk:\u001cG/[8o\u0015I\u0019\u0015\r\u001c7bE2,G)Z:de&\u0004Ho\u001c:\u000b\u0013-3UO\\2uS>t'bD2sK\u0006$X\rU1sC6,G/\u001a:\u000b1Y\u000bG.^3QCJ\fW.\u001a;fe\u0012+7o\u0019:jaR|'O\u0003\u0006L!\u0006\u0014\u0018-\\3uKJT1c\u0019:fCR,G+\u001f9f!\u0006\u0014\u0018-\\3uKJTA\"\u001a=ue\u0006\u001cGO\u00117pG.TA\u0001^3yi*9a-\u001b7f\r>\u0014(\u0002\u00034jY\u0016\u0004\u0016\r\u001e5\u000b\t\u0019LG.\u001a\u0006\u0012!NLg)\u001b7f'f\u001cH/Z7Ji\u0016l'\u0002C5oi\u0016dG.\u001b6\u000b\u0007\r|WNC\ngS:$g)\u001e8di&|g.\u00138dYV$WM\u0003\u0006qg&,E.Z7f]RT!\u0002U:j\u000b2,W.\u001a8u\u0015-Ign\u00197vI\u00164\u0015\u000e\\3\u000b\u0019\u0019,hn\u0019;j_:t\u0015-\\3\u000b\u0011\u001d,Go\u00117bgNTAb\u00197bgN,E.Z7f]RTqb\u00117bgN$Um]2sSB$xN\u001d\u0006\u000ecV\fG.\u001b4jK\u0012t\u0015-\\3\u000b\u0015\u001d,G\u000fU1dW\u0006<WMC\nOC6,7\u000f]1dK\u0012+7o\u0019:jaR|'O\u0003\u0003oC6,'\"D4fiB\u001b\u0018.\u00127f[\u0016tGOC\u0004hKR$\u0016\u0010]3\u000b\u000b\u0005$\u0016\u0010]3\u000b\u000f)+G\u000fV=qK*)A/\u001f9fg*)1\nV=qK*Y\u0001.[4iY&<\u0007\u000e^3s\u0015A\u0019\u0016P\u001c;bq\"Kw\r\u001b7jO\",'O\u0003\bhKRD\u0015n\u001a5mS\u001eDG/\u001a:\u000b\u001dM,G\u000fS5hQ2Lw\r\u001b;fe*9\u0011n\u001d'pG\u0006d'b\u0002\"p_2,\u0017M\u001c\u0006\u0014Y>\fGmV5lS\u0012+7o\u0019:jaRLwN\u001c\u0006\u0004a.<'b\u00037pG\u0006$\u0018n\u001c8G_JTQ\u0002T5oK\u0006sGmQ8mk6t'b\u0004#jC\u001etwn\u001d;jGV#\u0018\u000e\\:\u000b\u0017\u0011L\u0017m\u001a8pgRL7m\u001d\u0006\u001e\t&\fwM\\8ti&\u001cW\u000b^5mg\u0012b\u0015N\\3B]\u0012\u001cu\u000e\\;n]*\tR.\u0019:lI><h\u000e\u0015:pG\u0016\u001c8o\u001c:\u000b!A+w\rR8x]B\u0013xnY3tg>\u0014(b\u00029fO\u0012|wO\u001c\u0006\u0015O\u0016$X*\u0019:lI><h\u000e\u0015:pG\u0016\u001c8o\u001c:\u000b)M,G/T1sW\u0012|wO\u001c)s_\u000e,7o]8s\u0015\u0011qW\r\u001f;\u000b/A\f7m[1hK\u0012+7o\u0019:jaRLwN\u001c$jY\u0016\u001c(\"C!se\u0006LH*[:u\u0015i9W\r\u001e)bG.\fw-\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:4\u0015\u000e\\3t\u0015)\u0001\u0018mY6bO\u0016l\u0015\r\u001d\u0006\n'>\u0014H/\u001a3NCBTQbZ3u!\u0006\u001c7.Y4f\u001b\u0006\u0004(\u0002\u00039bG.\fw-Z:\u000b\u0017\u001d,G\u000fU1dW\u0006<Wm\u001d\u0006\taJ,g/[8vg*i\u0001O]8dKN\u001cX*Y2s_NT!\u0003^3yi^KG\u000f[,iSR,7\u000f]1dK*q\u0001O]8kK\u000e$(k\\8u\t&\u0014(\"\u0005:fC\u0012lU\rR5sgN\u001b\u0017M\u001c8fI*9\u0001*Y:i'\u0016$(\u0002F4fiJ+\u0017\rZ'f\t&\u00148oU2b]:,GM\u0003\u0007sK2\fG/\u001b<f\r&dWMC\u0005eSJ,7\r^8ss*a\u0001k]5ESJ,7\r^8ss*a!/\u001a7bi&4XMT1nK*9\u0001k]5GS2,'\"D4fiN{WO]2f\t&\u00148O\u0003\tt_V\u00148-Z%oM>\u0014\u0015PR5mK*Q1k\\;sG\u0016LeNZ8\u000b\u00075\u000b\u0007OC\nhKR\u001cv.\u001e:dK&sgm\u001c\"z\r&dWMC\u0007t_V\u00148-\u001a'j].4uN\u001d\u0006\u000bg>,(oY3MS:,'bA%oi*aA.\u001b8f\u0019&t7\u000eV3yi*Qq-\u001a;T_V\u00148-Z:\u000b\u0017M|WO]2fg&sgm\u001c\u0006\u000fO\u0016$8k\\;sG\u0016\u001c\u0018J\u001c4p\u0015\u0015!\u0018\u000e\u001e7f\u0015!9W\r\u001e+ji2,'\"\u0004;ss2{\u0017\r\u001a*fC\u0012lUMC\u0004wKJ\u001c\u0018n\u001c8\u000b\u0015\u001d,GOV3sg&|gNC\u0006xS.L7i\u001c8wKJ$(\u0002\u00047j].\u0014VM\u001c3fe\u0016\u0014(\u0002\u0004'j].\u0014VM\u001c3fe\u0016\u0014(\u0002\u00034jY\u0016t\u0015-\\34\f)\u0011\u0001#\u0002\u0006\u0005\u0011\u0001\u0001BA\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\tQA\u0001C\u0002\u0011\u0003)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0004\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0011A\u0011\u0001E\u0004\u000b\t!A\u0001\u0003\u0004\u0006\u0005\u0011%\u00012B\u0003\u0004\t\u0015AQ\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001b\u0002\u0007\u0001\u000b\r!1\u0001\u0003\u0005\r\u0001\u0015\t\u00012C\u0003\u0003\t\u001dA\u0011\"B\u0002\u0005\u0010!EA\u0002A\u0003\u0003\t\u0013A1\"B\u0002\u0005\u0012!UA\u0002A\u0003\u0003\t\u0015AQ!\u0002\u0002\u0005\u0004!9QA\u0001\u0003\b\u0011/)!\u0001\"\u0006\t\u0011\u0015\u0019Aa\u0001E\r\u0019\u0001)!\u0001B\u0004\t\r\u0015\u0011A\u0001\u0004E\r\u000b\r!!\u0001C\b\r\u0001\u0015\u0011A!\u0002E\u0011\u000b\r!Y\u0002\u0003\t\r\u0001\u0015\u0019Aa\u0001\u0005\u0012\u0019\u0001)!\u0001\u0002\u0002\t\u001f\u0015\u0011A1\u0004\u0005\u0011\u000b\r!1\u0001#\n\r\u0001\u0015\u0019AA\u0001\u0005\u0014\u0019\u0001)!\u0001\"\u0003\t(\u0015\u0019A!\u0005\u0005\u0015\u0019\u0001)1\u0001B\u0002\t+1\u0001Qa\u0001\u0003\u0003\u0011Wa\u0001!\u0002\u0002\u0005\u0016!)Ra\u0001\u0003\u0003\u0011]a\u0001!B\u0002\u0005#!IB\u0002A\u0003\u0003\tEA\u0011$B\u0002\u0005\u0005!YB\u0002A\u0003\u0003\t\tA1$B\u0002\u0005#!eB\u0002A\u0003\u0004\t\tAQ\u0004\u0004\u0001\u0006\u0005\u0011\u0011\u0001\"H\u0003\u0003\tEAI$B\u0002\u0005#!qB\u0002A\u0003\u0004\t\tAi\u0004\u0004\u0001\u0006\u0005\u0011\u0011\u0001RH\u0003\u0003\tEAa$\u0002\u0002\u0005\u0005!\u0019RA\u0001\u0003\u0012\u0011Q)\u0011\u0001C\u0012\u0006\u0005\u0011Y\u0002RI\u0003\u0003\toA1\"B\u0002\u00059!\u0011C\u0002A\u0003\u0003\tqA!%B\u0002\u00059!%C\u0002A\u0003\u0003\tqAI%B\u0002\u0005#!9C\u0002A\u0003\u0003\t\tAq#\u0002\u0002\u0005#!9Sa\u0001\u0003\u0012\u0011#b\u0001!\u0002\u0002\u0005\u0005!-RA\u0001\u0003\u0012\u0011#*!\u0001\"\u0003\tX\u0015\u0019A1\t\u0005,\u0019\u0001)1\u0001\u0002\u0002\tY1\u0001QA\u0001\u0003\u0003\u00111*!\u0001b\u0011\tW\u0015\u0011A1\u0001E-\u000b\r!A\u0005C\u0017\r\u0001\u0015\u0011A\u0001\n\u0005.\u000b\r!1\u0001C\u0018\r\u0001\u0015\u0011A\u0011\u0002\u00053\u000b\r!a\u0005c\u0019\r\u0001\u0015\u0019AQ\n\u00052\u0019\u0001)!\u0001\u0002\u0014\tf\u0015\u0011A\u0001\u0001\u00055\u000b\r!\u0001\u0006c\u001a\r\u0001\u0015\u0011A\u0001\u000bE4\u000b\r!)\u0002#\u001c\r\u0001\u0015\u0011AQ\u0003E7\u000b\r!)\u0002\u0003\u001d\r\u0001\u0015\u0011AQ\u0003\u00059\u000b\r!)\u0002#\u001f\r\u0001\u0015\u0011AQ\u0003E=\u000b\r!A\u0004# \r\u0001\u0015\u0019A\u0001\bE@\u0019\u0001)!\u0001\u0002\u000f\t\u0000\u0015\u0011A\u0001\bE?\u000b\u000f!!\u0001Ca\u0001\u0019\u0001))\u0001\u0002\u0002\t\u0003\u0004)!\u0001\"\u0005\t\u0016\u0015\u001dAa\u0001EB\u00021\u0001QQ\u0001C\u000b\u0011\u0007\u0007Qq\u0001\u0003\u0004\u0011\u000f\u0007A\u0002AC\u0004\t!B\u0019\u001a\u0001\u0007\u0001\u000b\u000b!\u0001\u0006ce\u0001\t\u0001a)!\u0007\u0002\u0006\u0003!\u001d\u0011\u0006\u000f\u0003d\u0002a!QT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\fA\u001b\u0001!(\u0004\u0005\u0001!5QBA\u0003\u0002\u0011\u0019\u00016\u0011AO\u000b\t\u0001Ay!\u0004\u0004\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005A\u0001\u0002U\u0002\u0002;+!\u0001\u0001\u0003\u0006\u000e\r\u0015\t\u0001RB\u0005\u0004\u0013\t)\u0011\u0001C\u0005Q\u0007\u0007\t#!B\u0001\t\u0006E\u001b1\u0002\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001E\n\u001b\u0005A!\"D\u0001\t\u00175\t\u0001bC\u0017\u0017\t\u0005\u0007\u0004\u0004D\u0011\u0004\u000b\u0005A9\u0002$\u0001V\u00079)1\u0001\u0002\u0007\n\u0003!eQb\u0001\u0003\u000e\u0013\u0005AI\"E\u0003\u0005\u001c%\tA\u0001A\u0007\u0002\u00113iK\u0004\u0002\u0001\u0019\u001du5A\u0001\u0001E\u000f\u001b\t)\u0011\u0001C\u0007Q\u0007\u0001ij\u0001\u0002\u0001\t 5\u0011Q!\u0001\u0005\u000f!\u000e\u0005\u0011EA\u0003\u0002\u0011;\t6a\u0002\u0003\u000f\u0013\u0005!\u0001!D\u0001\t\u001f5\t\u0001rDW&\t\u0001A\u001a#(\u0006\u0005\u0001!\u0011RBB\u0003\u0002\u0011AI1!\u0003\u0002\u0006\u0003!\u0005\u0002k\u0001\u0001\u001e\u0018\u0011\u0001\u0001rE\u0007\b\u000b\u0005Ai!\u0003\u0003\n\u0007\u0015\t\u00012\u0005G\u0001!\u000e\u0005\u0011EA\u0003\u0002\u0011;\t6a\u0002C\u0012\u0013\u0005!\u0001!D\u0001\t\u00175\t\u0001bC\u0017\u0011\t\r\u0004\u0002\u0014F\u0011\u0007\u000b\u0005A!#C\u0002\n\u0005\u0015\t\u0001R\u0005\u0013$+\u000e!Qb\u0001\u0003\u0017\u0013\u0005A1#\f\t\u0005GBAj#\t\u0004\u0006\u0003!\u0011\u0012bA\u0005\u0003\u000b\u0005A9\u0003J\u0012V\u0007\u0011i1\u0001b\f\n\u0003!\u0019Rf\u0005\u0003\u00031aij\u0001\u0002\u0001\t25\u0011Q!\u0001\u0005\u0015!\u000e\u0001\u0011EA\u0003\u0002\u0011/\t6!\u0002\u0003\u0019\u0013\u0005AI\"D\u0001\t*5zA\u0001\u0019\t\u0019\u000e\u0005\u0012Q!\u0001\u0005\u0007+\u000eAQa\u0001C\u0007\u0013\u0005A!\"D\u0002\u00054%\t\u0001BCW\u001d\t\u0001A\"$(\u0004\u0005\u0001!URBA\u0003\u0002\u0011U\u00016\u0001AO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!!\u0002k!\u0001\"\u0005\u0015\t\u0001RD)\u0004\u000f\u0011Q\u0012\"\u0001\u0003\u0001\u001b\u0005AY#D\u0001\t*5zA\u0001\u0019\t\u0019\n\u0005\u0012Q!\u0001E\u0006+\u000eAQa\u0001C\u0005\u0013\u0005A\u0019\"D\u0002\u00058%\t\u00012CW\u001e\t\tAB$(\u0004\u0005\u0001!uQBA\u0003\u0002\u00115\u00016\u0001AO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!1\u0002k!\u0001\"\u0007\u0015\t\u0001R\u0006G\u0001#\u000e9A\u0001H\u0005\u0002\u0011]i\u0011\u0001C\b\u000e\u0003!=R\u0006\u0006\u0003\u00031wij\u0001\u0002\u0001\t25\u0011Q!\u0001\u0005\u0019!\u000e\u0001\u0011eA\u0003\u0002\u0011ca\t!U\u0002\u0006\twI\u0011\u0001C\r\u000e\u0003!MR\u0006\u0006\u0003\u00031}ij\u0001\u0002\u0001\t25\u0011Q!\u0001E\u0012!\u000e\u0001\u0011eA\u0003\u0002\u0011Ca\t!U\u0002\u0006\t}I\u0011\u0001\u0003\u000e\u000e\u0003!UR\u0006\u0006\u0003\u00031\u007fij\u0001\u0002\u0001\tA5\u0011Q!\u0001E\f!\u000e\u0001\u0011eA\u0003\u0002\u0011/a\t!U\u0002\u0006\t\u007fI\u0011\u0001#\u0007\u000e\u0003!eQ\u0006\u0006\u0003\u00011\u0003jj\u0001\u0002\u0001\t25\u0011Q!\u0001\u0005\u0015!\u000e\u0001\u0011eA\u0003\u0002\u0011/a\t!U\u0002\u0006\t\u0003J\u0011\u0001#\u0007\u000e\u0003!%R\u0006\u0006\u0003\u00011\u0005jj\u0001\u0002\u0001\t25\u0011Q!\u0001\u0005\u0015!\u000e\u0001\u0011eA\u0003\u0002\u0011/a\t!U\u0002\u0006\t\u0005J\u0011\u0001#\u0007\u000e\u0003!%R&\u0006\u0003\u00031\u0005jz\u0001\u0002\u0001\tD5\u0019Q!\u0001E\u001d\u0019\u0003\u00016\u0001A\u0011\u0004\u000b\u0005A9\u0002$\u0001R\u0007\u0015!\u0011%C\u0001\t\u001a5\t\u0001\"H\u0017(\t\tA:%(\u0004\u0005\u0001!!SBA\u0003\u0002\u0011w\u00016\u0001AO\u0007\t\u0001AQ%\u0004\u0002\u0006\u0003!]\u0001k!\u0001\u001e\u000e\u0011\u0001\u00012J\u0007\u0003\u000b\u0005A9\u0002U\u0002\u0002C\r)\u0011\u0001c\u0006\r\u0002E\u001b\u0011\u0002b\u0012\n\u0003!eQ\"\u0001\u0005\u001f\u001b\u0005AI\"D\u0001\t\u001a5\"B\u0001\u0001\r';\u001b!\u0001\u0001#\u0014\u000e\u0005\u0015\t\u0001R\b)\u0004\u0001\u0005\u001aQ!\u0001E\u0014\u0019\u0003\t6!\u0002\u0003'\u0013\u0005Aq$D\u0001\t@5\"B\u0001\u0001\r';\u001b!\u0001\u0001c\u0014\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\u0014\u0019\u0003\t6!\u0002\u0003'\u0013\u0005Aq$D\u0001\t\u001a5\u001aB\u0001\u0001\r);\u001b!\u0001\u0001#\r\u000e\u0005\u0015\t\u0001\u0002\t)\u0004\u0001\u0005\u0012Q!\u0001E\u0013#\u000e)A\u0001K\u0005\u0002\u0011\u0003j\u0011\u0001C\u0011.)\u0011\u0001\u0001\u0004KO\u0007\t\u0001A\u0011&\u0004\u0002\u0006\u0003!]\u0001k\u0001\u0001\"\u0007\u0015\t\u0001R\u0005G\u0001#\u000e)A\u0001K\u0005\u0002\u0011\u0003j\u0011\u0001#\u0007.)\u0011\u0001\u00014KO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!!\u0002k\u0001\u0001\"\u0007\u0015\t\u00012\bG\u0001#\u000e)A1K\u0005\u0002\u0011yi\u0011\u0001#\u000b.+\u0011\u0001\u0001DKO\b\t\u0001A)&D\u0002\u0006\u0003!\u0011C\u0012\u0001)\u0004\u0001\u0005\u001aQ!\u0001E#\u0019\u0003\t6!\u0002\u0003+\u0013\u0005A1%D\u0001\tH5*Ba1\u0019\u0019Z\u0005\u0012Q!\u0001E%+\u000eqQa\u0001C-\u0013\u0005AQ%D\u0002\u0005\\%\t\u0001\"J\t\u0006\t9J\u0011\u0001\u0002\u0001\u000e\u0003!)Sf\u0005\u0003\u00031;jj\u0001\u0002\u0001\t25\u0011Q!\u0001\u0005\u0015!\u000e\u0001\u0011EA\u0003\u0002\u0011\u0017\n6!\u0002C/\u0013\u0005!\t!D\u0001\t*5nBA\u0001M0;\u001b!\u0001\u0001\u0003\u0019\u000e\u0005\u0015\t\u0001R\u0005)\u0004\u0001u=A\u0001\u0001E\"\u001b\r)\u0011\u0001c\u0006\r\u0002A\u001b\t!\t\u0002\u0006\u0003!u\u0011kA\u0004\u0005`%\tA\u0001A\u0007\u0002\u0011\u0003j\u0011\u0001#\u0007.)\u0011\u0001\u0001\u0014MO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!!\u0002k\u0001\u0001\"\u0007\u0015\t\u0001b\nG\u0001#\u000e)A\u0011M\u0005\u0002\u0011\u001fj\u0011\u0001#\u000b.+\u0011\u0019\r\u0007G\u001a\"\u0005\u0015\t\u0001\u0012K+\u0004\u001d\u0015\u0019AaM\u0005\u0002\u0011%j1\u0001\"\u001b\n\u0003!I\u0013#\u0002\u00036\u0013\u0005!\u0001!D\u0001\tS5\"B\u0001\u0001M6;\u001b!\u0001\u0001\u0003\u0019\u000e\u0005\u0015\t\u0001R\u0005)\u0004\u0001\u0005\u001aQ!\u0001E\u0013\u0019\u0003\t6!\u0002C6\u0013\u0005A\t%D\u0001\tB5\u001aB\u0001\u0019\t\u0019m\u00052Q!\u0001E*\u0013\rI!!B\u0001\t\u0018U\u001b\u0001\"B\u0002\u0005m%\t\u0001BK\u0007\u0004\t]J\u0011\u0001\u0003\u0016./\u0011\u0019\u0007\u0003g\u001c\"\u0015\u0015\t\u0001RK\u0005\u0004\u0013\t)\u0011\u0001c\u0006\n\u0007%\u0011Q!\u0001E\u0013+\u000eAQa\u0001C8\u0013\u0005A1&D\u0002\u0005r%\t\u0001bK\u0017\u0011\t\r\u0004\u0002$O\u0011\u0007\u000b\u0005A!#C\u0002\n\u0005\u0015\t\u0001R\u0005\u0013$+\u000e!Qb\u0001C:\u0013\u0005A1#\f\u000b\u0005\u0001aQTT\u0002\u0003\u0001\u0011Aj!!B\u0001\t&A\u001b\u0001!I\u0002\u0006\u0003!\u0015B\u0012A)\u0004\u000b\u0011Q\u0014\"\u0001E!\u001b\u0005A\t%,\u000f\u0005\u0005aUTT\u0002\u0003\u0001\u0011mj!!B\u0001\t\u0018A\u001b\u0001!(\u0004\u0005\u0001!!SBA\u0003\u0002\u0011w\u00016\u0011A\u0011\u0003\u000b\u0005A9\"U\u0002\b\tkJ\u0011\u0001#\u0007\u000e\u0003!eQ\"\u0001\u0005\u001f['!\u0001\u0001g\u001e\"\u0005\u0015\t\u0001rC)\u0004\u0007\u0011]\u0014\"\u0001E\r[M!\u0011\r\u0005\r=C\u0019)\u0011\u0001c\u0016\n\u0007%\u0011Q!\u0001E\f+\u000eAQa\u0001\u0003=\u0013\u0005AA&D\u0002\u0005{%\t\u0001\u0002LW\u001e\t\tAZ((\u0004\u0005\u0001!qTBA\u0003\u0002\u00113\u00026\u0001AO\u0007\t\u0001Aq(\u0004\u0002\u0006\u0003!]\u0001k!\u0001\"\u0007\u0015\t\u0001\"\fG\u0001#\u000e9A1P\u0005\u0002\u00117j\u0011\u0001\u0003\u0018\u000e\u0003!eQv\u0005\u0003a!a=\u0011EB\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!AQk!\u0005\u0006\u0007\u0011=\u0011\"\u0001\u0005\f\u001b\u000f!\u0001\u0019A\u0005\u0002\u0011-iC\u0003\u0002\u0001\u0019\u0002\u0004ij\u0001\u0002\u0001\tD5\u0011Q!\u0001\u0005\n!\u000e\u0001\u0011EA\u0003\u0002\u0011;\n61\u0002CA\u0002%\t\u0001bL\u0007\u0002\u0011?j\u000b\u0004B1\u00111\u0003\u0007\u0011EC\u0003\u0002\u0011AJ1!\u0003\u0002\u0006\u0003!I\u0011bA\u0005\u0003\u000b\u0005Ai&V\u0002\n\u000b\u000f!\t\u0019A\u0005\u0002\u0011Cj9\u0001\u0002b\u0001\u0013\u0005A\t'L\u0015\u0005\u0001a\u0015\r!(\u0004\u0005\u0001!\tSBA\u0003\u0002\u0011/\u00016\u0001A\u000f\b\t\u0001A1\u0019A\u0007\u0003\u000b\u0005A\u0011\u0007UB\u0001;\u001d!\u0011\u0001\u0003c\u0001\u001b\t)\u0011\u0001c\u0006Q\u0007\u0005\t3!B\u0001\t\u00181\u0005\u0011ka\u0005\u0005\u0006\u0004I\u0011\u0001#\u0007\u000e\u0003!eQ\"\u0001C\u0003\u001b\u0005AI\"l\n\u0005ABA\"\"\t\u0004\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005A\u0011\"VB\t\u000b\r!!\"C\u0001\t\u00175\u001dA\u00112\u0001\n\u0003!YQ\u0016\u0006\u0003a!a)\r!\t\u0004\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005Ai&V\u0002\n\u000b\u000f!Q\u0019A\u0005\u0002\u0011-i9\u0001bc\u0001\u0013\u0005A1\"L\u0007\u0005GBAb\u0019A\u0011\u0003\u000b\u0005A9\u0002J\u0012V\u0007\u0013i9\u0001\"d\u0001\u0013\u0005AI\"l\u000f\u0005\u0001a9\r!(\u0004\u0005\u0001!\u0001TBA\u0003\u0002\u0011K\u00016\u0001AO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!!\u0002k!\u0001\"\u0005\u0015\t\u0001RD)\u0004\u0010\u00119\r!C\u0001\u0005\u00015\t\u0001\u0012I\u0007\u0002\u0011SiS\u0002B2\u00111\u001f\u0007\u0011EA\u0003\u0002\u0011/!3%VB\u0005\u001b\u000f!\u0001\u001aA\u0005\u0002\u00113i\u0013\u0006\u0002\u0001\u0019\u0012\u0004ij\u0001\u0002\u0001\tA5\u0011Q!\u0001E\f!\u000e\u0001Qd\u0002\u0003\u0001\u0011%\u0007QBA\u0003\u0002\u0011G\u00026\u0011A\u000f\t\t\u0001A!\u001aA\u0007\u0004\u000b\u0005A9\u0002$\u0001Q\u0007\u0005\t#!B\u0001\t\u0018E\u001b\u0019\u0002\"e\u0001\u0013\u0005AI\"D\u0001\t\u001a5\t\u0001BM\u0007\u0002\u00113\u0001"})
public final class KModel
implements JetObject {
    private final SortedMap<String, KPackage> packageMap;
    private PegDownProcessor markdownProcessor;
    private SyntaxHighligher highlighter;
    private String _projectRootDir;
    private final ArrayList<String> packageDescriptionFiles;
    private final HashSet<String> readMeDirsScanned;
    private final List<? extends SourceInfo> sourcesInfo;
    private final Map<JetFile, ? extends SourceInfo> sourceInfoByFile;
    private final BindingContext context;
    private final KDocConfig config;
    private final List<? extends File> sourceDirs;
    private final List<? extends JetFile> sources;

    public final SortedMap<String, KPackage> getPackageMap() {
        return this.packageMap;
    }

    public final Collection<KPackage> getAllPackages() {
        Collection<KPackage> collection = this.packageMap.values();
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return collection;
    }

    public final Collection<KPackage> getPackages() {
        return KotlinPackage.filter(this.getAllPackages(), (Function1)((Function1)new KModel$packages$1(this)));
    }

    public final Collection<KClass> getClasses() {
        return KotlinPackage.flatMap(this.getPackages(), (Function1)((Function1)KModel$classes$1.instance$));
    }

    public final PegDownProcessor getMarkdownProcessor() {
        return this.markdownProcessor;
    }

    public final void setMarkdownProcessor(@JetValueParameter(name="<set-?>") PegDownProcessor pegDownProcessor) {
        this.markdownProcessor = pegDownProcessor;
    }

    public final SyntaxHighligher getHighlighter() {
        return this.highlighter;
    }

    public final void setHighlighter(@JetValueParameter(name="<set-?>") SyntaxHighligher syntaxHighligher) {
        this.highlighter = syntaxHighligher;
    }

    public final String getTitle() {
        return this.config.getTitle();
    }

    public final String getVersion() {
        return this.config.getVersion();
    }

    private final String get_projectRootDir() {
        return this._projectRootDir;
    }

    private final void set_projectRootDir(@JetValueParameter(name="<set-?>", type="?") String string) {
        this._projectRootDir = string;
    }

    public final ArrayList<String> getPackageDescriptionFiles() {
        return this.packageDescriptionFiles;
    }

    private final HashSet<String> getReadMeDirsScanned() {
        return this.readMeDirsScanned;
    }

    public final List<SourceInfo> getSourcesInfo() {
        return this.sourcesInfo;
    }

    private final Map<JetFile, SourceInfo> getSourceInfoByFile() {
        return this.sourceInfoByFile;
    }

    public final SourceInfo sourceInfoByFile(@JetValueParameter(name="file") JetFile file) {
        SourceInfo sourceInfo = this.sourceInfoByFile.get(file);
        if (sourceInfo == null) {
            Intrinsics.throwNpe();
        }
        return sourceInfo;
    }

    public final String projectRootDir() {
        String string;
        boolean bl = true;
        if (this._projectRootDir != null) {
            bl = false;
        }
        if (bl) {
            String string2;
            String rootDir = this.config.getProjectRootDir();
            boolean bl2 = true;
            if (rootDir != null) {
                bl2 = false;
            }
            if (bl2) {
                ModelPackage-KotlinModel-508284e7.warning("KDocConfig does not have a projectRootDir defined so we cannot generate relative source Hrefs");
                string2 = "";
            } else {
                string2 = new File(rootDir).getCanonicalPath();
                if (string2 == null) {
                    string2 = this._projectRootDir = "";
                }
            }
        }
        if ((string = this._projectRootDir) == null) {
            string = "";
        }
        return string;
    }

    public final KPackage getPackage(@JetValueParameter(name="name") String name) {
        return (KPackage)this.packageMap.get(name);
    }

    public final KPackage getPackage(@JetValueParameter(name="descriptor") NamespaceDescriptor descriptor) {
        String name = ModelPackage-KotlinModel-508284e7.qualifiedName((DeclarationDescriptor)descriptor);
        SharedVar.Boolean created = new SharedVar.Boolean();
        created.ref = 0;
        KPackage pkg2 = (KPackage)KotlinPackage.getOrPut((Map)this.packageMap, (Object)name, (Function0)((Function0)new KModel$getPackage$pkg$1(this, descriptor, name, created)));
        if (created.ref) {
            this.configureComments(pkg2, (DeclarationDescriptor)descriptor);
            JetScope scope = descriptor.getMemberScope();
            this.addFunctions(pkg2, scope);
            pkg2.setLocal(this.isLocal((DeclarationDescriptor)descriptor));
            pkg2.setUseExternalLink(KotlinPackage.isNotEmpty((String)((KAnnotated)pkg2).getModel().config.resolveLink(pkg2.getName(), false)));
            if (KotlinPackage.isEmpty((String)((KAnnotated)pkg2).getWikiDescription())) {
                String file = this.config.getPackageDescriptionFiles().get(name);
                this.loadWikiDescription(pkg2, file);
            }
        }
        return pkg2;
    }

    protected final void loadWikiDescription(@JetValueParameter(name="pkg") KPackage pkg2, @JetValueParameter(name="file", type="?") String file) {
        boolean bl = true;
        if (file == null) {
            bl = false;
        }
        if (bl) {
            try {
                ((KAnnotated)pkg2).setWikiDescription(IoPackage.readText$default((File)new File(file), null, (int)1));
            }
            catch (Throwable throwable) {
                ModelPackage-KotlinModel-508284e7.warning("Failed to load package " + pkg2.getName() + " documentation file " + file + ". Reason " + throwable);
            }
        }
    }

    public final void tryLoadReadMe(@JetValueParameter(name="pkg") KPackage pkg2, @JetValueParameter(name="descriptor") DeclarationDescriptor descriptor) {
        if (KotlinPackage.isEmpty((String)((KAnnotated)pkg2).getWikiDescription())) {
            String srcPath = ((KAnnotated)pkg2).getModel().filePath(descriptor);
            boolean bl = true;
            if (srcPath == null) {
                bl = false;
            }
            if (bl) {
                boolean bl2;
                File srcFile = new File(srcPath);
                File dir = srcFile.isDirectory() ? srcFile : srcFile.getParentFile();
                boolean bl3 = true;
                if (dir == null) {
                    bl3 = false;
                }
                if (bl3) {
                    String string = dir.getPath();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    bl2 = this.readMeDirsScanned.add(string);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    File f2 = (File)KotlinPackage.find((Iterable)KotlinPackage.map((Collection)this.packageDescriptionFiles, (Function1)((Function1)new KModel$tryLoadReadMe$f$1(dir))), (Function1)((Function1)KModel$tryLoadReadMe$f$2.instance$));
                    boolean bl4 = true;
                    if (f2 == null) {
                        bl4 = false;
                    }
                    if (bl4) {
                        String file = f2.getCanonicalPath();
                        this.loadWikiDescription(pkg2, file);
                    } else {
                        ModelPackage-KotlinModel-508284e7.info("package " + pkg2.getName() + " has no ReadMe.(html|md) in " + dir);
                    }
                }
            }
        }
    }

    public final String wikiConvert(@JetValueParameter(name="text") String text2, @JetValueParameter(name="linkRenderer") LinkRenderer linkRenderer, @JetValueParameter(name="fileName", type="?") String fileName) {
        String string = this.markdownProcessor.markdownToHtml(text2, linkRenderer);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public final String sourceLinkFor(@JetValueParameter(name="filePath") String filePath, @JetValueParameter(name="sourceLine") int sourceLine2, @JetValueParameter(name="lineLinkText") String lineLinkText) {
        String root = this.config.getSourceRootHref();
        boolean bl = true;
        if (root == null) {
            bl = false;
        }
        if (bl) {
            String rootDir = this.projectRootDir();
            String string = new File(filePath).getCanonicalPath();
            if (string == null) {
                string = "";
            }
            String canonicalFile = string;
            String relativeFile = KotlinPackage.startsWith((String)canonicalFile, (String)rootDir) ? KotlinPackage.substring((String)canonicalFile, (int)KotlinPackage.length((String)rootDir)) : canonicalFile;
            String cleanRoot = KotlinPackage.trimTrailing((String)root, (String)"/");
            String cleanPath = KotlinPackage.trimLeading((String)relativeFile, (String)"/");
            return cleanRoot + "/" + cleanPath + lineLinkText + sourceLine2;
        }
        return null;
    }

    public static /* synthetic */ String sourceLinkFor$default(KModel kModel, String string, int n, String string2, int n2) {
        if ((n2 & 4) != 0) {
            string2 = "#L";
        }
        return kModel.sourceLinkFor(string, n, string2);
    }

    protected final boolean isLocal(@JetValueParameter(name="descriptor") DeclarationDescriptor descriptor) {
        int n;
        if (descriptor instanceof ModuleDescriptor) {
            n = 1;
        } else {
            DeclarationDescriptor parent = descriptor.getContainingDeclaration();
            boolean bl = true;
            if (parent == null) {
                bl = false;
            }
            n = bl ? (int)(this.isLocal(parent) ? 1 : 0) : 0;
        }
        return n != 0;
    }

    public final void addFunctions(@JetValueParameter(name="owner") KClassOrPackage owner, @JetValueParameter(name="scope") JetScope scope) {
        try {
            Collection descriptors = scope.getAllDescriptors();
            for (DeclarationDescriptor descriptor : descriptors) {
                Unit unit;
                if (descriptor instanceof PropertyDescriptor) {
                    String name = ((PropertyDescriptor)descriptor).getName().asString();
                    KType returnType = this.getType(((PropertyDescriptor)descriptor).getReturnType());
                    boolean bl = true;
                    if (returnType == null) {
                        bl = false;
                    }
                    if (!bl) continue;
                    ReceiverParameterDescriptor receiver = ((PropertyDescriptor)descriptor).getReceiverParameter();
                    boolean bl2 = true;
                    if (receiver == null) {
                        bl2 = false;
                    }
                    KType extensionClass = bl2 ? this.getType(receiver.getType()) : (KType)null;
                    KType kType = extensionClass;
                    KProperty property = new KProperty(owner, (PropertyDescriptor)descriptor, name, returnType, kType != null ? kType.getKlass() : null);
                    owner.getProperties().add(property);
                    continue;
                }
                if (descriptor instanceof CallableDescriptor) {
                    KFunction function = this.createFunction(owner, (CallableDescriptor)descriptor);
                    boolean bl = true;
                    if (function == null) {
                        bl = false;
                    }
                    if (bl) {
                        owner.getFunctions().add(function);
                    }
                    unit = Unit.VALUE;
                    continue;
                }
                unit = Unit.VALUE;
            }
        }
        catch (Throwable throwable) {
            ModelPackage-KotlinModel-508284e7.warning("Caught exception finding function declarations on " + owner + " " + throwable);
            throwable.printStackTrace();
        }
    }

    protected final KFunction createFunction(@JetValueParameter(name="owner") KClassOrPackage owner, @JetValueParameter(name="descriptor") CallableDescriptor descriptor) {
        KType returnType = this.getType(descriptor.getReturnType());
        boolean bl = true;
        if (returnType == null) {
            bl = false;
        }
        if (bl) {
            String name = descriptor.getName().asString();
            ArrayList<KParameter> parameters = new ArrayList<KParameter>();
            List params = descriptor.getValueParameters();
            for (ValueParameterDescriptor param : params) {
                boolean bl2 = true;
                if (param == null) {
                    bl2 = false;
                }
                if (!bl2) continue;
                KParameter p = this.createParameter(param);
                boolean bl3 = true;
                if (p == null) {
                    bl3 = false;
                }
                if (!bl3) continue;
                parameters.add(p);
            }
            KFunction function = new KFunction(descriptor, owner, name, returnType, parameters, null, null, null, null, null, null, 2016);
            this.addTypeParameters(function.getTypeParameters(), descriptor.getTypeParameters());
            this.configureComments(function, (DeclarationDescriptor)descriptor);
            ReceiverParameterDescriptor receiver = descriptor.getReceiverParameter();
            boolean bl4 = true;
            if (receiver == null) {
                bl4 = false;
            }
            if (bl4) {
                KType receiverType = this.getType(receiver.getType());
                function.setReceiverType(receiverType);
                KType kType = receiverType;
                function.setExtensionClass(kType != null ? kType.getKlass() : null);
            }
            return function;
        }
        return null;
    }

    public final void addTypeParameters(@JetValueParameter(name="answer") List<KTypeParameter> answer2, @JetValueParameter(name="descriptors") List<? extends TypeParameterDescriptor> descriptors) {
        for (TypeParameterDescriptor typeParameterDescriptor : descriptors) {
            boolean bl = true;
            if (typeParameterDescriptor == null) {
                bl = false;
            }
            if (!bl) continue;
            KTypeParameter p = this.createTypeParameter(typeParameterDescriptor);
            boolean bl2 = true;
            if (p == null) {
                bl2 = false;
            }
            if (!bl2) continue;
            answer2.add(p);
        }
    }

    protected final KTypeParameter createTypeParameter(@JetValueParameter(name="descriptor") TypeParameterDescriptor descriptor) {
        String name = descriptor.getName().asString();
        KTypeParameter answer2 = new KTypeParameter(name, descriptor, this, null, 8);
        this.configureComments(answer2, (DeclarationDescriptor)descriptor);
        return answer2;
    }

    protected final KParameter createParameter(@JetValueParameter(name="descriptor") ValueParameterDescriptor descriptor) {
        KType returnType = this.getType(descriptor.getReturnType());
        boolean bl = true;
        if (returnType == null) {
            bl = false;
        }
        if (bl) {
            String name = descriptor.getName().asString();
            KParameter answer2 = new KParameter(descriptor, name, returnType);
            this.configureComments(answer2, (DeclarationDescriptor)descriptor);
            return answer2;
        }
        return null;
    }

    public final DiagnosticUtils.LineAndColumn locationFor(@JetValueParameter(name="descriptor") DeclarationDescriptor descriptor) {
        PsiElement psiElement = this.getPsiElement(descriptor);
        boolean bl = true;
        if (psiElement == null) {
            bl = false;
        }
        if (bl) {
            PsiFile psiFile = psiElement.getContainingFile();
            Object object = psiFile != null ? psiFile.getViewProvider() : null;
            Document document = object != null ? object.getDocument() : null;
            boolean bl2 = true;
            if (document == null) {
                bl2 = false;
            }
            if (bl2) {
                int offset = psiElement.getTextOffset();
                return DiagnosticUtils.offsetToLineAndColumn((Document)document, (int)offset);
            }
        }
        return null;
    }

    public final String fileFor(@JetValueParameter(name="descriptor") DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        PsiElement psiElement2 = psiElement = this.getPsiElement(descriptor);
        Object object = psiElement2 != null ? psiElement2.getContainingFile() : null;
        return object != null ? object.getName() : null;
    }

    public final String filePath(@JetValueParameter(name="descriptor") DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        PsiElement psiElement2 = psiElement = this.getPsiElement(descriptor);
        PsiFile file = psiElement2 != null ? psiElement2.getContainingFile() : null;
        return this.filePath((PsiFileSystemItem)file);
    }

    public final PsiElement getPsiElement(@JetValueParameter(name="descriptor") DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        try {
            psiElement = BindingContextUtils.descriptorToDeclaration((BindingContext)this.context, (DeclarationDescriptor)descriptor);
        }
        catch (Throwable throwable) {
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    protected final String commentsFor(@JetValueParameter(name="descriptor") DeclarationDescriptor descriptor) {
        PsiElement psiElement = this.getPsiElement(descriptor);
        boolean bl = true;
        if (psiElement == null) {
            bl = false;
        }
        if (bl) {
            String string;
            ASTNode aSTNode = psiElement.getNode();
            ASTNode node = aSTNode != null ? aSTNode.getTreePrev() : null;
            while (true) {
                boolean bl2;
                boolean bl3 = true;
                if (node == null) {
                    bl3 = false;
                }
                if (bl3) {
                    ASTNode aSTNode2 = node;
                    if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)JetTokens.WHITE_SPACE)) {
                        ASTNode aSTNode3 = node;
                        bl2 = Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)JetTokens.BLOCK_COMMENT);
                    } else {
                        bl2 = true;
                    }
                } else {
                    bl2 = false;
                }
                if (!bl2) break;
                ASTNode aSTNode4 = node;
                node = aSTNode4 != null ? aSTNode4.getTreePrev() : null;
            }
            boolean bl4 = true;
            if (node != null) {
                bl4 = false;
            }
            if (bl4) {
                return "";
            }
            ASTNode aSTNode5 = node;
            if (Intrinsics.areEqual((Object)(aSTNode5 != null ? aSTNode5.getElementType() : null), (Object)JetTokens.DOC_COMMENT) ^ true) {
                return "";
            }
            ASTNode aSTNode6 = node;
            String string2 = aSTNode6 != null ? aSTNode6.getText() : null;
            if (string2 == null) {
                string2 = "";
            }
            String text2 = string2;
            String[] lines = KotlinPackage.split((String)KotlinPackage.trim((String)text2), (String)"\\n");
            StringBuilder buffer = new StringBuilder();
            int last = lines.length - 1;
            int n = 0;
            int n2 = last;
            if (n <= n2) {
                while (true) {
                    Unit unit;
                    void i;
                    String string3;
                    if ((string3 = lines[i]) == null) {
                        string3 = "";
                    }
                    String text3 = string3;
                    text3 = KotlinPackage.trim((String)text3);
                    boolean bl5 = true;
                    if (i != false) {
                        bl5 = false;
                    }
                    if (bl5) {
                        text3 = KotlinPackage.trimLeading((String)KotlinPackage.trimLeading((String)text3, (String)"/**"), (String)"/*");
                    } else {
                        buffer.append("\n");
                    }
                    if (i >= last) {
                        text3 = KotlinPackage.trimTrailing((String)text3, (String)"*/");
                    } else if (i > false) {
                        if (Intrinsics.areEqual((Object)(text3 = KotlinPackage.trimLeading((String)text3, (String)"* ")), (Object)"*")) {
                            text3 = "";
                        }
                        unit = Unit.VALUE;
                    } else {
                        unit = Unit.VALUE;
                    }
                    text3 = this.processMacros(text3, psiElement);
                    buffer.append(text3);
                    if (i == n2) break;
                    ++i;
                }
            }
            if ((string = buffer.toString()) == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    protected final String processMacros(@JetValueParameter(name="textWithWhitespace") String textWithWhitespace, @JetValueParameter(name="psiElement") PsiElement psiElement) {
        String text2 = KotlinPackage.trim((String)textWithWhitespace);
        if (KotlinPackage.startsWith((String)text2, (String)"@")) {
            String macro;
            String remaining = KotlinPackage.substring((String)text2, (int)1);
            if (KotlinPackage.startsWith((String)remaining, (String)(macro = "includeFunctionBody"))) {
                String next = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)KotlinPackage.length((String)macro)));
                String[] words = KotlinPackage.split((String)next, (String)"\\s");
                if (words.length > 1) {
                    String string = words[0];
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String includeFile = string;
                    String string2 = words[1];
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String fnName = string2;
                    String content = this.findFunctionInclude(psiElement, includeFile, fnName);
                    boolean bl = true;
                    if (content == null) {
                        bl = false;
                    }
                    if (bl) {
                        return content;
                    }
                    ModelPackage-KotlinModel-508284e7.warning("could not find function " + fnName + " in file " + includeFile + " from source file " + psiElement.getContainingFile());
                }
            } else {
                ModelPackage-KotlinModel-508284e7.warning("Unknown kdoc macro @" + remaining);
            }
        }
        return textWithWhitespace;
    }

    protected final String findFunctionInclude(@JetValueParameter(name="psiElement") PsiElement psiElement, @JetValueParameter(name="includeFile") String includeFile, @JetValueParameter(name="functionName") String functionName) {
        PsiFile psiFile = psiElement.getContainingFile();
        PsiDirectory dir = psiFile != null ? psiFile.getParent() : null;
        boolean bl = true;
        if (dir == null) {
            bl = false;
        }
        if (bl) {
            PsiDirectory psiDirectory = dir;
            if (psiDirectory == null) {
                Intrinsics.throwNpe();
            }
            PsiFile file = this.relativeFile(psiDirectory, includeFile);
            boolean bl2 = true;
            if (file == null) {
                bl2 = false;
            }
            if (bl2) {
                String text2 = file.getText();
                boolean bl3 = true;
                if (text2 == null) {
                    bl3 = false;
                }
                if (bl3) {
                    Matcher matcher;
                    Pattern regex = KotlinPackage.toRegex$default((String)("fun" + "\\" + "s+" + functionName + "\\" + "(.*" + "\\" + ")"), (int)0, (int)1);
                    Matcher matcher2 = regex.matcher(text2);
                    if (matcher2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((matcher = matcher2).find()) {
                        int idx = matcher.end();
                        String remaining = KotlinPackage.substring((String)text2, (int)idx);
                        String content = this.extractBlock(remaining);
                        boolean bl4 = true;
                        if (content == null) {
                            bl4 = false;
                        }
                        if (bl4) {
                            String highlight = this.highlighter.highlight(content);
                            String filePath = this.filePath((PsiFileSystemItem)file);
                            int sourceLine2 = KotlinPackage.count((String)KotlinPackage.substring((String)text2, (int)0, (int)idx), (Function1)((Function1)KModel$findFunctionInclude$sourceLine$1.instance$)) + 1;
                            boolean bl5 = true;
                            if (filePath == null) {
                                bl5 = false;
                            }
                            String link = bl5 ? KModel.sourceLinkFor$default(this, filePath, sourceLine2, null, 4) : (String)null;
                            boolean bl6 = true;
                            if (link == null) {
                                bl6 = false;
                            }
                            return bl6 ? "<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + link + "\"" + " target=" + "\"" + "_top" + "\"" + "  class=" + "\"" + "repoSourceCode" + "\"" + ">source</a></div>" + "\n" + highlight : highlight;
                        }
                    }
                }
            }
        }
        return null;
    }

    protected final String filePath(@JetValueParameter(name="file", type="?") PsiFileSystemItem file) {
        boolean bl = true;
        if (file == null) {
            bl = false;
        }
        if (bl) {
            PsiFileSystemItem dir = file.getParent();
            boolean bl2 = true;
            if (dir == null) {
                bl2 = false;
            }
            if (bl2) {
                String string = this.filePath(dir);
                if (string == null) {
                    string = "";
                }
                String parentName = string;
                return parentName + "/" + file.getName();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected final String extractBlock(@JetValueParameter(name="text") String text2) {
        int idx = KotlinPackage.indexOf((String)text2, (char)'{');
        if (idx >= 0) {
            String line22;
            int nidx;
            String remaining = KotlinPackage.substring((String)text2, (int)(idx + 1));
            while ((nidx = KotlinPackage.indexOf((String)remaining, (char)'\n')) >= 0 && KotlinPackage.isEmpty((String)(line22 = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)0, (int)nidx))))) {
                remaining = KotlinPackage.substring((String)remaining, (int)(nidx + 1));
            }
            int count = 1;
            int line22 = 0;
            int n = KotlinPackage.getSize((String)remaining) - 1;
            if (line22 <= n) {
                while (true) {
                    Integer n2;
                    void i;
                    char ch;
                    if ((ch = remaining.charAt((int)i)) == '{') {
                        n2 = count;
                        ++count;
                    } else if (ch == '}') {
                        if (--count <= 0) {
                            return KotlinPackage.substring((String)remaining, (int)0, (int)i);
                        }
                        n2 = Unit.VALUE;
                    } else {
                        n2 = Unit.VALUE;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            ModelPackage-KotlinModel-508284e7.warning("missing } in code block for " + remaining);
            return remaining;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected final PsiFile relativeFile(@JetValueParameter(name="directory") PsiDirectory directory, @JetValueParameter(name="relativeName") String relativeName) {
        PsiDirectory dir = directory;
        int n = 0;
        String[] paths = KotlinPackage.split((String)relativeName, (String)"/");
        int size = paths.length;
        int n2 = size - 2;
        if (n <= n2) {
            while (true) {
                void i;
                String path;
                if (!Intrinsics.areEqual((Object)(path = paths[i]), (Object)".")) {
                    Unit unit;
                    if (Intrinsics.areEqual((Object)path, (Object)"..")) {
                        PsiDirectory psiDirectory = dir;
                        dir = psiDirectory != null ? psiDirectory.getParent() : null;
                        unit = Unit.VALUE;
                    } else {
                        PsiDirectory psiDirectory = dir;
                        dir = psiDirectory != null ? psiDirectory.findSubdirectory(path) : null;
                        unit = Unit.VALUE;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        String name = paths[size - 1];
        boolean bl = true;
        if (dir == null) {
            bl = false;
        }
        if (bl) {
            PsiDirectory psiDirectory = dir;
            PsiFile file = psiDirectory != null ? psiDirectory.findFile(name) : null;
            boolean bl2 = true;
            if (file == null) {
                bl2 = false;
            }
            if (bl2) {
                return file;
            }
            ModelPackage-KotlinModel-508284e7.warning("could not find file " + relativeName + " in " + dir + " with name " + name);
        }
        return null;
    }

    public final void configureComments(@JetValueParameter(name="annotated") KAnnotated annotated, @JetValueParameter(name="descriptor") DeclarationDescriptor descriptor) {
        String detailedText = KotlinPackage.trim((String)this.commentsFor(descriptor));
        annotated.setWikiDescription(detailedText);
    }

    public final KType getType(@JetValueParameter(name="aType", type="?") JetType aType) {
        boolean bl = true;
        if (aType == null) {
            bl = false;
        }
        if (bl) {
            ClassifierDescriptor classifierDescriptor = aType.getConstructor().getDeclarationDescriptor();
            KClass klass2 = classifierDescriptor instanceof ClassDescriptor ? this.getClass((ClassDescriptor)classifierDescriptor) : (KClass)null;
            return new KType(aType, this, klass2, null, 8);
        }
        return null;
    }

    public final KClass getClass(@JetValueParameter(name="qualifiedName") String qualifiedName) {
        int idx = KotlinPackage.lastIndexOf((String)qualifiedName, (char)'.');
        String pkgName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)0, (int)idx) : "";
        KPackage pkg2 = this.getPackage(pkgName);
        boolean bl = true;
        if (pkg2 == null) {
            bl = false;
        }
        if (bl) {
            String simpleName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)(idx + 1)) : qualifiedName;
            return (KClass)pkg2.getClassMap().get(simpleName);
        }
        return null;
    }

    public final KClass getClass(@JetValueParameter(name="classElement") ClassDescriptor classElement) {
        String name = classElement.getName().asString();
        DeclarationDescriptor dec = classElement.getContainingDeclaration();
        while (true) {
            boolean bl = true;
            if (dec == null) {
                bl = false;
            }
            if (!bl) break;
            DeclarationDescriptor container = dec;
            if (container instanceof NamespaceDescriptor) {
                KPackage pkg2 = this.getPackage((NamespaceDescriptor)container);
                return pkg2.getClass(classElement);
            }
            DeclarationDescriptor declarationDescriptor = dec;
            dec = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        }
        ModelPackage-KotlinModel-508284e7.warning("no package found for class " + name);
        return null;
    }

    public final KPackage previous(@JetValueParameter(name="pkg") KPackage pkg2) {
        return null;
    }

    public final KPackage next(@JetValueParameter(name="pkg") KPackage pkg2) {
        return null;
    }

    public final BindingContext getContext() {
        return this.context;
    }

    public final KDocConfig getConfig() {
        return this.config;
    }

    public final List<File> getSourceDirs() {
        return this.sourceDirs;
    }

    public final List<JetFile> getSources() {
        return this.sources;
    }

    public KModel(@JetValueParameter(name="context") BindingContext context, @JetValueParameter(name="config") KDocConfig config, @JetValueParameter(name="sourceDirs") List<? extends File> sourceDirs2, @JetValueParameter(name="sources") List<? extends JetFile> sources) {
        this.context = context;
        this.config = config;
        this.sourceDirs = sourceDirs2;
        this.sources = sources;
        this.packageMap = new TreeMap();
        this.markdownProcessor = new PegDownProcessor(Extensions.ALL);
        this.highlighter = new SyntaxHighligher();
        this.packageDescriptionFiles = KotlinPackage.arrayList((Object[])new String[]{"readme.md", "ReadMe.md, readme.html, ReadMe.html"});
        this.readMeDirsScanned = new HashSet();
        List normalizedSourceDirs2 = KotlinPackage.map((Collection)this.sourceDirs, (Function1)((Function1)KModel$normalizedSourceDirs$1.instance$));
        KModel$1 kModel$1 = new KModel$1(normalizedSourceDirs2);
        this.sourcesInfo = KotlinPackage.map((Collection)this.sources, (Function1)((Function1)new KModel$2(kModel$1)));
        this.sourceInfoByFile = DocPackage-collections-b8ec3894.toHashMapMappingToKey(this.sourcesInfo, (Function1)KModel$sourceInfoByFile$1.instance$);
        HashSet<NamespaceDescriptor> allNamespaces = new HashSet<NamespaceDescriptor>();
        for (JetFile jetFile : this.sources) {
            Boolean bl;
            NamespaceDescriptor namespaceDescriptor = BindingContextUtils.namespaceDescriptor((BindingContext)this.context, (JetFile)jetFile);
            boolean bl2 = true;
            if (namespaceDescriptor == null) {
                bl2 = false;
            }
            if (bl2) {
                bl = allNamespaces.add(namespaceDescriptor);
                continue;
            }
            ModelPackage-KotlinModel-508284e7.warning("No NamespaceDescriptor for source " + jetFile);
            bl = Unit.VALUE;
        }
        HashSet<KClass> hashSet = new HashSet<KClass>();
        for (NamespaceDescriptor namespace : allNamespaces) {
            this.getPackage(namespace);
            for (DeclarationDescriptor descriptor : namespace.getMemberScope().getAllDescriptors()) {
                if (descriptor instanceof ClassDescriptor) {
                    KClass klass2 = this.getClass((ClassDescriptor)descriptor);
                    boolean bl = true;
                    if (klass2 == null) {
                        bl = false;
                    }
                    if (!bl) continue;
                    hashSet.add(klass2);
                    continue;
                }
                Object object = descriptor instanceof NamespaceDescriptor ? this.getPackage((NamespaceDescriptor)descriptor) : Unit.VALUE;
            }
        }
    }
}

