/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import jet.JetObject;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.TemplateLinkRenderer;
import org.jetbrains.kotlin.doc.templates.KDocTemplate;

@JetClass(signature="Ljava/lang/Object;", flags=16, abiVersion=6)
public abstract class KAnnotated
implements JetObject {
    private String wikiDescription;
    private boolean deprecated;
    private final KModel model;
    private final DeclarationDescriptor declarationDescriptor;

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public String getWikiDescription() {
        return this.wikiDescription;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public void setWikiDescription(@JetValueParameter(name="<set-?>", type="Ljava/lang/String;") String string) {
        this.wikiDescription = string;
    }

    @JetMethod(flags=1, propertyType="Z")
    public boolean getDeprecated() {
        return this.deprecated;
    }

    @JetMethod(flags=1, propertyType="Z")
    public void setDeprecated(@JetValueParameter(name="<set-?>", type="Z") boolean bl) {
        this.deprecated = bl;
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public String description(@JetValueParameter(name="template", type="Lorg/jetbrains/kotlin/doc/templates/KDocTemplate;") KDocTemplate template2) {
        String detailedText = this.detailedDescription(template2);
        int idx = KotlinPackage.indexOf((String)detailedText, (String)"</p>");
        return idx > 0 ? KotlinPackage.trimLeading((String)KotlinPackage.substring((String)detailedText, (int)0, (int)idx), (String)"<p>") : detailedText;
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String detailedDescription(@JetValueParameter(name="template", type="Lorg/jetbrains/kotlin/doc/templates/KDocTemplate;") KDocTemplate template2) {
        String wiki = this.getWikiDescription();
        return this.wikiConvert(wiki, template2);
    }

    @JetMethod(flags=32, returnType="Ljava/lang/String;")
    protected final String wikiConvert(@JetValueParameter(name="wiki", type="Ljava/lang/String;") String wiki, @JetValueParameter(name="template", type="Lorg/jetbrains/kotlin/doc/templates/KDocTemplate;") KDocTemplate template2) {
        String file = this.model.fileFor(this.declarationDescriptor);
        return this.model.wikiConvert(wiki, new TemplateLinkRenderer(this, template2), file);
    }

    @JetMethod(flags=16, returnType="Z")
    public final boolean isLinkToSourceRepo() {
        boolean bl = true;
        if (this.model.getConfig().getSourceRootHref() == null) {
            bl = false;
        }
        return bl;
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String sourceTargetAttribute() {
        return this.isLinkToSourceRepo() ? " target=\"_top\" class=\"repoSourceCode\"" : "";
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String sourceLink() {
        String file = this.filePath();
        boolean bl = true;
        if (file == null) {
            bl = false;
        }
        if (bl) {
            String link = KModel.sourceLinkFor$default(this.model, file, this.getSourceLine(), null, 4);
            boolean bl2 = true;
            if (link == null) {
                bl2 = false;
            }
            if (bl2) {
                return link;
            }
        }
        return "";
    }

    @JetMethod(flags=16, returnType="?Ljava/lang/String;")
    public final String filePath() {
        return this.model.filePath(this.declarationDescriptor);
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/jet/lang/diagnostics/DiagnosticUtils$LineAndColumn;")
    public final DiagnosticUtils.LineAndColumn location() {
        return this.model.locationFor(this.declarationDescriptor);
    }

    @JetMethod(flags=17, propertyType="I")
    public final int getSourceLine() {
        DiagnosticUtils.LineAndColumn loc = this.location();
        boolean bl = true;
        if (loc == null) {
            bl = false;
        }
        return bl ? loc.getLine() : 1;
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/kotlin/doc/model/KModel;")
    public final KModel getModel() {
        return this.model;
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;")
    public final DeclarationDescriptor getDeclarationDescriptor() {
        return this.declarationDescriptor;
    }

    @JetConstructor
    public KAnnotated(@JetValueParameter(name="model", type="Lorg/jetbrains/kotlin/doc/model/KModel;") KModel model, @JetValueParameter(name="declarationDescriptor", type="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;") DeclarationDescriptor declarationDescriptor) {
        this.model = model;
        this.declarationDescriptor = declarationDescriptor;
        this.wikiDescription = "";
    }
}

