/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.CharIterator;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.io.IoPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.doc.DocPackage$collections$f9a3b1f1;
import org.jetbrains.kotlin.doc.KDocConfig;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighlighter;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.model.ModelPackage$KotlinModel$f59ec484;
import org.jetbrains.kotlin.doc.model.SourceInfo;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.pegdown.Extensions;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u000f\u001e)11*T8eK2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004I>\u001c'\"B7pI\u0016d'bA!os*1A(\u001b8jizRqaY8oi\u0016DHO\u0003\bCS:$\u0017N\\4D_:$X\r\u001f;\u000b\u000fI,7o\u001c7wK*11m\u001c8gS\u001eT!b\u0013#pG\u000e{gNZ5h\u0015)\u0019x.\u001e:dK\u0012K'o\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0003GS2,'\u0002\u00026bm\u0006T!![8\u000b\u000fM|WO]2fg*9!*\u001a;GS2,'b\u00019tS*!Q\u000f^5m\u0015=y\u0006O]8kK\u000e$(k\\8u\t&\u0014(BB*ue&twM\u0003\u0003mC:<'bC1mYB\u000b7m[1hKNT!bQ8mY\u0016\u001cG/[8o\u0015!Y\u0005+Y2lC\u001e,'BD4fi\u0006cG\u000eU1dW\u0006<Wm\u001d\u0006\bG2\f7o]3t\u0015\u0019Y5\t\\1tg*Qq-\u001a;DY\u0006\u001c8/Z:\u000b\u0013\u001d,GoQ8oM&<'BC4fi\u000e{g\u000e^3yi*Y\u0001.[4iY&<\u0007\u000e^3s\u0015E\u0019\u0016P\u001c;bq\"Kw\r\u001b7jO\"$XM\u001d\u0006\u000fO\u0016$\b*[4iY&<\u0007\u000e^3s\u00159\u0019X\r\u001e%jO\"d\u0017n\u001a5uKJT\u0011#\\1sW\u0012|wO\u001c)s_\u000e,7o]8s\u0015A\u0001Vm\u001a#po:\u0004&o\\2fgN|'OC\u0004qK\u001e$wn\u001e8\u000b)\u001d,G/T1sW\u0012|wO\u001c)s_\u000e,7o]8s\u0015Q\u0019X\r^'be.$wn\u001e8Qe>\u001cWm]:pe*9\u0002/Y2lC\u001e,G)Z:de&\u0004H/[8o\r&dWm\u001d\u0006\u001bO\u0016$\b+Y2lC\u001e,G)Z:de&\u0004H/[8o\r&dWm\u001d\u0006\u000ba\u0006\u001c7.Y4f\u001b\u0006\u0004(\"C*peR,G-T1q\u001559W\r\u001e)bG.\fw-Z'ba*A\u0001/Y2lC\u001e,7OC\u0006hKR\u0004\u0016mY6bO\u0016\u001c(\"\u0005:fC\u0012lU\rR5sgN\u001b\u0017M\u001c8fI*9\u0001*Y:i'\u0016$(\"D4fiN{WO]2f\t&\u00148O\u0003\tt_V\u00148-Z%oM>\u0014\u0015PR5mK*\u0019Q*\u00199\u000b\u0015M{WO]2f\u0013:4wN\u0003\u0006hKR\u001cv.\u001e:dKNT1b]8ve\u000e,7/\u00138g_*qq-\u001a;T_V\u00148-Z:J]\u001a|'\"\u0002;ji2,'\u0002C4fiRKG\u000f\\3\u000b\u000fY,'o]5p]*Qq-\u001a;WKJ\u001c\u0018n\u001c8\u000b\u0019\u0005$GMR;oGRLwN\\:\u000b\u000b=<h.\u001a:\u000b\u001f-\u001bE.Y:t\u001fJ\u0004\u0016mY6bO\u0016TQa]2pa\u0016T\u0001BS3u'\u000e|\u0007/\u001a\u0006\u0007g\u000e|\u0007/Z:\u000b\tUs\u0017\u000e\u001e\u0006\u0012C\u0012$G+\u001f9f!\u0006\u0014\u0018-\\3uKJ\u001c(BB1og^,'OC\u0006NkR\f'\r\\3MSN$(BD&UsB,\u0007+\u0019:b[\u0016$XM\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148OC\fUsB,\u0007+\u0019:b[\u0016$XM\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe*Y1m\\7nK:$8OR8s\u0015)!Wm]2sSB$xN\u001d\u0006\u0016\t\u0016\u001cG.\u0019:bi&|g\u000eR3tGJL\u0007\u000f^8s\u0015E\u0019wN\u001c4jOV\u0014XmQ8n[\u0016tGo\u001d\u0006\nC:tw\u000e^1uK\u0012T!bS!o]>$\u0018\r^3e\u00159\u0019'/Z1uK\u001a+hn\u0019;j_:T!cQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*I1JR;oGRLwN\u001c\u0006\u000eGJ,\u0017\r^3QC\u000e\\\u0017mZ3\u000b3A\u000b7m[1hK\u001a\u0013\u0018mZ7f]R$Um]2sSB$xN\u001d\u0006\u0005]\u0006lWMC\bde\u0016\fG/\u001a)be\u0006lW\r^3s\u0015a1\u0016\r\\;f!\u0006\u0014\u0018-\\3uKJ$Um]2sSB$xN\u001d\u0006\u000b\u0017B\u000b'/Y7fi\u0016\u0014(bE2sK\u0006$X\rV=qKB\u000b'/Y7fi\u0016\u0014(\u0002D3yiJ\f7\r\u001e\"m_\u000e\\'\u0002\u0002;fqRTqAZ5mK\u001a{'O\u0003\u0005gS2,\u0007+\u0019;i\u0015\u00111\u0017\u000e\\3\u000b#A\u001b\u0018NR5mKNK8\u000f^3n\u0013R,WNC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0014M&tGMR;oGRLwN\\%oG2,H-\u001a\u0006\u000baNLW\t\\3nK:$(B\u0003)tS\u0016cW-\\3oi*Y\u0011N\\2mk\u0012,g)\u001b7f\u001511WO\\2uS>tg*Y7f\u0015!9W\r^\"mCN\u001c(\"D9vC2Lg-[3e\u001d\u0006lWM\u0003\u0007dY\u0006\u001c8/\u00127f[\u0016tGOC\bDY\u0006\u001c8\u000fR3tGJL\u0007\u000f^8s\u0015I9W\r^(s\u0007J,\u0017\r^3QC\u000e\\\u0017mZ3\u000b\u0015\u001d,G\u000fU1dW\u0006<WMC\u0007hKR\u00046/[#mK6,g\u000e\u001e\u0006\bO\u0016$H+\u001f9f\u0015\u0015\tG+\u001f9f\u0015\u001dQU\r\u001e+za\u0016TQ\u0001^=qKNTQa\u0013+za\u0016T1\u0003\\8bI^K7.\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:T1\u0001]6h\u0015-awnY1uS>tgi\u001c:\u000b\u001b1Kg.Z!oI\u000e{G.^7o\u0015=!\u0015.Y4o_N$\u0018nY+uS2\u001c(b\u00033jC\u001etwn\u001d;jGNTQ\u0004R5bO:|7\u000f^5d+RLGn\u001d\u0013MS:,\u0017I\u001c3D_2,XN\u001c\u0006\u0005]\u0016DHO\u0003\u0005qe\u00164\u0018n\\;t\u00155\u0001(o\\2fgNl\u0015m\u0019:pg*\u0011B/\u001a=u/&$\bn\u00165ji\u0016\u001c\b/Y2f\u00159\u0001(o\u001c6fGR\u0014vn\u001c;ESJTAB]3mCRLg/\u001a$jY\u0016T\u0011\u0002Z5sK\u000e$xN]=\u000b\u0019A\u001b\u0018\u000eR5sK\u000e$xN]=\u000b\u0019I,G.\u0019;jm\u0016t\u0015-\\3\u000b\u000fA\u001b\u0018NR5mK*i1o\\;sG\u0016d\u0015N\\6G_JT!b]8ve\u000e,G*\u001b8f\u0015\rIe\u000e\u001e\u0006\rY&tW\rT5oWR+\u0007\u0010\u001e\u0006\u000eiJLHj\\1e%\u0016\fG-T3\u000b\u0017]L7.[\"p]Z,'\u000f\u001e\u0006\rY&t7NU3oI\u0016\u0014XM\u001d\u0006\r\u0019&t7NU3oI\u0016\u0014XM\u001d\u0006\tM&dWMT1nKF-!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\u0007)1\u0001B\u0002\t\u00071\u0001QA\u0001\u0003\u0002\u0011\u0015)1\u0001\u0002\u0003\t\n1\u0001Qa\u0001C\u0002\u0011\u0019a\u0001!B\u0002\u0005\u0007!9A\u0002A\u0003\u0002\u0011!)!\u0001\u0002\u0004\t\u0012\u0015\u0019AQ\u0002E\b\u0019\u0001)!\u0001B\u0001\t\u0015\u0015\u0019Aq\u0002E\n\u0019\u0001)!\u0001\u0002\u0003\t\n\u0015\u0011A1\u0001\u0005\u0007\u000b\t!a\u0001#\u0006\u0006\u0005\u0011M\u0001bB\u0003\u0004\t\rA9\u0002\u0004\u0001\u0006\u0005\u00111\u0001\u0002D\u0003\u0003\t-A9\"B\u0002\u0005\u0007!iA\u0002A\u0003\u0004\t\tAY\u0002\u0004\u0001\u0006\u0005\u0011M\u0001\"D\u0003\u0004\t\tAq\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001\"E\u0003\u0004\t9A\u0019\u0003\u0004\u0001\u0006\u0005\u0011q\u00012E\u0003\u0003\t\u0001AA#B\u0002\u0005 !\u001dB\u0002A\u0003\u0003\t?A9#B\u0002\u0005\u0014!9B\u0002A\u0003\u0003\t'Aq#B\u0002\u0005\u0014!MB\u0002A\u0003\u0003\t'A\u0019$B\u0002\u0005\u0007!YB\u0002A\u0003\u0004\t\tA9\u0004\u0004\u0001\u0006\u0005\u0011M\u0001bG\u0003\u0004\t\tA\t\u0005\u0004\u0001\u0006\u0005\u0011!\u0001BI\u0003\u0004\tUA\u0019\u0005\u0004\u0001\u0006\u0007\u0011\u0019\u0001R\t\u0007\u0001\u000b\t!!\u0001#\u0011\u0006\u0005\u0011)\u00022I\u0003\u0004\t\rAA\u0005\u0004\u0001\u0006\u0007\u0011\u0011\u0001\u0012\n\u0007\u0001\u000b\t!\u0011\u0001C\u0013\u0006\u0007\u0011E\u00022\n\u0007\u0001\u000b\r!\t\u0004C\u0014\r\u0001\u0015\u0011A\u0011\u0007\u0005(\u000b\r!!\u0001#\u0015\r\u0001\u0015\u0011AA\u0001E)\u000b\r!\t\u0004c\u0015\r\u0001\u0015\u0019AA\u0001\u0005+\u0019\u0001)!\u0001\u0002\u0002\tU\u0015\u0011A\u0011\u0007E*\u000b\r!\t\u0004C\u0016\r\u0001\u0015\u0011AA\u0001E\u000e\u000b\r!\t\u0004#\u0017\r\u0001\u0015\u0019AA\u0001\u0005.\u0019\u0001)!\u0001\u0002\u0002\t[\u0015\u0011A\u0011\u0007E-\u000b\t!!\u0001#\u0013\u0006\u0005\u0011E\u00022J\u0003\u0002\u0011E*!\u0001b\u0011\td\u0015\u0011AA\t\u0005\u000b\u000b\r!)\u0005#\u0019\r\u0001\u0015\u0011AQ\tE1\u000b\r!)\u0005C\u001a\r\u0001\u0015\u0011AQ\t\u00054\u000b\t!!\u0001C\b\u0006\u0007\u0011E\u0002B\u000e\u0007\u0001\u000b\t!\t\u0004\u0003\u001c\u0006\u0005\u0011E\u0002bK\u0003\u0003\t\u0005A\u0019(B\u0002\u0005O!ID\u0002A\u0003\u0004\t\tA!\b\u0004\u0001\u0006\u0005\u0011\u0011\u0001BO\u0003\u0003\t\u001dB\u0011(\u0002\u0002\u0005\u0003!iTa\u0001C*\u0011sb\u0001!B\u0002\u0005U!aD\u0002A\u0003\u0003\t'BY(b\u0002\u0005F!\r\r\u0001\u0004\u0001\u0006\b\u0011\u0015\u0003R1\u0001\r\u0001\u0015\u0015AQ\tEC\u0002\u0015\u0015AQ\tEB\u0002\u0015\u0011AA\u0001E\u001c\u000b\t!y\u0001c\u0005\u0006\b\u0011\u0019\u0001\u00022\u0001\r\u0001\u0015\u001dAq\u0004EG\u00021\u0001QQ\u0001C\u0010\u0011\u001b\u0007A\u0001\u0001G\u00033\t)\u0011\u0001c\u0002.\u0019\u0011\tM\u0002G\u0006\"\u0007\u0015\t\u0001R\u0003G\u0001+\u000e!Qa\u0001\u0003\f\u0013\u0005A9\"\f\t\u0005A\u0012AJ\"\t\u0004\u0006\u0003!a\u0011bA\u0005\u0003\u000b\u0005AI\u0002\n\u0011V\u0007\u0011i1\u0001\u0002\b\n\u0003!iQ\u0006\u0005\u0003a\tau\u0011EB\u0003\u0002\u00111I1!\u0003\u0002\u0006\u0003!mA\u0005I+\u0004\t5\u0019AqD\u0005\u0002\u00115is\u0002\u00021\u00051\u0017\t#!B\u0001\t\u000bU\u001b\u0001\"B\u0002\u0005\f%\t\u0001\"C\u0007\u0004\tAI\u0011\u0001C\u0005.\u001f\u0011\u0001G\u0001\u0007\u0003\"\u0005\u0015\t\u0001\u0012B+\u0004\u0011\u0015\u0019A\u0001B\u0005\u0002\u0011#i1\u0001\"\t\n\u0003!EQ&\u0006\u0003A\u001aa\t\u0012EA\u0003\u0002\u0011;)6AD\u0003\u0004\tEI\u0011\u0001C\b\u000e\u0007\u0011\u0011\u0012\"\u0001\u0005\u0010#\u0015!)#C\u0001\u0005\u00015\t\u0001bD\u0017\u0016\t\u0001g\u0001dE\u0011\u0003\u000b\u0005A\u0001#V\u0002\u000f\u000b\r!1#C\u0001\t\"5\u0019A\u0011F\u0005\u0002\u0011C\tR\u0001B\u000b\n\u0003\u0011\u0001Q\"\u0001E\u0011[M!\u0001\r\u0002M\u0016C\u0019)\u0011\u0001c\u0003\n\u0007%\u0011Q!\u0001E\u000b+\u000eAQa\u0001C\u0016\u0013\u0005A!\"D\u0002\u0005-%\t\u0001BC\u0017\u0018\t\u0001$\u0001TF\u0011\u000b\u000b\u0005A\u0011#C\u0002\n\u0005\u0015\t\u0001RC\u0005\u0004\u0013\t)\u0011\u0001#\u0007V\u0007!)1\u0001\"\f\n\u0003!\rRb\u0001C\u0018\u0013\u0005A\u0019#\f\t\u0005A\u0012A\u0002$\t\u0004\u0006\u0003!a\u0011bA\u0005\u0003\u000b\u0005AI\u0002\n\u0011V\u0007\u0011i1\u0001\"\r\n\u0003!iQf\u0004\u0003b\taI\u0012EB\u0003\u0002\u0011II1!\u0003\u0002\u0006\u0003!UQk\u0001\u0003\u0006\u0007\u0011I\u0012\"\u0001E\u0013[M!\u0001\r\u0002M\u0007C\u0019)\u0011\u0001c\u0003\n\u0007%\u0011Q!\u0001\u0005\b+\u000eAQa\u0001C\u0007\u0013\u0005A!\"D\u0002\u00055%\t\u0001BC\u0017\u0014\t\u0005$\u0001TG\u0011\u000b\u000b\u0005A1#C\u0002\n\u0005\u0015\t\u0001\u0002C\u0005\u0004\u0013\t)\u0011\u0001c\nV\u0007\u0011)1\u0001\"\u000e\n\u0003!!Rf\u0005\u0003a\taI\u0011EB\u0003\u0002\u0011\u0017I1!\u0003\u0002\u0006\u0003!AQk\u0001\u0005\u0006\u0007\u0011I\u0011\"\u0001\u0005\u000b\u001b\r!A$C\u0001\t\u00155\u001aB\u0001\u0019\u0003\u0019:\u00052Q!\u0001E\u0006\u0013\rI!!B\u0001\t(U\u001b\u0001\"B\u0002\u0005:%\t\u0001BC\u0007\u0004\tuI\u0011\u0001\u0003\u0006.\u0019\u0011\u0001G\u0001g\u000f\"\u0005\u0015\t\u0001R\u0003\u0013!+\u000e!Qb\u0001\u0003\u001f\u0013\u0005A9\"\f\u0007\u0005A\u0012Aj$\t\u0002\u0006\u0003!UA\u0005I+\u0004\t5\u0019AaH\u0005\u0002\u0011/iK\u0004\u0002\u0001\u0019@u5A\u0001\u0001\u0005!\u001b\t)\u0011\u0001#\u000bQ\u0007\u0001ij\u0001\u0002\u0001\tC5\u0011Q!\u0001E\u0016!\u000e\u0005\u0011EA\u0003\u0002\u0011Y\t6a\u0002C \u0013\u0005!\u0001!D\u0001\t.5\t\u0001bFW&\t\u0001A2%(\u0006\u0005\u0001!\u001dSBB\u0003\u0002\u0011_I1!\u0003\u0002\u0006\u0003!A\u0002k\u0001\u0001\u001e\u0018\u0011\u0001\u0001\"J\u0007\b\u000b\u0005AY!\u0003\u0003\n\u0007\u0015\t\u0001\"\u0007G\u0001!\u000e\u0005\u0011EA\u0003\u0002\u0011Y\t6a\u0002\u0003$\u0013\u0005!\u0001!D\u0001\t\u00155\t\u0001BC\u0017\u0014\t\tAb%(\u0004\u0005\u0001!5SBA\u0003\u0002\u0011g\u00016\u0001A\u0011\u0003\u000b\u0005A)\"U\u0002\u0006\t\u0019J\u0011\u0001c\u0006\u000e\u0003!QR\u0016\b\u0003\u00011\u001fjj\u0001\u0002\u0001\tQ5\u0011Q!\u0001E\u001b!\u000e\u0001QT\u0002\u0003\u0001\u0011\u001bj!!B\u0001\t4A\u001b\t!\t\u0002\u0006\u0003!1\u0012kA\u0004\u0005P%\tA\u0001A\u0007\u0002\u0011mi\u0011\u0001\u0003\u000e.<\u0011\u0011\u0001$KO\u0007\t\u0001A\u0001%\u0004\u0002\u0006\u0003!%\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RJ\u0007\u0003\u000b\u0005A9\u0004UB\u0001C\r)\u0011\u0001\u0003\u000f\r\u0002E\u001bq\u0001B\u0015\n\u0003!eR\"\u0001E\u0017\u001b\u0005AQ$,\u0011\u0005\u0003aUST\u0003\u0003\u0001\u0011\u0015ja!B\u0001\t\f%\u0019\u0011BA\u0003\u0002\u0011w\u00016\u0001AO\u0007\t\u0001A9&\u0004\u0002\u0006\u0003!U\u0001k!\u0001\"\u0005\u0015\t\u0001\u0012D)\u0004\u000f\u0011U\u0013\"\u0001\u0005\u001f\u001b\u0005A!\"D\u0001\t\u00185\"BA\u0001\r-;\u001b!\u0001\u0001#\u0014\u000e\u0005\u0015\t\u0001R\b)\u0004\u0001\u0005\u001aQ!\u0001\u0005 \u0019\u0003\t6!\u0002\u0003-\u0013\u0005Ay$D\u0001\tA5\"BA\u0001M.;\u001b!\u0001\u0001#\u0014\u000e\u0005\u0015\t\u0001\"\u0007)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u0019\u0019\u0003\t6!\u0002C.\u0013\u0005A\t%D\u0001\tC5\"BA\u0001\r/;\u001b!\u0001\u0001#\u0018\u000e\u0005\u0015\t\u0001R\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\u000b\u0019\u0003\t6!\u0002\u0003/\u0013\u0005A9\"D\u0001\t\u00185\"B\u0001\u0001\r0;\u001b!\u0001\u0001#\u0014\u000e\u0005\u0015\t\u00012\u0007)\u0004\u0001\u0005\u001aQ!\u0001E\u000b\u0019\u0003\t6!\u0002\u00030\u0013\u0005A9\"D\u0001\t55*BA\u0001M0;\u001f!\u0001\u0001\u0003\u0019\u000e\u0007\u0015\t\u0001b\tG\u0001!\u000e\u0001\u0011eA\u0003\u0002\u0011+a\t!U\u0002\u0006\t?J\u0011\u0001c\u0006\u000e\u0003!\u001dS\u0006\u0006\u0003\u00011?jj\u0001\u0002\u0001\tN5\u0011Q!\u0001E\u001a!\u000e\u0001\u0011eA\u0003\u0002\u0011+a\t!U\u0002\u0006\t?J\u0011\u0001c\u0006\u000e\u0003!QRf\n\u0003\u00031Ijj\u0001\u0002\u0001\tf5\u0011Q!\u0001\u0005%!\u000e\u0001QT\u0002\u0003\u0001\u0011Oj!!B\u0001\t\u0016A\u001b\t!(\u0004\u0005\u0001!!TBA\u0003\u0002\u0011+\u00016!A\u0011\u0004\u000b\u0005A)\u0002$\u0001R\u0007%!!'C\u0001\t\u00185\t\u0001\u0012J\u0007\u0002\u0011/i\u0011\u0001c\u0006.)\u0011\u0001\u0001\u0014NO\u0007\t\u0001AQ'\u0004\u0002\u0006\u0003!U\u0001k\u0001\u0001\"\u0007\u0015\t\u00012\u0004G\u0001#\u000e)A\u0011N\u0005\u0002\u0011\u0015j\u0011\u0001c\u0006.)\u0011\u0001\u0001\u0014NO\u0007\t\u0001AY'\u0004\u0002\u0006\u0003!-\u0003k\u0001\u0001\"\u0007\u0015\t\u00012\u0004G\u0001#\u000e)A\u0011N\u0005\u0002\u0011\u0015j\u0011\u0001\u0003\u0014.'\u0011\u0001\u0001TNO\u0007\t\u0001Ai%\u0004\u0002\u0006\u0003!m\u0002k\u0001\u0001\"\u0005\u0015\t\u0001\u0012D)\u0004\u000b\u00115\u0014\"\u0001\u0005\u001f\u001b\u0005Ai%\f\u000b\u0005\u0001a9TT\u0002\u0003\u0001\u0011/j!!B\u0001\t\u0016A\u001b\u0001!I\u0002\u0006\u0003!eA\u0012A)\u0004\u000b\u00119\u0014\"\u0001\u0005\u001f\u001b\u0005A9\"\f\u000b\u0005\u0001a=TT\u0002\u0003\u0001\u0011\u001bj!!B\u0001\t4A\u001b\u0001!I\u0002\u0006\u0003!!C\u0012A)\u0004\u000b\u0011=\u0014\"\u0001E%\u001b\u0005A!$L\u000b\u0005\u0001aATt\u0002\u0003\u0001\u0011cj1!B\u0001\tP1\u0005\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u000bG\u0001#\u000e)A\u0001O\u0005\u0002\u0011#j\u0011\u0001C\u0015.<\u0011\u0011\u0001TOO\u0007\t\u0001A1(\u0004\u0002\u0006\u0003!e\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002M\u0007\u0004\u000b\u0005A)\u0002$\u0001Q\u0007\u0003\t#!B\u0001\t-E\u001bq\u0001\"\u001e\n\u0003\u0011\u0001Q\"\u0001\u0005\u001f\u001b\u0005A9\"\f\u000b\u0005\u0001a]TT\u0002\u0003\u0001\u0011\u001bj!!B\u0001\t4A\u001b\u0001!I\u0002\u0006\u0003!UC\u0012A)\u0004\u000b\u0011]\u0014\"\u0001\u0005,\u001b\u0005A!$\f\u000b\u0005\u0001aqTT\u0002\u0003\u0001\u0011mj!!B\u0001\t\u001aA\u001b\u0001!I\u0002\u0006\u0003!eA\u0012A)\u0004\u000b\u0011q\u0014\"\u0001\u0005\u001f\u001b\u0005Aa$\f\u000b\u0005\u0001auTT\u0002\u0003\u0001\u0011mj!!B\u0001\t\u001aA\u001b\u0001!I\u0002\u0006\u0003!eA\u0012A)\u0004\u000b\u0011u\u0014\"\u0001\u0005\u001f\u001b\u0005Aa$,\u000f\u0005\u0005ayTT\u0002\u0003\u0001\u0011\u007fj!!B\u0001\t\u0016A\u001b\u0001!(\u0004\u0005\u0001!\u0015TBA\u0003\u0002\u0011\u0011\u00026\u0011A\u0011\u0003\u000b\u0005A)\"U\u0002\b\t}J\u0011\u0001c\u0006\u000e\u0003!]Q\"\u0001E%[+!\u0001\u0001\u0007a\u0001C\t)\u0011\u0001#\u0006R\u0007\u000f!\u0001\u0019A\u0005\u0002\u0011/i{\u0004\u0002\u0002\u0019\u0002\u0004ir\u0001\u0002\u0001\t\u0003\u0004i!!B\u0001\tXA\u001b\u0001!H\u0004\u0005\u0001!\u0011\r!\u0004\u0002\u0006\u0003!U\u0001k!\u0001\"\u0007\u0015\t\u0001\u0002\fG\u0001#\u000e=A\u00111\u0001\n\u0003!eS\"\u0001\u0005.\u001b\u0005A9\"L\n\u0005\u0001aURT\u0002\u0003\u0001\u0011Aj!!B\u0001\t\u0011A\u001b\u0001!\t\u0002\u0006\u0003!\u001d\u0012kA\u0003\u00056%\t\u00012L\u0007\u0002\u00119j\u0013\u0006\u0002\u0001\u0019\u0007\u0004ij\u0001\u0002\u0001\t`5\u0011Q!\u0001E\u000b!\u000e\u0001Qd\u0002\u0003\u0001\u0011\u000f\u0007QBA\u0003\u0002\u0011;\u00026\u0011A\u000f\b\t\u0005AI\u0019A\u0007\u0003\u000b\u0005A)\u0002U\u0002\u0002C\r)\u0011\u0001#\u0006\r\u0002E\u001b\u0019\u0002Bb\u0001\u0013\u0005A9\"D\u0001\t\u00185\tAQA\u0007\u0002\u0011/i[\u0004\u0002\u0001\u0019\u000b\u0004ij\u0001\u0002\u0001\tw5\u0011Q!\u0001E\r!\u000e\u0001QT\u0002\u0003\u0001\u0011\u001bj!!B\u0001\t4A\u001b\t!\t\u0002\u0006\u0003!1\u0012ka\u0004\u0005\u000b\u0004I\u0011\u0001\u0002\u0001\u000e\u0003!qR\"\u0001\u0005\u001b[%\"\u0001\u0001gc\u0001;\u001b!\u0001\u0001#\u0018\u000e\u0005\u0015\t\u0001R\u0003)\u0004\u0001u9A\u0001\u0001\u0005G\u00025\u0011Q!\u0001\u00050!\u000e\u0005Q\u0004\u0003\u0003\u0001\u0011\u001d\u0007QbA\u0003\u0002\u0011+a\t\u0001U\u0002\u0002C\t)\u0011\u0001#\u0006R\u0007'!Y\u0019A\u0005\u0002\u0011/i\u0011\u0001c\u0006\u000e\u0003!}S\"\u0001E\fke*\u0001\bBr\u00011\u000fij\u0001\u0002\u0001\t\t5\u0011Q!\u0001E\u0005!\u000e\u0001QT\u0002\u0003\u0001\u0011\u0017i!!B\u0001\t\u000bA\u001b\t!(\u0006\u0005\u0001!5QBB\u0003\u0002\u0011\u0017I1!\u0003\u0002\u0006\u0003!9\u0001kA\u0001\u001e\u0016\u0011\u0001\u0001\"C\u0007\u0007\u000b\u0005AY!C\u0002\n\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0004\u0005\u0012Q!\u0001E\u0003#\u000eYAqA\u0005\u0002\t\u0001i\u0011\u0001#\u0005\u000e\u0003!IQ\"\u0001\u0005\u000b\u001b\u0005A!\u0002"})
public final class KModel {
    public static final /* synthetic */ kotlin.reflect.KClass $kotlinClass;
    @NotNull
    private final SortedMap<String, KPackage> packageMap;
    @NotNull
    private PegDownProcessor markdownProcessor;
    @NotNull
    private SyntaxHighlighter highlighter;
    private String _projectRootDir;
    @NotNull
    private final List<? extends String> packageDescriptionFiles;
    private final HashSet<String> readMeDirsScanned;
    @NotNull
    private final List<? extends SourceInfo> sourcesInfo;
    private final Map<JetFile, ? extends SourceInfo> sourceInfoByFile;
    @NotNull
    private final BindingContext context;
    @NotNull
    private final KDocConfig config;
    @NotNull
    private final List<? extends File> sourceDirs;
    @NotNull
    private final List<? extends JetFile> sources;

    static {
        $kotlinClass = Reflection.createKotlinClass(KModel.class);
    }

    @NotNull
    public final SortedMap<String, KPackage> getPackageMap() {
        return this.packageMap;
    }

    @NotNull
    public final Collection<KPackage> getAllPackages() {
        Collection<KPackage> collection = this.packageMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"packageMap.values()");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<KPackage> getPackages() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.getAllPackages();
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            KPackage it = (KPackage)element;
            if (!this.getConfig().includePackage(it)) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<KClass> getClasses() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.getPackages();
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            KPackage it = (KPackage)element;
            Iterable list = it.getClasses();
            KotlinPackage.addAll((Collection)destination, (Iterable)list);
        }
        return (List)var3_3;
    }

    @NotNull
    public final PegDownProcessor getMarkdownProcessor() {
        return this.markdownProcessor;
    }

    public final void setMarkdownProcessor(@JetValueParameter(name="<set-?>") @NotNull PegDownProcessor pegDownProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)pegDownProcessor, (String)"<set-?>");
        this.markdownProcessor = pegDownProcessor;
    }

    @NotNull
    public final SyntaxHighlighter getHighlighter() {
        return this.highlighter;
    }

    public final void setHighlighter(@JetValueParameter(name="<set-?>") @NotNull SyntaxHighlighter syntaxHighlighter) {
        Intrinsics.checkParameterIsNotNull((Object)syntaxHighlighter, (String)"<set-?>");
        this.highlighter = syntaxHighlighter;
    }

    @NotNull
    public final String getTitle() {
        return this.config.getTitle();
    }

    @NotNull
    public final String getVersion() {
        return this.config.getVersion();
    }

    @NotNull
    public final List<String> getPackageDescriptionFiles() {
        return this.packageDescriptionFiles;
    }

    @NotNull
    public final List<SourceInfo> getSourcesInfo() {
        return this.sourcesInfo;
    }

    @NotNull
    public final SourceInfo sourceInfoByFile(@JetValueParameter(name="file") @NotNull JetFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        SourceInfo sourceInfo = this.sourceInfoByFile.get(file);
        if (sourceInfo == null) {
            Intrinsics.throwNpe();
        }
        return sourceInfo;
    }

    @NotNull
    public final String projectRootDir() {
        String string;
        if (this._projectRootDir == null) {
            String string2;
            String rootDir = this.config.getProjectRootDir();
            if (rootDir == null) {
                ModelPackage$KotlinModel$f59ec484.warning("KDocConfig does not have a projectRootDir defined so we cannot generate relative source Hrefs");
                string2 = "";
            } else {
                string2 = this._projectRootDir = new File(rootDir).getCanonicalPath();
            }
        }
        if ((string = this._projectRootDir) == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final KPackage getPackage(@JetValueParameter(name="name") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (KPackage)this.packageMap.get(name);
    }

    @NotNull
    public final KPackage getOrCreatePackage(@JetValueParameter(name="descriptor") @NotNull PackageFragmentDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        String name = ModelPackage$KotlinModel$f59ec484.qualifiedName((DeclarationDescriptor)descriptor);
        KPackage pkg = (KPackage)this.packageMap.get(name);
        if (pkg != null) {
            return pkg;
        }
        return this.createPackage(KotlinPackage.listOf((Object)descriptor), name);
    }

    private final KPackage createPackage(@JetValueParameter(name="descriptors") List<? extends PackageFragmentDescriptor> descriptors, @JetValueParameter(name="name") String name) {
        KPackage pkg = new KPackage(this, descriptors, name, KotlinPackage.isNotEmpty((String)this.config.resolveLink(name, false)));
        boolean bl = !this.packageMap.containsKey(name);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String message = "packageMap entry created earlier for package " + name + ": old=" + (KPackage)this.getPackageMap().get(name) + ", new=" + pkg;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        KotlinPackage.set((Map)this.packageMap, (Object)name, (Object)pkg);
        for (PackageFragmentDescriptor packageFragmentDescriptor : descriptors) {
            this.addFunctions(pkg, packageFragmentDescriptor.getMemberScope());
        }
        String string = this.config.getPackageDescriptionFiles().get(name);
        this.loadWikiDescription(pkg, string);
        return pkg;
    }

    protected final void loadWikiDescription(@JetValueParameter(name="pkg") @NotNull KPackage pkg, @JetValueParameter(name="file", type="?") @Nullable String file) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        if (file != null) {
            try {
                ((KAnnotated)pkg).setWikiDescription(IoPackage.readText$default((File)new File(file), null, (int)1));
            }
            catch (Throwable e) {
                ModelPackage$KotlinModel$f59ec484.warning("Failed to load package " + pkg.getName() + " documentation file " + file + ". Reason " + e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void tryLoadReadMe(@JetValueParameter(name="pkg") @NotNull KPackage pkg, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        String srcPath;
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        if (KotlinPackage.isEmpty((String)((KAnnotated)pkg).getWikiDescription()) && (srcPath = ((KAnnotated)pkg).getModel().filePath(descriptor)) != null) {
            File dir;
            File srcFile = new File(srcPath);
            File file = dir = srcFile.isDirectory() ? srcFile : srcFile.getParentFile();
            if (dir != null && this.readMeDirsScanned.add(dir.getPath())) {
                Object v1;
                block6: {
                    void destination;
                    Iterable $receiver;
                    Iterable $receiver2;
                    Iterable iterable = this.packageDescriptionFiles;
                    void var8_7 = $receiver2;
                    Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                    for (Object item : $receiver) {
                        void it;
                        String string = (String)item;
                        void var13_12 = destination;
                        File file2 = new File(dir, (String)it);
                        var13_12.add(file2);
                    }
                    $receiver2 = (List)destination;
                    $receiver = $receiver2;
                    for (Object element : $receiver) {
                        File it = (File)element;
                        if (!it.exists()) continue;
                        v1 = element;
                        break block6;
                    }
                    v1 = null;
                }
                File f = v1;
                if (f != null) {
                    String file3 = f.getCanonicalPath();
                    this.loadWikiDescription(pkg, file3);
                } else {
                    ModelPackage$KotlinModel$f59ec484.info("package " + pkg.getName() + " has no ReadMe.(html|md) in " + dir);
                }
            }
        }
    }

    @NotNull
    public final String wikiConvert(@JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="linkRenderer") @NotNull LinkRenderer linkRenderer, @JetValueParameter(name="fileName", type="?") @Nullable String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)linkRenderer, (String)"linkRenderer");
        String string = this.markdownProcessor.markdownToHtml(text, linkRenderer);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Nullable
    public final String sourceLinkFor(@JetValueParameter(name="filePath") @NotNull String filePath, @JetValueParameter(name="sourceLine") int sourceLine, @JetValueParameter(name="lineLinkText") @NotNull String lineLinkText) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)lineLinkText, (String)"lineLinkText");
        String root = this.config.getSourceRootHref();
        if (root != null) {
            String rootDir = this.projectRootDir();
            String canonicalFile = new File(filePath).getCanonicalPath();
            String relativeFile = KotlinPackage.startsWith$default((String)canonicalFile, (String)rootDir, (boolean)false, (int)2) ? KotlinPackage.substring((String)canonicalFile, (int)rootDir.length()) : canonicalFile;
            String cleanRoot = KotlinPackage.trimTrailing((String)root, (String)"/");
            String cleanPath = KotlinPackage.trimLeading((String)relativeFile, (String)"/");
            return cleanRoot + "/" + cleanPath + lineLinkText + sourceLine;
        }
        return null;
    }

    @Nullable
    public static /* synthetic */ String sourceLinkFor$default(KModel kModel, String string, int n, String string2, int n2) {
        if ((n2 & 4) != 0) {
            string2 = "#L";
        }
        return kModel.sourceLinkFor(string, n, string2);
    }

    public final void addFunctions(@JetValueParameter(name="owner") @NotNull KClassOrPackage owner, @JetValueParameter(name="scope") @NotNull JetScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        try {
            Collection descriptors = scope.getAllDescriptors();
            for (DeclarationDescriptor descriptor : descriptors) {
                KFunction function;
                if (descriptor instanceof PropertyDescriptor) {
                    String name = ((PropertyDescriptor)descriptor).getName().asString();
                    KType returnType = this.getType(((PropertyDescriptor)descriptor).getReturnType());
                    if (returnType == null) continue;
                    ReceiverParameterDescriptor receiver = ((PropertyDescriptor)descriptor).getExtensionReceiverParameter();
                    KType extensionClass = receiver != null ? this.getType(receiver.getType()) : (KType)null;
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                    String string = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                    KType kType = extensionClass;
                    KProperty property = new KProperty(owner, propertyDescriptor, string, returnType, kType != null ? kType.getKlass() : null);
                    owner.getProperties().add(property);
                    continue;
                }
                if (!(descriptor instanceof CallableDescriptor) || (function = this.createFunction(owner, (CallableDescriptor)descriptor)) == null) continue;
                owner.getFunctions().add(function);
            }
        }
        catch (Throwable e) {
            ModelPackage$KotlinModel$f59ec484.warning("Caught exception finding function declarations on " + owner + " " + e);
            e.printStackTrace();
        }
    }

    @Nullable
    protected final KFunction createFunction(@JetValueParameter(name="owner") @NotNull KClassOrPackage owner, @JetValueParameter(name="descriptor") @NotNull CallableDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        KType returnType = this.getType(descriptor.getReturnType());
        if (returnType != null) {
            String name = descriptor.getName().asString();
            ArrayList<KParameter> parameters = new ArrayList<KParameter>();
            List params = descriptor.getValueParameters();
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                ValueParameterDescriptor param;
                ValueParameterDescriptor valueParameterDescriptor = param = (ValueParameterDescriptor)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"param");
                KParameter p = this.createParameter(valueParameterDescriptor);
                if (p == null) continue;
                parameters.add(p);
            }
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            KFunction function = new KFunction(descriptor, owner, string, returnType, parameters, null, null, null, null, null, null, 2016, null);
            List<KTypeParameter> list = function.getTypeParameters();
            List list2 = descriptor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"descriptor.getTypeParameters()");
            this.addTypeParameters(list, list2);
            this.configureComments(function, (DeclarationDescriptor)descriptor);
            ReceiverParameterDescriptor receiver = descriptor.getExtensionReceiverParameter();
            if (receiver != null) {
                KType receiverType = this.getType(receiver.getType());
                function.setReceiverType(receiverType);
                KType kType = receiverType;
                function.setExtensionClass(kType != null ? kType.getKlass() : null);
            }
            return function;
        }
        return null;
    }

    public final void addTypeParameters(@JetValueParameter(name="answer") @NotNull List<KTypeParameter> answer, @JetValueParameter(name="descriptors") @NotNull List<? extends TypeParameterDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(answer, (String)"answer");
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        for (TypeParameterDescriptor typeParameterDescriptor : descriptors) {
            KTypeParameter p;
            if (typeParameterDescriptor == null || (p = this.createTypeParameter(typeParameterDescriptor)) == null) continue;
            answer.add(p);
        }
    }

    @Nullable
    protected final KTypeParameter createTypeParameter(@JetValueParameter(name="descriptor") @NotNull TypeParameterDescriptor descriptor) {
        String name;
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        String string = name = descriptor.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        KTypeParameter answer = new KTypeParameter(string, descriptor, this, null, 8, null);
        this.configureComments(answer, (DeclarationDescriptor)descriptor);
        return answer;
    }

    @Nullable
    protected final KParameter createParameter(@JetValueParameter(name="descriptor") @NotNull ValueParameterDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        KType returnType = this.getType(descriptor.getReturnType());
        if (returnType != null) {
            String name;
            String string = name = descriptor.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            KParameter answer = new KParameter(descriptor, string, returnType);
            this.configureComments(answer, (DeclarationDescriptor)descriptor);
            return answer;
        }
        return null;
    }

    @Nullable
    public final DiagnosticUtils.LineAndColumn locationFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.getPsiElement(descriptor);
        if (psiElement != null) {
            Document document;
            PsiFile psiFile = psiElement.getContainingFile();
            Document document2 = psiFile != null && (psiFile = psiFile.getViewProvider()) != null ? psiFile.getDocument() : (document = null);
            if (document != null) {
                int offset = psiElement.getTextOffset();
                return DiagnosticUtils.offsetToLineAndColumn((Document)document, (int)offset);
            }
        }
        return null;
    }

    @Nullable
    public final String fileFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.getPsiElement(descriptor);
        PsiElement psiElement2 = psiElement;
        return psiElement2 != null && (psiElement2 = psiElement2.getContainingFile()) != null ? psiElement2.getName() : null;
    }

    @Nullable
    public final String filePath(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement2 = psiElement = this.getPsiElement(descriptor);
        PsiFile file = psiElement2 != null ? psiElement2.getContainingFile() : null;
        return this.filePath((PsiFileSystemItem)file);
    }

    @Nullable
    public final PsiElement getPsiElement(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        try {
            psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)descriptor);
        }
        catch (Throwable e) {
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String commentsFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.getPsiElement(descriptor);
        if (psiElement != null) {
            ASTNode node;
            ASTNode aSTNode = psiElement.getNode();
            Object object = node = aSTNode != null ? aSTNode.getTreePrev() : null;
            while (node != null) {
                ASTNode aSTNode2 = node;
                if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)JetTokens.WHITE_SPACE)) {
                    ASTNode aSTNode3 = node;
                    if (!Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)JetTokens.BLOCK_COMMENT)) break;
                }
                ASTNode aSTNode4 = node;
                node = aSTNode4 != null ? aSTNode4.getTreePrev() : null;
            }
            if (node == null) {
                return "";
            }
            ASTNode aSTNode5 = node;
            if (Intrinsics.areEqual((Object)(aSTNode5 != null ? aSTNode5.getElementType() : null), (Object)JetTokens.DOC_COMMENT) ^ true) {
                return "";
            }
            Object object2 = node;
            if (object2 == null || (object2 = object2.getText()) == null) {
                object2 = "";
            }
            Object nodeText = object2;
            List lines = KotlinPackage.split$default((String)KotlinPackage.trim((String)nodeText), (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6);
            StringBuilder buffer = new StringBuilder();
            int last = KotlinPackage.getSize((Collection)lines) - 1;
            int n = 0;
            int n2 = last;
            if (n <= n2) {
                while (true) {
                    void i;
                    String text = (String)lines.get((int)i);
                    text = KotlinPackage.trim((String)text);
                    if (i == false) {
                        text = KotlinPackage.trimLeading((String)KotlinPackage.trimLeading((String)text, (String)"/**"), (String)"/*");
                    } else {
                        buffer.append("\n");
                    }
                    if (i >= last) {
                        text = KotlinPackage.trimTrailing((String)text, (String)"*/");
                    } else if (i > false && Intrinsics.areEqual((Object)(text = KotlinPackage.trimLeading((String)text, (String)"* ")), (Object)"*")) {
                        text = "";
                    }
                    text = this.processMacros(text, psiElement);
                    buffer.append(text);
                    if (i == n2) break;
                    ++i;
                }
            }
            String string = buffer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
            return string;
        }
        return "";
    }

    @NotNull
    protected final String processMacros(@JetValueParameter(name="textWithWhitespace") @NotNull String textWithWhitespace, @JetValueParameter(name="psiElement") @NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull((Object)textWithWhitespace, (String)"textWithWhitespace");
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        String text = KotlinPackage.trim((String)textWithWhitespace);
        if (KotlinPackage.startsWith$default((String)text, (String)"@", (boolean)false, (int)2)) {
            String macro;
            String remaining = KotlinPackage.substring((String)text, (int)1);
            if (KotlinPackage.startsWith$default((String)remaining, (String)(macro = "includeFunctionBody"), (boolean)false, (int)2)) {
                String next = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)macro.length()));
                List words = KotlinPackage.split$default((String)next, (Regex)KotlinPackage.toRegex((String)"\\s"), (int)0, (int)2);
                if (KotlinPackage.getSize((Collection)words) > 1) {
                    String fnName;
                    String includeFile = (String)words.get(0);
                    String content = this.findFunctionInclude(psiElement, includeFile, fnName = (String)words.get(1));
                    if (content != null) {
                        return content;
                    }
                    ModelPackage$KotlinModel$f59ec484.warning("could not find function " + fnName + " in file " + includeFile + " from source file " + psiElement.getContainingFile());
                }
            } else {
                ModelPackage$KotlinModel$f59ec484.warning("Unknown kdoc macro @" + remaining);
            }
        }
        return textWithWhitespace;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final String findFunctionInclude(@JetValueParameter(name="psiElement") @NotNull PsiElement psiElement, @JetValueParameter(name="includeFile") @NotNull String includeFile, @JetValueParameter(name="functionName") @NotNull String functionName) {
        PsiDirectory dir;
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        Intrinsics.checkParameterIsNotNull((Object)includeFile, (String)"includeFile");
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        PsiFile psiFile = psiElement.getContainingFile();
        Object object = dir = psiFile != null ? psiFile.getParent() : null;
        if (dir != null) {
            int idx;
            String remaining;
            String content;
            Regex regex;
            Matcher matcher;
            String text;
            PsiFile file;
            PsiDirectory psiDirectory = dir;
            if (psiDirectory == null) {
                Intrinsics.throwNpe();
            }
            if ((file = this.relativeFile(psiDirectory, includeFile)) != null && (text = file.getText()) != null && (matcher = (regex = KotlinPackage.toRegex((String)("fun" + "\\" + "s+" + functionName + "\\" + "(.*" + "\\" + ")"))).matcher((CharSequence)text)).find() && (content = this.extractBlock(remaining = KotlinPackage.substring((String)text, (int)(idx = matcher.end())))) != null) {
                void $receiver;
                String highlight = this.highlighter.highlight(content);
                String filePath = this.filePath((PsiFileSystemItem)file);
                String string = KotlinPackage.substring((String)text, (int)0, (int)idx);
                int count = 0;
                CharIterator charIterator = KotlinPackage.iterator((CharSequence)((CharSequence)$receiver));
                while (charIterator.hasNext()) {
                    char element = charIterator.nextChar();
                    char it = element;
                    if (!(it == '\n')) continue;
                    ++count;
                }
                int sourceLine = count + 1;
                String link = filePath != null ? KModel.sourceLinkFor$default(this, filePath, sourceLine, null, 4) : (String)null;
                return link != null ? "<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + link + "\"" + " target=" + "\"" + "_top" + "\"" + "  class=" + "\"" + "repoSourceCode" + "\"" + ">source</a></div>" + "\n" + highlight : highlight;
            }
        }
        return null;
    }

    @Nullable
    protected final String filePath(@JetValueParameter(name="file", type="?") @Nullable PsiFileSystemItem file) {
        PsiFileSystemItem dir;
        if (file != null && (dir = file.getParent()) != null) {
            String string = this.filePath(dir);
            if (string == null) {
                string = "";
            }
            String parentName = string;
            return parentName + "/" + file.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final String extractBlock(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int idx = KotlinPackage.indexOf$default((String)text, (char)'{', (int)0, (boolean)false, (int)6);
        if (idx >= 0) {
            String line22;
            int nidx;
            String remaining = KotlinPackage.substring((String)text, (int)(idx + 1));
            while ((nidx = KotlinPackage.indexOf$default((String)remaining, (char)'\n', (int)0, (boolean)false, (int)6)) >= 0 && KotlinPackage.isEmpty((String)(line22 = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)0, (int)nidx))))) {
                remaining = KotlinPackage.substring((String)remaining, (int)(nidx + 1));
            }
            int count = 1;
            int line22 = 0;
            int n = KotlinPackage.getSize((String)remaining) - 1;
            if (line22 <= n) {
                while (true) {
                    void i;
                    char ch;
                    if ((ch = remaining.charAt((int)i)) == '{') {
                        ++count;
                    } else if (ch == '}' && --count <= 0) {
                        return KotlinPackage.substring((String)remaining, (int)0, (int)i);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            ModelPackage$KotlinModel$f59ec484.warning("missing } in code block for " + remaining);
            return remaining;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiFile relativeFile(@JetValueParameter(name="directory") @NotNull PsiDirectory directory, @JetValueParameter(name="relativeName") @NotNull String relativeName) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)relativeName, (String)"relativeName");
        PsiDirectory dir = directory;
        List paths = KotlinPackage.split$default((String)relativeName, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6);
        int size = KotlinPackage.getSize((Collection)paths);
        int n = 0;
        int n2 = size - 2;
        if (n <= n2) {
            while (true) {
                void i;
                String path;
                if (!Intrinsics.areEqual((Object)(path = (String)paths.get((int)i)), (Object)".")) {
                    if (Intrinsics.areEqual((Object)path, (Object)"..")) {
                        PsiDirectory psiDirectory = dir;
                        dir = psiDirectory != null ? psiDirectory.getParent() : null;
                    } else {
                        PsiDirectory psiDirectory = dir;
                        Object object = dir = psiDirectory != null ? psiDirectory.findSubdirectory(path) : null;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        String name = (String)paths.get(size - 1);
        if (dir != null) {
            PsiFile file;
            PsiDirectory psiDirectory = dir;
            Object object = file = psiDirectory != null ? psiDirectory.findFile(name) : null;
            if (file != null) {
                return file;
            }
            ModelPackage$KotlinModel$f59ec484.warning("could not find file " + relativeName + " in " + dir + " with name " + name);
        }
        return null;
    }

    public final void configureComments(@JetValueParameter(name="annotated") @NotNull KAnnotated annotated, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)annotated, (String)"annotated");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        String detailedText = KotlinPackage.trim((String)this.commentsFor(descriptor));
        annotated.setWikiDescription(detailedText);
    }

    @Nullable
    public final KType getType(@JetValueParameter(name="aType", type="?") @Nullable JetType aType) {
        if (aType != null) {
            KClass kClass;
            ClassifierDescriptor classifierDescriptor = aType.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"classifierDescriptor");
                kClass = this.getClass(classDescriptor);
            } else {
                kClass = null;
            }
            KClass klass = kClass;
            return new KType(aType, this, klass, null, 8, null);
        }
        return null;
    }

    @Nullable
    public final KClass getClass(@JetValueParameter(name="qualifiedName") @NotNull String qualifiedName) {
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        int idx = KotlinPackage.lastIndexOf$default((String)qualifiedName, (char)'.', (int)0, (boolean)false, (int)6);
        String pkgName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)0, (int)idx) : "";
        KPackage pkg = this.getPackage(pkgName);
        if (pkg != null) {
            String simpleName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)(idx + 1)) : qualifiedName;
            return (KClass)pkg.getClassMap().get(simpleName);
        }
        return null;
    }

    @Nullable
    public final KClass getClass(@JetValueParameter(name="classElement") @NotNull ClassDescriptor classElement) {
        Intrinsics.checkParameterIsNotNull((Object)classElement, (String)"classElement");
        String name = classElement.getName().asString();
        DeclarationDescriptor dec = classElement.getContainingDeclaration();
        while (dec != null) {
            DeclarationDescriptor container = dec;
            if (container instanceof PackageFragmentDescriptor) {
                KPackage pkg = this.getOrCreatePackage((PackageFragmentDescriptor)container);
                return pkg.getClass(classElement);
            }
            DeclarationDescriptor declarationDescriptor = dec;
            dec = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        }
        ModelPackage$KotlinModel$f59ec484.warning("no package found for class " + name);
        return null;
    }

    @Nullable
    public final KPackage previous(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        return null;
    }

    @Nullable
    public final KPackage next(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        return null;
    }

    @NotNull
    public final BindingContext getContext() {
        return this.context;
    }

    @NotNull
    public final KDocConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final List<File> getSourceDirs() {
        return this.sourceDirs;
    }

    @NotNull
    public final List<JetFile> getSources() {
        return this.sources;
    }

    /*
     * WARNING - void declaration
     */
    public KModel(@JetValueParameter(name="context") @NotNull BindingContext context, @JetValueParameter(name="config") @NotNull KDocConfig config, @JetValueParameter(name="sourceDirs") @NotNull List<? extends File> sourceDirs, @JetValueParameter(name="sources") @NotNull List<? extends JetFile> sources) {
        void map;
        void $receiver;
        void $receiver2;
        Iterable packageFragment;
        String htmlPath;
        void destination;
        void $receiver22;
        void $receiver3;
        Object object;
        KModel kModel;
        void destination2;
        Object item22;
        Iterable $receiver32;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(sourceDirs, (String)"sourceDirs");
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.context = context;
        this.config = config;
        this.sourceDirs = sourceDirs;
        this.sources = sources;
        this.packageMap = KotlinPackage.sortedMapOf((Pair[])new Pair[0]);
        this.markdownProcessor = new PegDownProcessor(Extensions.ALL);
        this.highlighter = new SyntaxHighlighter();
        this.packageDescriptionFiles = KotlinPackage.listOf((Object[])new String[]{"readme.md", "ReadMe.md, readme.html, ReadMe.html"});
        this.readMeDirsScanned = new HashSet();
        Iterable object2 = this.sourceDirs;
        Object object3 = object2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)object2, (int)10));
        for (Object item22 : $receiver32) {
            void file;
            Iterator iterator = (File)item22;
            kModel = destination2;
            object = file.getCanonicalPath();
            kModel.add(object);
        }
        final List normalizedSourceDirs = (List)destination2;
        Function1<PsiFile, String> function1 = new Function1<PsiFile, String>(){

            @NotNull
            public final String invoke(@JetValueParameter(name="psiFile") @NotNull PsiFile psiFile) {
                Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null) {
                    throw new TypeCastException("com.intellij.openapi.vfs.VirtualFile! cannot be cast to com.intellij.openapi.vfs.local.CoreLocalVirtualFile");
                }
                String string = ((CoreLocalVirtualFile)virtualFile).getPath();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                File file = new File(string).getCanonicalFile();
                String filePath = file.getPath();
                for (String sourceDirPath : normalizedSourceDirs) {
                    if (!KotlinPackage.startsWith$default((String)filePath, (String)sourceDirPath, (boolean)false, (int)2) || filePath.length() <= sourceDirPath.length()) continue;
                    return KotlinPackage.substring((String)filePath, (int)(KotlinPackage.getLength((CharSequence)sourceDirPath) + 1));
                }
                throw (Throwable)new Exception(file + " is not a child of any source roots " + normalizedSourceDirs);
            }
        };
        $receiver32 = this.sources;
        kModel = this;
        destination2 = $receiver3;
        Collection collection2 = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item3 : $receiver22) {
            void source;
            JetFile jetFile = (JetFile)item3;
            object = destination;
            String relativePath = function1.invoke((PsiFile)source);
            htmlPath = KotlinPackage.replaceFirst((String)relativePath, (Regex)KotlinPackage.toRegex((String)"\\.kt$"), (String)"") + ".html";
            SourceInfo sourceInfo = new SourceInfo((JetFile)source, relativePath, htmlPath);
            object.add(sourceInfo);
        }
        kModel.sourcesInfo = object = (List)destination;
        this.sourceInfoByFile = DocPackage$collections$f9a3b1f1.toHashMapMappingToKey(this.sourcesInfo, sourceInfoByFile.1.INSTANCE$);
        HashSet<Iterable> allPackageFragments = new HashSet<Iterable>();
        for (JetFile jetFile : this.sources) {
            packageFragment = (PackageFragmentDescriptor)this.context.get((ReadOnlySlice)BindingContext.FILE_TO_PACKAGE_FRAGMENT, (Object)jetFile);
            if (packageFragment != null) {
                allPackageFragments.add(packageFragment);
                continue;
            }
            ModelPackage$KotlinModel$f59ec484.warning("No PackageFragmentDescriptor for source " + jetFile);
        }
        packageFragment = allPackageFragments;
        destination = $receiver2;
        item22 = new LinkedHashMap();
        for (Object element : $receiver) {
            Object object4;
            void $receiver5;
            PackageFragmentDescriptor it = (PackageFragmentDescriptor)element;
            String key = ModelPackage$KotlinModel$f59ec484.qualifiedName((DeclarationDescriptor)it);
            htmlPath = map;
            if ($receiver5.containsKey(key)) {
                object4 = $receiver5.get(key);
            } else {
                ArrayList answer = new ArrayList();
                $receiver5.put(key, answer);
                object4 = answer;
            }
            List list = (List)object4;
            list.add(element);
        }
        object3 = KotlinPackage.iterator((Map)map);
        while (object3.hasNext()) {
            Map.Entry entry = (Map.Entry)object3.next();
            String name = (String)KotlinPackage.component1((Map.Entry)entry);
            List packageFragments = (List)KotlinPackage.component2((Map.Entry)entry);
            this.createPackage(packageFragments, name);
            for (PackageFragmentDescriptor packageFragment2 : packageFragments) {
                for (DeclarationDescriptor descriptor : packageFragment2.getMemberScope().getAllDescriptors()) {
                    if (!(descriptor instanceof ClassDescriptor)) continue;
                    this.getClass((ClassDescriptor)descriptor);
                }
            }
        }
    }
}

