/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.ModelPackage$KotlinModel$f59ec484;
import org.jetbrains.kotlin.doc.templates.PackageTemplateSupport;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\t\u0006)!\u0002+Y2lC\u001e,gI]1nKR+W\u000e\u001d7bi\u0016T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004I>\u001c'\"\u0003;f[Bd\u0017\r^3t\u0015Y\u0001\u0016mY6bO\u0016$V-\u001c9mCR,7+\u001e9q_J$(B\u0002\u001fj]&$hHC\u0003n_\u0012,GN\u0003\u0004L\u001b>$W\r\u001c\u0006\u0002a*A1\nU1dW\u0006<WM\u0003\u0005hKRlu\u000eZ3m\u00151\u0001(/\u001b8u\u00072\f7o]3t\u0015\u0011Y\u0017N\u001c3\u000b\rM#(/\u001b8h\u0015-!Wm]2sSB$\u0018n\u001c8\u000b\tUs\u0017\u000e\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'b\u00069sS:$X\t\u001f;f]NLwN\u001c$v]\u000e$\u0018n\u001c8t\u00159\u0001(/\u001b8u\rVt7\r^5p]NTa\u0003\u001d:j]R\u0004\u0016mY6bO\u0016\u0004&o\u001c9feRLWm\u001d\u0006\u0007e\u0016tG-\u001a:s\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00071\u0001QA\u0001C\u0002\u0011\u0011)1\u0001b\u0002\t\n1\u0001Qa\u0001C\u0004\u0011\u0017a\u0001!\u0002\u0002\u0005\b!%QA\u0001C\u0004\u0011\u0017)\u0011\u0001c\u0001\u0006\u0007\u00111\u0001r\u0002\u0007\u0001\u000b\r!a\u0001#\u0005\r\u0001\u0015\t\u0001\"C\u0003\u0003\t\u001fA\u0019\"\u0002\u0002\u0005\u0011!=A\u0001\u0001G\u00033\t)\u0011\u0001C\u0002.\u001f\u0011\u0001G\u0001\u0007\u0003\"\u0005\u0015\t\u0001\u0002B+\u0004\u0011\u0015\u0019A\u0001B\u0005\u0002\u0011\u0015i1\u0001\u0002\u0004\n\u0003!)Q\u0016\b\u0003\u00031\u001bij\u0001\u0002\u0001\t\u000f5\u0011Q!\u0001E\u0007!\u000e\u0001QT\u0002\u0003\u0001\u0011!i!!B\u0001\t\u000eA\u001b\t!\t\u0002\u0006\u0003!9\u0011kA\u0004\u0005\u000e%\tA\u0001A\u0007\u0002\u0011#i\u0011\u0001#\u0005.\u0014\u0011\u0011\u0001DC\u0011\u0003\u000b\u0005Aq!U\u0002\u0004\t)I\u0011\u0001\u0002\u0001.\u0014\u0011\u0011\u0001TC\u0011\u0003\u000b\u0005Aq!U\u0002\u0004\t+I\u0011\u0001\u0002\u0001.\u0014\u0011\u0011\u0001dC\u0011\u0003\u000b\u0005Aq!U\u0002\u0004\t-I\u0011\u0001\u0002\u0001.\u0014\u0011A\u0001tC\u0011\u0003\u000b\u0005Aq!U\u0002\u0004\t/I\u0011\u0001\u0002\u00016=\u0015iBa9\u0001\u0019\bu5A\u0001\u0001\u0005\u0005\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\u000b5\u0011Q!\u0001E\u0005!\u000e\u0005\u0011EA\u0003\u0002\u0011\u000b\t6a\u0002C\u0004\u0013\u0005!\u0001!D\u0001\t\u000b5\t\u00012\u0002"})
public final class PackageFrameTemplate
extends PackageTemplateSupport {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final KModel model;

    static {
        $kotlinClass = Reflection.createKotlinClass(PackageFrameTemplate.class);
    }

    @Override
    public void render() {
        this.println("<!DOCTYPE HTML PUBLIC " + "\"" + "-//W3C//DTD HTML 4.01 Transitional//EN" + "\"" + " " + "\"" + "http://www.w3.org/TR/html4/loose.dtd" + "\"" + ">" + "\n" + "<!--NewPage-->" + "\n" + "<HTML>" + "\n" + "<HEAD>" + "\n" + this.getGeneratedComment() + "\n" + "<META http-equiv=" + "\"" + "Content-Type" + "\"" + " content=" + "\"" + "text/html; charset=UTF-8" + "\"" + ">" + "\n" + "<TITLE>" + "\n" + this.getPkg().getName() + " (" + this.model.getTitle() + ")" + "\n" + "</TITLE>" + "\n" + "\n" + "<META NAME=" + "\"" + "date" + "\"" + " CONTENT=" + "\"" + "2012-01-09" + "\"" + ">" + "\n" + this.stylesheets() + "\n" + "\n" + "</HEAD>" + "\n" + "\n" + "<BODY BGCOLOR=" + "\"" + "white" + "\"" + ">" + "\n" + "<FONT size=" + "\"" + "+1" + "\"" + " CLASS=" + "\"" + "FrameTitleFont" + "\"" + ">" + "\n" + "<A HREF=" + "\"" + this.getPkg().getNameAsRelativePath() + this.getPkg().getNameAsPath() + "/package-summary.html" + "\"" + " target=" + "\"" + "classFrame" + "\"" + ">" + this.getPkg().getName() + "</A></FONT>");
        this.printClasses("trait", "Traits");
        this.printClasses("class", "Classes");
        this.printClasses("enum", "Enums");
        this.printClasses("annotation", "Annotations");
        this.printClasses("exception", "Exceptions");
        this.printPackageProperties();
        this.printFunctions();
        this.printExtensionFunctions();
        this.println("</BODY>\n</HTML>");
    }

    /*
     * WARNING - void declaration
     */
    protected final void printClasses(@JetValueParameter(name="kind") @NotNull String kind, @JetValueParameter(name="description") @NotNull String description) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Iterable iterable = this.getPkg().getClasses();
        Iterator iterator = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            org.jetbrains.kotlin.doc.model.KClass it = (org.jetbrains.kotlin.doc.model.KClass)element;
            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)kind)) continue;
            destination.add(element);
        }
        List classes = (List)destination;
        if (!classes.isEmpty()) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">");
            this.print(description);
            this.println("</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            for (org.jetbrains.kotlin.doc.model.KClass c : classes) {
                String formatted = Intrinsics.areEqual((Object)kind, (Object)"interface") ? "<I>" + c.getSimpleName() + "</I>" : c.getSimpleName();
                this.println("<A HREF=" + "\"" + c.getSimpleName() + ".html" + "\"" + " title=" + "\"" + kind + " in " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + ">" + formatted + "</A>" + "\n" + "<BR>");
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    protected final void printFunctions() {
        Collection<KFunction> functions = ModelPackage$KotlinModel$f59ec484.filterDuplicateNames((Collection<? extends KFunction>)this.getPkg().packageFunctions());
        if (!functions.isEmpty()) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Functions</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            String lastName = "";
            for (KFunction c : functions) {
                if (Intrinsics.areEqual((Object)c.getName(), (Object)lastName) ^ true) {
                    this.println("<A HREF=" + "\"" + this.href(c) + "\"" + " title=" + "\"" + "function in " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + "><I>" + c.getName() + "</I></A>" + "\n" + "    <BR>");
                }
                lastName = c.getName();
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    protected final void printExtensionFunctions() {
        Map<org.jetbrains.kotlin.doc.model.KClass, List<? extends KFunction>> map = ModelPackage$KotlinModel$f59ec484.extensionFunctions((Collection<? extends KFunction>)((KClassOrPackage)this.getPkg()).getFunctions());
        if (!map.isEmpty()) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Extensions</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            Iterator iterator = KotlinPackage.iterator(map);
            while (iterator.hasNext()) {
                Map.Entry e = (Map.Entry)iterator.next();
                org.jetbrains.kotlin.doc.model.KClass c = (org.jetbrains.kotlin.doc.model.KClass)KotlinPackage.getKey((Map.Entry)e);
                this.println("<A HREF=" + "\"" + this.extensionsHref(this.getPkg(), c) + "\"" + " title=" + "\"" + "extensions functions on class " + c.getName() + " from " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + "><I>" + c.getName() + "</I></A>" + "\n" + "<BR>");
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    protected final void printPackageProperties() {
        List<KProperty> list = this.getPkg().packageProperties();
        if (KotlinPackage.isNotEmpty((Collection)list)) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Properties</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            for (KProperty c : list) {
                StringBuilder stringBuilder = new StringBuilder().append("<A HREF=").append("\"");
                KPackage kPackage = this.getPkg();
                KProperty kProperty = c;
                Intrinsics.checkExpressionValueIsNotNull((Object)kProperty, (String)"c");
                this.println(stringBuilder.append(this.href(kPackage, kProperty)).append("\"").append(" title=").append("\"").append("property from ").append(this.getPkg().getName()).append("\"").append(" target=").append("\"").append("classFrame").append("\"").append("><I>").append(c.getName()).append("</I></A>").append("\n").append("<BR>").toString());
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    @NotNull
    public final KModel getModel() {
        return this.model;
    }

    public PackageFrameTemplate(@JetValueParameter(name="model") @NotNull KModel model, @JetValueParameter(name="p") @NotNull KPackage p) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        super(p);
        this.model = model;
    }
}

