/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.templates;

import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KAnnotation;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.templates.KDocTemplate;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"\"\n)1\u0002+Y2lC\u001e,G+Z7qY\u0006$XmU;qa>\u0014HOC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\r!wn\u0019\u0006\ni\u0016l\u0007\u000f\\1uKNTAb\u0013#pGR+W\u000e\u001d7bi\u0016Ta\u0001P5oSRt$b\u00019lO*A1\nU1dW\u0006<WMC\u0003n_\u0012,GN\u0003\u0006gk:\\U-_<pe\u0012Taa\u0015;sS:<'\u0002\u00026bm\u0006TA\u0001\\1oO*iq-\u001a;Gk:\\U-_<pe\u0012TaaZ3u!.<'B\u0003<bY.+\u0017p^8sI*iq-\u001a;WC2\\U-_<pe\u0012T!B^1s\u0017\u0016Lxo\u001c:e\u001559W\r\u001e,be.+\u0017p^8sI*91.Z=x_J$'\u0002\u00028b[\u0016T\u0001\u0003\u001d:j]R\feN\\8uCRLwN\\:\u000b\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u000b\u0007>dG.Z2uS>t'bC&B]:|G/\u0019;j_:TA!\u00168ji*!Q\u000f^5m\u0015M\u0001(/\u001b8u\rVt7\r^5p]\u0012+G/Y5m\u0015%1WO\\2uS>t7OC\u0005L\rVt7\r^5p]*Aa-\u001e8di&|gN\u0003\u000bqe&tGOR;oGRLwN\\*v[6\f'/\u001f\u0006\u0010aJLg\u000e\u001e)be\u0006lW\r^3sg*1Q.\u001a;i_\u0012TA\u0003\u001d:j]R\u0004&o\u001c9feRL8+^7nCJL(B\u00039s_B,'\u000f^5fg*I1\n\u0015:pa\u0016\u0014H/\u001f\u0006\taJ|\u0007/\u001a:us*\t\u0002O]5oiJ+7-Z5wKJ$\u0016\u0010]3\u000b\rA\u0014XMZ5y\u0015\u001d\u0001xn\u001d;gSbTAA\\8oK*\u0019\u0002O]5oiRK\b/\u001a)be\u0006lW\r^3sg*I1/\u001a9be\u0006$xN\u001d\u0006\u000fe\u0016d\u0017\r^5wKB\u0013XMZ5y9\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0002\u0005\u0005!\u0019A\u0002A\u0003\u0003\t\u0007AQ!B\u0002\u0005\b!%A\u0002A\u0003\u0003\t\u000fAI!B\u0001\t\u0004\u0015\u0019A!\u0002\u0005\u0007\u0019\u0001)\u0011\u0001#\u0004\u0006\u0005\u00111\u0001bB\u0003\u0003\t\u001bAa!B\u0002\u0005\u000b!eA\u0002A\u0003\u0004\t\u000fAQ\u0002\u0004\u0001\u0006\u0007\u0011)\u00012\u0004\u0007\u0001\u000b\t!a\u0001\u0003\b\u0006\u0005\u0011I\u0001\u0012D\u0003\u0004\t\u000fAy\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001rD\u0003\u0004\t\u000fA1\u0003\u0004\u0001\u0006\u0005\u0011\u001d\u0001b\u0005\u0003\u0011\u0019\u000bI\"!B\u0001\t\u00075zA\u0001\u0019\u0003\u0019\f\u0005\u0012Q!\u0001E\u0006+\u000eAQa\u0001C\u0006\u0013\u0005Aq!D\u0002\u0005\u0010%\t\u0001bB\u0017\u0010\t!$\u0001\u0004B\u0011\u0003\u000b\u0005AA!V\u0002\t\u000b\r!A!C\u0001\t\n5\u0019A\u0001C\u0005\u0002\u0011\u0013is\u0002\u00021\u00051#\t#!B\u0001\t\fU\u001b\u0001\"B\u0002\u0005\u0012%\t\u0001bB\u0007\u0004\t%I\u0011\u0001C\u0004.\u001f\u0011\u0001G\u0001g\u0005\"\u0005\u0015\t\u00012B+\u0004\u0011\u0015\u0019A1C\u0005\u0002\u0011\u001di1\u0001\u0002\u0006\n\u0003!9Qf\u0005\u0003\u00031+ij\u0001\u0002\u0001\t\u00175\u0011Q!\u0001E\u0006!\u000e\u0001\u0011EA\u0003\u0002\u0011\u0017\t6!\u0002C\u000b\u0013\u0005Aq!D\u0001\t\u000f5:B\u0001\u0001M\f;+!\u0001\u0001\u0003\u0007\u000e\r\u0015\t\u0001rB\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0005Q\u0007\u0001\t#!B\u0001\t\u0012E\u001bQ\u0001b\u0006\n\u0003\u0011\u0001Q\"\u0001E\n[]!\u0001\u0001'\b\u001e\u0016\u0011\u0001\u0001bD\u0007\u0007\u000b\u0005Ay!C\u0002\n\u0005\u0015\t\u0001B\u0003)\u0004\u0001\u0005\u0012Q!\u0001E\t#\u000e)AQD\u0005\u0002\t\u0001i\u0011\u0001c\u0005.'\u0011\u0001\u0001TDO\u0007\t\u0001A\u0001#\u0004\u0002\u0006\u0003!Q\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\u0012C)\u0004\u000b\u0011u\u0011\"\u0001\u0003\u0001\u001b\u0005A)\"L\f\u0005\u0001a\u0005RT\u0003\u0003\u0001\u0011=ia!B\u0001\t\u0010%\u0019\u0011BA\u0003\u0002\u0011)\u00016\u0001A\u0011\u0003\u000b\u0005A\t\"U\u0002\u0006\tCI\u0011\u0001\u0002\u0001\u000e\u0003!MQf\u0005\u0003\u00011Cij\u0001\u0002\u0001\t!5\u0011Q!\u0001\u0005\u000b!\u000e\u0001\u0011EA\u0003\u0002\u0011#\t6!\u0002C\u0011\u0013\u0005!\u0001!D\u0001\t\u00165\u001aB\u0001\u0001\r\u0012;\u001b!\u0001\u0001c\t\u000e\u0005\u0015\t\u0001B\u0003)\u0004\u0001\u0005\u0012Q!\u0001E\t#\u000e)A!E\u0005\u0002\t\u0001i\u0011\u0001#\u0006./\u0011\u0001\u0001DEO\u000b\t\u0001A)#\u0004\u0004\u0006\u0003!=\u0011bA\u0005\u0003\u000b\u0005A1\u0002U\u0002\u0001C\t)\u0011\u0001#\u0005R\u0007\u0015!!#C\u0001\u0005\u00015\t\u00012C\u0017\u0014\t\u0001A\"#(\u0004\u0005\u0001!\u001dRBA\u0003\u0002\u0011-\u00016\u0001A\u0011\u0003\u000b\u0005A\t\"U\u0002\u0006\tII\u0011\u0001\u0002\u0001\u000e\u0003!]Qv\f\u0003\u00011Qij\u0001\u0002\u0001\t!5\u0011Q!\u0001\u0005\u000b!\u000e\u0001QT\u0002\u0003\u0002\u0011Si!!B\u0001\t\fA\u001b\t!(\u0004\u0005\u0003!)RBA\u0003\u0002\u0011\u0017\u00016!AO\u0007\t\u0005AY#\u0004\u0002\u0006\u0003!-\u0001ka\u0001\"\u0005\u0015\t\u0001\u0012C)\u0004\u0017\u0011!\u0012\"\u0001\u0003\u0001\u001b\u0005A)\"D\u0001\t\u000f5\t\u0001bB\u0007\u0002\u0011\u001diK\u0004\u0002\u0001\u0019-u5A\u0001\u0001E\u0012\u001b\t)\u0011\u0001\u0003\u0006Q\u0007\u0001ij\u0001B\u0001\t.5\u0011Q!\u0001E\u0006!\u000e\u0005\u0011EA\u0003\u0002\u0011#\t6a\u0002\u0003\u0017\u0013\u0005!\u0001!D\u0001\t\u00165\t\u0001bBW\n\t)Ar#\t\u0002\u0006\u0003!-\u0011kA\u0002\u0005/%\t\u0001bB[\u0015\u000bO!1\u001d\u0001M\u0004;\u001b!\u0001\u0001\u0003\u0003\u000e\u0005\u0015\t\u0001\u0002\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\u0003#\u000e)AqA\u0005\u0002\t\u0001i\u0011\u0001#\u0003"})
public abstract class PackageTemplateSupport
extends KDocTemplate {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final String funKeyword;
    @NotNull
    private final String valKeyword;
    @NotNull
    private final String varKeyword;
    @NotNull
    private final KPackage pkg;

    static {
        $kotlinClass = Reflection.createKotlinClass(PackageTemplateSupport.class);
    }

    @Override
    @NotNull
    protected String relativePrefix() {
        return this.getPkg().getNameAsRelativePath();
    }

    @NotNull
    public final String getFunKeyword() {
        return this.funKeyword;
    }

    @NotNull
    public final String getValKeyword() {
        return this.valKeyword;
    }

    @NotNull
    public final String getVarKeyword() {
        return this.varKeyword;
    }

    @NotNull
    protected final String keyword(@JetValueParameter(name="name") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return "<B>" + name + "</B>";
    }

    public final void printFunctionSummary(@JetValueParameter(name="functions") @NotNull Collection<? extends KFunction> functions) {
        Intrinsics.checkParameterIsNotNull(functions, (String)"functions");
        if (KotlinPackage.isNotEmpty(functions)) {
            this.println("<!-- ========== FUNCTION SUMMARY =========== -->\n\n<A NAME=\"method_summary\"><!-- --></A>\n<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\n<B>Function Summary</B></FONT></TH>\n</TR>");
            for (KFunction kFunction : functions) {
                this.printFunctionSummary(kFunction);
            }
            this.println("</TABLE>\n&nbsp;\n<P>\n");
        }
    }

    public final void printFunctionSummary(@JetValueParameter(name="function") @NotNull KFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        String deprecated = ((KAnnotated)function).getDeprecated() ? "<B>Deprecated.</B>" : "";
        this.print("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\n<CODE>");
        if (!function.getTypeParameters().isEmpty()) {
            this.println("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" SUMMARY=\"\">\n            <TR ALIGN=\"right\" VALIGN=\"\">\n            <TD NOWRAP><FONT SIZE=\"-1\">\n            <CODE>");
            this.print(this.funKeyword + " ");
            PackageTemplateSupport.printTypeParameters$default(this, function, null, 2);
            PackageTemplateSupport.printReceiverType$default(this, function, "<BR>", null, null, 12);
            this.println("</CODE></FONT></TD>\n</TR>\n</TABLE>");
        } else {
            this.print(this.funKeyword);
            PackageTemplateSupport.printReceiverType$default(this, function, null, null, null, 14);
        }
        this.println("</CODE></FONT></TD>");
        this.print("<TD><CODE><B><A HREF=" + "\"" + this.href(function) + "\"" + ">" + function.getName() + "</A></B>");
        this.printParameters(function);
        this.print(": ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, function.getReturnType(), false, 2));
        this.println("</CODE>");
        this.println("");
        this.println("<BR>");
        this.println(String.valueOf(function.description(this)));
        this.println("</TD>");
        this.println("</TR>");
    }

    public final void printReceiverType(@JetValueParameter(name="function") @NotNull KFunction function, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="none") @NotNull String none) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)postfix, (String)"postfix");
        Intrinsics.checkParameterIsNotNull((Object)none, (String)"none");
        KType receiverType = function.getReceiverType();
        if (receiverType != null) {
            this.print(prefix);
            this.print(KDocTemplate.link$default((KDocTemplate)this, receiverType, false, 2));
            this.print(postfix);
        } else {
            this.print(none);
        }
    }

    public static void printReceiverType$default(PackageTemplateSupport packageTemplateSupport, KFunction kFunction, String string, String string2, String string3, int n) {
        if ((n & 2) != 0) {
            string = " ";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        packageTemplateSupport.printReceiverType(kFunction, string, string2, string3);
    }

    public final void printFunctionDetail(@JetValueParameter(name="functions") @NotNull Collection<? extends KFunction> functions) {
        Intrinsics.checkParameterIsNotNull(functions, (String)"functions");
        if (KotlinPackage.isNotEmpty(functions)) {
            this.println("\n\n            <!-- ============ FUNCTION DETAIL ========== -->\n\n            <A NAME=\"method_detail\"><!-- --></A>\n            <TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n            <TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n            <TH ALIGN=\"left\" COLSPAN=\"1\"><FONT SIZE=\"+2\">\n            <B>Function Detail</B></FONT></TH>\n            </TR>\n            </TABLE>\n            ");
            for (KFunction kFunction : functions) {
                this.printFunctionDetail(kFunction);
            }
        }
    }

    public final void printFunctionDetail(@JetValueParameter(name="function") @NotNull KFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        this.println("<div class=\"doc-member function\">");
        this.println("<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + this.sourceHref(function) + "\"" + function.sourceTargetAttribute() + ">source</a></div>");
        this.println("<A NAME=" + "\"" + function.getName() + "{" + function.getParameterTypeText() + "}" + "\"" + "><!-- --></A><A NAME=" + "\"" + function.getLink() + "\"" + "><!-- --></A><H3>");
        this.println(function.getName() + "</H3>");
        this.println("<PRE>");
        this.println("<FONT SIZE=\"-1\">");
        this.printAnnotations((Collection<? extends KAnnotation>)function.getAnnotations());
        this.print("</FONT>" + KotlinPackage.makeString$default((Iterable)function.getModifiers(), (String)" ", null, null, (int)0, null, (int)30) + " " + this.funKeyword);
        this.printTypeParameters(function, " ");
        this.printReceiverType(function, " ", ".", " ");
        this.print("<B>" + function.getName() + "</B>");
        this.printParameters(function);
        this.print(": ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, function.getReturnType(), false, 2));
        List<org.jetbrains.kotlin.doc.model.KClass> exlist = function.getExceptions();
        int first = 1;
        if (!exlist.isEmpty()) {
            this.println("                                throws ");
            for (org.jetbrains.kotlin.doc.model.KClass ex : exlist) {
                if (first != 0) {
                    first = 0;
                } else {
                    this.print(", ");
                }
                this.print(KDocTemplate.link$default((KDocTemplate)this, ex, false, 2));
            }
        }
        this.println("</PRE>");
        this.println(function.detailedDescription(this));
        this.println("</div>");
    }

    public final void printPropertySummary(@JetValueParameter(name="properties") @NotNull Collection<? extends KProperty> properties) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        if (KotlinPackage.isNotEmpty(properties)) {
            this.println("<!-- ========== PROPERTY SUMMARY =========== -->\n\n<A NAME=\"method_summary\"><!-- --></A>\n<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\n<B>Property Summary</B></FONT></TH>\n</TR>");
            for (KProperty kProperty : properties) {
                this.printPropertySummary(kProperty);
            }
            this.println("</TABLE>\n&nbsp;\n<P>\n");
        }
    }

    public final void printPropertySummary(@JetValueParameter(name="property") @NotNull KProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        String deprecated = ((KAnnotated)property).getDeprecated() ? "<B>Deprecated.</B>" : "";
        this.print("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\n<CODE>");
        this.print(property.isVar() ? this.varKeyword : this.valKeyword);
        this.println("</CODE></FONT></TD>");
        this.print("<TD>" + "\n" + "<div class=" + "\"" + "doc-member property" + "\"" + ">" + "\n" + "<div class=" + "\"" + "source-detail" + "\"" + "><a HREF=" + "\"" + this.sourceHref(property) + "\"" + property.sourceTargetAttribute() + ">source</a></div>" + "\n" + "        <CODE><B>" + property.getName() + "</B>: ");
        this.print(KDocTemplate.link$default((KDocTemplate)this, property.getReturnType(), false, 2));
        this.println("</CODE>");
        this.println("");
        this.println("<BR>");
        this.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + deprecated + "&nbsp;" + property.detailedDescription(this) + "\n" + "</div></TD>");
        this.println("</TR>");
    }

    public final void printTypeParameters(@JetValueParameter(name="method") @NotNull KFunction method, @JetValueParameter(name="separator") @NotNull String separator) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        List<KTypeParameter> typeParameters = method.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            this.print(separator);
            this.print("&lt");
            String separator2 = "";
            for (KTypeParameter t : typeParameters) {
                this.print(separator2);
                separator2 = ", ";
                this.print(t.getName());
                List<org.jetbrains.kotlin.doc.model.KClass> elist = t.getExtends();
                if (elist.isEmpty()) continue;
                this.print(" extends ");
                String esep = "";
                for (org.jetbrains.kotlin.doc.model.KClass e : elist) {
                    this.print(esep);
                    esep = " & ";
                    this.print(KDocTemplate.link$default((KDocTemplate)this, e, false, 2));
                }
            }
            this.print("&gt");
        }
    }

    public static void printTypeParameters$default(PackageTemplateSupport packageTemplateSupport, KFunction kFunction, String string, int n) {
        if ((n & 2) != 0) {
            string = "";
        }
        packageTemplateSupport.printTypeParameters(kFunction, string);
    }

    public final void printParameters(@JetValueParameter(name="method") @NotNull KFunction method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        this.print("(");
        int first = 1;
        int defaultValue = 0;
        for (KParameter p : method.getParameters()) {
            KType kType;
            if ((!p.hasDefaultValue() ? defaultValue : 0) != 0) {
                this.print("]");
                defaultValue = 0;
            }
            if (first != 0) {
                first = 0;
            } else {
                this.print(", ");
            }
            boolean bl = p.hasDefaultValue() ? defaultValue == 0 : false;
            if (bl) {
                this.print(" [");
                defaultValue = 1;
            }
            if (p.isVarArg()) {
                this.print("vararg ");
                kType = p.varArgType();
                if (kType == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                kType = p.getaType();
            }
            KType pType = kType;
            this.print(p.getName() + ":&nbsp;");
            this.print(KDocTemplate.link$default((KDocTemplate)this, pType, false, 2));
        }
        if (defaultValue != 0) {
            this.print("]");
        }
        this.print(")");
    }

    public final void printAnnotations(@JetValueParameter(name="annotations") @NotNull Collection<? extends KAnnotation> annotations) {
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        for (KAnnotation kAnnotation : annotations) {
            this.println(this.link(kAnnotation));
        }
    }

    @NotNull
    public KPackage getPkg() {
        return this.pkg;
    }

    public PackageTemplateSupport(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        this.pkg = pkg;
        this.funKeyword = this.keyword("fun");
        this.valKeyword = this.keyword("val");
        this.varKeyword = this.keyword("var");
    }
}

