/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KProperty;

@KotlinSyntheticClass(abiVersion=22, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ModelPackage$KotlinModel$4ef04bcc {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KFunction> filterDuplicateNames(@JetValueParameter(name="functions") @NotNull Collection<? extends KFunction> functions) {
        Intrinsics.checkParameterIsNotNull(functions, (String)"functions");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = "";
        Iterable iterable = functions;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            void lastName;
            KFunction it = (KFunction)t;
            String name = it.getName();
            boolean answer = Intrinsics.areEqual((Object)name, (Object)((String)lastName.element)) ^ true;
            lastName.element = name;
            if (!answer) continue;
            collection.add(t);
        }
        return (ArrayList)collection;
    }

    @NotNull
    public static final String containerName(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        return ModelPackage$KotlinModel$4ef04bcc.qualifiedName(descriptor.getContainingDeclaration());
    }

    @NotNull
    public static final String qualifiedName(@JetValueParameter(name="descriptor", type="?") @Nullable DeclarationDescriptor descriptor) {
        if (!(descriptor == null) ? descriptor instanceof ModuleDescriptor : true) {
            return "";
        }
        if (descriptor instanceof PackageFragmentDescriptor) {
            String string = ((PackageFragmentDescriptor)descriptor).getFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.fqName.asString()");
            return string;
        }
        String parent = ModelPackage$KotlinModel$4ef04bcc.containerName(descriptor);
        String name = descriptor.getName().asString();
        if (KotlinPackage.startsWith((String)name, (String)"<")) {
            name = "";
        }
        String answer = parent.length() > 0 ? parent + "." + name : name;
        return KotlinPackage.startsWith((String)answer, (String)".") ? KotlinPackage.substring((String)answer, (int)1) : answer;
    }

    public static final void warning(@JetValueParameter(name="message") @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        IoPackage.println((Object)("Warning: " + message));
    }

    public static final void info(@JetValueParameter(name="message") @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
    }

    @NotNull
    public static final Map<KClass, SortedSet<KFunction>> inheritedExtensionFunctions(@JetValueParameter(name="functions") @NotNull Collection<? extends KFunction> functions) {
        Intrinsics.checkParameterIsNotNull(functions, (String)"functions");
        Map<KClass, List<? extends KFunction>> map = ModelPackage$KotlinModel$4ef04bcc.extensionFunctions(functions);
        TreeMap<KClass, SortedSet> answer = new TreeMap<KClass, SortedSet>();
        for (KClass klass : map.keySet()) {
            SortedSet allFunctions = KotlinPackage.toSortedSet((Iterable)KotlinPackage.orEmpty(map.get(klass)));
            answer.put(klass, allFunctions);
            for (KClass descendant : KClass.descendants$default(klass, null, 1)) {
                for (KFunction f : KotlinPackage.orEmpty(map.get(descendant))) {
                    boolean bl;
                    block4: {
                        Iterable iterable = allFunctions;
                        for (Object t : iterable) {
                            KFunction it = (KFunction)t;
                            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)f.getName()) ? Intrinsics.areEqual((Object)it.getParameterTypeText(), (Object)f.getParameterTypeText()) : false)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                    if (bl) continue;
                    allFunctions.add(f);
                }
            }
        }
        return answer;
    }

    @NotNull
    public static final Map<KClass, SortedSet<KProperty>> inheritedExtensionProperties(@JetValueParameter(name="properties") @NotNull Collection<? extends KProperty> properties) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Map<KClass, List<? extends KProperty>> map = ModelPackage$KotlinModel$4ef04bcc.extensionProperties(properties);
        TreeMap<KClass, SortedSet> answer = new TreeMap<KClass, SortedSet>();
        for (KClass klass : map.keySet()) {
            SortedSet allProperties = KotlinPackage.toSortedSet((Iterable)KotlinPackage.orEmpty(map.get(klass)));
            answer.put(klass, allProperties);
            for (KClass descendant : KClass.descendants$default(klass, null, 1)) {
                for (KProperty f : KotlinPackage.orEmpty(map.get(descendant))) {
                    boolean bl;
                    block4: {
                        Iterable iterable = allProperties;
                        for (Object t : iterable) {
                            KProperty it = (KProperty)t;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)f.getName())) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                    if (bl) continue;
                    allProperties.add(f);
                }
            }
        }
        return answer;
    }

    @NotNull
    public static final Map<KClass, List<? extends KFunction>> extensionFunctions(@JetValueParameter(name="functions") @NotNull Collection<? extends KFunction> functions) {
        Object object;
        Intrinsics.checkParameterIsNotNull(functions, (String)"functions");
        TreeMap map = new TreeMap();
        Iterable iterable = functions;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList();
        Iterator iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            KFunction it = (KFunction)object;
            if (!(it.getExtensionClass() != null)) continue;
            collection2.add(object);
        }
        iterable = (ArrayList)collection2;
        for (Collection collection2 : iterable) {
            Object object2;
            KFunction it = (KFunction)((Object)collection2);
            if (it.getExtensionClass() == null) {
                Intrinsics.throwNpe();
            }
            object = map;
            if (object.containsKey(iterator)) {
                object2 = object.get(iterator);
            } else {
                ArrayList arrayList = new ArrayList();
                object.put(iterator, arrayList);
                object2 = arrayList;
            }
            List list = (List)object2;
            list.add(collection2);
        }
        return map;
    }

    @NotNull
    public static final Map<KClass, List<? extends KProperty>> extensionProperties(@JetValueParameter(name="properties") @NotNull Collection<? extends KProperty> properties) {
        Object object;
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        TreeMap map = new TreeMap();
        Iterable iterable = properties;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList();
        Iterator iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            KProperty it = (KProperty)object;
            if (!(it.getExtensionClass() != null)) continue;
            collection2.add(object);
        }
        iterable = (ArrayList)collection2;
        for (Collection collection2 : iterable) {
            Object object2;
            KProperty it = (KProperty)((Object)collection2);
            if (it.getExtensionClass() == null) {
                Intrinsics.throwNpe();
            }
            object = map;
            if (object.containsKey(iterator)) {
                object2 = object.get(iterator);
            } else {
                ArrayList arrayList = new ArrayList();
                object.put(iterator, arrayList);
                object2 = arrayList;
            }
            List list = (List)object2;
            list.add(collection2);
        }
        return map;
    }
}

