/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.highlighter;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.template.HtmlFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetKeywordToken;
import org.jetbrains.kotlin.lexer.JetLexer;
import org.jetbrains.kotlin.lexer.JetTokens;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"\n\u0006)\t2+\u001f8uCbD\u0015n\u001a5mS\u001eDG/\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1\u0001Z8d\u0015-A\u0017n\u001a5mS\u001eDG/\u001a:\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\nM>\u0014X.\u0019;uKJTQ\u0002\u0013;nY\u001a{'/\\1ui\u0016\u0014(\u0002\u0003;f[Bd\u0017\r^3\u000b\u0019\u001d,GOR8s[\u0006$H/\u001a:\u000b\u0019M,GOR8s[\u0006$H/\u001a:\u000b\u0011M$\u0018\u0010\\3NCBT1!T1q\u00151IU\t\\3nK:$H+\u001f9f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*\u0019\u0001o]5\u000b\tQ\u0014X-\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005kRLGNC\u0006hKR\u001cF/\u001f7f\u001b\u0006\u0004(BD2sK\u0006$Xm\u0015;zY\u0016l\u0015\r\u001d\u0006\nQ&<\u0007\u000e\\5hQRTAaY8eK*!A.\u00198h\u001d\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)!\u0001B\u0002\t\u000b\u0015\u0019A\u0001\u0002E\u0005\u0019\u0001)!\u0001\u0002\u0003\t\n\u0015\u0019Aa\u0001\u0005\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00111\u0001\u0012C\u0003\u0003\t\u001bA\u0011\"\u0002\u0002\u0005\u000f!MQa\u0001C\b\u0011\u001fa\u0001!B\u0002\u0005\u0007!QA\u0002A\u0003\u0002\u0011+)!\u0001B\u0005\t\u0017\u0015\u0011A1\u0003\u0005\b\u000b\t!\u0011\u0002c\u0007\u0006\u0005\u0011U\u0001B\u0003\u0003\u0001\u0019\u000bI\"!B\u0001\t\b5*B\u00011\u0007\u0019\t\u0005\u0012Q!\u0001E\u0005+\u000eqQa\u0001\u0003\u0005\u0013\u0005AQ!D\u0002\u0005\f%\t\u0001\"B\t\u0006\t\u0019I\u0011\u0001\u0002\u0001\u000e\u0003!)Q\u0006\u0007\u0003a\ta5\u0011eC\u0003\u0002\u0011\u0017IA!C\u0002\u0006\u0003!AA\u0012A\u0005\u0004\u0013\t)\u0011\u0001#\u0005V\u0007!)1\u0001\"\u0004\n\u0003!QQb\u0001C\f\u0013\u0005A!\",\n\u0005\u0005aa\u0011eC\u0003\u0002\u0011\u0017IA!C\u0002\u0006\u0003!AA\u0012A\u0005\u0004\u0013\t)\u0011\u0001#\u0005R\u0007\r!A\"C\u0001\t\u00155\u001aB\u0001\u0001M\r;\u001b!\u0001\u0001C\u0007\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0001\u0005\u0012Q!\u0001E\t#\u000e)A\u0011D\u0005\u0002\u0011-i\u0011\u0001C\u00066\u0017\u0015QAa9\u0001\u0019\b\u0005\u0012Q!\u0001E\u0003#\u000e\u0019AqA\u0005\u0002\t\u0001\u0001"})
public final class SyntaxHighlighter {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private HtmlFormatter formatter = new HtmlFormatter(null, 1, null);
    @NotNull
    private final Map<IElementType, ? extends String> styleMap = this.createStyleMap();

    static {
        $kotlinClass = Reflection.createKotlinClass(SyntaxHighlighter.class);
    }

    @NotNull
    public final HtmlFormatter getFormatter() {
        return this.formatter;
    }

    public final void setFormatter(@JetValueParameter(name="<set-?>") @NotNull HtmlFormatter htmlFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)htmlFormatter, (String)"<set-?>");
        this.formatter = htmlFormatter;
    }

    @NotNull
    public final Map<IElementType, String> getStyleMap() {
        return this.styleMap;
    }

    @NotNull
    public final String highlight(@JetValueParameter(name="code") @NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=\"code panel\" style=\"border-width: 1px\">" + "<div class=\"codeContent panelContent\">" + "<div class=\"container\">");
            int idx = 0;
            while (Character.isWhitespace(code.charAt(idx))) {
                ++idx;
            }
            if (idx > 0) {
                String space = KotlinPackage.substring((String)code, (int)0, (int)idx);
                builder.append("<code class=" + "\"" + "jet whitespace" + "\"" + ">" + space + "</code>");
            }
            JetLexer lexer = new JetLexer();
            lexer.start((CharSequence)code);
            while (true) {
                lexer.advance();
                IElementType token = lexer.getTokenType();
                if (token == null) break;
                String tokenText = KotlinPackage.replaceAll((String)((Object)lexer.getTokenSequence()).toString(), (String)"\n", (String)"\r\n");
                String style = null;
                if (token instanceof JetKeywordToken) {
                    style = "keyword";
                } else if (Intrinsics.areEqual((Object)token, (Object)JetTokens.IDENTIFIER)) {
                    IElementType[] iElementTypeArray = JetTokens.SOFT_KEYWORDS.getTypes();
                    for (int i = 0; i < iElementTypeArray.length; ++i) {
                        IElementType softKeyword = iElementTypeArray[i];
                        if (!(softKeyword instanceof JetKeywordToken) || !Intrinsics.areEqual((Object)((JetKeywordToken)softKeyword).getValue(), (Object)tokenText)) continue;
                        style = "softkeyword";
                        break;
                    }
                    style = style == null ? "plain" : style;
                } else if (this.styleMap.containsKey(token)) {
                    style = this.styleMap.get(token);
                    if (style == null) {
                        IoPackage.println((Object)("Warning: No style for token " + token));
                    }
                } else {
                    style = "plain";
                }
                builder.append("<code class=" + "\"" + "jet " + style + "\"" + ">");
                this.formatter.format((Appendable)builder, tokenText);
                builder.append("</code>");
            }
            builder.append("</div>");
            builder.append("</div>");
            builder.append("</div>");
            String string = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
            return string;
        }
        catch (Exception e) {
            IoPackage.println((Object)("Warning: failed to parse code " + e));
            StringBuilder builder = new StringBuilder();
            builder.append("<div class=" + "\"" + "jet herror" + "\"" + ">Jet highlighter error [" + "\"" + e.getClass().getSimpleName() + "\"" + "]: ");
            this.formatter.format((Appendable)builder, (Object)e.getMessage());
            builder.append("<br/>");
            builder.append("Original text:");
            builder.append("<pre>");
            this.formatter.format((Appendable)builder, code);
            builder.append("</pre>");
            builder.append("</div>");
            String string = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
            return string;
        }
    }

    @NotNull
    protected final Map<IElementType, String> createStyleMap() {
        HashMap<Object, String> styleMap = new HashMap<Object, String>();
        Function2<TokenSet, String, Unit> function2 = new Function2<TokenSet, String, Unit>(styleMap){
            final /* synthetic */ HashMap $styleMap;

            public final void invoke(@JetValueParameter(name="tokenSet", type="?") @Nullable TokenSet tokenSet, @JetValueParameter(name="style") @NotNull String style) {
                Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
                if (tokenSet != null) {
                    IElementType[] iElementTypeArray = tokenSet.getTypes();
                    for (int i = 0; i < iElementTypeArray.length; ++i) {
                        IElementType token = iElementTypeArray[i];
                        this.$styleMap.put(token, style);
                    }
                }
            }
            {
                this.$styleMap = hashMap;
            }
        };
        styleMap.put(JetTokens.BLOCK_COMMENT, "jet-comment");
        styleMap.put(JetTokens.DOC_COMMENT, "jet-comment");
        styleMap.put(JetTokens.EOL_COMMENT, "jet-comment");
        styleMap.put(JetTokens.WHITE_SPACE, "whitespace");
        styleMap.put(JetTokens.INTEGER_LITERAL, "number");
        styleMap.put(JetTokens.FLOAT_LITERAL, "number");
        styleMap.put(JetTokens.OPEN_QUOTE, "string");
        styleMap.put(JetTokens.REGULAR_STRING_PART, "string");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.LONG_TEMPLATE_ENTRY_END, "escape");
        styleMap.put(JetTokens.SHORT_TEMPLATE_ENTRY_START, "escape");
        styleMap.put(JetTokens.ESCAPE_SEQUENCE, "escape");
        styleMap.put(JetTokens.CLOSING_QUOTE, "string");
        styleMap.put(JetTokens.CHARACTER_LITERAL, "string");
        styleMap.put(JetTokens.LABEL_IDENTIFIER, "label");
        styleMap.put(JetTokens.FIELD_IDENTIFIER, "field");
        styleMap.put(TokenType.BAD_CHARACTER, "bad");
        function2.invoke(JetTokens.STRINGS, "string");
        function2.invoke(JetTokens.MODIFIER_KEYWORDS, "softkeyword");
        function2.invoke(JetTokens.SOFT_KEYWORDS, "softkeyword");
        function2.invoke(JetTokens.COMMENTS, "jet-comment");
        function2.invoke(JetTokens.OPERATIONS, "operation");
        return styleMap;
    }
}

