/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.doc.Doclet;
import org.jetbrains.kotlin.doc.JavadocStyleHtmlDoclet;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.ModelPackage$KotlinModel$4ef04bcc;
import org.jetbrains.kotlin.doc.templates.AllClassesFrameTemplate;
import org.jetbrains.kotlin.doc.templates.ClassExtensionsTemplate;
import org.jetbrains.kotlin.doc.templates.ClassTemplate;
import org.jetbrains.kotlin.doc.templates.HelpDocTemplate;
import org.jetbrains.kotlin.doc.templates.IndexTemplate;
import org.jetbrains.kotlin.doc.templates.OverviewFrameTemplate;
import org.jetbrains.kotlin.doc.templates.OverviewSummaryTemplate;
import org.jetbrains.kotlin.doc.templates.OverviewTreeTemplate;
import org.jetbrains.kotlin.doc.templates.PackageFrameTemplate;
import org.jetbrains.kotlin.doc.templates.PackageListTemplate;
import org.jetbrains.kotlin.doc.templates.PackageSummaryTemplate;
import org.jetbrains.kotlin.doc.templates.SearchXmlTemplate;
import org.jetbrains.kotlin.template.TextTemplate;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"\u0019\u0004)1\"*\u0019<bI>\u001c7\u000b^=mK\"#X\u000e\u001c#pG2,GOC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\r!wn\u0019\u0006\u0007\t>\u001cG.\u001a;\u000b\rqJg.\u001b;?\u0015!9WM\\3sCR,'\"B7pI\u0016d'BB&N_\u0012,GNC\u0005pkR\u0004X\u000f\u001e#je*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'\u0002B+oSRT1\u0001\\8h\u0015\u0011!X\r\u001f;\u000b\rM#(/\u001b8h\u0015\u0011a\u0017M\\4s\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)1\u0001b\u0001\t\u00011\u0001Qa\u0001C\u0002\u0011\u000ba\u0001!\u0002\u0002\u0005\u0004!!Qa\u0001\u0003\u0004\u0011\u0013a\u0001!B\u0001\t\r\u0015\u0011A\u0001\u0002E\u0007\u000b\r!I\u0001c\u0003\r\u0001\u0015\t\u00012A\u0003\u0004\t\u0017Aq\u0001\u0004\u0001\u0006\u0005\u0011\u0019\u0001\u0012B\u0003\u0003\t\u0013AY!B\u0002\u0005\f!EA\u0002A\u0003\u0003\t\u0011A\u0011\"\u0002\u0002\u0005\u0011!EA\u0001\u0001\u0007\u00033\t)\u0011\u0001#\u0002.:\u0011A\u0001tAO\u0007\t\u0001AA!\u0004\u0002\u0006\u0003!\u001d\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\"B\u0007\u0003\u000b\u0005AQ\u0001UB\u0001C\t)\u0011\u0001\u0003\u0004R\u0007\u001d!9!C\u0001\u0005\u00015\t\u0001RB\u0007\u0002\u0011\u001di3\u0003\u0002\u0002\u0019\u0010u5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001c\u0004Q\u0007\u0001\t#!B\u0001\t\rE\u001bQ\u0001b\u0004\n\u0003\u0011\u0001Q\"\u0001E\tk-)!\u0002Br\u00011\r\t#!B\u0001\t\u0005E\u001b1\u0001B\u0002\n\u0003\u0011\u0001\u0001"})
public final class JavadocStyleHtmlDoclet
implements Doclet {
    public static final /* synthetic */ kotlin.reflect.KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JavadocStyleHtmlDoclet.class);
    }

    @Override
    public void generate(@JetValueParameter(name="model") @NotNull KModel model, @JetValueParameter(name="outputDir") @NotNull File outputDir) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Function2<String, TextTemplate, Unit> function2 = new Function2<String, TextTemplate, Unit>(this, outputDir){
            final /* synthetic */ JavadocStyleHtmlDoclet this$0;
            final /* synthetic */ File $outputDir;

            public final void invoke(@JetValueParameter(name="fileName") @NotNull String fileName, @JetValueParameter(name="template") @NotNull TextTemplate template2) {
                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                Intrinsics.checkParameterIsNotNull((Object)template2, (String)"template");
                File file = new File(this.$outputDir, fileName);
                File file2 = file.getParentFile();
                Boolean bl = file2 != null ? Boolean.valueOf(file2.mkdirs()) : null;
                this.this$0.log("Generating " + fileName);
                template2.renderTo(file);
            }
            {
                this.this$0 = javadocStyleHtmlDoclet;
                this.$outputDir = file;
            }
        };
        Function1<KPackage, Unit> function1 = new Function1<KPackage, Unit>(function2, model){
            final /* synthetic */ generate.1 $run;
            final /* synthetic */ KModel $model;

            public final void invoke(@JetValueParameter(name="p") @NotNull KPackage p) {
                Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
                Map<KClass, SortedSet<KFunction>> map = ModelPackage$KotlinModel$4ef04bcc.inheritedExtensionFunctions((Collection<? extends KFunction>)((KClassOrPackage)p).getFunctions());
                Map<KClass, SortedSet<KProperty>> pmap = ModelPackage$KotlinModel$4ef04bcc.inheritedExtensionProperties((Collection<? extends KProperty>)((KClassOrPackage)p).getProperties());
                HashSet classes = KotlinPackage.hashSet((Object[])new KClass[0]);
                classes.addAll((Collection)map.keySet());
                classes.addAll((Collection)pmap.keySet());
                for (KClass c : classes) {
                    Set functions = KotlinPackage.orEmpty((Set)map.get(c));
                    Set properties = KotlinPackage.orEmpty((Set)pmap.get(c));
                    String string = p.getNameAsPath() + "/" + c.getNameAsPath() + "-extensions.html";
                    KClass kClass = c;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kClass, (String)"c");
                    this.$run.invoke(string, new ClassExtensionsTemplate(this.$model, p, kClass, functions, properties));
                }
            }
            {
                this.$run = var1_1;
                this.$model = kModel;
            }
        };
        IoPackage.println((Object)("Generating kdoc to " + outputDir + " excluding packages " + model.getConfig().getIgnorePackages()));
        function2.invoke("allclasses-frame.html", (TextTemplate)new AllClassesFrameTemplate(model, " target=\"classFrame\""));
        function2.invoke("allclasses-noframe.html", (TextTemplate)new AllClassesFrameTemplate(model, null, 2, null));
        function2.invoke("help-doc.html", (TextTemplate)new HelpDocTemplate(model));
        function2.invoke("index.html", (TextTemplate)new IndexTemplate(model));
        function2.invoke("overview-frame.html", (TextTemplate)new OverviewFrameTemplate(model));
        function2.invoke("overview-summary.html", (TextTemplate)new OverviewSummaryTemplate(model));
        function2.invoke("overview-tree.html", (TextTemplate)new OverviewTreeTemplate(model));
        function2.invoke("package-list", (TextTemplate)new PackageListTemplate(model));
        function2.invoke("search.xml", (TextTemplate)new SearchXmlTemplate(model));
        for (KPackage p : model.getPackages()) {
            function2.invoke(p.getNameAsPath() + "/package-frame.html", (TextTemplate)new PackageFrameTemplate(model, p));
            function2.invoke(p.getNameAsPath() + "/package-summary.html", (TextTemplate)new PackageSummaryTemplate(model, p));
            for (KClass c : p.getClasses()) {
                function2.invoke(c.getNameAsPath() + ".html", (TextTemplate)new ClassTemplate(model, p, c));
            }
            function1.invoke(p);
        }
    }

    protected final void log(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        IoPackage.println((Object)text);
    }
}

