/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import java.util.HashMap;
import jet.JetObject;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import org.jetbrains.kotlin.doc.KDocConfig;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.ModelPackage$src$KotlinModel$13dae9a8;
import org.jetbrains.kotlin.doc.templates.KDocTemplate;
import org.pegdown.LinkRenderer;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.WikiLinkNode;

@JetClass(signature="Lorg/pegdown/LinkRenderer;", flags=16, abiVersion=6)
public final class TemplateLinkRenderer
extends LinkRenderer
implements JetObject {
    private final HashMap<String, Pair<? extends String, ? extends String>> hackedLinks;
    private final KAnnotated annotated;
    private final KDocTemplate template;

    @JetMethod(flags=17, propertyType="Ljava/util/HashMap<Ljava/lang/String;Lkotlin/Pair<Ljava/lang/String;Ljava/lang/String;>;>;")
    public final HashMap<String, Pair<? extends String, ? extends String>> getHackedLinks() {
        return this.hackedLinks;
    }

    @JetMethod(returnType="?Lorg/pegdown/LinkRenderer$Rendering;")
    public LinkRenderer.Rendering render(@JetValueParameter(name="node", type="?Lorg/pegdown/ast/WikiLinkNode;") WikiLinkNode node) {
        LinkRenderer.Rendering answer2 = super.render(node);
        boolean bl = true;
        if (answer2 == null) {
            bl = false;
        }
        if (bl) {
            String text2 = answer2.text;
            boolean bl2 = true;
            if (text2 == null) {
                bl2 = false;
            }
            if (bl2) {
                String qualified = this.resolveToQualifiedName(text2);
                String href = this.resolveClassNameLink(qualified);
                boolean bl3 = true;
                if (href == null) {
                    bl3 = false;
                }
                if (bl3) {
                    answer2.href = href;
                } else {
                    for (String prefix : KotlinPackage.arrayList((Object[])new String[]{"java.lang", "java.util", "java.util.concurrent", "java.util.regex", "java.io", "jet", "java.awt", "java.awt.event", "java.sql", "java.beans", "javax.swing", "javax.swing.event", "org.w3c.dom", "kotlin.template"})) {
                        boolean bl4 = true;
                        if (href != null) {
                            bl4 = false;
                        }
                        if (!bl4) continue;
                        href = this.resolveClassNameLink(prefix + "." + qualified);
                        boolean bl5 = true;
                        if (href == null) {
                            bl5 = false;
                        }
                        if (!bl5) continue;
                        break;
                    }
                }
                boolean bl6 = true;
                if (href != null) {
                    bl6 = false;
                }
                if (bl6) {
                    Pair<? extends String, ? extends String> link = this.hackedLinks.get(text2);
                    boolean bl7 = true;
                    if (link == null) {
                        bl7 = false;
                    }
                    if (bl7) {
                        href = KDocConfig.resolveLink$default(this.annotated.getModel().getConfig(), (String)link.getFirst(), false, 2) + (String)link.getSecond();
                    }
                }
                boolean bl8 = true;
                if (href == null) {
                    bl8 = false;
                }
                if (bl8) {
                    answer2.href = href;
                } else {
                    answer2.href = "#NotImplementedYet";
                    ModelPackage$src$KotlinModel$13dae9a8.warning("could not resolve expression: " + qualified + " into a wiki link");
                }
            }
        }
        return answer2;
    }

    @JetMethod(flags=32, returnType="?Ljava/lang/String;")
    protected final String resolveClassNameLink(@JetValueParameter(name="qualifiedName", type="Ljava/lang/String;") String qualifiedName) {
        KModel model = this.annotated.getModel();
        KPackage pkg2 = model.getPackage(qualifiedName);
        boolean bl = true;
        if (pkg2 == null) {
            bl = false;
        }
        if (bl) {
            return this.template.href(pkg2);
        }
        KClass klass2 = model.getClass(qualifiedName);
        boolean bl2 = true;
        if (klass2 == null) {
            bl2 = false;
        }
        if (bl2) {
            return this.template.href(klass2);
        }
        int idx = KotlinPackage.lastIndexOf((String)qualifiedName, (char)'.');
        if (idx > 0) {
            String className = KotlinPackage.substring((String)qualifiedName, (int)0, (int)idx);
            KClass c = model.getClass(className);
            boolean bl3 = true;
            if (c == null) {
                bl3 = false;
            }
            if (bl3) {
                String remaining = KotlinPackage.substring((String)qualifiedName, (int)(idx + 1));
                KFunction fn = c.findFunction(remaining);
                boolean bl4 = true;
                if (fn == null) {
                    bl4 = false;
                }
                if (bl4) {
                    return this.template.href(fn);
                }
                KProperty p = c.findProperty(remaining);
                boolean bl5 = true;
                if (p == null) {
                    bl5 = false;
                }
                if (bl5) {
                    return this.template.href(p);
                }
            }
        }
        return null;
    }

    @JetMethod(flags=32, returnType="Ljava/lang/String;")
    protected final String resolveToQualifiedName(@JetValueParameter(name="text", type="Ljava/lang/String;") String text2) {
        return text2;
    }

    @JetMethod(returnType="?Lorg/pegdown/LinkRenderer$Rendering;")
    public LinkRenderer.Rendering render(@JetValueParameter(name="node", type="?Lorg/pegdown/ast/RefLinkNode;") RefLinkNode node, @JetValueParameter(name="url", type="?Ljava/lang/String;") String url, @JetValueParameter(name="title", type="?Ljava/lang/String;") String title, @JetValueParameter(name="text", type="?Ljava/lang/String;") String text2) {
        return super.render(node, url, title, text2);
    }

    @JetMethod(returnType="?Lorg/pegdown/LinkRenderer$Rendering;")
    public LinkRenderer.Rendering render(@JetValueParameter(name="node", type="?Lorg/pegdown/ast/AutoLinkNode;") AutoLinkNode node) {
        return super.render(node);
    }

    @JetMethod(returnType="?Lorg/pegdown/LinkRenderer$Rendering;")
    public LinkRenderer.Rendering render(@JetValueParameter(name="node", type="?Lorg/pegdown/ast/ExpLinkNode;") ExpLinkNode node, @JetValueParameter(name="text", type="?Ljava/lang/String;") String text2) {
        return super.render(node, text2);
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/kotlin/doc/model/KAnnotated;")
    public final KAnnotated getAnnotated() {
        return this.annotated;
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/kotlin/doc/templates/KDocTemplate;")
    public final KDocTemplate getTemplate() {
        return this.template;
    }

    @JetConstructor
    public TemplateLinkRenderer(@JetValueParameter(name="annotated", type="Lorg/jetbrains/kotlin/doc/model/KAnnotated;") KAnnotated annotated, @JetValueParameter(name="template", type="Lorg/jetbrains/kotlin/doc/templates/KDocTemplate;") KDocTemplate template2) {
        this.annotated = annotated;
        this.template = template2;
        this.hackedLinks = KotlinPackage.hashMap((Pair[])new Pair[]{new Pair((Object)"IllegalArgumentException", (Object)new Pair((Object)"java.lang", (Object)"java/lang/IllegalArgumentException.html")), new Pair((Object)"IllegalStateException", (Object)new Pair((Object)"java.lang", (Object)"java/lang/IllegalStateException.html")), new Pair((Object)"Map.Entry", (Object)new Pair((Object)"java.util", (Object)"java/util/Map.Entry.html")), new Pair((Object)"System.in", (Object)new Pair((Object)"java.lang", (Object)"java/lang/System.html#in")), new Pair((Object)"System.out", (Object)new Pair((Object)"java.lang", (Object)"java/lang/System.html#in")), new Pair((Object)"#equals()", (Object)new Pair((Object)"java.lang", (Object)"java/lang/Object.html#equals(java.lang.Object)")), new Pair((Object)"#hashCode()", (Object)new Pair((Object)"java.lang", (Object)"java/lang/Object.html#hashCode()"))});
    }
}

