/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven.doc;

import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.jetbrains.jet.cli.common.CompilerArguments;
import org.jetbrains.jet.cli.jvm.K2JVMCompiler;
import org.jetbrains.jet.cli.jvm.K2JVMCompilerArguments;
import org.jetbrains.kotlin.doc.KDocArguments;
import org.jetbrains.kotlin.doc.KDocCompiler;
import org.jetbrains.kotlin.doc.KDocConfig;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;

public class KDocMojo
extends KotlinCompileMojoBase {
    public List<String> classpath;
    protected List<String> testClasspath;
    public String output;
    public List<String> annotationPaths;
    private List<String> sources;
    private String docOutputDir;
    private String docModule;
    protected List<String> ignorePackages;
    private boolean includeProtected;
    private String title;
    private String version;
    private String sourceRootHref;
    private String projectRootDir;
    private boolean warnNoComments;
    private Map<String, String> packageDescriptionFiles;
    private Map<String, String> packagePrefixToUrls;
    private Map<String, String> packageSummaryText;

    protected K2JVMCompiler createCompiler() {
        return new KDocCompiler();
    }

    protected K2JVMCompilerArguments createCompilerArguments() {
        return new KDocArguments();
    }

    protected void configureCompilerArguments(CompilerArguments arguments) throws MojoExecutionException {
        if (arguments instanceof K2JVMCompilerArguments) {
            this.configureBaseCompilerArguments(this.getLog(), (K2JVMCompilerArguments)arguments, this.docModule, this.sources, this.classpath, this.output);
        }
        if (arguments instanceof KDocArguments) {
            KDocArguments kdoc = (KDocArguments)arguments;
            KDocConfig docConfig = kdoc.getDocConfig();
            docConfig.setDocOutputDir(this.docOutputDir);
            kdoc.noJdkAnnotations = true;
            kdoc.annotations = this.getFullAnnotationsPath(this.getLog(), this.annotationPaths);
            if (this.ignorePackages != null) {
                docConfig.getIgnorePackages().addAll(this.ignorePackages);
            }
            if (this.packageDescriptionFiles != null) {
                docConfig.getPackageDescriptionFiles().putAll(this.packageDescriptionFiles);
            }
            if (this.packagePrefixToUrls != null) {
                docConfig.getPackagePrefixToUrls().putAll(this.packagePrefixToUrls);
            }
            if (this.packageSummaryText != null) {
                docConfig.getPackageSummaryText().putAll(this.packageSummaryText);
            }
            docConfig.setIncludeProtected(this.includeProtected);
            docConfig.setTitle(this.title);
            docConfig.setVersion(this.version);
            docConfig.setWarnNoComments(this.warnNoComments);
            docConfig.setSourceRootHref(this.sourceRootHref);
            docConfig.setProjectRootDir(this.projectRootDir);
            this.getLog().info((CharSequence)("API docs output to: " + docConfig.getDocOutputDir()));
            this.getLog().info((CharSequence)("classpath: " + this.classpath));
            this.getLog().info((CharSequence)("title: " + this.title));
            this.getLog().info((CharSequence)("sources: " + this.sources));
            this.getLog().info((CharSequence)("sourceRootHref: " + this.sourceRootHref));
            this.getLog().info((CharSequence)("projectRootDir: " + this.projectRootDir));
            this.getLog().info((CharSequence)("kotlin annotations: " + kdoc.annotations));
            this.getLog().info((CharSequence)("packageDescriptionFiles: " + this.packageDescriptionFiles));
            this.getLog().info((CharSequence)("packagePrefixToUrls: " + this.packagePrefixToUrls));
            this.getLog().info((CharSequence)("API docs ignore packages: " + this.ignorePackages));
        } else {
            this.getLog().warn((CharSequence)"No KDocArguments available!");
        }
    }
}

