/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven.doc;

import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.doc.KDocArguments;
import org.jetbrains.kotlin.doc.KDocCompiler;
import org.jetbrains.kotlin.doc.KDocConfig;
import org.jetbrains.kotlin.maven.K2JVMCompileMojo;

public class KDocMojo
extends K2JVMCompileMojo {
    private List<String> sources;
    private String docOutputDir;
    private String docModule;
    protected List<String> ignorePackages;
    private boolean includeProtected;
    private String title;
    private String version;
    private String sourceRootHref;
    private String projectRootDir;
    private boolean warnNoComments;
    private Map<String, String> packageDescriptionFiles;
    private Map<String, String> packagePrefixToUrls;
    private Map<String, String> packageSummaryText;

    public List<String> getSources() {
        return this.sources;
    }

    protected K2JVMCompiler createCompiler() {
        return new KDocCompiler();
    }

    protected K2JVMCompilerArguments createCompilerArguments() {
        return new KDocArguments();
    }

    @NotNull
    protected ExitCode executeCompiler(@NotNull CLICompiler<K2JVMCompilerArguments> compiler, @NotNull K2JVMCompilerArguments arguments, @NotNull MessageCollector messageCollector) {
        ExitCode exitCode = super.executeCompiler(compiler, (CommonCompilerArguments)arguments, messageCollector);
        if (exitCode == ExitCode.COMPILATION_ERROR) {
            return ExitCode.OK;
        }
        return exitCode;
    }

    protected void configureSpecificCompilerArguments(K2JVMCompilerArguments arguments) throws MojoExecutionException {
        if (arguments instanceof KDocArguments) {
            KDocArguments kdoc = (KDocArguments)arguments;
            KDocConfig docConfig = kdoc.getDocConfig();
            docConfig.setDocOutputDir(this.docOutputDir);
            kdoc.noJdkAnnotations = true;
            kdoc.annotations = this.getFullAnnotationsPath(this.getLog(), this.annotationPaths);
            if (this.ignorePackages != null) {
                docConfig.getIgnorePackages().addAll(this.ignorePackages);
            }
            if (this.packageDescriptionFiles != null) {
                docConfig.getPackageDescriptionFiles().putAll(this.packageDescriptionFiles);
            }
            if (this.packagePrefixToUrls != null) {
                docConfig.getPackagePrefixToUrls().putAll(this.packagePrefixToUrls);
            }
            if (this.packageSummaryText != null) {
                docConfig.getPackageSummaryText().putAll(this.packageSummaryText);
            }
            docConfig.setIncludeProtected(this.includeProtected);
            docConfig.setTitle(this.title);
            docConfig.setVersion(this.version);
            docConfig.setWarnNoComments(this.warnNoComments);
            docConfig.setSourceRootHref(this.sourceRootHref);
            docConfig.setProjectRootDir(this.projectRootDir);
            this.LOG.info((CharSequence)("API docs output to: " + docConfig.getDocOutputDir()));
            this.LOG.info((CharSequence)("classpath: " + this.classpath));
            this.LOG.info((CharSequence)("title: " + this.title));
            this.LOG.info((CharSequence)("sources: " + this.sources));
            this.LOG.info((CharSequence)("sourceRootHref: " + this.sourceRootHref));
            this.LOG.info((CharSequence)("projectRootDir: " + this.projectRootDir));
            this.LOG.info((CharSequence)("kotlin annotations: " + kdoc.annotations));
            this.LOG.info((CharSequence)("packageDescriptionFiles: " + this.packageDescriptionFiles));
            this.LOG.info((CharSequence)("packagePrefixToUrls: " + this.packagePrefixToUrls));
            this.LOG.info((CharSequence)("API docs ignore packages: " + this.ignorePackages));
        } else {
            this.LOG.warn((CharSequence)"No KDocArguments available!");
        }
    }
}

