/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jvm.abi.AbiClassInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0016J\u001e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiClassInfoBuilder;", "", "removePrivateClasses", "", "<init>", "(Z)V", "abiClassInfo", "", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiClassInfo;", "innerClassToOuter", "allSuperInterfaces", "", "recordInitialClassInfo", "", "className", "info", "superInterfaces", "addInnerClass", "innerClass", "outerClass", "buildClassInfo", "", "keepInterface", "visited", "", "jvm-abi-gen"})
@SourceDebugExtension(value={"SMAP\nJvmAbiClassInfoBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAbiClassInfoBuilder.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiClassInfoBuilder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,67:1\n381#2,7:68\n*S KotlinDebug\n*F\n+ 1 JvmAbiClassInfoBuilder.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiClassInfoBuilder\n*L\n34#1:68,7\n*E\n"})
public final class JvmAbiClassInfoBuilder {
    private final boolean removePrivateClasses;
    @NotNull
    private final Map<String, AbiClassInfo> abiClassInfo;
    @NotNull
    private final Map<String, String> innerClassToOuter;
    @NotNull
    private final Map<String, List<String>> allSuperInterfaces;

    public JvmAbiClassInfoBuilder(boolean removePrivateClasses) {
        this.removePrivateClasses = removePrivateClasses;
        this.abiClassInfo = new LinkedHashMap();
        this.innerClassToOuter = new LinkedHashMap();
        this.allSuperInterfaces = new LinkedHashMap();
    }

    public final void recordInitialClassInfo(@NotNull String className, @NotNull AbiClassInfo info, @NotNull List<String> superInterfaces) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(superInterfaces, (String)"superInterfaces");
        this.abiClassInfo.put(className, info);
        if (this.removePrivateClasses) {
            this.allSuperInterfaces.put(className, superInterfaces);
        }
    }

    public final void addInnerClass(@NotNull String innerClass, @Nullable String outerClass) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
            if (outerClass == null) {
                return;
            }
            if (!this.removePrivateClasses) break block2;
            Map<String, String> $this$getOrPut$iv = this.innerClassToOuter;
            boolean $i$f$getOrPut = false;
            String value$iv = $this$getOrPut$iv.get(innerClass);
            if (value$iv == null) {
                boolean bl = false;
                String answer$iv = outerClass;
                $this$getOrPut$iv.put(innerClass, answer$iv);
            }
        }
    }

    @NotNull
    public final Map<String, AbiClassInfo> buildClassInfo() {
        if (this.removePrivateClasses) {
            HashSet visited = new HashSet();
            for (Map.Entry<String, AbiClassInfo> entry : this.abiClassInfo.entrySet()) {
                String className = entry.getKey();
                AbiClassInfo info = entry.getValue();
                if (Intrinsics.areEqual((Object)info, (Object)AbiClassInfo.Deleted.INSTANCE)) continue;
                List list = this.allSuperInterfaces.get(className);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                for (String superInterface : list) {
                    this.keepInterface(superInterface, visited);
                }
            }
        }
        return this.abiClassInfo;
    }

    private final void keepInterface(String className, Set<String> visited) {
        if (!visited.add(className)) {
            return;
        }
        this.abiClassInfo.put(className, AbiClassInfo.Public.INSTANCE);
        for (String outerClass : SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)className, (Function1)((Function1)new Function1<String, String>(this.innerClassToOuter){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return (String)((Map)this.receiver).get(p0);
            }
        })), (int)1)) {
            if (!Intrinsics.areEqual((Object)this.abiClassInfo.get(outerClass), (Object)AbiClassInfo.Deleted.INSTANCE)) continue;
            this.abiClassInfo.put(outerClass, new AbiClassInfo.Stripped(MapsKt.emptyMap(), true));
        }
        List list = this.allSuperInterfaces.get(className);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (String superInterface : list) {
            this.keepInterface(superInterface, visited);
        }
    }
}

