/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.jvm.abi.JvmAbiMetadataProcessorKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.Attributes;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmClass;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmConstructor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmDeclarationContainer;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmFunction;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmPackage;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmProperty;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.Visibility;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.JvmExtensionsKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.JvmMetadataUtil;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.JvmMetadataVersion;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001c\u0010\u0006\u001a\u00020\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\n*\u00020\u00012\u0006\u0010\f\u001a\u00020\tH\u0002\u001a\u001c\u0010\r\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\r\u001a\u00020\n*\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\r\u001a\u00020\n*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\"\u0018\u0010\u0014\u001a\u00020\u0004*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\u0017"}, d2={"abiMetadataProcessor", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "annotationVisitor", "removeDataClassCopyIfConstructorIsPrivate", "", "preserveDeclarationOrder", "kotlinClassHeaderVisitor", "body", "Lkotlin/Function1;", "Lkotlin/Metadata;", "", "visitKotlinMetadata", "header", "removePrivateDeclarations", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmClass;", "removeCopyAlongWithConstructor", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmPackage;", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmDeclarationContainer;", "copyFunShouldBeDeleted", "removeDataClassCopy", "isPrivate", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/Visibility;", "(Lkotlinx/metadata/Visibility;)Z", "jvm-abi-gen"})
@SourceDebugExtension(value={"SMAP\nJvmAbiMetadataProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAbiMetadataProcessor.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiMetadataProcessorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n13291#2,2:189\n13291#2,2:191\n2622#3,3:193\n*S KotlinDebug\n*F\n+ 1 JvmAbiMetadataProcessor.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiMetadataProcessorKt\n*L\n131#1:189,2\n137#1:191,2\n184#1:193,3\n*E\n"})
public final class JvmAbiMetadataProcessorKt {
    @NotNull
    public static final AnnotationVisitor abiMetadataProcessor(@NotNull AnnotationVisitor annotationVisitor, boolean removeDataClassCopyIfConstructorIsPrivate, boolean preserveDeclarationOrder) {
        Intrinsics.checkNotNullParameter((Object)annotationVisitor, (String)"annotationVisitor");
        return JvmAbiMetadataProcessorKt.kotlinClassHeaderVisitor((Function1<? super Metadata, Unit>)((Function1)new Function1<Metadata, Unit>(annotationVisitor, removeDataClassCopyIfConstructorIsPrivate, preserveDeclarationOrder){
            final /* synthetic */ AnnotationVisitor $annotationVisitor;
            final /* synthetic */ boolean $removeDataClassCopyIfConstructorIsPrivate;
            final /* synthetic */ boolean $preserveDeclarationOrder;
            {
                this.$annotationVisitor = $annotationVisitor;
                this.$removeDataClassCopyIfConstructorIsPrivate = $removeDataClassCopyIfConstructorIsPrivate;
                this.$preserveDeclarationOrder = $preserveDeclarationOrder;
                super(1);
            }

            public final void invoke(Metadata header) {
                Object object;
                Object $i$a$-runCatching-JvmAbiMetadataProcessorKt$abiMetadataProcessor$1$newHeader$22;
                int[] nArray;
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                int[] v22 = nArray = header.mv();
                boolean bl = false;
                Integer n = ArraysKt.getOrNull((int[])v22, (int)0);
                int major22 = n != null ? n : 0;
                Integer n2 = ArraysKt.getOrNull((int[])v22, (int)1);
                int minor = n2 != null ? n2 : 0;
                int[] nArray2 = (int[])(major22 > 1 || major22 == 1 && minor >= 4 ? nArray : null);
                if (nArray2 == null) {
                    nArray = new int[]{1, 4};
                    nArray2 = nArray;
                }
                int[] metadataVersion = nArray2;
                boolean bl2 = this.$removeDataClassCopyIfConstructorIsPrivate;
                boolean v22 = this.$preserveDeclarationOrder;
                try {
                    boolean $i$a$-runCatching-JvmAbiMetadataProcessorKt$abiMetadataProcessor$1$newHeader$22 = false;
                    $i$a$-runCatching-JvmAbiMetadataProcessorKt$abiMetadataProcessor$1$newHeader$22 = Result.constructor-impl((Object)KotlinClassMetadata.Companion.transform(header, (Function1<? super KotlinClassMetadata, Unit>)((Function1)new Function1<KotlinClassMetadata, Unit>(bl2, v22){
                        final /* synthetic */ boolean $removeDataClassCopyIfConstructorIsPrivate;
                        final /* synthetic */ boolean $preserveDeclarationOrder;
                        {
                            this.$removeDataClassCopyIfConstructorIsPrivate = $removeDataClassCopyIfConstructorIsPrivate;
                            this.$preserveDeclarationOrder = $preserveDeclarationOrder;
                            super(1);
                        }

                        public final void invoke(KotlinClassMetadata metadata) {
                            block1: {
                                KotlinClassMetadata kotlinClassMetadata;
                                block2: {
                                    block0: {
                                        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                                        kotlinClassMetadata = metadata;
                                        if (!(kotlinClassMetadata instanceof KotlinClassMetadata.Class)) break block0;
                                        JvmAbiMetadataProcessorKt.access$removePrivateDeclarations(((KotlinClassMetadata.Class)metadata).getKmClass(), this.$removeDataClassCopyIfConstructorIsPrivate, this.$preserveDeclarationOrder);
                                        break block1;
                                    }
                                    if (!(kotlinClassMetadata instanceof KotlinClassMetadata.FileFacade)) break block2;
                                    JvmAbiMetadataProcessorKt.access$removePrivateDeclarations(((KotlinClassMetadata.FileFacade)metadata).getKmPackage(), this.$preserveDeclarationOrder);
                                    break block1;
                                }
                                if (!(kotlinClassMetadata instanceof KotlinClassMetadata.MultiFileClassPart)) break block1;
                                JvmAbiMetadataProcessorKt.access$removePrivateDeclarations(((KotlinClassMetadata.MultiFileClassPart)metadata).getKmPackage(), this.$preserveDeclarationOrder);
                            }
                        }
                    })));
                }
                catch (Throwable major22) {
                    $i$a$-runCatching-JvmAbiMetadataProcessorKt$abiMetadataProcessor$1$newHeader$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)major22));
                }
                Object object2 = $i$a$-runCatching-JvmAbiMetadataProcessorKt$abiMetadataProcessor$1$newHeader$22;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) {
                    object = object2;
                } else {
                    Throwable cause = throwable;
                    boolean bl3 = false;
                    if (Boolean.parseBoolean(System.getProperty("idea.is.unit.test"))) {
                        String actual = "" + metadataVersion[0] + '.' + metadataVersion[1];
                        String expected = JvmMetadataVersion.LATEST_STABLE_SUPPORTED.toString();
                        throw new AssertionError("jvm-abi-gen can't process class file with the new metadata version because the version of kotlinx-metadata-jvm it depends on is too old.\nClass file has metadata version " + actual + ", but default metadata version of kotlinx-metadata-jvm is " + expected + ", so it can process class files with metadata version up to +1 from that (because of Kotlin/JVM's one-version forward compatibility policy).\nTo fix this error, ensure that jvm-abi-gen depends on the latest version of kotlinx-metadata-jvm.\nIf this happens during the update of the default language version in the project, make sure that a version of kotlinx-metadata-jvm has been published that supports this version, and update \"versions.kotlinx-metadata-jvm\" in `gradle/versions.properties`.", cause);
                    }
                    object = header;
                }
                Metadata newHeader2 = (Metadata)object;
                JvmAbiMetadataProcessorKt.access$visitKotlinMetadata(this.$annotationVisitor, newHeader2);
            }
        }));
    }

    private static final AnnotationVisitor kotlinClassHeaderVisitor(Function1<? super Metadata, Unit> body) {
        return new AnnotationVisitor(body){
            private int kind;
            private int[] metadataVersion;
            private List<String> data1;
            private List<String> data2;
            private String extraString;
            private String packageName;
            private int extraInt;
            final /* synthetic */ Function1<Metadata, Unit> $body;
            {
                this.$body = $body;
                super(589824);
                this.kind = 1;
                this.metadataVersion = new int[0];
                this.data1 = new ArrayList<E>();
                this.data2 = new ArrayList<E>();
            }

            public final int getKind() {
                return this.kind;
            }

            public final void setKind(int n) {
                this.kind = n;
            }

            public final int[] getMetadataVersion() {
                return this.metadataVersion;
            }

            public final void setMetadataVersion(int[] nArray) {
                Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
                this.metadataVersion = nArray;
            }

            public final List<String> getData1() {
                return this.data1;
            }

            public final void setData1(List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data1 = list;
            }

            public final List<String> getData2() {
                return this.data2;
            }

            public final void setData2(List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data2 = list;
            }

            public final String getExtraString() {
                return this.extraString;
            }

            public final void setExtraString(String string) {
                this.extraString = string;
            }

            public final String getPackageName() {
                return this.packageName;
            }

            public final void setPackageName(String string) {
                this.packageName = string;
            }

            public final int getExtraInt() {
                return this.extraInt;
            }

            public final void setExtraInt(int n) {
                this.extraInt = n;
            }

            public void visit(String name, Object value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                switch (name) {
                    case "k": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.kind = (Integer)value;
                        break;
                    }
                    case "xi": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.extraInt = (Integer)value;
                        break;
                    }
                    case "mv": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.IntArray");
                        this.metadataVersion = (int[])value;
                        break;
                    }
                    case "xs": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.extraString = (String)value;
                        break;
                    }
                    case "pn": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.packageName = (String)value;
                    }
                }
            }

            public AnnotationVisitor visitArray(String name) {
                List<String> list;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)"d1")) {
                    list = this.data1;
                } else if (Intrinsics.areEqual((Object)string, (Object)"d2")) {
                    list = this.data2;
                } else {
                    return null;
                }
                List<String> destination = list;
                return new AnnotationVisitor(destination){
                    final /* synthetic */ List<String> $destination;
                    {
                        this.$destination = $destination;
                        super(589824);
                    }

                    public void visit(String name, Object value) {
                        Collection collection = this.$destination;
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)value);
                    }
                };
            }

            public void visitEnd() {
                Collection $this$toTypedArray$iv = this.data1;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = this.data2;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                this.$body.invoke((Object)JvmMetadataUtil.Metadata(this.kind, this.metadataVersion, thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]), this.extraString, this.packageName, this.extraInt));
            }
        };
    }

    private static final void visitKotlinMetadata(AnnotationVisitor $this$visitKotlinMetadata, Metadata header) {
        String it;
        String element$iv;
        int n;
        int n2;
        boolean $i$f$forEach;
        String[] $this$forEach$iv;
        AnnotationVisitor annotationVisitor;
        $this$visitKotlinMetadata.visit("k", (Object)header.k());
        $this$visitKotlinMetadata.visit("mv", (Object)header.mv());
        if (!(header.d1().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u241 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d1");
            boolean bl = false;
            $this$forEach$iv = header.d1();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl2 = false;
                $this$visitKotlinMetadata_u24lambda_u241.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u241.visitEnd();
        }
        if (!(header.d2().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u243 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d2");
            boolean bl = false;
            $this$forEach$iv = header.d2();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl3 = false;
                $this$visitKotlinMetadata_u24lambda_u243.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u243.visitEnd();
        }
        if (((CharSequence)header.xs()).length() > 0) {
            $this$visitKotlinMetadata.visit("xs", (Object)header.xs());
        }
        if (((CharSequence)header.pn()).length() > 0) {
            $this$visitKotlinMetadata.visit("pn", (Object)header.pn());
        }
        if (header.xi() != 0) {
            $this$visitKotlinMetadata.visit("xi", (Object)header.xi());
        }
        $this$visitKotlinMetadata.visitEnd();
    }

    private static final void removePrivateDeclarations(KmClass $this$removePrivateDeclarations, boolean removeCopyAlongWithConstructor, boolean preserveDeclarationOrder) {
        $this$removePrivateDeclarations.getConstructors().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$4(removePrivateDeclarations.1.INSTANCE, arg_0));
        Intrinsics.checkNotNull((Object)$this$removePrivateDeclarations, (String)"null cannot be cast to non-null type kotlinx.metadata.KmDeclarationContainer");
        JvmAbiMetadataProcessorKt.removePrivateDeclarations((KmDeclarationContainer)$this$removePrivateDeclarations, JvmAbiMetadataProcessorKt.copyFunShouldBeDeleted($this$removePrivateDeclarations, removeCopyAlongWithConstructor), preserveDeclarationOrder);
        JvmExtensionsKt.getLocalDelegatedProperties($this$removePrivateDeclarations).clear();
    }

    private static final void removePrivateDeclarations(KmPackage $this$removePrivateDeclarations, boolean preserveDeclarationOrder) {
        Intrinsics.checkNotNull((Object)$this$removePrivateDeclarations, (String)"null cannot be cast to non-null type kotlinx.metadata.KmDeclarationContainer");
        JvmAbiMetadataProcessorKt.removePrivateDeclarations($this$removePrivateDeclarations, false, preserveDeclarationOrder);
        JvmExtensionsKt.getLocalDelegatedProperties($this$removePrivateDeclarations).clear();
    }

    private static final void removePrivateDeclarations(KmDeclarationContainer $this$removePrivateDeclarations, boolean copyFunShouldBeDeleted, boolean preserveDeclarationOrder) {
        $this$removePrivateDeclarations.getFunctions().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$5((Function1)new Function1<KmFunction, Boolean>(copyFunShouldBeDeleted){
            final /* synthetic */ boolean $copyFunShouldBeDeleted;
            {
                this.$copyFunShouldBeDeleted = $copyFunShouldBeDeleted;
                super(1);
            }

            public final Boolean invoke(KmFunction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JvmAbiMetadataProcessorKt.access$isPrivate(Attributes.getVisibility(it)) || this.$copyFunShouldBeDeleted && Intrinsics.areEqual((Object)it.getName(), (Object)"copy");
            }
        }, arg_0));
        $this$removePrivateDeclarations.getProperties().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$6(removePrivateDeclarations.3.INSTANCE, arg_0));
        if (!preserveDeclarationOrder) {
            Function1[] function1Array = new Function1[]{removePrivateDeclarations.4.INSTANCE, removePrivateDeclarations.5.INSTANCE};
            CollectionsKt.sortWith($this$removePrivateDeclarations.getFunctions(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
            function1Array = new Function1[]{removePrivateDeclarations.6.INSTANCE, removePrivateDeclarations.7.INSTANCE};
            CollectionsKt.sortWith($this$removePrivateDeclarations.getProperties(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        }
        for (KmProperty property : $this$removePrivateDeclarations.getProperties()) {
            if (Attributes.isConst(property)) continue;
            Attributes.setHasConstant(property, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean copyFunShouldBeDeleted(KmClass $this$copyFunShouldBeDeleted, boolean removeDataClassCopy) {
        boolean bl;
        if (!removeDataClassCopy) return false;
        if (!Attributes.isData($this$copyFunShouldBeDeleted)) return false;
        Iterable $this$none$iv = $this$copyFunShouldBeDeleted.getConstructors();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            KmConstructor it = (KmConstructor)element$iv;
            boolean bl2 = false;
            if (!Attributes.isSecondary(it)) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private static final boolean isPrivate(Visibility $this$isPrivate) {
        return $this$isPrivate == Visibility.PRIVATE || $this$isPrivate == Visibility.PRIVATE_TO_THIS || $this$isPrivate == Visibility.LOCAL;
    }

    private static final boolean removePrivateDeclarations$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$visitKotlinMetadata(AnnotationVisitor $receiver, Metadata header) {
        JvmAbiMetadataProcessorKt.visitKotlinMetadata($receiver, header);
    }

    public static final /* synthetic */ void access$removePrivateDeclarations(KmClass $receiver, boolean removeCopyAlongWithConstructor, boolean preserveDeclarationOrder) {
        JvmAbiMetadataProcessorKt.removePrivateDeclarations($receiver, removeCopyAlongWithConstructor, preserveDeclarationOrder);
    }

    public static final /* synthetic */ void access$removePrivateDeclarations(KmPackage $receiver, boolean preserveDeclarationOrder) {
        JvmAbiMetadataProcessorKt.removePrivateDeclarations($receiver, preserveDeclarationOrder);
    }

    public static final /* synthetic */ boolean access$isPrivate(Visibility $receiver) {
        return JvmAbiMetadataProcessorKt.isPrivate($receiver);
    }
}

