/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.jvm.abi.JvmAbiConfigurationKeys;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiCommandLineProcessor;", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "<init>", "()V", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getPluginOptions", "()Ljava/util/Collection;", "processOption", "", "option", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "value", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "jvm-abi-gen"})
public final class JvmAbiCommandLineProcessor
implements CommandLineProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String COMPILER_PLUGIN_ID = "org.jetbrains.kotlin.jvm.abi";
    @NotNull
    private static final CliOption OUTPUT_PATH_OPTION = new CliOption("outputDir", "<path>", "Output path for generated files. This can be either a directory or a jar file.", true, false, 16, null);
    @NotNull
    private static final CliOption REMOVE_DEBUG_INFO_OPTION = new CliOption("removeDebugInfo", "true/false", "Remove debug info from the generated class files. False by default. Note that if ABI jars are used for incremental compilation, it's not safe to remove debug info because debugger will behave incorrectly on non-recompiled call sites of inline functions.", false, false, 16, null);
    @NotNull
    private static final CliOption REMOVE_DATA_CLASS_COPY_IF_CONSTRUCTOR_IS_PRIVATE_OPTION = new CliOption("removeDataClassCopyIfConstructorIsPrivate", "true/false", "Remove the 'copy' function from ABI if the primary constructor of the data class is private. False by default. Note that if ABI jars are used for incremental compilation, removal of the 'copy' function might break usages outside of the compilation unit where it's declared.", false, false, 16, null);
    @NotNull
    private static final CliOption PRESERVE_DECLARATION_ORDER_OPTION = new CliOption("preserveDeclarationOrder", "true/false", "Do not sort class members in output abi.jar. Legacy flag that allows tools that rely on methods/fields order in the source to keep working. Flipping this to true reduces stability of the ABI.", false, false, 16, null);
    @NotNull
    private static final CliOption REMOVE_PRIVATE_CLASSES_OPTION = new CliOption("removePrivateClasses", "true/false", "Remove private classes from ABI. False by default due to backwards compatibility. If enabled, private top-level classes will no longer be available from Java classes in the same package.", false, false, 16, null);
    @NotNull
    private static final CliOption TREAT_INTERNAL_AS_PRIVATE_OPTION = new CliOption("treatInternalAsPrivate", "true/false", "Treat internal declarations as private and remove from ABI. False by default due to backwards compatibility.\nIf enabled, internal functions are removed and will no longer be available from Java if it's compiled against abi.jar.\nWorks best in conjunction with flags:\n  * removePrivateClasses - internal classes are being removed too;\n  * removeDataClassCopyIfConstructorIsPrivate - copy method is removed along with internal constructor.", false, false, 16, null);

    @NotNull
    public String getPluginId() {
        return COMPILER_PLUGIN_ID;
    }

    @NotNull
    public Collection<CliOption> getPluginOptions() {
        Object[] objectArray = new CliOption[]{OUTPUT_PATH_OPTION, REMOVE_DEBUG_INFO_OPTION, REMOVE_DATA_CLASS_COPY_IF_CONSTRUCTOR_IS_PRIVATE_OPTION, PRESERVE_DECLARATION_ORDER_OPTION, REMOVE_PRIVATE_CLASSES_OPTION, TREAT_INTERNAL_AS_PRIVATE_OPTION};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void processOption(@NotNull AbstractCliOption option, @NotNull String value, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        AbstractCliOption abstractCliOption = option;
        if (Intrinsics.areEqual((Object)abstractCliOption, (Object)OUTPUT_PATH_OPTION)) {
            configuration.put(JvmAbiConfigurationKeys.INSTANCE.getOUTPUT_PATH(), (Object)value);
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)REMOVE_DEBUG_INFO_OPTION)) {
            configuration.put(JvmAbiConfigurationKeys.INSTANCE.getREMOVE_DEBUG_INFO(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)REMOVE_DATA_CLASS_COPY_IF_CONSTRUCTOR_IS_PRIVATE_OPTION)) {
            configuration.put(JvmAbiConfigurationKeys.INSTANCE.getREMOVE_DATA_CLASS_COPY_IF_CONSTRUCTOR_IS_PRIVATE(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)PRESERVE_DECLARATION_ORDER_OPTION)) {
            configuration.put(JvmAbiConfigurationKeys.INSTANCE.getPRESERVE_DECLARATION_ORDER(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)REMOVE_PRIVATE_CLASSES_OPTION)) {
            configuration.put(JvmAbiConfigurationKeys.INSTANCE.getREMOVE_PRIVATE_CLASSES(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)TREAT_INTERNAL_AS_PRIVATE_OPTION)) {
            configuration.put(JvmAbiConfigurationKeys.INSTANCE.getTREAT_INTERNAL_AS_PRIVATE(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else {
            throw new CliOptionProcessingException("Unknown option: " + option.getOptionName(), null, 2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiCommandLineProcessor$Companion;", "", "<init>", "()V", "COMPILER_PLUGIN_ID", "", "OUTPUT_PATH_OPTION", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getOUTPUT_PATH_OPTION", "()Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "REMOVE_DEBUG_INFO_OPTION", "getREMOVE_DEBUG_INFO_OPTION", "REMOVE_DATA_CLASS_COPY_IF_CONSTRUCTOR_IS_PRIVATE_OPTION", "getREMOVE_DATA_CLASS_COPY_IF_CONSTRUCTOR_IS_PRIVATE_OPTION", "PRESERVE_DECLARATION_ORDER_OPTION", "getPRESERVE_DECLARATION_ORDER_OPTION", "REMOVE_PRIVATE_CLASSES_OPTION", "getREMOVE_PRIVATE_CLASSES_OPTION", "TREAT_INTERNAL_AS_PRIVATE_OPTION", "getTREAT_INTERNAL_AS_PRIVATE_OPTION", "jvm-abi-gen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CliOption getOUTPUT_PATH_OPTION() {
            return OUTPUT_PATH_OPTION;
        }

        @NotNull
        public final CliOption getREMOVE_DEBUG_INFO_OPTION() {
            return REMOVE_DEBUG_INFO_OPTION;
        }

        @NotNull
        public final CliOption getREMOVE_DATA_CLASS_COPY_IF_CONSTRUCTOR_IS_PRIVATE_OPTION() {
            return REMOVE_DATA_CLASS_COPY_IF_CONSTRUCTOR_IS_PRIVATE_OPTION;
        }

        @NotNull
        public final CliOption getPRESERVE_DECLARATION_ORDER_OPTION() {
            return PRESERVE_DECLARATION_ORDER_OPTION;
        }

        @NotNull
        public final CliOption getREMOVE_PRIVATE_CLASSES_OPTION() {
            return REMOVE_PRIVATE_CLASSES_OPTION;
        }

        @NotNull
        public final CliOption getTREAT_INTERNAL_AS_PRIVATE_OPTION() {
            return TREAT_INTERNAL_AS_PRIVATE_OPTION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

