/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi.kotlinx.metadata;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmAnnotation;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmAnnotationArgument;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmAnnotation;", "", "className", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/ClassName;", "", "arguments", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmAnnotationArgument;", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getClassName", "()Ljava/lang/String;", "Ljava/lang/String;", "getArguments", "()Ljava/util/Map;", "equals", "", "other", "hashCode", "", "toString", "kotlinx-metadata"})
public final class KmAnnotation {
    @NotNull
    private final String className;
    @NotNull
    private final Map<String, KmAnnotationArgument> arguments;

    public KmAnnotation(@NotNull String className, @NotNull Map<String, ? extends KmAnnotationArgument> arguments) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this.className = className;
        this.arguments = arguments;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final Map<String, KmAnnotationArgument> getArguments() {
        return this.arguments;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof KmAnnotation && Intrinsics.areEqual((Object)this.className, (Object)((KmAnnotation)other).className) && Intrinsics.areEqual(this.arguments, ((KmAnnotation)other).arguments);
    }

    public int hashCode() {
        return 31 * this.className.hashCode() + ((Object)this.arguments).hashCode();
    }

    @NotNull
    public String toString() {
        String args2 = CollectionsKt.joinToString$default((Iterable)MapsKt.toList(this.arguments), null, null, null, (int)0, null, (Function1)toString.args.1.INSTANCE, (int)31, null);
        return '@' + this.className + '(' + args2 + ')';
    }
}

