/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputBinaryFile;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.extensions.ClassFileFactoryFinalizerExtension;
import org.jetbrains.kotlin.jvm.abi.AbiClassInfo;
import org.jetbrains.kotlin.jvm.abi.AbiMethodInfo;
import org.jetbrains.kotlin.jvm.abi.JvmAbiMetadataProcessorKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.ClassRemapper;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.commons.Remapper;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension;", "Lorg/jetbrains/kotlin/codegen/extensions/ClassFileFactoryFinalizerExtension;", "outputPath", "Ljava/io/File;", "abiClassInfos", "", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiClassInfo;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "removeDebugInfo", "", "<init>", "(Ljava/io/File;Ljava/util/Map;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Z)V", "finalizeClassFactory", "", "factory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "InnerClassInfo", "AbiOutputFiles", "jvm-abi-gen"})
public final class JvmAbiOutputExtension
implements ClassFileFactoryFinalizerExtension {
    @NotNull
    private final File outputPath;
    @NotNull
    private final Map<String, AbiClassInfo> abiClassInfos;
    @NotNull
    private final MessageCollector messageCollector;
    private final boolean removeDebugInfo;

    public JvmAbiOutputExtension(@NotNull File outputPath, @NotNull Map<String, ? extends AbiClassInfo> abiClassInfos, @NotNull MessageCollector messageCollector, boolean removeDebugInfo) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter(abiClassInfos, (String)"abiClassInfos");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        this.outputPath = outputPath;
        this.abiClassInfos = abiClassInfos;
        this.messageCollector = messageCollector;
        this.removeDebugInfo = removeDebugInfo;
    }

    public void finalizeClassFactory(@NotNull ClassFileFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        AbiOutputFiles outputFiles = new AbiOutputFiles(this.abiClassInfos, (OutputFileCollection)factory, this.removeDebugInfo);
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)this.outputPath), (Object)"jar")) {
            CompileEnvironmentUtil.writeToJar((File)this.outputPath, (boolean)false, (boolean)true, (boolean)true, null, (OutputFileCollection)outputFiles, (MessageCollector)this.messageCollector);
        } else {
            OutputUtilsKt.writeAllTo((OutputFileCollection)outputFiles, (File)this.outputPath);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0016J.\u0010\u0016\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00040\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a0\u00032\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J&\u0010\u001c\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00040\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a0\u0003H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$AbiOutputFiles;", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "abiClassInfos", "", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiClassInfo;", "outputFiles", "removeDebugInfo", "", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;Z)V", "getAbiClassInfos", "()Ljava/util/Map;", "getOutputFiles", "()Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "getRemoveDebugInfo", "()Z", "get", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "relativePath", "asList", "", "addInnerClasses", "", "", "innerClassInfos", "Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$InnerClassInfo;", "internalName", "addOuterClasses", "jvm-abi-gen"})
    @SourceDebugExtension(value={"SMAP\nJvmAbiOutputExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAbiOutputExtension.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$AbiOutputFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,220:1\n764#2:221\n855#2,2:222\n1043#2:224\n1601#2,9:225\n1853#2:234\n1854#2:237\n1610#2:238\n1475#2:239\n1500#2,3:240\n1503#2,3:250\n1609#2:253\n1853#2:254\n1854#2:256\n1610#2:257\n1#3:235\n1#3:236\n1#3:255\n372#4,7:243\n*S KotlinDebug\n*F\n+ 1 JvmAbiOutputExtension.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$AbiOutputFiles\n*L\n61#1:221\n61#1:222,2\n63#1:224\n65#1:225,9\n65#1:234\n65#1:237\n65#1:238\n199#1:239\n199#1:240,3\n199#1:250,3\n205#1:253\n205#1:254\n205#1:256\n205#1:257\n65#1:236\n205#1:255\n199#1:243,7\n*E\n"})
    private static final class AbiOutputFiles
    implements OutputFileCollection {
        @NotNull
        private final Map<String, AbiClassInfo> abiClassInfos;
        @NotNull
        private final OutputFileCollection outputFiles;
        private final boolean removeDebugInfo;

        public AbiOutputFiles(@NotNull Map<String, ? extends AbiClassInfo> abiClassInfos, @NotNull OutputFileCollection outputFiles, boolean removeDebugInfo) {
            Intrinsics.checkNotNullParameter(abiClassInfos, (String)"abiClassInfos");
            Intrinsics.checkNotNullParameter((Object)outputFiles, (String)"outputFiles");
            this.abiClassInfos = abiClassInfos;
            this.outputFiles = outputFiles;
            this.removeDebugInfo = removeDebugInfo;
        }

        @NotNull
        public final Map<String, AbiClassInfo> getAbiClassInfos() {
            return this.abiClassInfos;
        }

        @NotNull
        public final OutputFileCollection getOutputFiles() {
            return this.outputFiles;
        }

        public final boolean getRemoveDebugInfo() {
            return this.removeDebugInfo;
        }

        @Nullable
        public OutputFile get(@NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            throw new IllegalStateException("AbiOutputFiles does not implement `get`.".toString());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<OutputFile> asList() {
            void $this$mapNotNullTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.outputFiles.asList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OutputFile it = (OutputFile)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.endsWith$default((String)it.getRelativePath(), (String)".class", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List metadata = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    OutputFile it = (OutputFile)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getRelativePath());
                    it = (OutputFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getRelativePath())));
                }
            });
            Iterable $this$mapNotNull$iv = CollectionsKt.sorted((Iterable)this.abiClassInfos.keySet());
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                OutputFile outputFile;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String internalName = (String)element$iv$iv;
                boolean bl2 = false;
                OutputFile outputFile2 = this.outputFiles.get(internalName + ".class");
                AbiClassInfo abiInfo = (AbiClassInfo)MapsKt.getValue(this.abiClassInfos, (Object)internalName);
                if (outputFile2 == null) {
                    outputFile = null;
                } else if (abiInfo instanceof AbiClassInfo.Public) {
                    outputFile = outputFile2;
                } else {
                    Intrinsics.checkNotNull((Object)abiInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.jvm.abi.AbiClassInfo.Stripped");
                    Map<Method, AbiMethodInfo> methodInfo = ((AbiClassInfo.Stripped)abiInfo).getMethodInfo();
                    Map innerClassInfos = new LinkedHashMap();
                    Set innerClassesToKeep = new LinkedHashSet();
                    ClassWriter writer = new ClassWriter(0);
                    ClassRemapper remapper2 = new ClassRemapper((ClassVisitor)writer, new Remapper(innerClassesToKeep){
                        final /* synthetic */ Set<String> $innerClassesToKeep;
                        {
                            this.$innerClassesToKeep = $innerClassesToKeep;
                        }

                        public String map(String internalName) {
                            Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
                            String string = internalName;
                            Set<String> set = this.$innerClassesToKeep;
                            String it = string;
                            boolean bl = false;
                            set.add(it);
                            return string;
                        }
                    });
                    new ClassReader(outputFile2.asByteArray()).accept(new ClassVisitor(remapper2, methodInfo, this, innerClassInfos){
                        final /* synthetic */ Map<Method, AbiMethodInfo> $methodInfo;
                        final /* synthetic */ AbiOutputFiles this$0;
                        final /* synthetic */ Map<String, InnerClassInfo> $innerClassInfos;
                        {
                            this.$methodInfo = $methodInfo;
                            this.this$0 = $receiver;
                            this.$innerClassInfos = $innerClassInfos;
                            super(589824, (ClassVisitor)$remapper);
                        }

                        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                            if ((access & 2) != 0) {
                                return null;
                            }
                            return super.visitField(access, name, descriptor, signature, value);
                        }

                        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                            AbiMethodInfo abiMethodInfo = this.$methodInfo.get(new Method(name, descriptor));
                            if (abiMethodInfo == null) {
                                return null;
                            }
                            AbiMethodInfo info = abiMethodInfo;
                            MethodVisitor visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                            if (info == AbiMethodInfo.KEEP || (access & 0x500) != 0) {
                                return new MethodVisitor(visitor, this.this$0){
                                    final /* synthetic */ AbiOutputFiles this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(589824, $visitor);
                                    }

                                    public void visitLineNumber(int line, Label start) {
                                        if (!this.this$0.getRemoveDebugInfo()) {
                                            super.visitLineNumber(line, start);
                                        }
                                    }

                                    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                                        if (!this.this$0.getRemoveDebugInfo()) {
                                            super.visitLocalVariable(name, descriptor, signature, start, end, index);
                                        }
                                    }
                                };
                            }
                            return new MethodVisitor(visitor){

                                public void visitCode() {
                                    MethodVisitor $this$visitCode_u24lambda_u240 = this.mv;
                                    boolean bl = false;
                                    $this$visitCode_u24lambda_u240.visitCode();
                                    $this$visitCode_u24lambda_u240.visitInsn(1);
                                    $this$visitCode_u24lambda_u240.visitInsn(191);
                                    $this$visitCode_u24lambda_u240.visitMaxs(0, 0);
                                    $this$visitCode_u24lambda_u240.visitEnd();
                                    this.mv = null;
                                }
                            };
                        }

                        public void visitSource(String source, String debug) {
                            if (this.this$0.getRemoveDebugInfo()) {
                                super.visitSource(null, null);
                            } else {
                                boolean bl;
                                block7: {
                                    Iterable $this$none$iv = this.$methodInfo.values();
                                    boolean $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl = true;
                                    } else {
                                        for (T element$iv : $this$none$iv) {
                                            AbiMethodInfo it = (AbiMethodInfo)((Object)element$iv);
                                            boolean bl2 = false;
                                            if (!(it == AbiMethodInfo.KEEP)) continue;
                                            bl = false;
                                            break block7;
                                        }
                                        bl = true;
                                    }
                                }
                                if (bl) {
                                    super.visitSource(source, null);
                                } else {
                                    super.visitSource(source, debug);
                                }
                            }
                        }

                        public void visitInnerClass(String name, String outerName, String innerName, int access) {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            this.$innerClassInfos.put(name, new InnerClassInfo(name, outerName, innerName, access));
                        }

                        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                            if (this.this$0.getRemoveDebugInfo() && Intrinsics.areEqual((Object)descriptor, (Object)"Lkotlin/jvm/internal/SourceDebugExtension;")) {
                                return null;
                            }
                            AnnotationVisitor delegate = super.visitAnnotation(descriptor, visible);
                            if (!Intrinsics.areEqual((Object)descriptor, (Object)JvmAnnotationNames.METADATA_DESC)) {
                                return delegate;
                            }
                            Intrinsics.checkNotNull((Object)delegate);
                            return JvmAbiMetadataProcessorKt.abiMetadataProcessor(delegate);
                        }

                        public void visitEnd() {
                        }
                    }, 0);
                    this.addInnerClasses(innerClassesToKeep, innerClassInfos, internalName);
                    this.addOuterClasses(innerClassesToKeep, innerClassInfos);
                    for (String name : CollectionsKt.sorted((Iterable)innerClassesToKeep)) {
                        InnerClassInfo it;
                        if ((InnerClassInfo)innerClassInfos.get(name) == null) continue;
                        boolean bl3 = false;
                        writer.visitInnerClass(it.getName(), it.getOuterName(), it.getInnerName(), it.getAccess());
                    }
                    writer.visitEnd();
                    List list = outputFile2.getSourceFiles();
                    String string = outputFile2.getRelativePath();
                    byte[] byArray = writer.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                    outputFile = (OutputFile)new SimpleOutputBinaryFile(list, string, byArray);
                }
                if (outputFile == null) continue;
                OutputFile it$iv$iv = outputFile;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List classFiles2 = (List)destination$iv$iv2;
            return CollectionsKt.plus((Collection)metadata, (Iterable)classFiles2);
        }

        /*
         * WARNING - void declaration
         */
        private final void addInnerClasses(Set<String> $this$addInnerClasses, Map<String, InnerClassInfo> innerClassInfos, String internalName) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = innerClassInfos.values();
            boolean $i$f$groupBy22 = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                InnerClassInfo it = (InnerClassInfo)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getOuterName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map innerClassesByOuterName = destination$iv$iv;
            Object[] $i$f$groupBy22 = new String[]{internalName};
            List stack = CollectionsKt.mutableListOf((Object[])$i$f$groupBy22);
            while (!((Collection)stack).isEmpty()) {
                String next = (String)CollectionsKt.removeLast((List)stack);
                $this$addInnerClasses.add(next);
                List list = (List)innerClassesByOuterName.get(next);
                if (list == null) continue;
                Iterable $this$mapNotNullTo$iv = list;
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    InnerClassInfo it = (InnerClassInfo)element$iv;
                    boolean bl3 = false;
                    String string = it.getName();
                    Map<String, AbiClassInfo> map = this.abiClassInfos;
                    String p0 = string;
                    boolean bl4 = false;
                    if ((map.containsKey(p0) ? string : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl5 = false;
                    ((Collection)stack).add(it$iv);
                }
                List cfr_ignored_0 = (List)((Collection)stack);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void addOuterClasses(Set<String> $this$addOuterClasses, Map<String, InnerClassInfo> innerClassInfos) {
            for (String name : CollectionsKt.toList((Iterable)$this$addOuterClasses)) {
                info = innerClassInfos.get(name);
                while (info != null) {
                    v0 = info.getOuterName();
                    if (v0 == null) ** GOTO lbl-1000
                    p0 = var6_6 = v0;
                    $i$a$-takeIf-JvmAbiOutputExtension$AbiOutputFiles$addOuterClasses$1 = false;
                    v0 = $this$addOuterClasses.add(p0) != false ? var6_6 : null;
                    if (v0 != null) {
                        p0 = v0;
                        $i$a$-let-JvmAbiOutputExtension$AbiOutputFiles$addOuterClasses$2 = false;
                        v1 = innerClassInfos.get(p0);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = null;
                    }
                    info = v1;
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$InnerClassInfo;", "", "name", "", "outerName", "innerName", "access", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getName", "()Ljava/lang/String;", "getOuterName", "getInnerName", "getAccess", "()I", "jvm-abi-gen"})
    private static final class InnerClassInfo {
        @NotNull
        private final String name;
        @Nullable
        private final String outerName;
        @Nullable
        private final String innerName;
        private final int access;

        public InnerClassInfo(@NotNull String name, @Nullable String outerName, @Nullable String innerName, int access) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.outerName = outerName;
            this.innerName = innerName;
            this.access = access;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getOuterName() {
            return this.outerName;
        }

        @Nullable
        public final String getInnerName() {
            return this.innerName;
        }

        public final int getAccess() {
            return this.access;
        }
    }
}

