/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.InconsistentKotlinMetadataException;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmAnnotation;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmClass;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmLambda;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmPackage;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.ReadersKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.ProtoBuf;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KmModule;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KmPackageParts;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.UnstableMetadataApi;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.internal.JvmExceptionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001d\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/jvm/internal/JvmReadUtils;", "", "<init>", "()V", "readKmClass", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmClass;", "annotationData", "Lkotlin/Metadata;", "readKmClass$kotlinx_metadata_jvm", "readKmPackage", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmPackage;", "readKmPackage$kotlinx_metadata_jvm", "readKmLambda", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmLambda;", "readKmLambda$kotlinx_metadata_jvm", "readMetadataImpl", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/jvm/KotlinClassMetadata;", "lenient", "", "readMetadataImpl$kotlinx_metadata_jvm", "readModuleMetadataImpl", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/jvm/KmModule;", "data", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/ModuleMapping;", "readModuleMetadataImpl$kotlinx_metadata_jvm", "checkMetadataVersionForRead", "", "throwIfNotCompatible", "jvmMetadataVersion", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/JvmMetadataVersion;", "throwIfNotCompatible$kotlinx_metadata_jvm", "kotlinx-metadata-jvm"})
@SourceDebugExtension(value={"SMAP\nJvmReadUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmReadUtils.kt\nkotlinx/metadata/jvm/internal/JvmReadUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JvmExceptionUtils.kt\nkotlinx/metadata/jvm/internal/JvmExceptionUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1#2:103\n15#3,8:104\n3183#4,10:112\n1269#4,2:122\n1283#4,4:124\n*S KotlinDebug\n*F\n+ 1 JvmReadUtils.kt\nkotlinx/metadata/jvm/internal/JvmReadUtils\n*L\n46#1:104,8\n62#1:112,10\n65#1:122,2\n65#1:124,4\n*E\n"})
public final class JvmReadUtils {
    @NotNull
    public static final JvmReadUtils INSTANCE = new JvmReadUtils();

    private JvmReadUtils() {
    }

    @NotNull
    public final KmClass readKmClass$kotlinx_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = (JvmNameResolver)pair.component1();
        ProtoBuf.Class proto = (ProtoBuf.Class)pair.component2();
        return ReadersKt.toKmClass$default(proto, strings, null, 2, null);
    }

    @NotNull
    public final KmPackage readKmPackage$kotlinx_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
        Pair<JvmNameResolver, ProtoBuf.Package> pair = JvmProtoBufUtil.readPackageDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = (JvmNameResolver)pair.component1();
        ProtoBuf.Package proto = (ProtoBuf.Package)pair.component2();
        return ReadersKt.toKmPackage$default(proto, strings, null, 2, null);
    }

    @Nullable
    public final KmLambda readKmLambda$kotlinx_metadata_jvm(@NotNull Metadata annotationData) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
                Pair<JvmNameResolver, ProtoBuf.Function> pair = annotationData.d1();
                Object[] p0 = (Object[])pair;
                boolean bl = false;
                object = !(p0.length == 0) ? pair : null;
                if (object == null) break block2;
                Pair<JvmNameResolver, ProtoBuf.Function> data1 = object;
                boolean bl2 = false;
                Pair<JvmNameResolver, ProtoBuf.Function> pair2 = JvmProtoBufUtil.readFunctionDataFrom((String[])data1, annotationData.d2());
                object = pair2;
                if (pair2 != null) break block3;
            }
            return null;
        }
        Pair<JvmNameResolver, ProtoBuf.Function> functionData = object;
        JvmNameResolver strings = (JvmNameResolver)functionData.component1();
        ProtoBuf.Function proto = (ProtoBuf.Function)functionData.component2();
        return ReadersKt.toKmLambda(proto, strings);
    }

    @NotNull
    public final KotlinClassMetadata readMetadataImpl$kotlinx_metadata_jvm(@NotNull Metadata annotationData, boolean lenient) {
        KotlinClassMetadata kotlinClassMetadata;
        Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
        this.checkMetadataVersionForRead(annotationData, lenient);
        boolean $i$f$wrapIntoMetadataExceptionWhenNeeded = false;
        try {
            KotlinClassMetadata kotlinClassMetadata2;
            boolean bl = false;
            switch (annotationData.k()) {
                case 1: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Class(annotationData, lenient);
                    break;
                }
                case 2: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.FileFacade(annotationData, lenient);
                    break;
                }
                case 3: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.SyntheticClass(annotationData, lenient);
                    break;
                }
                case 4: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassFacade(annotationData, lenient);
                    break;
                }
                case 5: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassPart(annotationData, lenient);
                    break;
                }
                default: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Unknown(annotationData, lenient);
                }
            }
            kotlinClassMetadata = kotlinClassMetadata2;
        }
        catch (Throwable e$iv) {
            Throwable throwable = e$iv;
            throw throwable instanceof IllegalArgumentException ? e$iv : (throwable instanceof VirtualMachineError || throwable instanceof ThreadDeath ? e$iv : (Throwable)new InconsistentKotlinMetadataException("Exception occurred when reading Kotlin metadata", e$iv));
        }
        return kotlinClassMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @UnstableMetadataApi
    @NotNull
    public final KmModule readModuleMetadataImpl$kotlinx_metadata_jvm(@NotNull ModuleMapping data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KmModule v = new KmModule();
        for (Map.Entry<String, PackageParts> entry : data.getPackageFqName2Parts().entrySet()) {
            void $this$associateWith$iv;
            String fqName = entry.getKey();
            PackageParts parts = entry.getValue();
            Iterable $this$partition$iv = parts.getParts();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Iterable<Object> second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (parts.getMultifileFacadeName(it) == null) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List fileFacades = (List)pair.component1();
            List multiFileClassParts = (List)pair.component2();
            Map<String, KmPackageParts> map = v.getPackageParts();
            second$iv = multiFileClassParts;
            List list = CollectionsKt.toMutableList((Collection)fileFacades);
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string;
                void it;
                String string2 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)parts.getMultifileFacadeName((String)it));
                map2.put(t, string);
            }
            Map map3 = MapsKt.toMutableMap((Map)result$iv);
            List list2 = list;
            KmPackageParts kmPackageParts = new KmPackageParts(list2, map3);
            map.put(fqName, kmPackageParts);
        }
        for (String annotation : data.getModuleData().getAnnotations()) {
            v.getAnnotations().add(new KmAnnotation(annotation, MapsKt.emptyMap()));
        }
        for (ProtoBuf.Class classProto : data.getModuleData().getOptionalAnnotations()) {
            v.getOptionalAnnotationClasses().add(ReadersKt.toKmClass$default(classProto, data.getModuleData().getNameResolver(), null, 2, null));
        }
        return v;
    }

    private final void checkMetadataVersionForRead(Metadata annotationData, boolean lenient) {
        if (annotationData.mv().length == 0) {
            throw new IllegalArgumentException("Provided Metadata instance does not have metadataVersion in it and therefore is malformed and cannot be read.");
        }
        JvmMetadataVersion jvmMetadataVersion = new JvmMetadataVersion(annotationData.mv(), (annotationData.xi() & 8) != 0);
        this.throwIfNotCompatible$kotlinx_metadata_jvm(jvmMetadataVersion, lenient);
    }

    public final void throwIfNotCompatible$kotlinx_metadata_jvm(@NotNull JvmMetadataVersion jvmMetadataVersion, boolean lenient) {
        boolean isCompatible;
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"jvmMetadataVersion");
        boolean isAtLeast110 = jvmMetadataVersion.isAtLeast(1, 1, 0);
        boolean bl = isCompatible = lenient ? isAtLeast110 : jvmMetadataVersion.isCompatibleWithCurrentCompilerVersion();
        if (!isCompatible) {
            String postfix = !isAtLeast110 ? "while minimum supported version is 1.1.0 (Kotlin 1.0)." : "while maximum supported version is " + (jvmMetadataVersion.isStrictSemantics() ? JvmMetadataVersion.INSTANCE : JvmMetadataVersion.INSTANCE_NEXT) + ". To support newer versions, update the kotlinx-metadata-jvm library.";
            throw new IllegalArgumentException("Provided Metadata instance has version " + jvmMetadataVersion + ", " + postfix);
        }
    }
}

