/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.jvm.abi.JvmAbiMetadataProcessorKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.Attributes;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmClass;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmDeclarationContainer;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmPackage;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmProperty;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.Visibility;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.JvmExtensionsKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.JvmMetadataUtil;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001c\u0010\u0003\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002\u001a\u0014\u0010\b\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\u000bH\u0002\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\fH\u0002\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\rH\u0002\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u0012"}, d2={"abiMetadataProcessor", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "annotationVisitor", "kotlinClassHeaderVisitor", "body", "Lkotlin/Function1;", "Lkotlin/Metadata;", "", "visitKotlinMetadata", "header", "removePrivateDeclarations", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmClass;", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmPackage;", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmDeclarationContainer;", "isPrivate", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/Visibility;", "(Lkotlinx/metadata/Visibility;)Z", "jvm-abi-gen"})
@SourceDebugExtension(value={"SMAP\nJvmAbiMetadataProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAbiMetadataProcessor.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiMetadataProcessorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,187:1\n13309#2,2:188\n13309#2,2:190\n*S KotlinDebug\n*F\n+ 1 JvmAbiMetadataProcessor.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiMetadataProcessorKt\n*L\n138#1:188,2\n144#1:190,2\n*E\n"})
public final class JvmAbiMetadataProcessorKt {
    @NotNull
    public static final AnnotationVisitor abiMetadataProcessor(@NotNull AnnotationVisitor annotationVisitor) {
        Intrinsics.checkNotNullParameter((Object)annotationVisitor, (String)"annotationVisitor");
        return JvmAbiMetadataProcessorKt.kotlinClassHeaderVisitor((Function1<? super Metadata, Unit>)((Function1)new Function1<Metadata, Unit>(annotationVisitor){
            final /* synthetic */ AnnotationVisitor $annotationVisitor;
            {
                this.$annotationVisitor = $annotationVisitor;
                super(1);
            }

            public final void invoke(Metadata header) {
                Object object;
                Object object2;
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                int[] v = object2 = header.mv();
                boolean bl = false;
                Integer n = ArraysKt.getOrNull((int[])v, (int)0);
                int major = n != null ? n : 0;
                Integer n2 = ArraysKt.getOrNull((int[])v, (int)1);
                int minor = n2 != null ? n2 : 0;
                int[] nArray = (int[])(major > 1 || major == 1 && minor >= 4 ? object2 : null);
                if (nArray == null) {
                    object2 = new int[]{1, 4};
                    nArray = object2;
                }
                int[] metadataVersion = nArray;
                try {
                    Metadata metadata;
                    boolean bl2 = false;
                    KotlinClassMetadata metadata2 = KotlinClassMetadata.Companion.read(header);
                    if (metadata2 instanceof KotlinClassMetadata.Class) {
                        KmClass klass = ((KotlinClassMetadata.Class)metadata2).getKmClass();
                        JvmAbiMetadataProcessorKt.access$removePrivateDeclarations(klass);
                        metadata = KotlinClassMetadata.Companion.writeClass(klass, metadataVersion, header.xi());
                    } else if (metadata2 instanceof KotlinClassMetadata.FileFacade) {
                        KmPackage pkg = ((KotlinClassMetadata.FileFacade)metadata2).getKmPackage();
                        JvmAbiMetadataProcessorKt.access$removePrivateDeclarations(pkg);
                        metadata = KotlinClassMetadata.Companion.writeFileFacade(pkg, metadataVersion, header.xi());
                    } else if (metadata2 instanceof KotlinClassMetadata.MultiFileClassPart) {
                        KmPackage pkg = ((KotlinClassMetadata.MultiFileClassPart)metadata2).getKmPackage();
                        JvmAbiMetadataProcessorKt.access$removePrivateDeclarations(pkg);
                        metadata = KotlinClassMetadata.Companion.writeMultiFileClassPart(pkg, ((KotlinClassMetadata.MultiFileClassPart)metadata2).getFacadeClassName(), metadataVersion, header.xi());
                    } else {
                        metadata = header;
                    }
                    object2 = Result.constructor-impl((Object)metadata);
                }
                catch (Throwable metadata2) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)metadata2));
                }
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) {
                    object = object2;
                } else {
                    Throwable cause = throwable;
                    boolean bl3 = false;
                    if (Boolean.parseBoolean(System.getProperty("idea.is.unit.test"))) {
                        String actual = "" + metadataVersion[0] + '.' + metadataVersion[1];
                        int[] it = KotlinClassMetadata.COMPATIBLE_METADATA_VERSION;
                        boolean bl4 = false;
                        String expected = "" + it[0] + '.' + it[1];
                        throw new AssertionError("jvm-abi-gen can't process class file with the new metadata version because the version of kotlinx-metadata-jvm it depends on is too old.\nClass file has metadata version " + actual + ", but default metadata version of kotlinx-metadata-jvm is " + expected + ", so it can process class files with metadata version up to +1 from that (because of Kotlin/JVM's one-version forward compatibility policy).\nTo fix this error, ensure that jvm-abi-gen depends on the latest version of kotlinx-metadata-jvm.\nIf this happens during the update of the default language version in the project, make sure that a version of kotlinx-metadata-jvm has been published that supports this version, and update \"versions.kotlinx-metadata-jvm\" in `gradle/versions.properties`.", cause);
                    }
                    object = header;
                }
                Metadata newHeader = (Metadata)object;
                JvmAbiMetadataProcessorKt.access$visitKotlinMetadata(this.$annotationVisitor, newHeader);
            }
        }));
    }

    private static final AnnotationVisitor kotlinClassHeaderVisitor(Function1<? super Metadata, Unit> body) {
        return new AnnotationVisitor(body){
            private int kind;
            private int[] metadataVersion;
            private List<String> data1;
            private List<String> data2;
            private String extraString;
            private String packageName;
            private int extraInt;
            final /* synthetic */ Function1<Metadata, Unit> $body;
            {
                this.$body = $body;
                super(589824);
                this.kind = 1;
                this.metadataVersion = new int[0];
                this.data1 = new ArrayList<E>();
                this.data2 = new ArrayList<E>();
            }

            public final int getKind() {
                return this.kind;
            }

            public final void setKind(int n) {
                this.kind = n;
            }

            public final int[] getMetadataVersion() {
                return this.metadataVersion;
            }

            public final void setMetadataVersion(int[] nArray) {
                Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
                this.metadataVersion = nArray;
            }

            public final List<String> getData1() {
                return this.data1;
            }

            public final void setData1(List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data1 = list;
            }

            public final List<String> getData2() {
                return this.data2;
            }

            public final void setData2(List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data2 = list;
            }

            public final String getExtraString() {
                return this.extraString;
            }

            public final void setExtraString(String string) {
                this.extraString = string;
            }

            public final String getPackageName() {
                return this.packageName;
            }

            public final void setPackageName(String string) {
                this.packageName = string;
            }

            public final int getExtraInt() {
                return this.extraInt;
            }

            public final void setExtraInt(int n) {
                this.extraInt = n;
            }

            public void visit(String name, Object value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                switch (name) {
                    case "k": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.kind = (Integer)value;
                        break;
                    }
                    case "xi": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.extraInt = (Integer)value;
                        break;
                    }
                    case "mv": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.IntArray");
                        this.metadataVersion = (int[])value;
                        break;
                    }
                    case "xs": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.extraString = (String)value;
                        break;
                    }
                    case "pn": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.packageName = (String)value;
                    }
                }
            }

            public AnnotationVisitor visitArray(String name) {
                List<String> list;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)"d1")) {
                    list = this.data1;
                } else if (Intrinsics.areEqual((Object)string, (Object)"d2")) {
                    list = this.data2;
                } else {
                    return null;
                }
                List<String> destination = list;
                return new AnnotationVisitor(destination){
                    final /* synthetic */ List<String> $destination;
                    {
                        this.$destination = $destination;
                        super(589824);
                    }

                    public void visit(String name, Object value) {
                        Collection collection = this.$destination;
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)value);
                    }
                };
            }

            public void visitEnd() {
                Collection $this$toTypedArray$iv = this.data1;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = this.data2;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                this.$body.invoke((Object)JvmMetadataUtil.Metadata(this.kind, this.metadataVersion, thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]), this.extraString, this.packageName, this.extraInt));
            }
        };
    }

    private static final void visitKotlinMetadata(AnnotationVisitor $this$visitKotlinMetadata, Metadata header) {
        String it;
        String element$iv;
        int n;
        int n2;
        boolean $i$f$forEach;
        String[] $this$forEach$iv;
        AnnotationVisitor annotationVisitor;
        $this$visitKotlinMetadata.visit("k", (Object)header.k());
        $this$visitKotlinMetadata.visit("mv", (Object)header.mv());
        if (!(header.d1().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u241 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d1");
            boolean bl = false;
            $this$forEach$iv = header.d1();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl2 = false;
                $this$visitKotlinMetadata_u24lambda_u241.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u241.visitEnd();
        }
        if (!(header.d2().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u243 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d2");
            boolean bl = false;
            $this$forEach$iv = header.d2();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl3 = false;
                $this$visitKotlinMetadata_u24lambda_u243.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u243.visitEnd();
        }
        if (((CharSequence)header.xs()).length() > 0) {
            $this$visitKotlinMetadata.visit("xs", (Object)header.xs());
        }
        if (((CharSequence)header.pn()).length() > 0) {
            $this$visitKotlinMetadata.visit("pn", (Object)header.pn());
        }
        if (header.xi() != 0) {
            $this$visitKotlinMetadata.visit("xi", (Object)header.xi());
        }
        $this$visitKotlinMetadata.visitEnd();
    }

    private static final void removePrivateDeclarations(KmClass $this$removePrivateDeclarations) {
        $this$removePrivateDeclarations.getConstructors().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$4(removePrivateDeclarations.1.INSTANCE, arg_0));
        Intrinsics.checkNotNull((Object)$this$removePrivateDeclarations, (String)"null cannot be cast to non-null type kotlinx.metadata.KmDeclarationContainer");
        JvmAbiMetadataProcessorKt.removePrivateDeclarations((KmDeclarationContainer)$this$removePrivateDeclarations);
        JvmExtensionsKt.getLocalDelegatedProperties($this$removePrivateDeclarations).clear();
    }

    private static final void removePrivateDeclarations(KmPackage $this$removePrivateDeclarations) {
        Intrinsics.checkNotNull((Object)$this$removePrivateDeclarations, (String)"null cannot be cast to non-null type kotlinx.metadata.KmDeclarationContainer");
        JvmAbiMetadataProcessorKt.removePrivateDeclarations((KmDeclarationContainer)$this$removePrivateDeclarations);
        JvmExtensionsKt.getLocalDelegatedProperties($this$removePrivateDeclarations).clear();
    }

    private static final void removePrivateDeclarations(KmDeclarationContainer $this$removePrivateDeclarations) {
        $this$removePrivateDeclarations.getFunctions().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$5(removePrivateDeclarations.2.INSTANCE, arg_0));
        $this$removePrivateDeclarations.getProperties().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$6(removePrivateDeclarations.3.INSTANCE, arg_0));
        for (KmProperty property : $this$removePrivateDeclarations.getProperties()) {
            if (Attributes.isConst(property)) continue;
            Attributes.setHasConstant(property, false);
        }
    }

    private static final boolean isPrivate(Visibility $this$isPrivate) {
        return $this$isPrivate == Visibility.PRIVATE || $this$isPrivate == Visibility.PRIVATE_TO_THIS || $this$isPrivate == Visibility.LOCAL;
    }

    private static final boolean removePrivateDeclarations$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$visitKotlinMetadata(AnnotationVisitor $receiver, Metadata header) {
        JvmAbiMetadataProcessorKt.visitKotlinMetadata($receiver, header);
    }

    public static final /* synthetic */ void access$removePrivateDeclarations(KmClass $receiver) {
        JvmAbiMetadataProcessorKt.removePrivateDeclarations($receiver);
    }

    public static final /* synthetic */ void access$removePrivateDeclarations(KmPackage $receiver) {
        JvmAbiMetadataProcessorKt.removePrivateDeclarations($receiver);
    }

    public static final /* synthetic */ boolean access$isPrivate(Visibility $receiver) {
        return JvmAbiMetadataProcessorKt.isPrivate($receiver);
    }
}

