/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.fus.internal;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.fus.GradleBuildFusStatisticsService;
import org.jetbrains.kotlin.gradle.fus.Metric;
import org.jetbrains.kotlin.gradle.fus.UniqueId;
import org.jetbrains.kotlin.gradle.fus.internal.GradleBuildFusStatisticsBuildServiceKt;
import org.jetbrains.kotlin.gradle.fus.internal.WriteMetricToFileKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0004\n\u0002\b\u0006\b&\u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00130\u0012H&J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001f\u0010\u001d\u001a\u00020\u00102\u0010\b\u0002\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\b\u001fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/fus/internal/InternalGradleBuildFusStatisticsService;", "T", "Lorg/jetbrains/kotlin/gradle/fus/internal/InternalGradleBuildFusStatisticsService$Parameter;", "Lorg/jetbrains/kotlin/gradle/fus/GradleBuildFusStatisticsService;", "Ljava/lang/AutoCloseable;", "()V", "buildId", "", "getBuildId$fus_statistics_gradle_plugin_common", "()Ljava/lang/String;", "executionTimeMetrics", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/kotlin/gradle/fus/Metric;", "getExecutionTimeMetrics$fus_statistics_gradle_plugin_common", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "close", "", "getExecutionTimeMetrics", "Lorg/gradle/api/provider/Provider;", "", "internalReportMetric", "name", "value", "", "uniqueId", "Lorg/jetbrains/kotlin/gradle/fus/UniqueId;", "reportMetric", "", "", "writeDownFusMetrics", "configurationTimeMetrics", "writeDownFusMetrics$fus_statistics_gradle_plugin_common", "Companion", "Parameter", "fus-statistics-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nInternalGradleBuildFusStatisticsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalGradleBuildFusStatisticsService.kt\norg/jetbrains/kotlin/gradle/fus/internal/InternalGradleBuildFusStatisticsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1851#2,2:95\n1851#2,2:97\n*S KotlinDebug\n*F\n+ 1 InternalGradleBuildFusStatisticsService.kt\norg/jetbrains/kotlin/gradle/fus/internal/InternalGradleBuildFusStatisticsService\n*L\n80#1:95,2\n83#1:97,2\n*E\n"})
public abstract class InternalGradleBuildFusStatisticsService<T extends Parameter>
implements GradleBuildFusStatisticsService<T>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentLinkedQueue<Metric> executionTimeMetrics = new ConcurrentLinkedQueue();
    @NotNull
    private final String buildId;
    @NotNull
    private static final String STATISTICS_FOLDER_NAME = "kotlin-profile";
    @NotNull
    private static final String BUILD_SESSION_SEPARATOR = "BUILD FINISHED";
    @NotNull
    public static final String FILE_NAME_BUILD_ID_PREFIX_SEPARATOR = ".";
    @NotNull
    public static final String PROFILE_FILE_NAME_SUFFIX = ".plugin-profile";

    public InternalGradleBuildFusStatisticsService() {
        Object object = ((Parameter)this.getParameters()).getBuildId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.buildId.get()");
        this.buildId = (String)object;
        GradleBuildFusStatisticsBuildServiceKt.getLog().debug("Initialize build service " + GradleBuildFusStatisticsBuildServiceKt.getServiceName() + ": class \"" + this.getClass().getSimpleName() + "\", build \"" + this.buildId + '\"');
    }

    @NotNull
    public final ConcurrentLinkedQueue<Metric> getExecutionTimeMetrics$fus_statistics_gradle_plugin_common() {
        return this.executionTimeMetrics;
    }

    @NotNull
    public final String getBuildId$fus_statistics_gradle_plugin_common() {
        return this.buildId;
    }

    @Override
    public void reportMetric(@NotNull String name, boolean value, @NotNull UniqueId uniqueId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        this.internalReportMetric(name, value, uniqueId);
    }

    @Override
    public void reportMetric(@NotNull String name, @NotNull String value, @NotNull UniqueId uniqueId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        this.internalReportMetric(name, value, uniqueId);
    }

    @Override
    public void reportMetric(@NotNull String name, @NotNull Number value, @NotNull UniqueId uniqueId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        this.internalReportMetric(name, value, uniqueId);
    }

    private final void internalReportMetric(String name, Object value, UniqueId uniqueId) {
        this.executionTimeMetrics.add(new Metric(name, value, uniqueId));
    }

    @NotNull
    public abstract Provider<List<Metric>> getExecutionTimeMetrics();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeDownFusMetrics$fus_statistics_gradle_plugin_common(@Nullable List<Metric> configurationTimeMetrics) {
        File reportDir = new File((String)((Parameter)this.getParameters()).getFusStatisticsRootDirPath().get(), STATISTICS_FOLDER_NAME);
        try {
            Files.createDirectories(reportDir.toPath(), new FileAttribute[0]);
        }
        catch (Exception e) {
            GradleBuildFusStatisticsBuildServiceKt.getLog().warn("Failed to create directory '" + reportDir + "' for FUS report. FUS report won't be created", (Throwable)e);
            return;
        }
        Logger logger = GradleBuildFusStatisticsBuildServiceKt.getLog();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        File file = WriteMetricToFileKt.createReportFile(reportDir, this.buildId, logger);
        if (file == null) {
            return;
        }
        File reportFile = file;
        Closeable closeable = new FileOutputStream(reportFile);
        Object object = Charsets.UTF_8;
        Appendable appendable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = appendable instanceof BufferedWriter ? (BufferedWriter)appendable : new BufferedWriter((Writer)appendable, n);
        object = null;
        try {
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            Appendable appendable2 = ((Appendable)it).append("Build: " + this.buildId);
            Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append('\\n')");
            List<Metric> list = configurationTimeMetrics;
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Metric metric = (Metric)element$iv;
                    boolean bl2 = false;
                    Appendable appendable3 = ((Appendable)it).append(metric.toString());
                    Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append('\\n')");
                }
            }
            Object object2 = this.getExecutionTimeMetrics().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getExecutionTimeMetrics().get()");
            $this$forEach$iv = (Iterable)object2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Metric reportedMetrics = (Metric)element$iv;
                boolean bl3 = false;
                Appendable appendable4 = ((Appendable)it).append(reportedMetrics.toString());
                Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable4.append('\n'), (String)"append('\\n')");
            }
            Appendable appendable5 = ((Appendable)it).append(BUILD_SESSION_SEPARATOR);
            Intrinsics.checkNotNullExpressionValue((Object)appendable5, (String)"append(value)");
            Appendable appendable6 = appendable5.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)appendable6, (String)"append('\\n')");
            appendable = appendable6;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    public static /* synthetic */ void writeDownFusMetrics$fus_statistics_gradle_plugin_common$default(InternalGradleBuildFusStatisticsService internalGradleBuildFusStatisticsService, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeDownFusMetrics");
        }
        if ((n & 1) != 0) {
            list = null;
        }
        internalGradleBuildFusStatisticsService.writeDownFusMetrics$fus_statistics_gradle_plugin_common(list);
    }

    @Override
    public void close() {
        GradleBuildFusStatisticsBuildServiceKt.getLog().debug("Close build service " + GradleBuildFusStatisticsBuildServiceKt.getServiceName() + ": class \"" + this.getClass().getSimpleName() + "\", build \"" + this.buildId + '\"');
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/fus/internal/InternalGradleBuildFusStatisticsService$Companion;", "", "()V", "BUILD_SESSION_SEPARATOR", "", "FILE_NAME_BUILD_ID_PREFIX_SEPARATOR", "PROFILE_FILE_NAME_SUFFIX", "STATISTICS_FOLDER_NAME", "fus-statistics-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/fus/internal/InternalGradleBuildFusStatisticsService$Parameter;", "Lorg/gradle/api/services/BuildServiceParameters;", "buildId", "Lorg/gradle/api/provider/Property;", "", "getBuildId", "()Lorg/gradle/api/provider/Property;", "fusStatisticsRootDirPath", "getFusStatisticsRootDirPath", "fus-statistics-gradle-plugin_common"})
    public static interface Parameter
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getFusStatisticsRootDirPath();

        @NotNull
        public Property<String> getBuildId();
    }
}

