/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.ModalityCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeParameterListCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.VisibilityCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirClass;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirClassifiersCache;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirCommonClass;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/ClassCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirClass;", "cache", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirClassifiersCache;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirClassifiersCache;)V", "isCompanion", "", "isInline", "isInner", "kind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "modality", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/ModalityCommonizer;", "name", "Lorg/jetbrains/kotlin/name/Name;", "typeParameters", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeParameterListCommonizer;", "visibility", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/VisibilityCommonizer;", "commonizationResult", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirCommonClass;", "doCommonizeWith", "next", "initialize", "", "first", "commonizer"})
public final class ClassCommonizer
extends AbstractStandardCommonizer<CirClass, CirClass> {
    private Name name;
    private ClassKind kind;
    private final TypeParameterListCommonizer typeParameters;
    private final ModalityCommonizer modality;
    private final VisibilityCommonizer visibility;
    private boolean isInner;
    private boolean isInline;
    private boolean isCompanion;

    @Override
    @NotNull
    protected CirCommonClass commonizationResult() {
        Name name = this.name;
        if (name == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
        }
        List list = (List)this.typeParameters.getResult();
        ClassKind classKind = this.kind;
        if (classKind == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kind");
        }
        return new CirCommonClass(name, list, classKind, (Modality)this.modality.getResult(), this.visibility.getResult(), this.isCompanion, this.isInline, this.isInner);
    }

    @Override
    protected void initialize(@NotNull CirClass first) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        this.name = first.getName();
        this.kind = first.getKind();
        this.isInner = first.isInner();
        this.isInline = first.isInline();
        this.isCompanion = first.isCompanion();
    }

    @Override
    protected boolean doCommonizeWith(@NotNull CirClass next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        ClassKind classKind = this.kind;
        if (classKind == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kind");
        }
        return classKind == next.getKind() && this.isInner == next.isInner() && this.isInline == next.isInline() && this.isCompanion == next.isCompanion() && this.modality.commonizeWith(next.getModality()) && this.visibility.commonizeWith(next) && this.typeParameters.commonizeWith(next.getTypeParameters());
    }

    public ClassCommonizer(@NotNull CirClassifiersCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.typeParameters = TypeParameterListCommonizer.Companion.default(cache);
        this.modality = ModalityCommonizer.Companion.default();
        this.visibility = VisibilityCommonizer.Companion.equalizing();
    }
}

