/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.commonizer.UtilsKt;
import org.jetbrains.kotlin.descriptors.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.ValueParameterCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirClassifiersCache;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirCommonValueParameter;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirType;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirValueParameter;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/DefaultValueParameterCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/ValueParameterCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirValueParameter;", "cache", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirClassifiersCache;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirClassifiersCache;)V", "isCrossinline", "", "isNoinline", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeCommonizer;", "varargElementType", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirType;", "commonizationResult", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirCommonValueParameter;", "doCommonizeWith", "next", "initialize", "", "first", "commonizer"})
final class DefaultValueParameterCommonizer
extends AbstractStandardCommonizer<CirValueParameter, CirValueParameter>
implements ValueParameterCommonizer {
    private Name name;
    private final TypeCommonizer returnType;
    private CirType varargElementType;
    private boolean isCrossinline;
    private boolean isNoinline;

    @Override
    @NotNull
    protected CirCommonValueParameter commonizationResult() {
        Name name = this.name;
        if (name == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
        }
        return new CirCommonValueParameter(name, (CirType)this.returnType.getResult(), this.varargElementType, this.isCrossinline, this.isNoinline);
    }

    @Override
    protected void initialize(@NotNull CirValueParameter first) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        this.name = first.getName();
        this.varargElementType = first.getVarargElementType();
        this.isCrossinline = first.isCrossinline();
        this.isNoinline = first.isNoinline();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doCommonizeWith(@NotNull CirValueParameter next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        if (next.getDeclaresDefaultValue()) return false;
        if (UtilsKt.isNull(this.varargElementType) != UtilsKt.isNull(next.getVarargElementType())) return false;
        Name name = this.name;
        if (name == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
        }
        if (!Intrinsics.areEqual((Object)name, (Object)next.getName())) return false;
        if (!this.returnType.commonizeWith(next.getReturnType())) return false;
        boolean bl = true;
        boolean result = bl;
        if (!result) return result;
        this.isCrossinline = this.isCrossinline && next.isCrossinline();
        this.isNoinline = this.isNoinline && next.isNoinline();
        return result;
    }

    public DefaultValueParameterCommonizer(@NotNull CirClassifiersCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.returnType = TypeCommonizer.Companion.default(cache);
        this.isCrossinline = true;
        this.isNoinline = true;
    }
}

